/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.DependencyBundlingAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Identifier;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.maven.ReportAggregationMojo;
import org.owasp.dependencycheck.maven.ReportingUtil;
import org.owasp.dependencycheck.utils.LogUtils;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="check", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, requiresOnline=true)
public class DependencyCheckMojo
extends ReportAggregationMojo {
    private static final Logger LOGGER = Logger.getLogger(DependencyCheckMojo.class.getName());
    private static final String PROPERTIES_FILE = "mojo.properties";
    private static final String LOG_PROPERTIES_FILE = "log.properties";
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private org.owasp.dependencycheck.maven.Engine engine = null;
    @Parameter(property="logFile", defaultValue="")
    private String logFile = null;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(property="failBuildOnCVSS", defaultValue="11", required=true)
    private float failBuildOnCVSS = 11.0f;
    @Parameter(property="autoupdate", defaultValue="true", required=true)
    private boolean autoUpdate = true;
    @Parameter(property="format", defaultValue="HTML", required=true)
    private String format = "HTML";
    @Parameter(property="mavenSettings", defaultValue="${settings}", required=false)
    private org.apache.maven.settings.Settings mavenSettings;
    @Parameter(property="mavenSettingsProxyId", required=false)
    private String mavenSettingsProxyId;
    @Parameter(property="connectionTimeout", defaultValue="", required=false)
    private String connectionTimeout = null;
    @Parameter(property="suppressionFile", defaultValue="", required=false)
    private String suppressionFile = null;
    @Parameter(property="showSummary", defaultValue="true", required=false)
    private boolean showSummary = true;
    @Parameter(property="jarAnalyzerEnabled", defaultValue="true", required=false)
    private boolean jarAnalyzerEnabled = true;
    @Parameter(property="archiveAnalyzerEnabled", defaultValue="true", required=false)
    private boolean archiveAnalyzerEnabled = true;
    @Parameter(property="assemblyAnalyzerEnabled", defaultValue="true", required=false)
    private boolean assemblyAnalyzerEnabled = true;
    @Parameter(property="nuspecAnalyzerEnabled", defaultValue="true", required=false)
    private boolean nuspecAnalyzerEnabled = true;
    @Parameter(property="nexusAnalyzerEnabled", defaultValue="true", required=false)
    private boolean nexusAnalyzerEnabled = true;
    @Parameter(property="nexusUrl", defaultValue="", required=false)
    private String nexusUrl;
    @Parameter(property="nexusUsesProxy", defaultValue="true", required=false)
    private boolean nexusUsesProxy = true;
    @Parameter(property="connectionString", defaultValue="", required=false)
    private String connectionString;
    @Parameter(property="databaseDriverName", defaultValue="", required=false)
    private String databaseDriverName;
    @Parameter(property="databaseDriverPath", defaultValue="", required=false)
    private String databaseDriverPath;
    @Parameter(property="databaseUser", defaultValue="", required=false)
    private String databaseUser;
    @Parameter(property="databasePassword", defaultValue="", required=false)
    private String databasePassword;
    @Parameter(property="zipExtensions", required=false)
    private String zipExtensions;
    @Parameter(property="skipTestScope", defaultValue="true", required=false)
    private boolean skipTestScope = true;
    @Parameter(property="skipRuntimeScope", defaultValue="false", required=false)
    private boolean skipRuntimeScope = false;
    @Parameter(property="skipProvidedScope", defaultValue="false", required=false)
    private boolean skipProvidedScope = false;
    @Parameter(property="dataDirectory", defaultValue="", required=false)
    private String dataDirectory;
    @Parameter(property="cveUrl12Modified", defaultValue="", required=false)
    private String cveUrl12Modified;
    @Parameter(property="cveUrl20Modified", defaultValue="", required=false)
    private String cveUrl20Modified;
    @Parameter(property="cveUrl12Base", defaultValue="", required=false)
    private String cveUrl12Base;
    @Parameter(property="cveUrl20Base", defaultValue="", required=false)
    private String cveUrl20Base;
    @Parameter(property="pathToMono", defaultValue="", required=false)
    private String pathToMono;
    @Deprecated
    @Parameter(property="proxyUrl", defaultValue="", required=false)
    private String proxyUrl = null;
    @Deprecated
    @Parameter(property="externalReport")
    private String externalReport = null;

    private org.owasp.dependencycheck.maven.Engine executeDependencyCheck() throws DatabaseException {
        return this.executeDependencyCheck(this.getProject());
    }

    private org.owasp.dependencycheck.maven.Engine executeDependencyCheck(MavenProject project) throws DatabaseException {
        org.owasp.dependencycheck.maven.Engine localEngine = this.engine == null ? this.initializeEngine(project) : this.engine;
        Set artifacts = project.getArtifacts();
        for (Artifact a : artifacts) {
            List deps;
            if (this.excludeFromScan(a) || (deps = localEngine.scan(a.getFile().getAbsoluteFile())) == null) continue;
            if (deps.size() == 1) {
                Dependency d = (Dependency)deps.get(0);
                if (d == null) continue;
                MavenArtifact ma = new MavenArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion());
                d.addAsEvidence("pom", ma, Confidence.HIGHEST);
                continue;
            }
            String msg = String.format("More then 1 dependency was identified in first pass scan of '%s:%s:%s'", a.getGroupId(), a.getArtifactId(), a.getVersion());
            LOGGER.info(msg);
        }
        localEngine.analyzeDependencies();
        return localEngine;
    }

    private org.owasp.dependencycheck.maven.Engine initializeEngine(MavenProject project) throws DatabaseException {
        this.populateSettings();
        org.owasp.dependencycheck.maven.Engine localEngine = new org.owasp.dependencycheck.maven.Engine(project);
        return localEngine;
    }

    private boolean excludeFromScan(Artifact a) {
        if (this.skipTestScope && "test".equals(a.getScope())) {
            return true;
        }
        if (this.skipProvidedScope && "provided".equals(a.getScope())) {
            return true;
        }
        return this.skipRuntimeScope && !"runtime".equals(a.getScope());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSettings() {
        Proxy proxy;
        Settings.initialize();
        InputStream mojoProperties = null;
        try {
            mojoProperties = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            Settings.mergeProperties((InputStream)mojoProperties);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Unable to load the dependency-check ant task.properties file.");
            LOGGER.log(Level.FINE, null, ex);
        }
        finally {
            if (mojoProperties != null) {
                try {
                    mojoProperties.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, null, ex);
                }
            }
        }
        Settings.setBoolean((String)"autoupdate", (boolean)this.autoUpdate);
        if (this.externalReport != null) {
            LOGGER.warning("The 'externalReport' option was set; this configuration option has been removed. Please update the dependency-check-maven plugin's configuration");
        }
        if (this.proxyUrl != null && !this.proxyUrl.isEmpty()) {
            LOGGER.warning("Deprecated configuration detected, proxyUrl will be ignored; use the maven settings to configure the proxy instead");
        }
        if ((proxy = this.getMavenProxy()) != null) {
            Settings.setString((String)"proxy.server", (String)proxy.getHost());
            Settings.setString((String)"proxy.port", (String)Integer.toString(proxy.getPort()));
            String userName = proxy.getUsername();
            String password = proxy.getPassword();
            if (userName != null) {
                Settings.setString((String)"proxy.username", (String)userName);
            }
            if (password != null) {
                Settings.setString((String)"proxy.password", (String)password);
            }
        }
        if (this.connectionTimeout != null && !this.connectionTimeout.isEmpty()) {
            Settings.setString((String)"connection.timeout", (String)this.connectionTimeout);
        }
        if (this.suppressionFile != null && !this.suppressionFile.isEmpty()) {
            Settings.setString((String)"suppression.file", (String)this.suppressionFile);
        }
        Settings.setBoolean((String)"analyzer.jar.enabled", (boolean)this.jarAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.nuspec.enabled", (boolean)this.nuspecAnalyzerEnabled);
        Settings.setBoolean((String)"analyzer.nexus.enabled", (boolean)this.nexusAnalyzerEnabled);
        if (this.nexusUrl != null && !this.nexusUrl.isEmpty()) {
            Settings.setString((String)"analyzer.nexus.url", (String)this.nexusUrl);
        }
        Settings.setBoolean((String)"analyzer.nexus.proxy", (boolean)this.nexusUsesProxy);
        Settings.setBoolean((String)"analyzer.archive.enabled", (boolean)this.archiveAnalyzerEnabled);
        if (this.zipExtensions != null && !this.zipExtensions.isEmpty()) {
            Settings.setString((String)"extensions.zip", (String)this.zipExtensions);
        }
        Settings.setBoolean((String)"analyzer.assembly.enabled", (boolean)this.assemblyAnalyzerEnabled);
        if (this.pathToMono != null && !this.pathToMono.isEmpty()) {
            Settings.setString((String)"analyzer.assembly.mono.path", (String)this.pathToMono);
        }
        if (this.databaseDriverName != null && !this.databaseDriverName.isEmpty()) {
            Settings.setString((String)"data.driver_name", (String)this.databaseDriverName);
        }
        if (this.databaseDriverPath != null && !this.databaseDriverPath.isEmpty()) {
            Settings.setString((String)"data.driver_path", (String)this.databaseDriverPath);
        }
        if (this.connectionString != null && !this.connectionString.isEmpty()) {
            Settings.setString((String)"data.connection_string", (String)this.connectionString);
        }
        if (this.databaseUser != null && !this.databaseUser.isEmpty()) {
            Settings.setString((String)"data.user", (String)this.databaseUser);
        }
        if (this.databasePassword != null && !this.databasePassword.isEmpty()) {
            Settings.setString((String)"data.password", (String)this.databasePassword);
        }
        if (this.dataDirectory != null && !this.dataDirectory.isEmpty()) {
            Settings.setString((String)"data.directory", (String)this.dataDirectory);
        }
        Settings.setBoolean((String)"skip.test.scope", (boolean)this.skipTestScope);
        Settings.setBoolean((String)"skip.runtime.scope", (boolean)this.skipRuntimeScope);
        Settings.setBoolean((String)"skip.provided.scope", (boolean)this.skipProvidedScope);
        if (this.cveUrl12Modified != null && !this.cveUrl12Modified.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.modified", (String)this.cveUrl12Modified);
        }
        if (this.cveUrl20Modified != null && !this.cveUrl20Modified.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.modified", (String)this.cveUrl20Modified);
        }
        if (this.cveUrl12Base != null && !this.cveUrl12Base.isEmpty()) {
            Settings.setString((String)"cve.url-1.2.base", (String)this.cveUrl12Base);
        }
        if (this.cveUrl20Base != null && !this.cveUrl20Base.isEmpty()) {
            Settings.setString((String)"cve.url-2.0.base", (String)this.cveUrl20Base);
        }
    }

    private Proxy getMavenProxy() {
        List proxies;
        if (this.mavenSettings != null && (proxies = this.mavenSettings.getProxies()) != null && proxies.size() > 0) {
            if (this.mavenSettingsProxyId != null) {
                for (Proxy proxy : proxies) {
                    if (!this.mavenSettingsProxyId.equalsIgnoreCase(proxy.getId())) continue;
                    return proxy;
                }
            } else {
                if (proxies.size() == 1) {
                    return (Proxy)proxies.get(0);
                }
                LOGGER.warning("Multiple proxy defentiions exist in the Maven settings. In the dependency-check configuration set the maveSettingsProxyId so that the correct proxy will be used.");
                throw new IllegalStateException("Ambiguous proxy definition");
            }
        }
        return null;
    }

    @Override
    protected void initialize() {
        InputStream in = DependencyCheckMojo.class.getClassLoader().getResourceAsStream(LOG_PROPERTIES_FILE);
        LogUtils.prepareLogger((InputStream)in, (String)this.logFile);
    }

    @Override
    protected void performExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.engine = this.executeDependencyCheck();
            ReportingUtil.generateExternalReports(this.engine, this.outputDirectory, this.getProject().getName(), this.format);
            if (this.showSummary) {
                this.showSummary(this.engine.getDependencies());
            }
            if (this.failBuildOnCVSS <= 10.0f) {
                this.checkForFailure(this.engine.getDependencies());
            }
        }
        catch (DatabaseException ex) {
            LOGGER.log(Level.SEVERE, "Unable to connect to the dependency-check database; analysis has stopped");
            LOGGER.log(Level.FINE, "", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postExecute() throws MojoExecutionException, MojoFailureException {
        try {
            super.postExecute();
        }
        finally {
            this.cleanupEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postGenerate() throws MavenReportException {
        try {
            super.postGenerate();
        }
        finally {
            this.cleanupEngine();
        }
    }

    private void cleanupEngine() {
        if (this.engine != null) {
            this.engine.cleanup();
            this.engine = null;
        }
        Settings.cleanup((boolean)true);
    }

    @Override
    protected void executeNonAggregateReport(Locale locale) throws MavenReportException {
        List<Dependency> deps = this.readDataFile();
        if (deps != null) {
            try {
                if (this.engine != null) {
                    this.engine = this.initializeEngine(this.getProject());
                }
                this.engine.getDependencies().addAll(deps);
            }
            catch (DatabaseException ex) {
                String msg = String.format("An unrecoverable exception with the dependency-check initialization occured while scanning %s", this.getProject().getName());
                throw new MavenReportException(msg, (Exception)((Object)ex));
            }
        }
        try {
            this.engine = this.executeDependencyCheck();
        }
        catch (DatabaseException ex) {
            String msg = String.format("An unrecoverable exception with the dependency-check scan occured while scanning %s", this.getProject().getName());
            throw new MavenReportException(msg, (Exception)((Object)ex));
        }
        ReportingUtil.generateExternalReports(this.engine, this.getReportOutputDirectory(), this.getProject().getName(), this.format);
    }

    @Override
    protected void executeAggregateReport(MavenProject project, Locale locale) throws MavenReportException {
        List<Dependency> deps = this.readDataFile(project);
        if (deps != null) {
            try {
                if (this.engine != null) {
                    this.engine = this.initializeEngine(project);
                }
                this.engine.getDependencies().addAll(deps);
            }
            catch (DatabaseException ex) {
                String msg = String.format("An unrecoverable exception with the dependency-check initialization occured while scanning %s", project.getName());
                throw new MavenReportException(msg, (Exception)((Object)ex));
            }
        }
        try {
            this.engine = this.executeDependencyCheck(project);
        }
        catch (DatabaseException ex) {
            String msg = String.format("An unrecoverable exception with the dependency-check scan occured while scanning %s", project.getName());
            throw new MavenReportException(msg, (Exception)((Object)ex));
        }
        for (MavenProject child : this.getAllChildren(project)) {
            deps = this.readDataFile(child);
            if (deps == null) {
                String msg = String.format("Unable to include information on %s in the dependency-check aggregate report", child.getName());
                LOGGER.severe(msg);
                continue;
            }
            this.engine.getDependencies().addAll(deps);
        }
        DependencyBundlingAnalyzer bundler = new DependencyBundlingAnalyzer();
        try {
            bundler.analyze(null, (Engine)this.engine);
        }
        catch (AnalysisException ex) {
            LOGGER.log(Level.WARNING, "An error occured grouping the dependencies; duplicate entries may exist in the report", ex);
            LOGGER.log(Level.FINE, "Bundling Exception", ex);
        }
        File outputDir = this.getReportOutputDirectory(project);
        if (outputDir != null) {
            ReportingUtil.generateExternalReports(this.engine, outputDir, project.getName(), this.format);
        }
    }

    public String getOutputName() {
        if ("HTML".equalsIgnoreCase(this.format) || "ALL".equalsIgnoreCase(this.format)) {
            return "dependency-check-report";
        }
        if ("XML".equalsIgnoreCase(this.format)) {
            return "dependency-check-report.xml#";
        }
        if ("VULN".equalsIgnoreCase(this.format)) {
            return "dependency-check-vulnerability";
        }
        LOGGER.log(Level.WARNING, "Unknown report format used during site generation.");
        return "dependency-check-report";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getName(Locale locale) {
        return "dependency-check";
    }

    public String getDescription(Locale locale) {
        return "A report providing details on any published vulnerabilities within project dependencies. This report is a best effort but may contain false positives and false negatives.";
    }

    public boolean canGenerateReport() {
        if (this.canGenerateAggregateReport() || this.isAggregate() && this.isMultiModule()) {
            return true;
        }
        if (this.canGenerateNonAggregateReport()) {
            return true;
        }
        String msg = this.getProject().getArtifacts().size() > 0 ? "No project dependencies exist in the included scope - dependency-check:check is unable to generate a report." : "No project dependencies exist - dependency-check:check is unable to generate a report.";
        LOGGER.warning(msg);
        return false;
    }

    @Override
    protected boolean canGenerateNonAggregateReport() {
        boolean ability = false;
        for (Artifact a : this.getProject().getArtifacts()) {
            if (this.excludeFromScan(a)) continue;
            ability = true;
            break;
        }
        return ability;
    }

    @Override
    protected boolean canGenerateAggregateReport() {
        return this.isAggregate() && this.isLastProject();
    }

    private void checkForFailure(List<Dependency> dependencies) throws MojoFailureException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean addName = true;
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(v.getCvssScore() >= this.failBuildOnCVSS)) continue;
                if (addName) {
                    addName = false;
                    ids.append(NEW_LINE).append(d.getFileName()).append(": ");
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater then '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString());
            throw new MojoFailureException(msg);
        }
    }

    private void showSummary(List<Dependency> dependencies) {
        StringBuilder summary = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean firstEntry = true;
            StringBuilder ids = new StringBuilder();
            for (Vulnerability v : d.getVulnerabilities()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    ids.append(", ");
                }
                ids.append(v.getName());
            }
            if (ids.length() <= 0) continue;
            summary.append(d.getFileName()).append(" (");
            firstEntry = true;
            for (Identifier id : d.getIdentifiers()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    summary.append(", ");
                }
                summary.append(id.getValue());
            }
            summary.append(") : ").append((CharSequence)ids).append(NEW_LINE);
        }
        if (summary.length() > 0) {
            String msg = String.format("%n%nOne or more dependencies were identified with known vulnerabilities:%n%n%s%n%nSee the dependency-check report for more details.%n%n", summary.toString());
            LOGGER.log(Level.WARNING, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File writeDataFile() {
        File file = null;
        if (this.engine != null && this.getProject().getContextValue(this.getDataFileContextKey()) == null) {
            file = new File(this.getProject().getBuild().getDirectory(), this.getDataFileName());
            FileOutputStream os = null;
            OutputStream bos = null;
            ObjectOutputStream out = null;
            try {
                os = new FileOutputStream(file);
                bos = new BufferedOutputStream(os);
                out = new ObjectOutputStream(bos);
                out.writeObject(this.engine.getDependencies());
                out.flush();
                out.reset();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Unable to create data file used for report aggregation; if report aggregation is being used the results may be incomplete.");
                LOGGER.log(Level.FINE, ex.getMessage(), ex);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.FINEST, "ignore", ex);
                    }
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.FINEST, "ignore", ex);
                    }
                }
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.FINEST, "ignore", ex);
                    }
                }
            }
        }
        return file;
    }

    protected List<Dependency> readDataFile() {
        return this.readDataFile(this.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Dependency> readDataFile(MavenProject project) {
        Object oPath = project.getContextValue(this.getDataFileContextKey());
        if (oPath == null) {
            return null;
        }
        List ret = null;
        String path = (String)oPath;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(path));
            ret = (List)ois.readObject();
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
        return ret;
    }
}

