/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.gradle.tasks;

import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.agent.DependencyCheckScanAgent;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.IncludedByReference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.gradle.extension.AdditionalCpe;
import org.owasp.dependencycheck.gradle.service.SlackNotificationSenderService;
import org.owasp.dependencycheck.gradle.tasks.ConfiguredTask;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.SeverityUtil;
import us.springett.parsers.cpe.CpeParser;

public abstract class AbstractAnalyze
extends ConfiguredTask {
    @org.gradle.api.tasks.Internal
    private String currentProjectName;
    @org.gradle.api.tasks.Internal
    private Attribute artifactType;
    private static final GradleVersion CUTOVER_GRADLE_VERSION;
    private static final GradleVersion IGNORE_NON_RESOLVABLE_SCOPES_GRADLE_VERSION;
    private static /* synthetic */ float $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AbstractAnalyze() {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this));
        this.currentProjectName = ShortTypeHandling.castToString((Object)object);
        Object object2 = callSiteArray[2].call(Attribute.class, (Object)"artifactType", String.class);
        this.artifactType = (Attribute)ScriptBytecodeAdapter.castToType((Object)object2, Attribute.class);
    }

    @TaskAction
    public Object analyze() {
        block25: {
            Boolean bl = this.getConfig().getSkip();
            if (bl == null ? false : bl) {
                this.getLogger().lifecycle("Skipping dependency-check-gradle");
                return null;
            }
            this.verifySettings();
            this.initializeSettings();
            Engine engine = null;
            try {
                Engine engine2;
                engine = engine2 = new Engine(this.getSettings());
            }
            catch (DatabaseException ex) {
                String msg = "Unable to connect to the dependency-check database";
                Boolean bl2 = this.getConfig().getFailOnError();
                if (bl2 == null ? false : bl2) {
                    this.cleanup(engine);
                    throw (Throwable)new GradleException(msg, (Throwable)ex);
                }
                this.getLogger().error(msg);
            }
            if (!(engine != null)) break block25;
            this.scanDependencies(engine);
            ExceptionCollection exCol = null;
            this.getLogger().lifecycle("Checking for updates and analyzing dependencies for vulnerabilities");
            try {
                engine.analyzeDependencies();
            }
            catch (ExceptionCollection ex) {
                ExceptionCollection exceptionCollection;
                if (DefaultTypeTransformation.booleanUnbox((Object)this.getConfig().getFailOnError()) || ex.isFatal()) {
                    this.cleanup(engine);
                    throw (Throwable)new GradleException("Analysis failed.", (Throwable)ex);
                }
                exCol = exceptionCollection = ex;
            }
            this.getLogger().lifecycle(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.currentProjectName}, new String[]{"Generating report for project ", ""})));
            try {
                try {
                    String name = this.getProject().getName();
                    String displayName = this.determineDisplayName();
                    String groupId = ShortTypeHandling.castToString((Object)this.getProject().getGroup());
                    String version = DefaultGroovyMethods.toString((Object)this.getProject().getVersion());
                    File output = this.getProject().file((Object)this.getConfig().getOutputDirectory());
                    Set<String> set = this.getReportFormats(this.getConfig().getFormat(), this.getConfig().getFormats());
                    String f = null;
                    Iterator<String> iterator = set != null ? set.iterator() : null;
                    if (iterator != null) {
                        while (iterator.hasNext()) {
                            f = ShortTypeHandling.castToString((Object)iterator.next());
                            engine.writeReports(displayName, groupId, name, version, output, f, exCol);
                        }
                    }
                    this.showSummary(engine);
                    CheckForFailureResult result = this.checkForFailure(engine);
                    this.sendSlackNotification(result);
                    Boolean bl3 = result.failed;
                    if (bl3 == null ? false : bl3) {
                        throw (Throwable)new GradleException(result.msg);
                    }
                }
                catch (ReportException ex) {
                    Boolean bl4 = this.getConfig().getFailOnError();
                    if (bl4 == null ? false : bl4) {
                        if (exCol != null) {
                            exCol.addException((Throwable)ex);
                            throw (Throwable)new GradleException("Error generating the report", (Throwable)exCol);
                        }
                        throw (Throwable)new GradleException("Error generating the report", (Throwable)ex);
                    }
                    this.getLogger().error("Error generating the report", (Throwable)ex);
                }
            }
            finally {
                this.cleanup(engine);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.getConfig().getFailOnError()) && exCol != null && exCol.getExceptions().size() > 0) {
                throw (Throwable)new GradleException("One or more exceptions occurred during analysis", (Throwable)exCol);
            }
            return null;
        }
        return null;
    }

    public String determineDisplayName() {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), callSiteArray[6].callGroovyObjectGetProperty((Object)this), (Object)"getDisplayName")) ? callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this)) : callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty((Object)this))));
    }

    /*
     * Unable to fully structure code
     */
    public Object verifySettings() {
        v0 = this.getConfig().getScanDependencies();
        if (!((v0 == null ? false : v0) == false)) ** GOTO lbl-1000
        v1 = this.getConfig().getScanBuildEnv();
        if ((v1 == null ? false : v1) == false) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (v2) {
            throw (Throwable)new IllegalArgumentException("At least one of scanDependencies or scanBuildEnv must be set to true");
        }
        if (DefaultTypeTransformation.booleanUnbox(this.getConfig().getScanConfigurations()) != false && DefaultTypeTransformation.booleanUnbox(this.getConfig().getSkipConfigurations()) != false) {
            throw (Throwable)new IllegalArgumentException("you can only specify one of scanConfigurations or skipConfigurations");
        }
        if (DefaultTypeTransformation.booleanUnbox(this.getConfig().getScanProjects()) != false && DefaultTypeTransformation.booleanUnbox(this.getConfig().getSkipProjects()) != false) {
            throw (Throwable)new IllegalArgumentException("you can only specify one of scanProjects or skipProjects");
        }
        return null;
    }

    private Set<String> getReportFormats(String format, List<String> formats) {
        HashSet<String> selectedFormats = new HashSet<String>();
        if (formats != null && !formats.isEmpty()) {
            List<String> list = formats;
            Iterator<String> iterator = list != null ? list.iterator() : null;
            String f = null;
            Iterator<String> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    f = ShortTypeHandling.castToString((Object)iterator2.next());
                    this.addFormat(f, selectedFormats);
                }
            }
        }
        this.addFormat(format, selectedFormats);
        return selectedFormats;
    }

    private void addFormat(String format, HashSet<String> selectedFormats) {
        if (format != null && !format.trim().isEmpty()) {
            ReportGenerator.Format f2 = null;
            ReportGenerator.Format[] formatArray = ReportGenerator.Format.values();
            if (formatArray != null) {
                for (ReportGenerator.Format f2 : formatArray) {
                    if (!f2.toString().equalsIgnoreCase(format)) continue;
                    selectedFormats.add(f2.toString());
                    return;
                }
            }
            selectedFormats.add(format);
        }
    }

    public Object cleanup(Engine engine) {
        if (engine != null) {
            engine.close();
        }
        if (this.getSettings() != null) {
            this.getSettings().cleanup(true);
            return null;
        }
        return null;
    }

    public abstract Object scanDependencies(Engine var1);

    public Object showSummary(Engine engine) {
        public final class _showSummary_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _showSummary_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Set<Vulnerability> doCall(Dependency dependency) {
                return dependency.getVulnerabilities();
            }

            @Generated
            public Set<Vulnerability> call(Dependency dependency) {
                return this.doCall(dependency);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _showSummary_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List vulnerabilities = DefaultGroovyMethods.flatten((List)DefaultGroovyMethods.collect((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)engine.getDependencies(), Object[].class)), (Closure)new _showSummary_closure1((Object)this, (Object)this)));
        this.getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{vulnerabilities.size(), this.currentProjectName}, new String[]{"Found ", " vulnerabilities in project ", ""})));
        Boolean bl = this.getConfig().getShowSummary();
        if (bl == null ? false : bl) {
            DependencyCheckScanAgent.showSummary((String)this.getProject().getName(), (Dependency[])engine.getDependencies());
            return null;
        }
        return null;
    }

    public CheckForFailureResult checkForFailure(Engine engine) {
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)this.getConfig().getFailBuildOnCVSS(), (Object)10)) {
            return CheckForFailureResult.createSuccess();
        }
        HashSet<String> vulnerabilities = new HashSet<String>();
        Dependency d = null;
        Dependency[] dependencyArray = engine.getDependencies();
        if (dependencyArray != null) {
            int n = dependencyArray.length;
            int n2 = 0;
            while (n2 < n) {
                d = dependencyArray[n2];
                ++n2;
                Vulnerability v = null;
                Set set = d.getVulnerabilities();
                Iterator iterator = set != null ? set.iterator() : null;
                if (iterator == null) continue;
                while (iterator.hasNext()) {
                    v = (Vulnerability)ScriptBytecodeAdapter.castToType(iterator.next(), Vulnerability.class);
                    if (!(v.getCvssV2() != null && v.getCvssV2().getCvssData() != null && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)v.getCvssV2().getCvssData().getBaseScore(), (Object)this.getConfig().getFailBuildOnCVSS()) || v.getCvssV3() != null && v.getCvssV3().getCvssData() != null && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)v.getCvssV3().getCvssData().getBaseScore(), (Object)this.getConfig().getFailBuildOnCVSS()) || v.getUnscoredSeverity() != null && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)SeverityUtil.estimateCvssV2((String)v.getUnscoredSeverity()), (Object)this.getConfig().getFailBuildOnCVSS()) || ScriptBytecodeAdapter.compareLessThanEqual((Object)this.getConfig().getFailBuildOnCVSS(), (Object)Float.valueOf($const$0)))) continue;
                    vulnerabilities.add(v.getName());
                }
            }
        }
        if (vulnerabilities.size() > 0) {
            String msg = String.format(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"%n%nDependency-Analyze Failure:%n", (CharSequence)"One or more dependencies were identified with vulnerabilities that have a CVSS score greater than '%.1f': %s%n"), (CharSequence)"See the dependency-check report for more details.%n%n"), this.getConfig().getFailBuildOnCVSS(), DefaultGroovyMethods.join(vulnerabilities, (String)", "));
            return CheckForFailureResult.createFailed(msg);
        }
        return CheckForFailureResult.createSuccess();
    }

    public void sendSlackNotification(CheckForFailureResult checkForFailureResult) {
        Boolean bl = checkForFailureResult.failed;
        if (bl == null ? false : bl) {
            new SlackNotificationSenderService(this.getSettings()).send(this.getCurrentProjectName(), checkForFailureResult.msg);
        }
    }

    public Object shouldBeScanned(Project project) {
        return !DefaultTypeTransformation.booleanUnbox(this.getConfig().getScanProjects()) || this.getConfig().getScanProjects().contains(project.getPath());
    }

    public Object shouldBeSkipped(Project project) {
        return this.getConfig().getSkipProjects().contains(project.getPath());
    }

    public boolean shouldBeScanned(Configuration configuration) {
        return !DefaultTypeTransformation.booleanUnbox(this.getConfig().getScanConfigurations()) || this.getConfig().getScanConfigurations().contains(configuration.getName());
    }

    public boolean shouldBeSkipped(Configuration configuration) {
        return IGNORE_NON_RESOLVABLE_SCOPES_GRADLE_VERSION.compareTo(GradleVersion.current()) <= 0 && ("archives".equals(configuration.getName()) || "default".equals(configuration.getName()) || "runtime".equals(configuration.getName()) || "compile".equals(configuration.getName()) || "compileOnly".equals(configuration.getName())) || this.getConfig().getSkipConfigurations().contains(configuration.getName());
    }

    public Object shouldBeSkipped(ResolvedArtifactResult artifact) {
        Reference name = new Reference((Object)artifact.getId().getComponentIdentifier().getDisplayName());
        public final class _shouldBeSkipped_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _shouldBeSkipped_closure2(Object _outerInstance, Object _thisObject, Reference name) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.name = reference = name;
            }

            public Boolean doCall(Object it) {
                return ((String)this.name.get()).startsWith(ShortTypeHandling.castToString((Object)it));
            }

            @Generated
            public Object getName() {
                return this.name.get();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _shouldBeSkipped_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.any(this.getConfig().getSkipGroups(), (Closure)new _shouldBeSkipped_closure2((Object)this, (Object)this, name));
    }

    public boolean shouldBeSkippedAsTest(Configuration configuration) {
        return DefaultTypeTransformation.booleanUnbox((Object)this.getConfig().getSkipTestGroups()) && this.isTestConfiguration(configuration);
    }

    public boolean isTestConfiguration(Configuration configuration) {
        boolean isTestConfiguration = AbstractAnalyze.isTestConfigurationCheck(configuration);
        public final class _isTestConfiguration_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isTestConfiguration_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return ((Configuration)it).getName();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isTestConfiguration_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        String hierarchy = DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Iterable)configuration.getHierarchy(), (Closure)new _isTestConfiguration_closure3((Object)this, (Object)this)), (String)" --> ");
        this.getLogger().info("'{}' is considered a test configuration: {}", (Object)hierarchy, (Object)isTestConfiguration);
        return isTestConfiguration;
    }

    public static boolean isTestConfigurationCheck(Configuration configuration) {
        Reference isTestConfiguration = new Reference((Object)(configuration.getName().startsWith("test") || configuration.getName().startsWith("androidTest") ? 1 : 0));
        public final class _isTestConfigurationCheck_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference isTestConfiguration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isTestConfigurationCheck_closure4(Object _outerInstance, Object _thisObject, Reference isTestConfiguration) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.isTestConfiguration = reference = isTestConfiguration;
            }

            public Boolean doCall(Object it) {
                Boolean bl = DefaultGroovyMethods.or((Boolean)((Boolean)ScriptBytecodeAdapter.castToType((Object)this.isTestConfiguration.get(), Boolean.class)), (Boolean)(ScriptBytecodeAdapter.compareEqual((Object)((Configuration)it).getName(), (Object)"testCompile") || ScriptBytecodeAdapter.compareEqual((Object)((Configuration)it).getName(), (Object)"androidTestCompile") || ScriptBytecodeAdapter.compareEqual((Object)((Configuration)it).getName(), (Object)"testImplementation") ? 1 : 0));
                this.isTestConfiguration.set((Object)bl);
                return bl;
            }

            @Generated
            public Boolean getIsTestConfiguration() {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.isTestConfiguration.get(), Boolean.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isTestConfigurationCheck_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)configuration.getHierarchy(), (Closure)new _isTestConfigurationCheck_closure4(AbstractAnalyze.class, AbstractAnalyze.class, isTestConfiguration));
        return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)isTestConfiguration.get()));
    }

    public boolean canBeResolved(Configuration configuration) {
        return DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getMetaClass((Object)configuration).respondsTo((Object)configuration, "isCanBeResolved")) ? configuration.isCanBeResolved() : true;
    }

    /*
     * WARNING - void declaration
     */
    protected void processBuildEnvironment(Project project, Engine engine) {
        void var2_2;
        Reference project2 = new Reference((Object)project);
        Reference engine2 = new Reference((Object)var2_2);
        public final class _processBuildEnvironment_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processBuildEnvironment_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Configuration configuration) {
                return ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeScanned(configuration) && !(((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeSkipped(configuration) || ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeSkippedAsTest(configuration)) && ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).canBeResolved(configuration);
            }

            @Generated
            public Boolean call(Configuration configuration) {
                return this.doCall(configuration);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processBuildEnvironment_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _processBuildEnvironment_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference engine;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processBuildEnvironment_closure6(Object _outerInstance, Object _thisObject, Reference engine, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.engine = reference2 = engine;
                this.project = reference = project;
            }

            public Object doCall(Configuration configuration) {
                if (AbstractAnalyze.pfaccess$0(null).compareTo(GradleVersion.current()) > 0) {
                    return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"processConfigLegacy", (Object)new Object[]{configuration, this.engine.get()});
                }
                return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"processConfigV4", (Object)new Object[]{this.project.get(), configuration, this.engine.get(), true});
            }

            @Generated
            public Object call(Configuration configuration) {
                return this.doCall(configuration);
            }

            @Generated
            public Engine getEngine() {
                return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processBuildEnvironment_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)((Project)project2.get()).getBuildscript().getConfigurations().findAll((Closure)new _processBuildEnvironment_closure5((Object)this, (Object)this)), (Closure)new _processBuildEnvironment_closure6((Object)this, (Object)this, engine2, project2));
    }

    /*
     * WARNING - void declaration
     */
    protected void processConfigurations(Project project, Engine engine) {
        void var2_2;
        Reference project2 = new Reference((Object)project);
        Reference engine2 = new Reference((Object)var2_2);
        public final class _processConfigurations_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processConfigurations_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Configuration configuration) {
                return ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeScanned(configuration) && !(((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeSkipped(configuration) || ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeSkippedAsTest(configuration)) && ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).canBeResolved(configuration);
            }

            @Generated
            public Boolean call(Configuration configuration) {
                return this.doCall(configuration);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigurations_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _processConfigurations_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference engine;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processConfigurations_closure8(Object _outerInstance, Object _thisObject, Reference engine, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.engine = reference2 = engine;
                this.project = reference = project;
            }

            public Object doCall(Configuration configuration) {
                if (AbstractAnalyze.pfaccess$0(null).compareTo(GradleVersion.current()) > 0) {
                    return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"processConfigLegacy", (Object)new Object[]{configuration, this.engine.get()});
                }
                return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"processConfigV4", (Object)new Object[]{this.project.get(), configuration, this.engine.get()});
            }

            @Generated
            public Object call(Configuration configuration) {
                return this.doCall(configuration);
            }

            @Generated
            public Engine getEngine() {
                return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigurations_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)((Project)project2.get()).getConfigurations().findAll((Closure)new _processConfigurations_closure7((Object)this, (Object)this)), (Closure)new _processConfigurations_closure8((Object)this, (Object)this, engine2, project2));
        if (this.getConfig().getScanSet() == null) {
            List toScan = ScriptBytecodeAdapter.createList((Object[])new Object[]{"src/main/resources", "src/main/webapp", "./package.json", "./package-lock.json", "./npm-shrinkwrap.json", "./yarn.lock", "./pnpm.lock", "./Gopkg.lock", "./go.mod"});
            public final class _processConfigurations_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference engine;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _processConfigurations_closure9(Object _outerInstance, Object _thisObject, Reference project, Reference engine) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.project = reference2 = project;
                    this.engine = reference = engine;
                }

                public List<Dependency> doCall(Object it) {
                    File f = ((Project)this.project.get()).file(it);
                    if (f.exists()) {
                        return ((Engine)this.engine.get()).scan(f, ((Project)this.project.get()).getName());
                    }
                    return (List)ScriptBytecodeAdapter.castToType(null, List.class);
                }

                @Generated
                public Project getProject() {
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                @Generated
                public Engine getEngine() {
                    return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public List<Dependency> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _processConfigurations_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((List)toScan, (Closure)new _processConfigurations_closure9((Object)this, (Object)this, project2, engine2));
        } else {
            public final class _processConfigurations_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference engine;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _processConfigurations_closure10(Object _outerInstance, Object _thisObject, Reference project, Reference engine) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.project = reference2 = project;
                    this.engine = reference = engine;
                }

                public List<Dependency> doCall(Object it) {
                    File f = ((Project)this.project.get()).file(it);
                    if (f.exists()) {
                        return ((Engine)this.engine.get()).scan(f, ((Project)this.project.get()).getName());
                    }
                    ((AbstractAnalyze)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{f, ((Project)this.project.get()).getName()}, new String[]{"ScanSet file `", "` does not exist in ", ""})));
                    return (List)ScriptBytecodeAdapter.castToType(null, List.class);
                }

                @Generated
                public Project getProject() {
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                @Generated
                public Engine getEngine() {
                    return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public List<Dependency> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _processConfigurations_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(this.getConfig().getScanSet(), (Closure)new _processConfigurations_closure10((Object)this, (Object)this, project2, engine2));
        }
        public final class _processConfigurations_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference engine;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processConfigurations_closure11(Object _outerInstance, Object _thisObject, Reference engine) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.engine = reference = engine;
            }

            public Object doCall(Object it) {
                Dependency dependency = new Dependency(true);
                dependency.setDescription(((AdditionalCpe)it).getDescription());
                dependency.setDisplayFileName(((AdditionalCpe)it).getCpe());
                dependency.setSha1sum(Checksum.getSHA1Checksum((String)((AdditionalCpe)it).getCpe()));
                dependency.setSha256sum(Checksum.getSHA256Checksum((String)((AdditionalCpe)it).getCpe()));
                dependency.setMd5sum(Checksum.getMD5Checksum((String)((AdditionalCpe)it).getCpe()));
                dependency.addVulnerableSoftwareIdentifier((Identifier)new CpeIdentifier(CpeParser.parse((String)((AdditionalCpe)it).getCpe()), Confidence.HIGHEST));
                dependency.setFileName("");
                dependency.setActualFilePath("");
                ((Engine)this.engine.get()).addDependency(dependency);
                return null;
            }

            @Generated
            public Engine getEngine() {
                return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigurations_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.getConfig().getAdditionalCpes(), (Closure)new _processConfigurations_closure11((Object)this, (Object)this, engine2));
    }

    /*
     * WARNING - void declaration
     */
    protected void processConfigLegacy(Configuration configuration, Engine engine) {
        void var2_2;
        Reference configuration2 = new Reference((Object)configuration);
        Reference engine2 = new Reference((Object)var2_2);
        public final class _processConfigLegacy_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference engine;
            private /* synthetic */ Reference configuration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processConfigLegacy_closure12(Object _outerInstance, Object _thisObject, Reference engine, Reference configuration) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.engine = reference2 = engine;
                this.configuration = reference = configuration;
            }

            public Object doCall(ResolvedArtifact artifact) {
                List dependencies = ((Engine)this.engine.get()).scan(artifact.getFile());
                return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"addInfoToDependencies", (Object)new Object[]{dependencies, ((Configuration)this.configuration.get()).getName(), artifact.getModuleVersion().getId(), null});
            }

            @Generated
            public Object call(ResolvedArtifact artifact) {
                return this.doCall(artifact);
            }

            @Generated
            public Engine getEngine() {
                return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
            }

            @Generated
            public Configuration getConfiguration() {
                return (Configuration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), Configuration.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigLegacy_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.collect((Iterable)((Configuration)configuration2.get()).getResolvedConfiguration().getResolvedArtifacts(), (Closure)new _processConfigLegacy_closure12((Object)this, (Object)this, engine2, configuration2));
    }

    private Map<PackageURL, Set<IncludedByReference>> buildIncludedByMap(Project project, Configuration configuration, boolean scanningBuildEnv) {
        Reference includedByMap = new Reference(new HashMap());
        Reference type = new Reference(null);
        if (scanningBuildEnv) {
            String string = "buildEnv";
            type.set((Object)string);
        }
        Reference parent = new Reference((Object)new IncludedByReference(AbstractAnalyze.convertIdentifier(project).toString(), (String)type.get()));
        public final class _buildIncludedByMap_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includedByMap;
            private /* synthetic */ Reference parent;
            private /* synthetic */ Reference type;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildIncludedByMap_closure13(Object _outerInstance, Object _thisObject, Reference includedByMap, Reference parent, Reference type) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.includedByMap = reference3 = includedByMap;
                this.parent = reference2 = parent;
                this.type = reference = type;
            }

            public Void doCall(Object it) {
                if (it instanceof ResolvedDependencyResult) {
                    ResolvedDependencyResult dr = (ResolvedDependencyResult)ScriptBytecodeAdapter.castToType((Object)it, ResolvedDependencyResult.class);
                    ResolvedComponentResult current = dr.getSelected();
                    PackageURL purl = AbstractAnalyze.convertIdentifier(current);
                    if (((HashMap)this.includedByMap.get()).containsKey(purl)) {
                        ((Set)((HashMap)this.includedByMap.get()).get(purl)).add(this.parent.get());
                    } else {
                        HashSet<Object> rootParent = new HashSet<Object>();
                        rootParent.add(this.parent.get());
                        ((HashMap)this.includedByMap.get()).put(purl, rootParent);
                    }
                    IncludedByReference root = new IncludedByReference(AbstractAnalyze.convertIdentifier(current).toString(), ShortTypeHandling.castToString((Object)this.type.get()));
                    AbstractAnalyze.collectDependencyMap((Map)ScriptBytecodeAdapter.castToType((Object)this.includedByMap.get(), Map.class), root, current.getDependencies(), 0);
                    return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
                }
                return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
            }

            @Generated
            public Map getIncludedByMap() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.includedByMap.get(), Map.class);
            }

            @Generated
            public IncludedByReference getParent() {
                return (IncludedByReference)ScriptBytecodeAdapter.castToType((Object)this.parent.get(), IncludedByReference.class);
            }

            @Generated
            public String getType() {
                return ShortTypeHandling.castToString((Object)this.type.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Void doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildIncludedByMap_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        configuration.getIncoming().getResolutionResult().getRoot().getDependencies().forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _buildIncludedByMap_closure13((Object)this, (Object)this, includedByMap, parent, type)), Consumer.class));
        return (HashMap)includedByMap.get();
    }

    private static void collectDependencyMap(Map<PackageURL, Set<IncludedByReference>> includedByMap, IncludedByReference root, Set<? extends DependencyResult> dependencies, int depth) {
        Set<? extends DependencyResult> set = dependencies;
        Iterator<? extends DependencyResult> iterator = set != null ? set.iterator() : null;
        DependencyResult it = null;
        Iterator<? extends DependencyResult> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                it = (DependencyResult)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), DependencyResult.class);
                if (!(it instanceof ResolvedDependencyResult)) continue;
                ResolvedDependencyResult rdr = (ResolvedDependencyResult)ScriptBytecodeAdapter.castToType((Object)it, ResolvedDependencyResult.class);
                ResolvedComponentResult current = rdr.getSelected();
                PackageURL purl = AbstractAnalyze.convertIdentifier(current);
                if (includedByMap.containsKey(purl)) {
                    Set includedBy = (Set)ScriptBytecodeAdapter.castToType(includedByMap.get(purl), Set.class);
                    if (includedBy.contains(root)) continue;
                    includedBy.add(root);
                } else {
                    HashSet<IncludedByReference> rootParent = new HashSet<IncludedByReference>();
                    rootParent.add(root);
                    includedByMap.put(purl, rootParent);
                }
                if (!(current.getDependencies() != null && !current.getDependencies().isEmpty() && depth < 500)) continue;
                AbstractAnalyze.collectDependencyMap(includedByMap, root, current.getDependencies(), depth + 1);
            }
        }
    }

    protected void processConfigV4(Project project, Configuration configuration, Engine engine, boolean scanningBuildEnv) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        String projectName = ShortTypeHandling.castToString((Object)callSiteArray[11].callGetProperty((Object)project));
        String scope = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projectName, callSiteArray[12].callGetProperty((Object)configuration)}, new String[]{"", ":", ""}));
        if (scanningBuildEnv) {
            scope = ShortTypeHandling.castToString((Object)callSiteArray[13].call((Object)scope, (Object)" (buildEnv)"));
        }
        callSiteArray[14].call(callSiteArray[15].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{scope}, new String[]{"- Analyzing ", ""}));
        Reference componentVersions = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _processConfigV4_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference componentVersions;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _processConfigV4_closure14(Object _outerInstance, Object _thisObject, Reference componentVersions) {
                Reference reference;
                CallSite[] callSiteArray = _processConfigV4_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.componentVersions = reference = componentVersions;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _processConfigV4_closure14.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(it, (Object)"selected"))) {
                    return callSiteArray[1].call(this.componentVersions.get(), callSiteArray[2].call(callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(it))), callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(it)));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call(it, (Object)"attempted"))) {
                    return callSiteArray[8].call(callSiteArray[9].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty(it))}, new String[]{"Unable to resolve artifact in ", ""}));
                }
                return callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{it}, new String[]{"Unable to resolve: ", ""}));
            }

            @Generated
            public Map getComponentVersions() {
                CallSite[] callSiteArray = _processConfigV4_closure14.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.componentVersions.get(), Map.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _processConfigV4_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigV4_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "hasProperty";
                stringArray[1] = "put";
                stringArray[2] = "toString";
                stringArray[3] = "id";
                stringArray[4] = "selected";
                stringArray[5] = "moduleVersion";
                stringArray[6] = "selected";
                stringArray[7] = "hasProperty";
                stringArray[8] = "debug";
                stringArray[9] = "logger";
                stringArray[10] = "displayName";
                stringArray[11] = "attempted";
                stringArray[12] = "warn";
                stringArray[13] = "logger";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[14];
                _processConfigV4_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_processConfigV4_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _processConfigV4_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[16].call(callSiteArray[17].callGetProperty(callSiteArray[18].callGetProperty(callSiteArray[19].callGetProperty((Object)configuration))), (Object)new _processConfigV4_closure14((Object)this, (Object)this, componentVersions));
        Map includedByMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callCurrent((GroovyObject)this, (Object)project, (Object)configuration, (Object)scanningBuildEnv), Map.class);
        Object types = callSiteArray[21].callGroovyObjectGetProperty(callSiteArray[22].callGroovyObjectGetProperty((Object)this));
        Reference type = new Reference(null);
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call(types), Iterator.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                type.set((Object)ShortTypeHandling.castToString(iterator.next()));
                public final class _processConfigV4_closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference type;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _processConfigV4_closure15(Object _outerInstance, Object _thisObject, Reference type) {
                        Reference reference;
                        CallSite[] callSiteArray = _processConfigV4_closure15.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.type = reference = type;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _processConfigV4_closure15.$getCallSiteArray();
                        callSiteArray[0].callCurrent((GroovyObject)this, (Object)true);
                        public final class _closure16
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference type;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure16(Object _outerInstance, Object _thisObject, Reference type) {
                                Reference reference;
                                CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.type = reference = type;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                return callSiteArray[0].call(it, callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.type.get());
                            }

                            @Generated
                            public String getType() {
                                CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                return ShortTypeHandling.castToString((Object)this.type.get());
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure16.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "attribute";
                                stringArray[1] = "artifactType";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[2];
                                _closure16.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure16.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure16.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[1].callCurrent((GroovyObject)this, (Object)new _closure16((Object)this, this.getThisObject(), this.type));
                    }

                    @Generated
                    public String getType() {
                        CallSite[] callSiteArray = _processConfigV4_closure15.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.type.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _processConfigV4_closure15.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _processConfigV4_closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "lenient";
                        stringArray[1] = "attributes";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _processConfigV4_closure15.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_processConfigV4_closure15.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _processConfigV4_closure15.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                List rar = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].callGetProperty((Object)configuration), (Object)new _processConfigV4_closure15((Object)this, (Object)this, type)))), List.class);
                ResolvedArtifactResult resolvedArtifactResult = null;
                Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call((Object)rar), Iterator.class);
                if (iterator2 == null) continue;
                while (iterator2.hasNext()) {
                    resolvedArtifactResult = (ResolvedArtifactResult)ScriptBytecodeAdapter.castToType(iterator2.next(), ResolvedArtifactResult.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].callCurrent((GroovyObject)this, (Object)resolvedArtifactResult))) continue;
                    ModuleVersionIdentifier id = (ModuleVersionIdentifier)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call((Object)((Map)componentVersions.get()), callSiteArray[31].call(callSiteArray[32].callGetProperty(callSiteArray[33].callGetProperty((Object)resolvedArtifactResult)))), ModuleVersionIdentifier.class);
                    if (ScriptBytecodeAdapter.compareEqual((Object)id, null)) {
                        callSiteArray[34].call(callSiteArray[35].callGroovyObjectGetProperty((Object)this), callSiteArray[36].call((Object)new GStringImpl(new Object[]{callSiteArray[37].callGetProperty(callSiteArray[38].callGetProperty((Object)resolvedArtifactResult))}, new String[]{"Could not find dependency {'artifact': '", "', "}), (Object)new GStringImpl(new Object[]{callSiteArray[39].callGetProperty((Object)resolvedArtifactResult)}, new String[]{"'file':'", "'}"})));
                        continue;
                    }
                    Object deps = callSiteArray[40].call((Object)engine, callSiteArray[41].callGetProperty((Object)resolvedArtifactResult), (Object)scope);
                    if (!ScriptBytecodeAdapter.compareNotEqual((Object)deps, null)) continue;
                    callSiteArray[42].callCurrent((GroovyObject)this, deps, (Object)scope, (Object)id, callSiteArray[43].call((Object)includedByMap, callSiteArray[44].callStatic(AbstractAnalyze.class, (Object)id)));
                }
            }
        }
    }

    protected void addInfoToDependencies(List<Dependency> deps, String configurationName, ModuleVersionIdentifier id, Set<IncludedByReference> includedBy) {
        if (deps != null) {
            if (deps.size() == 1) {
                Dependency d = (Dependency)ScriptBytecodeAdapter.castToType((Object)deps.get(0), Dependency.class);
                MavenArtifact mavenArtifact = new MavenArtifact(id.getGroup(), id.getName(), id.getVersion());
                d.addAsEvidence("gradle", mavenArtifact, Confidence.HIGHEST);
                d.addProjectReference(configurationName);
                if (includedBy != null) {
                    d.addAllIncludedBy(includedBy);
                }
            } else {
                List<Dependency> list = deps;
                Iterator<Dependency> iterator = list != null ? list.iterator() : null;
                Dependency it = null;
                Iterator<Dependency> iterator2 = iterator;
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        it = (Dependency)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Dependency.class);
                        it.addProjectReference(configurationName);
                        if (!(includedBy != null)) continue;
                        it.addAllIncludedBy(includedBy);
                    }
                }
            }
        }
    }

    private static PackageURL convertIdentifier(Project project) {
        PackageURL packageURL;
        PackageURL packageURL2;
        PackageURL p = null;
        p = DefaultTypeTransformation.booleanUnbox((Object)project.getGroup()) ? (packageURL2 = new PackageURL("maven", DefaultGroovyMethods.toString((Object)project.getGroup()), project.getName(), DefaultGroovyMethods.toString((Object)project.getVersion()), null, null)) : (packageURL = PackageURLBuilder.aPackageURL().withType("gradle").withName(project.getName()).withVersion(DefaultGroovyMethods.toString((Object)project.getVersion())).build());
        return p;
    }

    private static PackageURL convertIdentifier(ResolvedComponentResult result) {
        ModuleVersionIdentifier id = result.getModuleVersion();
        PackageURL p = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)id.getGroup())) {
            PackageURL packageURL;
            p = packageURL = new PackageURL("maven", id.getGroup(), id.getName(), id.getVersion(), null, null);
        } else {
            PackageURL packageURL;
            PackageURLBuilder pb = PackageURLBuilder.aPackageURL().withType("gradle").withName(id.getName());
            if (DefaultTypeTransformation.booleanUnbox((Object)id.getVersion())) {
                pb.withVersion(id.getVersion());
            }
            p = packageURL = pb.build();
        }
        return p;
    }

    private static PackageURL convertIdentifier(ModuleComponentIdentifier id) {
        PackageURL p = new PackageURL("maven", id.getModuleIdentifier().getGroup(), id.getModuleIdentifier().getName(), id.getVersion(), null, null);
        return p;
    }

    private static PackageURL convertIdentifier(ProjectComponentIdentifier id) {
        return PackageURLBuilder.aPackageURL().withType("gradle").withName(id.getProjectPath()).build();
    }

    private static PackageURL convertIdentifier(ModuleVersionIdentifier id) {
        PackageURL p = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)id.getGroup())) {
            PackageURL packageURL;
            p = packageURL = new PackageURL("maven", id.getGroup(), id.getName(), id.getVersion(), null, null);
        } else {
            PackageURLBuilder pb = PackageURLBuilder.aPackageURL().withType("gradle").withName(id.getName());
            if (DefaultTypeTransformation.booleanUnbox((Object)id.getVersion())) {
                pb.withVersion(id.getVersion());
            }
        }
        return p;
    }

    protected void addDependency(Engine engine, String projectName, String configurationName, ModuleVersionIdentifier id, String displayName, File file) {
        String string = displayName;
        String display = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""})));
        Dependency dependency = null;
        Object sha256 = null;
        if (file == null) {
            Dependency dependency2;
            this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{display}, new String[]{"Adding virtual dependency for ", ""})));
            dependency = dependency2 = new Dependency(this.getProject().getBuildFile(), true);
        } else {
            Dependency dependency3;
            this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{display}, new String[]{"Adding dependency for ", ""})));
            dependency = dependency3 = new Dependency(file);
        }
        if (dependency.getSha1sum() == null && dependency.isVirtual()) {
            String string2 = Checksum.getSHA1Checksum((String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""})));
            dependency.setSha1sum(string2);
            String string3 = Checksum.getSHA256Checksum((String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""})));
            dependency.setSha256sum(string3);
            String string4 = Checksum.getMD5Checksum((String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""})));
            dependency.setMd5sum(string4);
            String string5 = display;
            dependency.setDisplayFileName(string5);
        }
        dependency.addEvidence(EvidenceType.VENDOR, "build.gradle", "displayName", display, Confidence.MEDIUM);
        dependency.addEvidence(EvidenceType.PRODUCT, "build.gradle", "displayName", display, Confidence.HIGH);
        if (dependency.getPackagePath() == null) {
            String string6 = id.getName();
            dependency.setName(string6);
            String string7 = id.getVersion();
            dependency.setVersion(string7);
            GStringImpl gStringImpl = new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""});
            dependency.setPackagePath(ShortTypeHandling.castToString((Object)gStringImpl));
        }
        MavenArtifact mavenArtifact = new MavenArtifact(id.getGroup(), id.getName(), id.getVersion());
        dependency.addAsEvidence("gradle", mavenArtifact, Confidence.HIGHEST);
        dependency.addProjectReference(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projectName, configurationName}, new String[]{"", ":", ""})));
        engine.addDependency(dependency);
    }

    protected boolean hasNotCompatibleWithConfigurationCacheOption() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.getMetaClass().respondsTo((Object)this, "notCompatibleWithConfigurationCache", new Object[]{String.class}));
    }

    protected void callIncompatibleWithConfigurationCache() {
        String methodName = "notCompatibleWithConfigurationCache";
        Object[] methodArgs = new Object[]{"The gradle-versions-plugin isn't compatible with the configuration cache"};
        this.getMetaClass().invokeMethod((Object)this, methodName, methodArgs);
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[45].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[46].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[47].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ GradleVersion pfaccess$0(AbstractAnalyze $that) {
        return (GradleVersion)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(AbstractAnalyze.class, AbstractAnalyze.class, (String)"CUTOVER_GRADLE_VERSION"), GradleVersion.class);
    }

    @Generated
    protected void processConfigV4(Project project, Configuration configuration, Engine engine) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        this.processConfigV4(project, configuration, engine, false);
    }

    @Generated
    protected void addDependency(Engine engine, String projectName, String configurationName, ModuleVersionIdentifier id, String displayName) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        this.addDependency(engine, projectName, configurationName, id, displayName, null);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AbstractAnalyze.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        float f;
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = f = 0.0f;
    }

    static {
        AbstractAnalyze.__$swapInit();
        Object object = AbstractAnalyze.$getCallSiteArray()[48].call(GradleVersion.class, (Object)"4.0");
        CUTOVER_GRADLE_VERSION = (GradleVersion)ScriptBytecodeAdapter.castToType((Object)object, GradleVersion.class);
        Object object2 = AbstractAnalyze.$getCallSiteArray()[49].call(GradleVersion.class, (Object)"7.0");
        IGNORE_NON_RESOLVABLE_SCOPES_GRADLE_VERSION = (GradleVersion)ScriptBytecodeAdapter.castToType((Object)object2, GradleVersion.class);
    }

    @Generated
    public String getCurrentProjectName() {
        return this.currentProjectName;
    }

    @Generated
    public void setCurrentProjectName(String string) {
        this.currentProjectName = string;
    }

    @Generated
    public Attribute getArtifactType() {
        return this.artifactType;
    }

    @Generated
    public void setArtifactType(Attribute attribute) {
        this.artifactType = attribute;
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getName";
        stringArray[1] = "project";
        stringArray[2] = "of";
        stringArray[3] = "respondsTo";
        stringArray[4] = "metaClass";
        stringArray[5] = "project";
        stringArray[6] = "project";
        stringArray[7] = "getDisplayName";
        stringArray[8] = "project";
        stringArray[9] = "getName";
        stringArray[10] = "project";
        stringArray[11] = "name";
        stringArray[12] = "name";
        stringArray[13] = "plus";
        stringArray[14] = "info";
        stringArray[15] = "logger";
        stringArray[16] = "each";
        stringArray[17] = "allDependencies";
        stringArray[18] = "resolutionResult";
        stringArray[19] = "incoming";
        stringArray[20] = "buildIncludedByMap";
        stringArray[21] = "analyzedTypes";
        stringArray[22] = "config";
        stringArray[23] = "iterator";
        stringArray[24] = "toList";
        stringArray[25] = "getArtifacts";
        stringArray[26] = "artifactView";
        stringArray[27] = "incoming";
        stringArray[28] = "iterator";
        stringArray[29] = "shouldBeSkipped";
        stringArray[30] = "getAt";
        stringArray[31] = "getDisplayName";
        stringArray[32] = "componentIdentifier";
        stringArray[33] = "id";
        stringArray[34] = "debug";
        stringArray[35] = "logger";
        stringArray[36] = "plus";
        stringArray[37] = "componentIdentifier";
        stringArray[38] = "id";
        stringArray[39] = "file";
        stringArray[40] = "scan";
        stringArray[41] = "file";
        stringArray[42] = "addInfoToDependencies";
        stringArray[43] = "get";
        stringArray[44] = "convertIdentifier";
        stringArray[45] = "length";
        stringArray[46] = "getAt";
        stringArray[47] = "length";
        stringArray[48] = "version";
        stringArray[49] = "version";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[50];
        AbstractAnalyze.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AbstractAnalyze.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AbstractAnalyze.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class CheckForFailureResult
    implements GroovyObject {
        private Boolean failed;
        private String msg;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public CheckForFailureResult(Boolean failed, String msg) {
            String string;
            Boolean bl;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.failed = bl = failed;
            this.msg = string = msg;
        }

        public static CheckForFailureResult createSuccess() {
            return new CheckForFailureResult(false, "");
        }

        public static CheckForFailureResult createFailed(String msg) {
            return new CheckForFailureResult(true, msg);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CheckForFailureResult.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

