/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.gradle.tasks;

import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.beans.Transient;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.maven.MavenModule;
import org.gradle.maven.MavenPomArtifact;
import org.gradle.util.GradleVersion;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.agent.DependencyCheckScanAgent;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.IncludedByReference;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.gradle.extension.AdditionalCpe;
import org.owasp.dependencycheck.gradle.service.SlackNotificationSenderService;
import org.owasp.dependencycheck.gradle.tasks.ConfiguredTask;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.SeverityUtil;
import org.owasp.dependencycheck.xml.pom.PomUtils;
import us.springett.parsers.cpe.CpeParser;

public abstract class AbstractAnalyze
extends ConfiguredTask {
    @Internal
    private String currentProjectName;
    @Internal
    private Attribute artifactType;
    private static final GradleVersion CUTOVER_GRADLE_VERSION;
    private static final GradleVersion IGNORE_NON_RESOLVABLE_SCOPES_GRADLE_VERSION;
    private final Map<ModuleComponentIdentifier, File> pomCache;
    @OutputDirectory
    private final DirectoryProperty outputDir;
    private static /* synthetic */ float $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Inject
    public AbstractAnalyze(ObjectFactory objects) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        Object object = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this));
        this.currentProjectName = ShortTypeHandling.castToString((Object)object);
        Object object2 = callSiteArray[2].call(Attribute.class, (Object)"artifactType", String.class);
        this.artifactType = (Attribute)ScriptBytecodeAdapter.castToType((Object)object2, Attribute.class);
        Object object3 = callSiteArray[3].callConstructor(HashMap.class);
        this.pomCache = (Map)ScriptBytecodeAdapter.castToType((Object)object3, Map.class);
        Object object4 = callSiteArray[4].call(callSiteArray[5].call((Object)objects), callSiteArray[6].callGroovyObjectGetProperty(callSiteArray[7].callGroovyObjectGetProperty((Object)this)));
        this.outputDir = (DirectoryProperty)ScriptBytecodeAdapter.castToType((Object)object4, DirectoryProperty.class);
    }

    @TaskAction
    public Object analyze() {
        block25: {
            Object object = this.getConfig().getSkip().get();
            if (object == null ? false : (Boolean)object) {
                this.getLogger().lifecycle("Skipping dependency-check-gradle");
                return null;
            }
            this.verifySettings();
            this.initializeSettings();
            Engine engine = null;
            try {
                Engine engine2;
                engine = engine2 = new Engine(this.getSettings());
            }
            catch (DatabaseException ex) {
                String msg = "Unable to connect to the dependency-check database";
                Object object2 = this.getConfig().getFailOnError().get();
                if (object2 == null ? false : (Boolean)object2) {
                    this.cleanup(engine);
                    throw (Throwable)new GradleException(msg, (Throwable)ex);
                }
                this.getLogger().error(msg);
            }
            if (!(engine != null)) break block25;
            this.scanDependencies(engine);
            ExceptionCollection exCol = null;
            this.getLogger().lifecycle("Checking for updates and analyzing dependencies for vulnerabilities");
            try {
                engine.analyzeDependencies();
            }
            catch (ExceptionCollection ex) {
                ExceptionCollection exceptionCollection;
                if (DefaultTypeTransformation.booleanUnbox((Object)this.getConfig().getFailOnError().get()) || ex.isFatal()) {
                    this.cleanup(engine);
                    throw (Throwable)new GradleException("Analysis failed.", (Throwable)ex);
                }
                exCol = exceptionCollection = ex;
            }
            this.getLogger().lifecycle(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.currentProjectName}, new String[]{"Generating report for project ", ""})));
            try {
                try {
                    String name = this.getProject().getName();
                    String displayName = this.determineDisplayName();
                    String groupId = ShortTypeHandling.castToString((Object)this.getProject().getGroup());
                    String version = DefaultGroovyMethods.toString((Object)this.getProject().getVersion());
                    File output = ((Directory)this.outputDir.get()).getAsFile();
                    Set<String> set = this.getReportFormats(ShortTypeHandling.castToString((Object)this.getConfig().getFormat().get()), (List)ScriptBytecodeAdapter.castToType((Object)this.getConfig().getFormats().get(), List.class));
                    String f = null;
                    Iterator<String> iterator = set != null ? set.iterator() : null;
                    if (iterator != null) {
                        while (iterator.hasNext()) {
                            f = ShortTypeHandling.castToString((Object)iterator.next());
                            engine.writeReports(displayName, groupId, name, version, output, f, exCol);
                        }
                    }
                    this.showSummary(engine);
                    CheckForFailureResult result = this.checkForFailure(engine);
                    this.sendSlackNotification(result);
                    Boolean bl = result.failed;
                    if (bl == null ? false : bl) {
                        throw (Throwable)new GradleException(result.msg);
                    }
                }
                catch (ReportException ex) {
                    Object object3 = this.getConfig().getFailOnError().get();
                    if (object3 == null ? false : (Boolean)object3) {
                        if (exCol != null) {
                            exCol.addException((Throwable)ex);
                            throw (Throwable)new GradleException("Error generating the report", (Throwable)exCol);
                        }
                        throw (Throwable)new GradleException("Error generating the report", (Throwable)ex);
                    }
                    this.getLogger().error("Error generating the report", (Throwable)ex);
                }
            }
            finally {
                this.cleanup(engine);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.getConfig().getFailOnError().get()) && exCol != null && exCol.getExceptions().size() > 0) {
                throw (Throwable)new GradleException("One or more exceptions occurred during analysis", (Throwable)exCol);
            }
            return null;
        }
        return null;
    }

    public String determineDisplayName() {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].call(callSiteArray[9].callGetProperty(callSiteArray[10].callGroovyObjectGetProperty((Object)this)), callSiteArray[11].callGroovyObjectGetProperty((Object)this), (Object)"getDisplayName")) ? callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)this)) : callSiteArray[14].call(callSiteArray[15].callGroovyObjectGetProperty((Object)this))));
    }

    /*
     * Unable to fully structure code
     */
    public Object verifySettings() {
        v0 = this.getConfig().getScanDependencies().get();
        if (!((v0 == null ? false : (Boolean)v0) == false)) ** GOTO lbl-1000
        v1 = this.getConfig().getScanBuildEnv().get();
        if ((v1 == null ? false : (Boolean)v1) == false) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (v2) {
            throw (Throwable)new IllegalArgumentException("At least one of scanDependencies or scanBuildEnv must be set to true");
        }
        if (((List)this.getConfig().getScanConfigurations().get()).isEmpty() == false != false && ((List)this.getConfig().getSkipConfigurations().get()).isEmpty() == false != false) {
            throw (Throwable)new IllegalArgumentException("you can only specify one of scanConfigurations or skipConfigurations");
        }
        if (((List)this.getConfig().getScanProjects().get()).isEmpty() == false != false && ((List)this.getConfig().getSkipProjects().get()).isEmpty() == false != false) {
            throw (Throwable)new IllegalArgumentException("you can only specify one of scanProjects or skipProjects");
        }
        return null;
    }

    private Set<String> getReportFormats(String format, List<String> formats) {
        HashSet<String> selectedFormats = new HashSet<String>();
        if (formats != null && !formats.isEmpty()) {
            List<String> list = formats;
            Iterator<String> iterator = list != null ? list.iterator() : null;
            String f = null;
            Iterator<String> iterator2 = iterator;
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    f = ShortTypeHandling.castToString((Object)iterator2.next());
                    this.addFormat(f, selectedFormats);
                }
            }
        }
        this.addFormat(format, selectedFormats);
        return selectedFormats;
    }

    private void addFormat(String format, HashSet<String> selectedFormats) {
        if (format != null && !format.trim().isEmpty()) {
            ReportGenerator.Format f2 = null;
            ReportGenerator.Format[] formatArray = ReportGenerator.Format.values();
            if (formatArray != null) {
                for (ReportGenerator.Format f2 : formatArray) {
                    if (!f2.toString().equalsIgnoreCase(format)) continue;
                    selectedFormats.add(f2.toString());
                    return;
                }
            }
            selectedFormats.add(format);
        }
    }

    public Object cleanup(Engine engine) {
        if (engine != null) {
            engine.close();
        }
        if (this.getSettings() != null) {
            this.getSettings().cleanup(true);
            return null;
        }
        return null;
    }

    public abstract Object scanDependencies(Engine var1);

    public Object showSummary(Engine engine) {
        public final class _showSummary_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _showSummary_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Set<Vulnerability> doCall(Dependency dependency) {
                return dependency.getVulnerabilities();
            }

            @Generated
            public Set<Vulnerability> call(Dependency dependency) {
                return this.doCall(dependency);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _showSummary_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List vulnerabilities = DefaultGroovyMethods.flatten((List)DefaultGroovyMethods.collect((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)engine.getDependencies(), Object[].class)), (Closure)new _showSummary_closure1((Object)this, (Object)this)));
        this.getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{vulnerabilities.size(), this.currentProjectName}, new String[]{"Found ", " vulnerabilities in project ", ""})));
        Object object = this.getConfig().getShowSummary().get();
        if (object == null ? false : (Boolean)object) {
            DependencyCheckScanAgent.showSummary((String)this.getProject().getName(), (Dependency[])engine.getDependencies());
            return null;
        }
        return null;
    }

    public CheckForFailureResult checkForFailure(Engine engine) {
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)this.getConfig().getFailBuildOnCVSS().get(), (Object)10)) {
            return CheckForFailureResult.createSuccess();
        }
        HashSet<String> vulnerabilities = new HashSet<String>();
        Dependency d = null;
        Dependency[] dependencyArray = engine.getDependencies();
        if (dependencyArray != null) {
            int n = dependencyArray.length;
            int n2 = 0;
            while (n2 < n) {
                d = dependencyArray[n2];
                ++n2;
                Vulnerability v = null;
                Set set = d.getVulnerabilities();
                Iterator iterator = set != null ? set.iterator() : null;
                if (iterator == null) continue;
                while (iterator.hasNext()) {
                    v = (Vulnerability)ScriptBytecodeAdapter.castToType(iterator.next(), Vulnerability.class);
                    double cvssV2 = v.getCvssV2() != null && v.getCvssV2().getCvssData() != null && v.getCvssV2().getCvssData().getBaseScore() != null ? v.getCvssV2().getCvssData().getBaseScore() : (Double)ScriptBytecodeAdapter.castToType((Object)-1, Double.class);
                    double cvssV3 = v.getCvssV3() != null && v.getCvssV3().getCvssData() != null && v.getCvssV3().getCvssData().getBaseScore() != null ? v.getCvssV3().getCvssData().getBaseScore() : (Double)ScriptBytecodeAdapter.castToType((Object)-1, Double.class);
                    double cvssV4 = v.getCvssV4() != null && v.getCvssV4().getCvssData() != null && v.getCvssV4().getCvssData().getBaseScore() != null ? v.getCvssV4().getCvssData().getBaseScore() : (Double)ScriptBytecodeAdapter.castToType((Object)-1, Double.class);
                    boolean useUnscored = cvssV2 == (double)-1 && cvssV3 == (double)-1 && cvssV4 == (double)-1;
                    double unscoredCvss = useUnscored && v.getUnscoredSeverity() != null ? SeverityUtil.estimateCvssV2((String)v.getUnscoredSeverity()) : (Double)ScriptBytecodeAdapter.castToType((Object)-1, Double.class);
                    if (!(ScriptBytecodeAdapter.compareGreaterThanEqual((Object)cvssV2, (Object)this.getConfig().getFailBuildOnCVSS().get()) || ScriptBytecodeAdapter.compareGreaterThanEqual((Object)cvssV3, (Object)this.getConfig().getFailBuildOnCVSS().get()) || ScriptBytecodeAdapter.compareGreaterThanEqual((Object)cvssV4, (Object)this.getConfig().getFailBuildOnCVSS().get()) || useUnscored && ScriptBytecodeAdapter.compareGreaterThanEqual((Object)unscoredCvss, (Object)this.getConfig().getFailBuildOnCVSS().get()) || ScriptBytecodeAdapter.compareLessThanEqual((Object)this.getConfig().getFailBuildOnCVSS().get(), (Object)Float.valueOf($const$0)))) continue;
                    vulnerabilities.add(v.getName());
                }
            }
        }
        if (vulnerabilities.size() > 0) {
            String msg = String.format(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"%n%nDependency-Analyze Failure:%n", (CharSequence)"One or more dependencies were identified with vulnerabilities that have a CVSS score greater than '%.1f': %s%n"), (CharSequence)"See the dependency-check report for more details.%n%n"), this.getConfig().getFailBuildOnCVSS().get(), DefaultGroovyMethods.join(vulnerabilities, (String)", "));
            return CheckForFailureResult.createFailed(msg);
        }
        return CheckForFailureResult.createSuccess();
    }

    public void sendSlackNotification(CheckForFailureResult checkForFailureResult) {
        Boolean bl = checkForFailureResult.failed;
        if (bl == null ? false : bl) {
            new SlackNotificationSenderService(this.getSettings()).send(this.getCurrentProjectName(), checkForFailureResult.msg);
        }
    }

    public Object shouldBeScanned(Project project) {
        return ((List)this.getConfig().getScanProjects().get()).isEmpty() || ((List)this.getConfig().getScanProjects().get()).contains(project.getPath());
    }

    public Object shouldBeSkipped(Project project) {
        return ((List)this.getConfig().getSkipProjects().get()).contains(project.getPath());
    }

    public boolean shouldBeScanned(Configuration configuration) {
        return ((List)this.getConfig().getScanConfigurations().get()).isEmpty() || ((List)this.getConfig().getScanConfigurations().get()).contains(configuration.getName());
    }

    public boolean shouldBeSkipped(Configuration configuration) {
        return IGNORE_NON_RESOLVABLE_SCOPES_GRADLE_VERSION.compareTo(GradleVersion.current()) <= 0 && ("archives".equals(configuration.getName()) || "default".equals(configuration.getName()) || "runtime".equals(configuration.getName()) || "compile".equals(configuration.getName()) || "compileOnly".equals(configuration.getName())) || ((List)this.getConfig().getSkipConfigurations().get()).contains(configuration.getName());
    }

    public Object shouldBeSkipped(ResolvedArtifactResult artifact) {
        Reference name = new Reference((Object)artifact.getId().getComponentIdentifier().getDisplayName());
        public final class _shouldBeSkipped_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference name;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _shouldBeSkipped_closure2(Object _outerInstance, Object _thisObject, Reference name) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.name = reference = name;
            }

            public Boolean doCall(Object it) {
                return ((String)this.name.get()).startsWith(ShortTypeHandling.castToString((Object)it));
            }

            @Generated
            public Object getName() {
                return this.name.get();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _shouldBeSkipped_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.any((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)this.getConfig().getSkipGroups().get(), Iterable.class)), (Closure)new _shouldBeSkipped_closure2((Object)this, (Object)this, name));
    }

    public boolean shouldBeSkippedAsTest(Configuration configuration) {
        return DefaultTypeTransformation.booleanUnbox((Object)this.getConfig().getSkipTestGroups().get()) && this.isTestConfiguration(configuration);
    }

    public boolean isTestConfiguration(Configuration configuration) {
        boolean isTestConfiguration = AbstractAnalyze.isTestConfigurationCheck(configuration);
        public final class _isTestConfiguration_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isTestConfiguration_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return ((Configuration)it).getName();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isTestConfiguration_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        String hierarchy = DefaultGroovyMethods.join((Iterable)DefaultGroovyMethods.collect((Iterable)configuration.getHierarchy(), (Closure)new _isTestConfiguration_closure3((Object)this, (Object)this)), (String)" --> ");
        this.getLogger().info("'{}' is considered a test configuration: {}", (Object)hierarchy, (Object)isTestConfiguration);
        return isTestConfiguration;
    }

    public static boolean isTestConfigurationCheck(Configuration configuration) {
        Reference isTestConfiguration = new Reference((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)configuration.getName(), (Object)"((^|[a-z0-9_])T|(^|_)t)est([A-Z0-9_]|$)"), Boolean.class)));
        public final class _isTestConfigurationCheck_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference isTestConfiguration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isTestConfigurationCheck_closure4(Object _outerInstance, Object _thisObject, Reference isTestConfiguration) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.isTestConfiguration = reference = isTestConfiguration;
            }

            public Boolean doCall(Object it) {
                Boolean bl = DefaultGroovyMethods.or((Boolean)((Boolean)ScriptBytecodeAdapter.castToType((Object)this.isTestConfiguration.get(), Boolean.class)), (Boolean)DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.findRegex((Object)((Configuration)it).getName(), (Object)"((^|[a-z0-9_])T|(^|_)t)est([A-Z0-9_]|$)"), Boolean.TYPE)));
                this.isTestConfiguration.set((Object)bl);
                return bl;
            }

            @Generated
            public Boolean getIsTestConfiguration() {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.isTestConfiguration.get(), Boolean.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isTestConfigurationCheck_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)configuration.getHierarchy(), (Closure)new _isTestConfigurationCheck_closure4(AbstractAnalyze.class, AbstractAnalyze.class, isTestConfiguration));
        return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)isTestConfiguration.get()));
    }

    public boolean canBeResolved(Configuration configuration) {
        return DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getMetaClass((Object)configuration).respondsTo((Object)configuration, "isCanBeResolved")) ? configuration.isCanBeResolved() : true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File resolvePomFor(Project project, ModuleComponentIdentifier mci) {
        if (this.pomCache.containsKey(mci)) {
            return (File)ScriptBytecodeAdapter.castToType((Object)this.pomCache.get(mci), File.class);
        }
        try {
            ArtifactResolutionResult query = project.getDependencies().createArtifactResolutionQuery().forComponents(new ComponentIdentifier[]{mci}).withArtifacts(MavenModule.class, new Class[]{MavenPomArtifact.class}).execute();
            Set set = query.getResolvedComponents();
            ComponentArtifactsResult comp = null;
            Iterator iterator = set != null ? set.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    comp = (ComponentArtifactsResult)ScriptBytecodeAdapter.castToType(iterator.next(), ComponentArtifactsResult.class);
                    Set set2 = comp.getArtifacts(MavenPomArtifact.class);
                    Iterator iterator2 = set2 != null ? set2.iterator() : null;
                    Object ar = null;
                    Iterator iterator3 = iterator2;
                    if (iterator3 == null) continue;
                    while (iterator3.hasNext()) {
                        ar = iterator3.next();
                        if (!(ar instanceof ResolvedArtifactResult)) continue;
                        File pomFile = ((ResolvedArtifactResult)ScriptBytecodeAdapter.castToType(ar, ResolvedArtifactResult.class)).getFile();
                        this.pomCache.put(mci, pomFile);
                        this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mci, pomFile}, new String[]{"Resolved POM for ", ": ", ""})));
                        return pomFile;
                    }
                }
            }
        }
        catch (Exception e) {
            this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mci, e.getMessage()}, new String[]{"POM resolution failed for ", ": ", ""})));
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        this.pomCache.put(mci, null);
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    /*
     * WARNING - void declaration
     */
    protected void processBuildEnvironment(Project project, Engine engine) {
        void var2_2;
        Reference project2 = new Reference((Object)project);
        Reference engine2 = new Reference((Object)var2_2);
        public final class _processBuildEnvironment_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processBuildEnvironment_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Configuration configuration) {
                return ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeScanned(configuration) && !(((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeSkipped(configuration) || ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeSkippedAsTest(configuration)) && ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).canBeResolved(configuration);
            }

            @Generated
            public Boolean call(Configuration configuration) {
                return this.doCall(configuration);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processBuildEnvironment_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _processBuildEnvironment_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference engine;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processBuildEnvironment_closure6(Object _outerInstance, Object _thisObject, Reference engine, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.engine = reference2 = engine;
                this.project = reference = project;
            }

            public Object doCall(Configuration configuration) {
                if (AbstractAnalyze.pfaccess$0(null).compareTo(GradleVersion.current()) > 0) {
                    return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"processConfigLegacy", (Object)new Object[]{configuration, this.engine.get()});
                }
                return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"processConfigV4", (Object)new Object[]{this.project.get(), configuration, this.engine.get(), true});
            }

            @Generated
            public Object call(Configuration configuration) {
                return this.doCall(configuration);
            }

            @Generated
            public Engine getEngine() {
                return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processBuildEnvironment_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)((Project)project2.get()).getBuildscript().getConfigurations().findAll((Closure)new _processBuildEnvironment_closure5((Object)this, (Object)this)), (Closure)new _processBuildEnvironment_closure6((Object)this, (Object)this, engine2, project2));
    }

    /*
     * WARNING - void declaration
     */
    protected void processConfigurations(Project project, Engine engine) {
        void var2_2;
        Reference project2 = new Reference((Object)project);
        Reference engine2 = new Reference((Object)var2_2);
        public final class _processConfigurations_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processConfigurations_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Configuration configuration) {
                return ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeScanned(configuration) && !(((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeSkipped(configuration) || ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).shouldBeSkippedAsTest(configuration)) && ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).canBeResolved(configuration);
            }

            @Generated
            public Boolean call(Configuration configuration) {
                return this.doCall(configuration);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigurations_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _processConfigurations_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference engine;
            private /* synthetic */ Reference project;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processConfigurations_closure8(Object _outerInstance, Object _thisObject, Reference engine, Reference project) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.engine = reference2 = engine;
                this.project = reference = project;
            }

            public Object doCall(Configuration configuration) {
                if (AbstractAnalyze.pfaccess$0(null).compareTo(GradleVersion.current()) > 0) {
                    return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"processConfigLegacy", (Object)new Object[]{configuration, this.engine.get()});
                }
                return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"processConfigV4", (Object)new Object[]{this.project.get(), configuration, this.engine.get()});
            }

            @Generated
            public Object call(Configuration configuration) {
                return this.doCall(configuration);
            }

            @Generated
            public Engine getEngine() {
                return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
            }

            @Generated
            public Project getProject() {
                return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigurations_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)((Project)project2.get()).getConfigurations().findAll((Closure)new _processConfigurations_closure7((Object)this, (Object)this)), (Closure)new _processConfigurations_closure8((Object)this, (Object)this, engine2, project2));
        if (!this.getConfig().isScanSetConfigured()) {
            List toScan = ScriptBytecodeAdapter.createList((Object[])new Object[]{"src/main/resources", "src/main/webapp", "./package.json", "./package-lock.json", "./npm-shrinkwrap.json", "./yarn.lock", "./pnpm.lock", "pnpm-lock.yaml", "./Gopkg.lock", "./go.mod"});
            public final class _processConfigurations_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference engine;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _processConfigurations_closure9(Object _outerInstance, Object _thisObject, Reference project, Reference engine) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.project = reference2 = project;
                    this.engine = reference = engine;
                }

                public List<Dependency> doCall(Object it) {
                    File f = ((Project)this.project.get()).file(it);
                    if (f.exists()) {
                        return ((Engine)this.engine.get()).scan(f, ((Project)this.project.get()).getName());
                    }
                    return (List)ScriptBytecodeAdapter.castToType(null, List.class);
                }

                @Generated
                public Project getProject() {
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                @Generated
                public Engine getEngine() {
                    return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public List<Dependency> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _processConfigurations_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((List)toScan, (Closure)new _processConfigurations_closure9((Object)this, (Object)this, project2, engine2));
        } else {
            public final class _processConfigurations_closure10
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference project;
                private /* synthetic */ Reference engine;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _processConfigurations_closure10(Object _outerInstance, Object _thisObject, Reference project, Reference engine) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.project = reference2 = project;
                    this.engine = reference = engine;
                }

                public List<Dependency> doCall(Object it) {
                    File f = ((Project)this.project.get()).file(it);
                    if (f.exists()) {
                        return ((Engine)this.engine.get()).scan(f, ((Project)this.project.get()).getName());
                    }
                    ((AbstractAnalyze)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getLogger().warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{f, ((Project)this.project.get()).getName()}, new String[]{"ScanSet file `", "` does not exist in ", ""})));
                    return (List)ScriptBytecodeAdapter.castToType(null, List.class);
                }

                @Generated
                public Project getProject() {
                    return (Project)ScriptBytecodeAdapter.castToType((Object)this.project.get(), Project.class);
                }

                @Generated
                public Engine getEngine() {
                    return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public List<Dependency> doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _processConfigurations_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each((Iterable)this.getConfig().getScanSet(), (Closure)new _processConfigurations_closure10((Object)this, (Object)this, project2, engine2));
        }
        public final class _processConfigurations_closure11
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference engine;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processConfigurations_closure11(Object _outerInstance, Object _thisObject, Reference engine) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.engine = reference = engine;
            }

            public Object doCall(Object it) {
                Dependency dependency = new Dependency(true);
                dependency.setDescription(ShortTypeHandling.castToString((Object)((AdditionalCpe)it).getDescription().getOrNull()));
                dependency.setDisplayFileName(ShortTypeHandling.castToString((Object)((AdditionalCpe)it).getCpe().getOrNull()));
                dependency.setSha1sum(Checksum.getSHA1Checksum((String)ShortTypeHandling.castToString((Object)((AdditionalCpe)it).getCpe().getOrNull())));
                dependency.setSha256sum(Checksum.getSHA256Checksum((String)ShortTypeHandling.castToString((Object)((AdditionalCpe)it).getCpe().getOrNull())));
                dependency.setMd5sum(Checksum.getMD5Checksum((String)ShortTypeHandling.castToString((Object)((AdditionalCpe)it).getCpe().getOrNull())));
                dependency.addVulnerableSoftwareIdentifier((Identifier)new CpeIdentifier(CpeParser.parse((String)ShortTypeHandling.castToString((Object)((AdditionalCpe)it).getCpe().getOrNull())), Confidence.HIGHEST));
                dependency.setFileName("");
                dependency.setActualFilePath("");
                ((Engine)this.engine.get()).addDependency(dependency);
                return null;
            }

            @Generated
            public Engine getEngine() {
                return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigurations_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(this.getConfig().getAdditionalCpes(), (Closure)new _processConfigurations_closure11((Object)this, (Object)this, engine2));
    }

    /*
     * WARNING - void declaration
     */
    protected void processConfigLegacy(Configuration configuration, Engine engine) {
        void var2_2;
        Reference configuration2 = new Reference((Object)configuration);
        Reference engine2 = new Reference((Object)var2_2);
        public final class _processConfigLegacy_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference engine;
            private /* synthetic */ Reference configuration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processConfigLegacy_closure12(Object _outerInstance, Object _thisObject, Reference engine, Reference configuration) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.engine = reference2 = engine;
                this.configuration = reference = configuration;
            }

            public Object doCall(ResolvedArtifact artifact) {
                List dependencies = ((Engine)this.engine.get()).scan(artifact.getFile());
                if (!((AbstractAnalyze)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getProject().getGradle().getStartParameter().isOffline() && dependencies != null && dependencies.size() == 1) {
                    ModuleVersionIdentifier id = artifact.getModuleVersion().getId();
                    if (DefaultTypeTransformation.booleanUnbox((Object)id.getGroup()) && DefaultTypeTransformation.booleanUnbox((Object)id.getName()) && DefaultTypeTransformation.booleanUnbox((Object)id.getVersion())) {
                        ComponentIdentifier compId = artifact.getId().getComponentIdentifier();
                        if (compId instanceof ModuleComponentIdentifier) {
                            File pomFile = ((AbstractAnalyze)((Object)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), AbstractAnalyze.class))).resolvePomFor(((AbstractAnalyze)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getProject(), (ModuleComponentIdentifier)ScriptBytecodeAdapter.castToType((Object)compId, ModuleComponentIdentifier.class));
                            if (pomFile != null) {
                                try {
                                    PomUtils.analyzePOM((Dependency)((Dependency)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)dependencies, (int)0), Dependency.class)), (File)pomFile);
                                }
                                catch (Exception e) {
                                    ((AbstractAnalyze)((DefaultTask)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), DefaultTask.class))).getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion(), e.getMessage()}, new String[]{"Failed to analyze POM for ", ":", ":", ": ", ""})));
                                }
                            }
                        }
                    }
                }
                return InvokerHelper.invokeMethodSafe((Object)((Object)((AbstractAnalyze)((Object)this.getThisObject()))), (String)"addInfoToDependencies", (Object)new Object[]{dependencies, ((Configuration)this.configuration.get()).getName(), artifact.getModuleVersion().getId(), null});
            }

            @Generated
            public Object call(ResolvedArtifact artifact) {
                return this.doCall(artifact);
            }

            @Generated
            public Engine getEngine() {
                return (Engine)ScriptBytecodeAdapter.castToType((Object)this.engine.get(), Engine.class);
            }

            @Generated
            public Configuration getConfiguration() {
                return (Configuration)ScriptBytecodeAdapter.castToType((Object)this.configuration.get(), Configuration.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigLegacy_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.collect((Iterable)((Configuration)configuration2.get()).getResolvedConfiguration().getResolvedArtifacts(), (Closure)new _processConfigLegacy_closure12((Object)this, (Object)this, engine2, configuration2));
    }

    private Map<PackageURL, Set<IncludedByReference>> buildIncludedByMap(Project project, Configuration configuration, boolean scanningBuildEnv) {
        Reference includedByMap = new Reference(new HashMap());
        Reference type = new Reference(null);
        if (scanningBuildEnv) {
            String string = "buildEnv";
            type.set((Object)string);
        }
        Reference parent = new Reference((Object)new IncludedByReference(AbstractAnalyze.convertIdentifier(project).toString(), (String)type.get()));
        public final class _buildIncludedByMap_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includedByMap;
            private /* synthetic */ Reference parent;
            private /* synthetic */ Reference type;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildIncludedByMap_closure13(Object _outerInstance, Object _thisObject, Reference includedByMap, Reference parent, Reference type) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.includedByMap = reference3 = includedByMap;
                this.parent = reference2 = parent;
                this.type = reference = type;
            }

            public Void doCall(Object it) {
                if (it instanceof ResolvedDependencyResult) {
                    ResolvedDependencyResult dr = (ResolvedDependencyResult)ScriptBytecodeAdapter.castToType((Object)it, ResolvedDependencyResult.class);
                    ResolvedComponentResult current = dr.getSelected();
                    PackageURL purl = AbstractAnalyze.convertIdentifier(current);
                    if (((HashMap)this.includedByMap.get()).containsKey(purl)) {
                        ((Set)((HashMap)this.includedByMap.get()).get(purl)).add(this.parent.get());
                    } else {
                        HashSet<Object> rootParent = new HashSet<Object>();
                        rootParent.add(this.parent.get());
                        ((HashMap)this.includedByMap.get()).put(purl, rootParent);
                    }
                    IncludedByReference root = new IncludedByReference(AbstractAnalyze.convertIdentifier(current).toString(), ShortTypeHandling.castToString((Object)this.type.get()));
                    AbstractAnalyze.collectDependencyMap((Map)ScriptBytecodeAdapter.castToType((Object)this.includedByMap.get(), Map.class), root, current.getDependencies(), 0);
                    return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
                }
                return (Void)ScriptBytecodeAdapter.castToType(null, Void.class);
            }

            @Generated
            public Map getIncludedByMap() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.includedByMap.get(), Map.class);
            }

            @Generated
            public IncludedByReference getParent() {
                return (IncludedByReference)ScriptBytecodeAdapter.castToType((Object)this.parent.get(), IncludedByReference.class);
            }

            @Generated
            public String getType() {
                return ShortTypeHandling.castToString((Object)this.type.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Void doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildIncludedByMap_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        configuration.getIncoming().getResolutionResult().getRoot().getDependencies().forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _buildIncludedByMap_closure13((Object)this, (Object)this, includedByMap, parent, type)), Consumer.class));
        return (HashMap)includedByMap.get();
    }

    private static void collectDependencyMap(Map<PackageURL, Set<IncludedByReference>> includedByMap, IncludedByReference root, Set<? extends DependencyResult> dependencies, int depth) {
        Set<? extends DependencyResult> set = dependencies;
        Iterator<? extends DependencyResult> iterator = set != null ? set.iterator() : null;
        DependencyResult it = null;
        Iterator<? extends DependencyResult> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                it = (DependencyResult)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), DependencyResult.class);
                if (!(it instanceof ResolvedDependencyResult)) continue;
                ResolvedDependencyResult rdr = (ResolvedDependencyResult)ScriptBytecodeAdapter.castToType((Object)it, ResolvedDependencyResult.class);
                ResolvedComponentResult current = rdr.getSelected();
                PackageURL purl = AbstractAnalyze.convertIdentifier(current);
                if (includedByMap.containsKey(purl)) {
                    Set includedBy = (Set)ScriptBytecodeAdapter.castToType(includedByMap.get(purl), Set.class);
                    if (includedBy.contains(root)) continue;
                    includedBy.add(root);
                } else {
                    HashSet<IncludedByReference> rootParent = new HashSet<IncludedByReference>();
                    rootParent.add(root);
                    includedByMap.put(purl, rootParent);
                }
                if (!(current.getDependencies() != null && !current.getDependencies().isEmpty() && depth < 500)) continue;
                AbstractAnalyze.collectDependencyMap(includedByMap, root, current.getDependencies(), depth + 1);
            }
        }
    }

    protected void processConfigV4(Project project, Configuration configuration, Engine engine, boolean scanningBuildEnv) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        String projectName = ShortTypeHandling.castToString((Object)callSiteArray[16].callGetProperty((Object)project));
        String scope = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projectName, callSiteArray[17].callGetProperty((Object)configuration)}, new String[]{"", ":", ""}));
        if (scanningBuildEnv) {
            scope = ShortTypeHandling.castToString((Object)callSiteArray[18].call((Object)scope, (Object)" (buildEnv)"));
        }
        callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{scope}, new String[]{"- Analyzing ", ""}));
        Reference componentVersions = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _processConfigV4_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference componentVersions;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _processConfigV4_closure14(Object _outerInstance, Object _thisObject, Reference componentVersions) {
                Reference reference;
                CallSite[] callSiteArray = _processConfigV4_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.componentVersions = reference = componentVersions;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _processConfigV4_closure14.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(it, (Object)"selected"))) {
                    return callSiteArray[1].call(this.componentVersions.get(), callSiteArray[2].call(callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(it))), callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(it)));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call(it, (Object)"attempted"))) {
                    return callSiteArray[8].call(callSiteArray[9].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[10].callGetProperty(callSiteArray[11].callGetProperty(it))}, new String[]{"Unable to resolve artifact in ", ""}));
                }
                return callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{it}, new String[]{"Unable to resolve: ", ""}));
            }

            @Generated
            public Map getComponentVersions() {
                CallSite[] callSiteArray = _processConfigV4_closure14.$getCallSiteArray();
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.componentVersions.get(), Map.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _processConfigV4_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processConfigV4_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "hasProperty";
                stringArray[1] = "put";
                stringArray[2] = "toString";
                stringArray[3] = "id";
                stringArray[4] = "selected";
                stringArray[5] = "moduleVersion";
                stringArray[6] = "selected";
                stringArray[7] = "hasProperty";
                stringArray[8] = "debug";
                stringArray[9] = "logger";
                stringArray[10] = "displayName";
                stringArray[11] = "attempted";
                stringArray[12] = "warn";
                stringArray[13] = "logger";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[14];
                _processConfigV4_closure14.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_processConfigV4_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _processConfigV4_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[21].call(callSiteArray[22].callGetProperty(callSiteArray[23].callGetProperty(callSiteArray[24].callGetProperty((Object)configuration))), (Object)new _processConfigV4_closure14((Object)this, (Object)this, componentVersions));
        Map includedByMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callCurrent((GroovyObject)this, (Object)project, (Object)configuration, (Object)scanningBuildEnv), Map.class);
        Object types = callSiteArray[26].call(callSiteArray[27].callGroovyObjectGetProperty(callSiteArray[28].callGroovyObjectGetProperty((Object)this)));
        Reference type = new Reference(null);
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].call(types), Iterator.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                type.set((Object)ShortTypeHandling.castToString(iterator.next()));
                public final class _processConfigV4_closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference type;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _processConfigV4_closure15(Object _outerInstance, Object _thisObject, Reference type) {
                        Reference reference;
                        CallSite[] callSiteArray = _processConfigV4_closure15.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.type = reference = type;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _processConfigV4_closure15.$getCallSiteArray();
                        callSiteArray[0].callCurrent((GroovyObject)this, (Object)true);
                        public final class _closure16
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference type;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure16(Object _outerInstance, Object _thisObject, Reference type) {
                                Reference reference;
                                CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.type = reference = type;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                return callSiteArray[0].call(it, callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.type.get());
                            }

                            @Generated
                            public String getType() {
                                CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                return ShortTypeHandling.castToString((Object)this.type.get());
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure16.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure16.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "attribute";
                                stringArray[1] = "artifactType";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[2];
                                _closure16.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure16.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure16.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        return callSiteArray[1].callCurrent((GroovyObject)this, (Object)new _closure16((Object)this, this.getThisObject(), this.type));
                    }

                    @Generated
                    public String getType() {
                        CallSite[] callSiteArray = _processConfigV4_closure15.$getCallSiteArray();
                        return ShortTypeHandling.castToString((Object)this.type.get());
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _processConfigV4_closure15.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _processConfigV4_closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "lenient";
                        stringArray[1] = "attributes";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[2];
                        _processConfigV4_closure15.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_processConfigV4_closure15.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _processConfigV4_closure15.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                List rar = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].callGetProperty((Object)configuration), (Object)new _processConfigV4_closure15((Object)this, (Object)this, type)))), List.class);
                ResolvedArtifactResult resolvedArtifactResult = null;
                Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call((Object)rar), Iterator.class);
                if (iterator2 == null) continue;
                while (iterator2.hasNext()) {
                    resolvedArtifactResult = (ResolvedArtifactResult)ScriptBytecodeAdapter.castToType(iterator2.next(), ResolvedArtifactResult.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].callCurrent((GroovyObject)this, (Object)resolvedArtifactResult))) continue;
                    ModuleVersionIdentifier id = (ModuleVersionIdentifier)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call((Object)((Map)componentVersions.get()), callSiteArray[37].call(callSiteArray[38].callGetProperty(callSiteArray[39].callGetProperty((Object)resolvedArtifactResult)))), ModuleVersionIdentifier.class);
                    if (ScriptBytecodeAdapter.compareEqual((Object)id, null)) {
                        callSiteArray[40].call(callSiteArray[41].callGroovyObjectGetProperty((Object)this), callSiteArray[42].call((Object)new GStringImpl(new Object[]{callSiteArray[43].callGetProperty(callSiteArray[44].callGetProperty((Object)resolvedArtifactResult))}, new String[]{"Could not find dependency {'artifact': '", "', "}), (Object)new GStringImpl(new Object[]{callSiteArray[45].callGetProperty((Object)resolvedArtifactResult)}, new String[]{"'file':'", "'}"})));
                        continue;
                    }
                    Object deps = callSiteArray[46].call((Object)engine, callSiteArray[47].callGetProperty((Object)resolvedArtifactResult), (Object)scope);
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].callGetProperty(callSiteArray[49].callGetProperty(callSiteArray[50].callGetProperty((Object)project)))) && ScriptBytecodeAdapter.compareNotEqual((Object)deps, null) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[51].call(deps), (Object)1)) {
                        Object compId = callSiteArray[52].callGetProperty(callSiteArray[53].callGetProperty((Object)resolvedArtifactResult));
                        if (compId instanceof ModuleComponentIdentifier) {
                            File pomFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callCurrent((GroovyObject)this, (Object)project, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((ModuleComponentIdentifier)ScriptBytecodeAdapter.castToType((Object)compId, ModuleComponentIdentifier.class)), ModuleComponentIdentifier.class)), File.class);
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)pomFile, null)) {
                                try {
                                    callSiteArray[55].call(PomUtils.class, callSiteArray[56].call(deps, (Object)0), (Object)pomFile);
                                }
                                catch (Exception e) {
                                    callSiteArray[57].call(callSiteArray[58].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[59].callGetProperty(compId), callSiteArray[60].callGetProperty(compId), callSiteArray[61].callGetProperty(compId), e}, new String[]{"Failed to analyze POM for ", ":", ":", ": ", ""}));
                                }
                            }
                        }
                    }
                    if (!ScriptBytecodeAdapter.compareNotEqual((Object)deps, null)) continue;
                    callSiteArray[62].callCurrent((GroovyObject)this, deps, (Object)scope, (Object)id, callSiteArray[63].call((Object)includedByMap, callSiteArray[64].callStatic(AbstractAnalyze.class, (Object)id)));
                }
            }
        }
    }

    protected void addInfoToDependencies(List<Dependency> deps, String configurationName, ModuleVersionIdentifier id, Set<IncludedByReference> includedBy) {
        if (deps != null) {
            if (deps.size() == 1) {
                Dependency d = (Dependency)ScriptBytecodeAdapter.castToType((Object)deps.get(0), Dependency.class);
                MavenArtifact mavenArtifact = new MavenArtifact(id.getGroup(), id.getName(), id.getVersion());
                d.addAsEvidence("gradle", mavenArtifact, Confidence.HIGHEST);
                d.addProjectReference(configurationName);
                if (includedBy != null) {
                    d.addAllIncludedBy(includedBy);
                }
            } else {
                List<Dependency> list = deps;
                Iterator<Dependency> iterator = list != null ? list.iterator() : null;
                Dependency it = null;
                Iterator<Dependency> iterator2 = iterator;
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        it = (Dependency)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Dependency.class);
                        it.addProjectReference(configurationName);
                        if (!(includedBy != null)) continue;
                        it.addAllIncludedBy(includedBy);
                    }
                }
            }
        }
    }

    private static PackageURL convertIdentifier(Project project) {
        PackageURL packageURL;
        PackageURL packageURL2;
        PackageURL p = null;
        p = DefaultTypeTransformation.booleanUnbox((Object)project.getGroup()) ? (packageURL2 = new PackageURL("maven", DefaultGroovyMethods.toString((Object)project.getGroup()), project.getName(), DefaultGroovyMethods.toString((Object)project.getVersion()), null, null)) : (packageURL = PackageURLBuilder.aPackageURL().withType("gradle").withName(project.getName()).withVersion(DefaultGroovyMethods.toString((Object)project.getVersion())).build());
        return p;
    }

    private static PackageURL convertIdentifier(ResolvedComponentResult result) {
        return AbstractAnalyze.convertIdentifier(result.getModuleVersion());
    }

    private static PackageURL convertIdentifier(ModuleComponentIdentifier id) {
        PackageURL p = new PackageURL("maven", id.getModuleIdentifier().getGroup(), id.getModuleIdentifier().getName(), id.getVersion(), null, null);
        return p;
    }

    private static PackageURL convertIdentifier(ProjectComponentIdentifier id) {
        return PackageURLBuilder.aPackageURL().withType("gradle").withName(id.getProjectPath()).build();
    }

    private static PackageURL convertIdentifier(ModuleVersionIdentifier id) {
        PackageURL p = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)id.getGroup())) {
            PackageURL packageURL;
            p = packageURL = new PackageURL("maven", id.getGroup(), id.getName(), id.getVersion(), null, null);
        } else {
            PackageURL packageURL;
            PackageURLBuilder pb = PackageURLBuilder.aPackageURL().withType("gradle").withName(id.getName());
            if (DefaultTypeTransformation.booleanUnbox((Object)id.getVersion())) {
                pb.withVersion(id.getVersion());
            }
            p = packageURL = pb.build();
        }
        return p;
    }

    protected void addDependency(Engine engine, String projectName, String configurationName, ModuleVersionIdentifier id, String displayName, File file) {
        String string = displayName;
        String display = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""})));
        Dependency dependency = null;
        Object sha256 = null;
        if (file == null) {
            Dependency dependency2;
            this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{display}, new String[]{"Adding virtual dependency for ", ""})));
            dependency = dependency2 = new Dependency(this.getProject().getBuildFile(), true);
        } else {
            Dependency dependency3;
            this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{display}, new String[]{"Adding dependency for ", ""})));
            dependency = dependency3 = new Dependency(file);
        }
        if (dependency.getSha1sum() == null && dependency.isVirtual()) {
            String string2 = Checksum.getSHA1Checksum((String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""})));
            dependency.setSha1sum(string2);
            String string3 = Checksum.getSHA256Checksum((String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""})));
            dependency.setSha256sum(string3);
            String string4 = Checksum.getMD5Checksum((String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""})));
            dependency.setMd5sum(string4);
            String string5 = display;
            dependency.setDisplayFileName(string5);
        }
        dependency.addEvidence(EvidenceType.VENDOR, "build.gradle", "displayName", display, Confidence.MEDIUM);
        dependency.addEvidence(EvidenceType.PRODUCT, "build.gradle", "displayName", display, Confidence.HIGH);
        if (dependency.getPackagePath() == null) {
            String string6 = id.getName();
            dependency.setName(string6);
            String string7 = id.getVersion();
            dependency.setVersion(string7);
            GStringImpl gStringImpl = new GStringImpl(new Object[]{id.getGroup(), id.getName(), id.getVersion()}, new String[]{"", ":", ":", ""});
            dependency.setPackagePath(ShortTypeHandling.castToString((Object)gStringImpl));
        }
        MavenArtifact mavenArtifact = new MavenArtifact(id.getGroup(), id.getName(), id.getVersion());
        dependency.addAsEvidence("gradle", mavenArtifact, Confidence.HIGHEST);
        dependency.addProjectReference(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{projectName, configurationName}, new String[]{"", ":", ""})));
        engine.addDependency(dependency);
    }

    protected boolean hasNotCompatibleWithConfigurationCacheOption() {
        return DefaultTypeTransformation.booleanUnbox((Object)this.getMetaClass().respondsTo((Object)this, "notCompatibleWithConfigurationCache", new Object[]{String.class}));
    }

    protected void callIncompatibleWithConfigurationCache() {
        String methodName = "notCompatibleWithConfigurationCache";
        Object[] methodArgs = new Object[]{"The gradle-versions-plugin isn't compatible with the configuration cache"};
        this.getMetaClass().invokeMethod((Object)this, methodName, methodArgs);
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[65].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[66].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[67].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AbstractAnalyze.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ GradleVersion pfaccess$0(AbstractAnalyze $that) {
        return (GradleVersion)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(AbstractAnalyze.class, AbstractAnalyze.class, (String)"CUTOVER_GRADLE_VERSION"), GradleVersion.class);
    }

    @Generated
    protected void processConfigV4(Project project, Configuration configuration, Engine engine) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        this.processConfigV4(project, configuration, engine, false);
    }

    @Generated
    protected void addDependency(Engine engine, String projectName, String configurationName, ModuleVersionIdentifier id, String displayName) {
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        this.addDependency(engine, projectName, configurationName, id, displayName, null);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AbstractAnalyze.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        float f;
        CallSite[] callSiteArray = AbstractAnalyze.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = f = 0.0f;
    }

    static {
        AbstractAnalyze.__$swapInit();
        Object object = AbstractAnalyze.$getCallSiteArray()[68].call(GradleVersion.class, (Object)"4.0");
        CUTOVER_GRADLE_VERSION = (GradleVersion)ScriptBytecodeAdapter.castToType((Object)object, GradleVersion.class);
        Object object2 = AbstractAnalyze.$getCallSiteArray()[69].call(GradleVersion.class, (Object)"7.0");
        IGNORE_NON_RESOLVABLE_SCOPES_GRADLE_VERSION = (GradleVersion)ScriptBytecodeAdapter.castToType((Object)object2, GradleVersion.class);
    }

    @Generated
    public String getCurrentProjectName() {
        return this.currentProjectName;
    }

    @Generated
    public void setCurrentProjectName(String string) {
        this.currentProjectName = string;
    }

    @Generated
    public Attribute getArtifactType() {
        return this.artifactType;
    }

    @Generated
    public void setArtifactType(Attribute attribute) {
        this.artifactType = attribute;
    }

    @Generated
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getName";
        stringArray[1] = "project";
        stringArray[2] = "of";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "convention";
        stringArray[5] = "directoryProperty";
        stringArray[6] = "outputDirectory";
        stringArray[7] = "config";
        stringArray[8] = "respondsTo";
        stringArray[9] = "metaClass";
        stringArray[10] = "project";
        stringArray[11] = "project";
        stringArray[12] = "getDisplayName";
        stringArray[13] = "project";
        stringArray[14] = "getName";
        stringArray[15] = "project";
        stringArray[16] = "name";
        stringArray[17] = "name";
        stringArray[18] = "plus";
        stringArray[19] = "info";
        stringArray[20] = "logger";
        stringArray[21] = "each";
        stringArray[22] = "allDependencies";
        stringArray[23] = "resolutionResult";
        stringArray[24] = "incoming";
        stringArray[25] = "buildIncludedByMap";
        stringArray[26] = "get";
        stringArray[27] = "analyzedTypes";
        stringArray[28] = "config";
        stringArray[29] = "iterator";
        stringArray[30] = "toList";
        stringArray[31] = "getArtifacts";
        stringArray[32] = "artifactView";
        stringArray[33] = "incoming";
        stringArray[34] = "iterator";
        stringArray[35] = "shouldBeSkipped";
        stringArray[36] = "getAt";
        stringArray[37] = "getDisplayName";
        stringArray[38] = "componentIdentifier";
        stringArray[39] = "id";
        stringArray[40] = "debug";
        stringArray[41] = "logger";
        stringArray[42] = "plus";
        stringArray[43] = "componentIdentifier";
        stringArray[44] = "id";
        stringArray[45] = "file";
        stringArray[46] = "scan";
        stringArray[47] = "file";
        stringArray[48] = "offline";
        stringArray[49] = "startParameter";
        stringArray[50] = "gradle";
        stringArray[51] = "size";
        stringArray[52] = "componentIdentifier";
        stringArray[53] = "id";
        stringArray[54] = "resolvePomFor";
        stringArray[55] = "analyzePOM";
        stringArray[56] = "getAt";
        stringArray[57] = "debug";
        stringArray[58] = "logger";
        stringArray[59] = "group";
        stringArray[60] = "name";
        stringArray[61] = "version";
        stringArray[62] = "addInfoToDependencies";
        stringArray[63] = "get";
        stringArray[64] = "convertIdentifier";
        stringArray[65] = "length";
        stringArray[66] = "getAt";
        stringArray[67] = "length";
        stringArray[68] = "version";
        stringArray[69] = "version";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[70];
        AbstractAnalyze.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AbstractAnalyze.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AbstractAnalyze.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class CheckForFailureResult
    implements GroovyObject {
        private Boolean failed;
        private String msg;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public CheckForFailureResult(Boolean failed, String msg) {
            String string;
            Boolean bl;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.failed = bl = failed;
            this.msg = string = msg;
        }

        public static CheckForFailureResult createSuccess() {
            return new CheckForFailureResult(false, "");
        }

        public static CheckForFailureResult createFailed(String msg) {
            return new CheckForFailureResult(true, msg);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)).length == 1) {
                return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(CheckForFailureResult.class, AbstractAnalyze.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != CheckForFailureResult.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @groovy.transform.Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @groovy.transform.Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

