
package org.owasp.dependencycheck.data.knownexploited.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * CISA Catalog of Known Exploited Vulnerabilities
 * <p>
 * A catalog of known exploited vulnerabilities that carry significant risk to the federal enterprise
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "catalogVersion",
    "dateReleased",
    "count",
    "vulnerabilities"
})
@Generated("jsonschema2pojo")
public class KnownExploitedVulnerabilitiesSchema {

    /**
     * Version of the known exploited vulnerabilities catalog
     * (Required)
     * 
     */
    @JsonProperty("catalogVersion")
    @JsonPropertyDescription("Version of the known exploited vulnerabilities catalog")
    private String catalogVersion;
    /**
     * Date-time of Catalog Release in the format YYYY-MM-DDTHH:mm:ss.sssZ
     * (Required)
     * 
     */
    @JsonProperty("dateReleased")
    @JsonPropertyDescription("Date-time of Catalog Release in the format YYYY-MM-DDTHH:mm:ss.sssZ")
    private Date dateReleased;
    /**
     * Total number of Known Exploited Vulnerabilities in the catalog
     * (Required)
     * 
     */
    @JsonProperty("count")
    @JsonPropertyDescription("Total number of Known Exploited Vulnerabilities in the catalog")
    private Integer count;
    /**
     * The exploited vulnerabilities included in this catalog
     * (Required)
     * 
     */
    @JsonProperty("vulnerabilities")
    @JsonPropertyDescription("The exploited vulnerabilities included in this catalog")
    private List<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * Version of the known exploited vulnerabilities catalog
     * (Required)
     * 
     */
    @JsonProperty("catalogVersion")
    public String getCatalogVersion() {
        return catalogVersion;
    }

    /**
     * Version of the known exploited vulnerabilities catalog
     * (Required)
     * 
     */
    @JsonProperty("catalogVersion")
    public void setCatalogVersion(String catalogVersion) {
        this.catalogVersion = catalogVersion;
    }

    /**
     * Date-time of Catalog Release in the format YYYY-MM-DDTHH:mm:ss.sssZ
     * (Required)
     * 
     */
    @JsonProperty("dateReleased")
    public Date getDateReleased() {
        return dateReleased;
    }

    /**
     * Date-time of Catalog Release in the format YYYY-MM-DDTHH:mm:ss.sssZ
     * (Required)
     * 
     */
    @JsonProperty("dateReleased")
    public void setDateReleased(Date dateReleased) {
        this.dateReleased = dateReleased;
    }

    /**
     * Total number of Known Exploited Vulnerabilities in the catalog
     * (Required)
     * 
     */
    @JsonProperty("count")
    public Integer getCount() {
        return count;
    }

    /**
     * Total number of Known Exploited Vulnerabilities in the catalog
     * (Required)
     * 
     */
    @JsonProperty("count")
    public void setCount(Integer count) {
        this.count = count;
    }

    /**
     * The exploited vulnerabilities included in this catalog
     * (Required)
     * 
     */
    @JsonProperty("vulnerabilities")
    public List<Vulnerability> getVulnerabilities() {
        return vulnerabilities;
    }

    /**
     * The exploited vulnerabilities included in this catalog
     * (Required)
     * 
     */
    @JsonProperty("vulnerabilities")
    public void setVulnerabilities(List<Vulnerability> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(KnownExploitedVulnerabilitiesSchema.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("catalogVersion");
        sb.append('=');
        sb.append(((this.catalogVersion == null)?"<null>":this.catalogVersion));
        sb.append(',');
        sb.append("dateReleased");
        sb.append('=');
        sb.append(((this.dateReleased == null)?"<null>":this.dateReleased));
        sb.append(',');
        sb.append("count");
        sb.append('=');
        sb.append(((this.count == null)?"<null>":this.count));
        sb.append(',');
        sb.append("vulnerabilities");
        sb.append('=');
        sb.append(((this.vulnerabilities == null)?"<null>":this.vulnerabilities));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.catalogVersion == null)? 0 :this.catalogVersion.hashCode()));
        result = ((result* 31)+((this.count == null)? 0 :this.count.hashCode()));
        result = ((result* 31)+((this.vulnerabilities == null)? 0 :this.vulnerabilities.hashCode()));
        result = ((result* 31)+((this.dateReleased == null)? 0 :this.dateReleased.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof KnownExploitedVulnerabilitiesSchema) == false) {
            return false;
        }
        KnownExploitedVulnerabilitiesSchema rhs = ((KnownExploitedVulnerabilitiesSchema) other);
        return ((((((this.catalogVersion == rhs.catalogVersion)||((this.catalogVersion!= null)&&this.catalogVersion.equals(rhs.catalogVersion)))&&((this.count == rhs.count)||((this.count!= null)&&this.count.equals(rhs.count))))&&((this.vulnerabilities == rhs.vulnerabilities)||((this.vulnerabilities!= null)&&this.vulnerabilities.equals(rhs.vulnerabilities))))&&((this.dateReleased == rhs.dateReleased)||((this.dateReleased!= null)&&this.dateReleased.equals(rhs.dateReleased))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
