/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.jeremylong.openvulnerability.client.nvd.CveApiJson20;
import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.zip.GZIPInputStream;
import org.owasp.dependencycheck.data.nvd.ecosystem.CveEcosystemMapper;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdApiProcessor
implements Callable<NvdApiProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdApiProcessor.class);
    private final CveDB cveDB;
    private File jsonFile;
    private final CveEcosystemMapper mapper = new CveEcosystemMapper();
    private final long startTime;
    private long endTime = 0L;

    public NvdApiProcessor(CveDB cveDB, File jsonFile, long startTime) {
        this.cveDB = cveDB;
        this.jsonFile = jsonFile;
        this.startTime = startTime;
    }

    public NvdApiProcessor(CveDB cveDB, File jsonFile) {
        this(cveDB, jsonFile, System.currentTimeMillis());
    }

    @Override
    public NvdApiProcessor call() throws Exception {
        Collection data;
        block59: {
            Throwable throwable;
            GZIPInputStream gzipInputStream2;
            Throwable throwable2;
            FileInputStream fileInputStream;
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new JavaTimeModule());
            data = null;
            if (this.jsonFile.getName().endsWith(".jsonarray.gz")) {
                try {
                    fileInputStream = new FileInputStream(this.jsonFile);
                    throwable2 = null;
                    try {
                        gzipInputStream2 = new GZIPInputStream(fileInputStream);
                        throwable = null;
                        try {
                            data = (Collection)objectMapper.readValue((InputStream)gzipInputStream2, (TypeReference)new TypeReference<Collection<DefCveItem>>(){});
                            break block59;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (gzipInputStream2 != null) {
                                if (throwable != null) {
                                    try {
                                        gzipInputStream2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    gzipInputStream2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable gzipInputStream2) {
                        throwable2 = gzipInputStream2;
                        throw gzipInputStream2;
                    }
                    finally {
                        if (fileInputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Throwable gzipInputStream2) {
                                    throwable2.addSuppressed(gzipInputStream2);
                                }
                            } else {
                                fileInputStream.close();
                            }
                        }
                    }
                }
                catch (IOException exception) {
                    throw new UpdateException("Unable to read downloaded json data: " + this.jsonFile, exception);
                }
            }
            if (this.jsonFile.getName().endsWith(".gz")) {
                try {
                    fileInputStream = new FileInputStream(this.jsonFile);
                    throwable2 = null;
                    try {
                        gzipInputStream2 = new GZIPInputStream(fileInputStream);
                        throwable = null;
                        try {
                            CveApiJson20 cveData = (CveApiJson20)objectMapper.readValue((InputStream)gzipInputStream2, CveApiJson20.class);
                            if (cveData != null) {
                                data = cveData.getVulnerabilities();
                            }
                            break block59;
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (gzipInputStream2 != null) {
                                if (throwable != null) {
                                    try {
                                        gzipInputStream2.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    gzipInputStream2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable gzipInputStream3) {
                        throwable2 = gzipInputStream3;
                        throw gzipInputStream3;
                    }
                    finally {
                        if (fileInputStream != null) {
                            if (throwable2 != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (Throwable gzipInputStream3) {
                                    throwable2.addSuppressed(gzipInputStream3);
                                }
                            } else {
                                fileInputStream.close();
                            }
                        }
                    }
                }
                catch (IOException exception) {
                    throw new UpdateException("Unable to read downloaded json data: " + this.jsonFile, exception);
                }
            }
            data = (Collection)objectMapper.readValue(this.jsonFile, (TypeReference)new TypeReference<Collection<DefCveItem>>(){});
        }
        if (data != null) {
            for (DefCveItem entry : data) {
                try {
                    this.cveDB.updateVulnerability(entry, this.mapper.getEcosystem(entry));
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to process " + entry.getCve().getId(), (Throwable)ex);
                }
            }
        }
        this.endTime = System.currentTimeMillis();
        return this;
    }

    public long getDurationMillis() {
        return this.endTime - this.startTime;
    }
}

