/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.jeremylong.openvulnerability.client.nvd.NvdCveClient;
import io.github.jeremylong.openvulnerability.client.nvd.NvdCveClientBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.api.DownloadTask;
import org.owasp.dependencycheck.data.update.nvd.api.NvdApiProcessor;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdApiDataSource
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdApiDataSource.class);
    private static final int PROCESSING_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private Settings settings;
    private CveDB cveDb = null;
    private DatabaseProperties dbProperties = null;
    private static final String NVD_API_CACHE_MODIFIED_DATE = "lastModifiedDate";
    private static final int RESULTS_PER_PAGE = 2000;

    @Override
    public boolean update(Engine engine) throws UpdateException {
        this.settings = engine.getSettings();
        this.cveDb = engine.getDatabase();
        if (this.isUpdateConfiguredFalse()) {
            return false;
        }
        this.dbProperties = this.cveDb.getDatabaseProperties();
        String nvdDataFeedUrl = this.settings.getString("nvd.api.datafeed.url");
        if (nvdDataFeedUrl != null) {
            return this.processDatafeed(nvdDataFeedUrl);
        }
        return this.processApi();
    }

    protected UrlData extractUrlData(String nvdDataFeedUrl) {
        String url;
        String pattern = null;
        if (nvdDataFeedUrl.endsWith(".json.gz")) {
            int lio = nvdDataFeedUrl.lastIndexOf("/");
            pattern = nvdDataFeedUrl.substring(lio + 1);
            url = nvdDataFeedUrl.substring(0, lio);
        } else {
            url = nvdDataFeedUrl;
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return new UrlData(url, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processDatafeed(String nvdDataFeedUrl) throws UpdateException {
        boolean updatesMade;
        block15: {
            updatesMade = false;
            try {
                ZonedDateTime now;
                Map<String, String> updateable;
                this.dbProperties = this.cveDb.getDatabaseProperties();
                if (!this.checkUpdate()) break block15;
                UrlData data = this.extractUrlData(nvdDataFeedUrl);
                String url = data.getUrl();
                String pattern = data.getPattern();
                Properties cacheProperties = this.getRemoteCacheProperties(url, pattern);
                if (pattern == null) {
                    String prefix = cacheProperties.getProperty("prefix", "nvdcve-");
                    pattern = prefix + "{0}.json.gz";
                }
                if (!(updateable = this.getUpdatesNeeded(url, pattern, cacheProperties, now = ZonedDateTime.now(ZoneId.of("UTC")))).isEmpty()) {
                    int max = this.settings.getInt("max.download.threads", 1);
                    int downloadPoolSize = Math.min(Runtime.getRuntime().availableProcessors(), max);
                    ExecutorService processingExecutorService = null;
                    ExecutorService downloadExecutorService = null;
                    try {
                        downloadExecutorService = Executors.newFixedThreadPool(downloadPoolSize);
                        processingExecutorService = Executors.newFixedThreadPool(PROCESSING_THREAD_POOL_SIZE);
                        DownloadTask runLast = null;
                        HashSet<Future<Future<NvdApiProcessor>>> downloadFutures = new HashSet<Future<Future<NvdApiProcessor>>>(updateable.size());
                        runLast = this.startDownloads(updateable, processingExecutorService, runLast, downloadFutures, downloadExecutorService);
                        HashSet<Future<NvdApiProcessor>> processFutures = new HashSet<Future<NvdApiProcessor>>(updateable.size());
                        for (Future future : downloadFutures) {
                            this.processDownload(future, processFutures);
                        }
                        this.processFuture(processFutures);
                        processFutures.clear();
                        if (runLast != null) {
                            Future<Future<NvdApiProcessor>> modified = downloadExecutorService.submit(runLast);
                            this.processDownload(modified, processFutures);
                            this.processFuture(processFutures);
                        }
                    }
                    finally {
                        if (processingExecutorService != null) {
                            processingExecutorService.shutdownNow();
                        }
                        if (downloadExecutorService != null) {
                            downloadExecutorService.shutdownNow();
                        }
                    }
                    updatesMade = true;
                }
                this.storeLastModifiedDates(now, cacheProperties, updateable);
                if (updatesMade) {
                    this.cveDb.persistEcosystemCache();
                }
                int updateCount = this.cveDb.updateEcosystemCache();
                LOGGER.debug("Corrected the ecosystem for {} ecoSystemCache entries", (Object)updateCount);
                if (updatesMade || updateCount > 0) {
                    this.cveDb.cleanupDatabase();
                }
            }
            catch (UpdateException ex) {
                String jre;
                if (ex.getCause() != null && ex.getCause() instanceof DownloadFailedException && ((jre = System.getProperty("java.version")) == null || jre.startsWith("1.4") || jre.startsWith("1.5") || jre.startsWith("1.6") || jre.startsWith("1.7"))) {
                    LOGGER.error("An old JRE is being used ({} {}), and likely does not have the correct root certificates or algorithms to connect to the NVD - consider upgrading your JRE.", (Object)System.getProperty("java.vendor"), (Object)jre);
                }
                throw ex;
            }
            catch (DatabaseException ex) {
                throw new UpdateException("Database Exception, unable to update the data to use the most current data.", ex);
            }
        }
        return updatesMade;
    }

    private void storeLastModifiedDates(ZonedDateTime now, Properties cacheProperties, Map<String, String> updateable) throws UpdateException {
        ZonedDateTime lastModifiedRequest = DatabaseProperties.getTimestamp(cacheProperties, "lastModifiedDate.modified");
        this.dbProperties.save("nvd.cache.last.checked", now);
        this.dbProperties.save("nvd.cache.last.modified", lastModifiedRequest);
        this.dbProperties.save("nvd.api.last.checked", now);
        this.dbProperties.save("nvd.api.last.modified", lastModifiedRequest);
        for (String entry : updateable.keySet()) {
            ZonedDateTime date = DatabaseProperties.getTimestamp(cacheProperties, "lastModifiedDate." + entry);
            this.dbProperties.save("nvd.cache.last.modified." + entry, date);
        }
    }

    private DownloadTask startDownloads(Map<String, String> updateable, ExecutorService processingExecutorService, DownloadTask runLast, Set<Future<Future<NvdApiProcessor>>> downloadFutures, ExecutorService downloadExecutorService) throws UpdateException {
        DownloadTask lastCall = runLast;
        for (Map.Entry<String, String> cve : updateable.entrySet()) {
            DownloadTask call = new DownloadTask(cve.getValue(), processingExecutorService, this.cveDb, this.settings);
            if (call.isModified()) {
                lastCall = call;
                continue;
            }
            boolean added = downloadFutures.add(downloadExecutorService.submit(call));
            if (added) continue;
            throw new UpdateException("Unable to add the download task for " + cve);
        }
        return lastCall;
    }

    private void processFuture(Set<Future<NvdApiProcessor>> processFutures) throws UpdateException {
        for (Future<NvdApiProcessor> future : processFutures) {
            try {
                NvdApiProcessor nvdApiProcessor = future.get();
            }
            catch (InterruptedException ex) {
                LOGGER.debug("Thread was interrupted during processing", (Throwable)ex);
                Thread.currentThread().interrupt();
                throw new UpdateException(ex);
            }
            catch (ExecutionException ex) {
                LOGGER.debug("Execution Exception during process", (Throwable)ex);
                throw new UpdateException(ex);
            }
        }
    }

    private void processDownload(Future<Future<NvdApiProcessor>> future, Set<Future<NvdApiProcessor>> processFutures) throws UpdateException {
        try {
            Future<NvdApiProcessor> task = future.get();
            if (task != null) {
                processFutures.add(task);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.debug("Thread was interrupted during download", (Throwable)ex);
            Thread.currentThread().interrupt();
            throw new UpdateException("The download was interrupted", ex);
        }
        catch (ExecutionException ex) {
            LOGGER.debug("Thread was interrupted during download execution", (Throwable)ex);
            throw new UpdateException("The execution of the download was interrupted", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processApi() throws UpdateException {
        String key;
        ZonedDateTime lastChecked = this.dbProperties.getTimestamp("nvd.api.last.checked");
        int validForHours = this.settings.getInt("nvd.api.check.validforhours", 0);
        if (this.cveDb.dataExists() && lastChecked != null && validForHours > 0) {
            long validForSeconds = (long)validForHours * 60L * 60L;
            ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
            Duration duration = Duration.between(lastChecked, now);
            long difference = duration.getSeconds();
            if (difference < validForSeconds) {
                LOGGER.info("Skipping the NVD API Update as it was completed within the last {} minutes", (Object)(validForSeconds / 60L));
                return false;
            }
        }
        ZonedDateTime lastModifiedRequest = this.dbProperties.getTimestamp("nvd.api.last.modified");
        NvdCveClientBuilder builder = NvdCveClientBuilder.aNvdCveApi();
        String endpoint = this.settings.getString("nvd.api.endpoint");
        if (endpoint != null) {
            builder.withEndpoint(endpoint);
        }
        if (lastModifiedRequest != null) {
            ZonedDateTime end = lastModifiedRequest.minusDays(-120L);
            builder.withLastModifiedFilter(lastModifiedRequest, end);
        }
        if ((key = this.settings.getString("nvd.api.key")) != null) {
            builder.withApiKey(key).withDelay(2000L).withThreadCount(4);
        } else {
            LOGGER.warn("An NVD API Key was not provided - it is highly recommended to use an NVD API key as the update can take a VERY long time without an API Key");
            builder.withDelay(8000L);
        }
        builder.withResultsPerPage(2000);
        int retryCount = this.settings.getInt("nvd.api.max.retry.count", 10);
        builder.withMaxRetryCount(retryCount);
        long delay = 0L;
        try {
            delay = this.settings.getLong("nvd.api.delay");
        }
        catch (InvalidSettingException ex) {
            LOGGER.warn("Invalid setting `NVD_API_DELAY`? ({}), using default delay", (Object)this.settings.getString("nvd.api.delay"));
        }
        if (delay > 0L) {
            builder.withDelay(delay);
        }
        ExecutorService processingExecutorService = null;
        try {
            processingExecutorService = Executors.newFixedThreadPool(PROCESSING_THREAD_POOL_SIZE);
            ArrayList<Future<NvdApiProcessor>> submitted = new ArrayList<Future<NvdApiProcessor>>();
            int max = -1;
            int ctr = 0;
            try {
                NvdCveClient api = builder.build();
                Object object = null;
                try {
                    while (api.hasNext()) {
                        ZonedDateTime last;
                        Collection collection = api.next();
                        max = api.getTotalAvailable();
                        if (ctr == 0) {
                            LOGGER.info(String.format("NVD API has %,d records in this update", max));
                        }
                        if (collection != null && !collection.isEmpty()) {
                            ObjectMapper objectMapper = new ObjectMapper();
                            objectMapper.registerModule((Module)new JavaTimeModule());
                            File outputFile = this.settings.getTempFile("nvd-data-", ".jsonarray.gz");
                            try (FileOutputStream fos = new FileOutputStream(outputFile);
                                 GZIPOutputStream out = new GZIPOutputStream(fos);){
                                objectMapper.writeValue((OutputStream)out, (Object)collection);
                                Future<NvdApiProcessor> f = processingExecutorService.submit(new NvdApiProcessor(this.cveDb, outputFile));
                                submitted.add(f);
                            }
                            if (++ctr % 5 == 0) {
                                double percent = (double)(ctr * 2000) / (double)max * 100.0;
                                LOGGER.info(String.format("Downloaded %,d/%,d (%.0f%%)", ctr * 2000, max, percent));
                            }
                        }
                        if ((last = api.getLastUpdated()) == null || lastModifiedRequest != null && lastModifiedRequest.compareTo(last) >= 0) continue;
                        lastModifiedRequest = last;
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (api != null) {
                        if (object != null) {
                            try {
                                api.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            api.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new UpdateException("Error updating the NVD Data", e);
            }
            LOGGER.info(String.format("Downloaded %,d/%,d (%.0f%%)", max, max, Float.valueOf(100.0f)));
            max = submitted.size();
            boolean updated = max > 0;
            ctr = 0;
            for (Future future : submitted) {
                try {
                    NvdApiProcessor proc = (NvdApiProcessor)future.get();
                    double percent = (double)(++ctr) / (double)max * 100.0;
                    LOGGER.info(String.format("Completed processing batch %d/%d (%.0f%%) in %,dms", ctr, max, percent, proc.getDurationMillis()));
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ex);
                }
                catch (ExecutionException ex) {
                    LOGGER.error("Exception processing NVD API Results", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            if (lastModifiedRequest != null) {
                this.dbProperties.save("nvd.api.last.checked", ZonedDateTime.now());
                this.dbProperties.save("nvd.api.last.modified", lastModifiedRequest);
            }
            boolean bl = updated;
            return bl;
        }
        finally {
            if (processingExecutorService != null) {
                processingExecutorService.shutdownNow();
            }
        }
    }

    private boolean isUpdateConfiguredFalse() {
        if (!this.settings.getBoolean("updater.nvdcve.enabled", true)) {
            return true;
        }
        boolean autoUpdate = true;
        try {
            autoUpdate = this.settings.getBoolean("odc.autoupdate");
        }
        catch (InvalidSettingException ex) {
            LOGGER.debug("Invalid setting for auto-update; using true.");
        }
        return !autoUpdate;
    }

    @Override
    public boolean purge(Engine engine) {
        boolean result = true;
        try {
            File lockFile;
            File dataDir = engine.getSettings().getDataDirectory();
            File db = new File(dataDir, engine.getSettings().getString("data.file_name", "odc.mv.db"));
            if (db.exists()) {
                if (db.delete()) {
                    LOGGER.info("Database file purged; local copy of the NVD has been removed");
                } else {
                    LOGGER.error("Unable to delete '{}'; please delete the file manually", (Object)db.getAbsolutePath());
                    result = false;
                }
            } else {
                LOGGER.info("Unable to purge database; the database file does not exist: {}", (Object)db.getAbsolutePath());
                result = false;
            }
            File traceFile = new File(dataDir, "odc.trace.db");
            if (traceFile.exists() && !traceFile.delete()) {
                LOGGER.error("Unable to delete '{}'; please delete the file manually", (Object)traceFile.getAbsolutePath());
                result = false;
            }
            if ((lockFile = new File(dataDir, "odc.update.lock")).exists() && !lockFile.delete()) {
                LOGGER.error("Unable to delete '{}'; please delete the file manually", (Object)lockFile.getAbsolutePath());
                result = false;
            }
        }
        catch (IOException ex) {
            String msg = "Unable to delete the database";
            LOGGER.error("Unable to delete the database", (Throwable)ex);
            result = false;
        }
        return result;
    }

    private boolean checkUpdate() throws UpdateException {
        boolean proceed = true;
        int validForHours = this.settings.getInt("nvd.api.check.validforhours", 0);
        if (this.dataExists() && 0 < validForHours) {
            long validForSeconds = (long)validForHours * 60L * 60L;
            ZonedDateTime lastChecked = this.dbProperties.getTimestamp("nvd.cache.last.checked");
            if (lastChecked != null) {
                ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
                Duration duration = Duration.between(lastChecked, now);
                long difference = duration.getSeconds();
                boolean bl = proceed = difference > validForSeconds;
                if (!proceed) {
                    LOGGER.info("Skipping NVD API Cache check since last check was within {} hours.", (Object)validForHours);
                    LOGGER.debug("Last NVD API was at {}, and now {} is within {} s.", new Object[]{lastChecked, now, validForSeconds});
                }
            } else {
                LOGGER.warn("NVD cache last checked not present; updating the entire database. This could occur if you are switching back and forth from using the API vs a datafeed or if you are using a database created prior to ODC 9.x");
            }
        }
        return proceed;
    }

    private boolean dataExists() {
        return this.cveDb.dataExists();
    }

    protected final Map<String, String> getUpdatesNeeded(String url, String filePattern, Properties cacheProperties, ZonedDateTime now) throws UpdateException {
        LOGGER.debug("starting getUpdatesNeeded() ...");
        HashMap<String, String> updates = new HashMap<String, String>();
        if (this.dbProperties != null && !this.dbProperties.isEmpty()) {
            int startYear = this.settings.getInt("nvd.api.datafeed.startyear", 2002);
            int endYear = now.withZoneSameInstant(ZoneId.of("UTC+14:00")).getYear();
            boolean needsFullUpdate = false;
            for (int y = startYear; y <= endYear; ++y) {
                ZonedDateTime val = this.dbProperties.getTimestamp("nvd.cache.last.modified." + y);
                if (val != null) continue;
                needsFullUpdate = true;
                break;
            }
            ZonedDateTime lastUpdated = this.dbProperties.getTimestamp("nvd.cache.last.modified");
            int days = this.settings.getInt("nvd.api.datafeed.validfordays", 7);
            if (!needsFullUpdate && lastUpdated.equals(DatabaseProperties.getTimestamp(cacheProperties, NVD_API_CACHE_MODIFIED_DATE))) {
                return updates;
            }
            updates.put("modified", url + MessageFormat.format(filePattern, "modified"));
            if (needsFullUpdate) {
                for (int i = startYear; i <= endYear; ++i) {
                    if (!cacheProperties.containsKey("lastModifiedDate." + i)) continue;
                    updates.put(String.valueOf(i), url + MessageFormat.format(filePattern, String.valueOf(i)));
                }
            } else if (!DateUtil.withinDateRange(lastUpdated, now, days)) {
                for (int i = startYear; i <= endYear; ++i) {
                    if (!cacheProperties.containsKey("lastModifiedDate." + i)) continue;
                    ZonedDateTime lastModifiedCache = DatabaseProperties.getTimestamp(cacheProperties, "lastModifiedDate." + i);
                    ZonedDateTime lastModifiedDB = this.dbProperties.getTimestamp("nvd.cache.last.modified." + i);
                    if (lastModifiedDB != null && lastModifiedCache.compareTo(lastModifiedDB) <= 0) continue;
                    updates.put(String.valueOf(i), url + MessageFormat.format(filePattern, String.valueOf(i)));
                }
            }
        }
        if (updates.size() > 3) {
            LOGGER.info("NVD API Cache requires several updates; this could take a couple of minutes.");
        }
        return updates;
    }

    protected final Properties getRemoteCacheProperties(String url, String pattern) throws UpdateException {
        Downloader d = new Downloader(this.settings);
        Properties properties = new Properties();
        try {
            URL u = new URI(url + "cache.properties").toURL();
            String content = d.fetchContent(u, true, "nvd.api.datafeed.user", "nvd.api.datafeed.password");
            properties.load(new StringReader(content));
        }
        catch (URISyntaxException ex) {
            throw new UpdateException("Invalid NVD Cache URL", ex);
        }
        catch (DownloadFailedException | ResourceNotFoundException ex) {
            String metaPattern = pattern == null ? "nvdcve-{0}.meta" : pattern.replace(".json.gz", ".meta");
            try {
                URL metaUrl = new URI(url + MessageFormat.format(metaPattern, "modified")).toURL();
                String content = d.fetchContent(metaUrl, true, "nvd.api.datafeed.user", "nvd.api.datafeed.password");
                Properties props = new Properties();
                props.load(new StringReader(content));
                ZonedDateTime lmd = DatabaseProperties.getIsoTimestamp(props, NVD_API_CACHE_MODIFIED_DATE);
                DatabaseProperties.setTimestamp(properties, "lastModifiedDate.modified", lmd);
                DatabaseProperties.setTimestamp(properties, NVD_API_CACHE_MODIFIED_DATE, lmd);
                int startYear = this.settings.getInt("nvd.api.datafeed.startyear", 2002);
                ZonedDateTime now = ZonedDateTime.now(ZoneId.of("UTC"));
                int endYear = now.withZoneSameInstant(ZoneId.of("UTC+14:00")).getYear();
                for (int y = startYear; y <= endYear; ++y) {
                    metaUrl = new URI(url + MessageFormat.format(metaPattern, String.valueOf(y))).toURL();
                    content = d.fetchContent(metaUrl, true, "nvd.api.datafeed.user", "nvd.api.datafeed.password");
                    props.clear();
                    props.load(new StringReader(content));
                    lmd = DatabaseProperties.getIsoTimestamp(props, NVD_API_CACHE_MODIFIED_DATE);
                    DatabaseProperties.setTimestamp(properties, "lastModifiedDate." + String.valueOf(y), lmd);
                }
            }
            catch (IOException | URISyntaxException | ResourceNotFoundException | TooManyRequestsException ex1) {
                throw new UpdateException("Unable to download the data feed META files", ex);
            }
        }
        catch (TooManyRequestsException ex) {
            throw new UpdateException("Unable to download the NVD API cache.properties", ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Invalid NVD Cache Properties file contents", ex);
        }
        return properties;
    }

    protected static class UrlData {
        private final String url;
        private final String pattern;

        public UrlData(String url, String pattern) {
            this.url = url;
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

