/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.exception.ParseException;
import org.owasp.dependencycheck.utils.DateUtil;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
public class SuppressionHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressionHandler.class);
    public static final String SUPPRESS = "suppress";
    public static final String FILE_PATH = "filePath";
    public static final String SHA1 = "sha1";
    public static final String CVE = "cve";
    public static final String VULNERABILITY_NAME = "vulnerabilityName";
    public static final String NOTES = "notes";
    public static final String CPE = "cpe";
    public static final String CWE = "cwe";
    public static final String GAV = "gav";
    public static final String PACKAGE_URL = "packageUrl";
    public static final String CVSS_BELOW = "cvssBelow";
    private final List<SuppressionRule> suppressionRules = new ArrayList<SuppressionRule>();
    private SuppressionRule rule;
    private Attributes currentAttributes;
    private StringBuilder currentText;

    public List<SuppressionRule> getSuppressionRules() {
        return this.suppressionRules;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentAttributes = attributes;
        this.currentText = new StringBuilder();
        if (SUPPRESS.equals(qName)) {
            this.rule = new SuppressionRule();
            String base = this.currentAttributes.getValue("base");
            if (base != null) {
                this.rule.setBase(Boolean.parseBoolean(base));
            } else {
                this.rule.setBase(false);
            }
            String until = this.currentAttributes.getValue("until");
            if (until != null) {
                try {
                    this.rule.setUntil(DateUtil.parseXmlDate(until));
                }
                catch (ParseException ex) {
                    throw new SAXException("Unable to parse until date in suppression file: " + until, ex);
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (null != qName) {
            switch (qName) {
                case "suppress": {
                    if (this.rule.getUntil() != null && this.rule.getUntil().before(Calendar.getInstance())) {
                        LOGGER.info("Suppression is expired for rule: {}", (Object)this.rule);
                    } else {
                        this.suppressionRules.add(this.rule);
                    }
                    this.rule = null;
                    break;
                }
                case "filePath": {
                    this.rule.setFilePath(this.processPropertyType());
                    break;
                }
                case "sha1": {
                    this.rule.setSha1(this.currentText.toString().trim());
                    break;
                }
                case "gav": {
                    this.rule.setGav(this.processPropertyType());
                    break;
                }
                case "packageUrl": {
                    this.rule.setPackageUrl(this.processPropertyType());
                    break;
                }
                case "cpe": {
                    this.rule.addCpe(this.processPropertyType());
                    break;
                }
                case "cwe": {
                    this.rule.addCwe(this.currentText.toString().trim());
                    break;
                }
                case "cve": {
                    this.rule.addCve(this.currentText.toString().trim());
                    break;
                }
                case "vulnerabilityName": {
                    this.rule.addVulnerabilityName(this.processPropertyType());
                    break;
                }
                case "notes": {
                    this.rule.setNotes(this.currentText.toString().trim());
                    break;
                }
                case "cvssBelow": {
                    Double cvss = Double.valueOf(this.currentText.toString().trim());
                    this.rule.addCvssBelow(cvss);
                    break;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText.append(ch, start, length);
    }

    private PropertyType processPropertyType() {
        PropertyType pt = new PropertyType();
        pt.setValue(this.currentText.toString().trim());
        if (this.currentAttributes != null && this.currentAttributes.getLength() > 0) {
            String caseSensitive;
            String regex = this.currentAttributes.getValue("regex");
            if (regex != null) {
                pt.setRegex(Boolean.parseBoolean(regex));
            }
            if ((caseSensitive = this.currentAttributes.getValue("caseSensitive")) != null) {
                pt.setCaseSensitive(Boolean.parseBoolean(caseSensitive));
            }
        }
        return pt;
    }
}

