/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd.api;

import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.owasp.dependencycheck.data.nvd.ecosystem.CveEcosystemMapper;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdApiProcessor
implements Callable<NvdApiProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdApiProcessor.class);
    private final CveDB cveDB;
    private Collection<DefCveItem> data;
    private final CveEcosystemMapper mapper = new CveEcosystemMapper();
    private final long startTime;
    private long endTime = 0L;

    public NvdApiProcessor(CveDB cveDB, Collection<DefCveItem> data, long startTime) {
        this.cveDB = cveDB;
        this.data = data;
        this.startTime = startTime;
    }

    public NvdApiProcessor(CveDB cveDB, Collection<DefCveItem> data) {
        this(cveDB, data, System.currentTimeMillis());
    }

    @Override
    public NvdApiProcessor call() throws Exception {
        for (DefCveItem entry : this.data) {
            try {
                this.cveDB.updateVulnerability(entry, this.mapper.getEcosystem(entry));
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process " + entry.getCve().getId(), (Throwable)ex);
            }
        }
        this.endTime = System.currentTimeMillis();
        this.data = null;
        return this;
    }

    public long getDurationMillis() {
        return this.endTime - this.startTime;
    }
}

