/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

public final class Utils {
    private Utils() {
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.specification.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static int getJavaUpdateVersion() {
        String runtimeVersion = System.getProperty("java.runtime.version");
        try {
            String[] parts = runtimeVersion.split("\\.");
            if (parts.length == 4) {
                return Integer.parseInt(parts[2]);
            }
            int pos = runtimeVersion.indexOf(95);
            if (pos <= 0 && (pos = runtimeVersion.lastIndexOf(46)) <= 0) {
                return 0;
            }
            int end = runtimeVersion.lastIndexOf(43);
            if (end < 0) {
                end = runtimeVersion.lastIndexOf(45);
            }
            if (end > pos) {
                return Integer.parseInt(runtimeVersion.substring(pos + 1, end));
            }
            return Integer.parseInt(runtimeVersion.substring(pos + 1));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public static void main(String[] args) {
        System.out.println("Java version : " + Utils.getJavaVersion());
        System.out.println("Java update  : " + Utils.getJavaUpdateVersion());
    }
}

