
package org.owasp.dependencycheck.data.knownexploited.json;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "cveID",
    "vendorProject",
    "product",
    "vulnerabilityName",
    "dateAdded",
    "shortDescription",
    "requiredAction",
    "dueDate",
    "notes"
})
@Generated("jsonschema2pojo")
public class Vulnerability {

    /**
     * The CVE ID of the vulnerability in the format CVE-YYYY-NNNN, note that the number portion can have more than 4 digits
     * (Required)
     * 
     */
    @JsonProperty("cveID")
    @JsonPropertyDescription("The CVE ID of the vulnerability in the format CVE-YYYY-NNNN, note that the number portion can have more than 4 digits")
    private String cveID;
    /**
     * The vendor or project name for the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("vendorProject")
    @JsonPropertyDescription("The vendor or project name for the vulnerability")
    private String vendorProject;
    /**
     * The vulnerability product
     * (Required)
     * 
     */
    @JsonProperty("product")
    @JsonPropertyDescription("The vulnerability product")
    private String product;
    /**
     * The name of the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("vulnerabilityName")
    @JsonPropertyDescription("The name of the vulnerability")
    private String vulnerabilityName;
    /**
     * The date the vulnerability was added to the catalog in the format YYYY-MM-DD
     * (Required)
     * 
     */
    @JsonProperty("dateAdded")
    @JsonPropertyDescription("The date the vulnerability was added to the catalog in the format YYYY-MM-DD")
    private String dateAdded;
    /**
     * A short description of the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("shortDescription")
    @JsonPropertyDescription("A short description of the vulnerability")
    private String shortDescription;
    /**
     * The required action to address the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("requiredAction")
    @JsonPropertyDescription("The required action to address the vulnerability")
    private String requiredAction;
    /**
     * The date the required action is due in the format YYYY-MM-DD
     * (Required)
     * 
     */
    @JsonProperty("dueDate")
    @JsonPropertyDescription("The date the required action is due in the format YYYY-MM-DD")
    private String dueDate;
    /**
     * Any additional notes about the vulnerability
     * 
     */
    @JsonProperty("notes")
    @JsonPropertyDescription("Any additional notes about the vulnerability")
    private String notes;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * The CVE ID of the vulnerability in the format CVE-YYYY-NNNN, note that the number portion can have more than 4 digits
     * (Required)
     * 
     */
    @JsonProperty("cveID")
    public String getCveID() {
        return cveID;
    }

    /**
     * The CVE ID of the vulnerability in the format CVE-YYYY-NNNN, note that the number portion can have more than 4 digits
     * (Required)
     * 
     */
    @JsonProperty("cveID")
    public void setCveID(String cveID) {
        this.cveID = cveID;
    }

    /**
     * The vendor or project name for the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("vendorProject")
    public String getVendorProject() {
        return vendorProject;
    }

    /**
     * The vendor or project name for the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("vendorProject")
    public void setVendorProject(String vendorProject) {
        this.vendorProject = vendorProject;
    }

    /**
     * The vulnerability product
     * (Required)
     * 
     */
    @JsonProperty("product")
    public String getProduct() {
        return product;
    }

    /**
     * The vulnerability product
     * (Required)
     * 
     */
    @JsonProperty("product")
    public void setProduct(String product) {
        this.product = product;
    }

    /**
     * The name of the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("vulnerabilityName")
    public String getVulnerabilityName() {
        return vulnerabilityName;
    }

    /**
     * The name of the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("vulnerabilityName")
    public void setVulnerabilityName(String vulnerabilityName) {
        this.vulnerabilityName = vulnerabilityName;
    }

    /**
     * The date the vulnerability was added to the catalog in the format YYYY-MM-DD
     * (Required)
     * 
     */
    @JsonProperty("dateAdded")
    public String getDateAdded() {
        return dateAdded;
    }

    /**
     * The date the vulnerability was added to the catalog in the format YYYY-MM-DD
     * (Required)
     * 
     */
    @JsonProperty("dateAdded")
    public void setDateAdded(String dateAdded) {
        this.dateAdded = dateAdded;
    }

    /**
     * A short description of the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("shortDescription")
    public String getShortDescription() {
        return shortDescription;
    }

    /**
     * A short description of the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("shortDescription")
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    /**
     * The required action to address the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("requiredAction")
    public String getRequiredAction() {
        return requiredAction;
    }

    /**
     * The required action to address the vulnerability
     * (Required)
     * 
     */
    @JsonProperty("requiredAction")
    public void setRequiredAction(String requiredAction) {
        this.requiredAction = requiredAction;
    }

    /**
     * The date the required action is due in the format YYYY-MM-DD
     * (Required)
     * 
     */
    @JsonProperty("dueDate")
    public String getDueDate() {
        return dueDate;
    }

    /**
     * The date the required action is due in the format YYYY-MM-DD
     * (Required)
     * 
     */
    @JsonProperty("dueDate")
    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    /**
     * Any additional notes about the vulnerability
     * 
     */
    @JsonProperty("notes")
    public String getNotes() {
        return notes;
    }

    /**
     * Any additional notes about the vulnerability
     * 
     */
    @JsonProperty("notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Vulnerability.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("cveID");
        sb.append('=');
        sb.append(((this.cveID == null)?"<null>":this.cveID));
        sb.append(',');
        sb.append("vendorProject");
        sb.append('=');
        sb.append(((this.vendorProject == null)?"<null>":this.vendorProject));
        sb.append(',');
        sb.append("product");
        sb.append('=');
        sb.append(((this.product == null)?"<null>":this.product));
        sb.append(',');
        sb.append("vulnerabilityName");
        sb.append('=');
        sb.append(((this.vulnerabilityName == null)?"<null>":this.vulnerabilityName));
        sb.append(',');
        sb.append("dateAdded");
        sb.append('=');
        sb.append(((this.dateAdded == null)?"<null>":this.dateAdded));
        sb.append(',');
        sb.append("shortDescription");
        sb.append('=');
        sb.append(((this.shortDescription == null)?"<null>":this.shortDescription));
        sb.append(',');
        sb.append("requiredAction");
        sb.append('=');
        sb.append(((this.requiredAction == null)?"<null>":this.requiredAction));
        sb.append(',');
        sb.append("dueDate");
        sb.append('=');
        sb.append(((this.dueDate == null)?"<null>":this.dueDate));
        sb.append(',');
        sb.append("notes");
        sb.append('=');
        sb.append(((this.notes == null)?"<null>":this.notes));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.product == null)? 0 :this.product.hashCode()));
        result = ((result* 31)+((this.vulnerabilityName == null)? 0 :this.vulnerabilityName.hashCode()));
        result = ((result* 31)+((this.notes == null)? 0 :this.notes.hashCode()));
        result = ((result* 31)+((this.cveID == null)? 0 :this.cveID.hashCode()));
        result = ((result* 31)+((this.dueDate == null)? 0 :this.dueDate.hashCode()));
        result = ((result* 31)+((this.vendorProject == null)? 0 :this.vendorProject.hashCode()));
        result = ((result* 31)+((this.shortDescription == null)? 0 :this.shortDescription.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.requiredAction == null)? 0 :this.requiredAction.hashCode()));
        result = ((result* 31)+((this.dateAdded == null)? 0 :this.dateAdded.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Vulnerability) == false) {
            return false;
        }
        Vulnerability rhs = ((Vulnerability) other);
        return (((((((((((this.product == rhs.product)||((this.product!= null)&&this.product.equals(rhs.product)))&&((this.vulnerabilityName == rhs.vulnerabilityName)||((this.vulnerabilityName!= null)&&this.vulnerabilityName.equals(rhs.vulnerabilityName))))&&((this.notes == rhs.notes)||((this.notes!= null)&&this.notes.equals(rhs.notes))))&&((this.cveID == rhs.cveID)||((this.cveID!= null)&&this.cveID.equals(rhs.cveID))))&&((this.dueDate == rhs.dueDate)||((this.dueDate!= null)&&this.dueDate.equals(rhs.dueDate))))&&((this.vendorProject == rhs.vendorProject)||((this.vendorProject!= null)&&this.vendorProject.equals(rhs.vendorProject))))&&((this.shortDescription == rhs.shortDescription)||((this.shortDescription!= null)&&this.shortDescription.equals(rhs.shortDescription))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.requiredAction == rhs.requiredAction)||((this.requiredAction!= null)&&this.requiredAction.equals(rhs.requiredAction))))&&((this.dateAdded == rhs.dateAdded)||((this.dateAdded!= null)&&this.dateAdded.equals(rhs.dateAdded))));
    }

}
