/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.RubyGemspecAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;

@Experimental
@ThreadSafe
public class RubyBundlerAnalyzer
extends RubyGemspecAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "ruby";
    private static final String ANALYZER_NAME = "Ruby Bundler Analyzer";
    private static final String SPECIFICATIONS = "specifications";
    private static final String GEMS = "gems";

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public boolean accept(File pathname) {
        boolean accepted = super.accept(pathname);
        if (accepted) {
            File parentDir = pathname.getParentFile();
            accepted = parentDir != null && parentDir.getName().equals(SPECIFICATIONS);
        }
        return accepted;
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        super.analyzeDependency(dependency, engine);
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        File gemspecFile = dependency.getActualFile();
        String gemFileName = gemspecFile.getName();
        String gemName = gemFileName.substring(0, gemFileName.lastIndexOf(".gemspec"));
        File specificationsDir = gemspecFile.getParentFile();
        if (specificationsDir != null && specificationsDir.getName().equals(SPECIFICATIONS) && specificationsDir.exists()) {
            File[] matchingFiles;
            File parentDir = specificationsDir.getParentFile();
            File gemsDir = new File(parentDir, GEMS);
            if (parentDir != null && parentDir.exists() && gemsDir.exists() && (matchingFiles = gemsDir.listFiles((dir, name) -> name.equals(gemName))) != null && matchingFiles.length > 0) {
                String gemPath = matchingFiles[0].getAbsolutePath();
                if (dependency.getActualFilePath().equals(dependency.getFilePath())) {
                    if (gemPath != null) {
                        dependency.setPackagePath(gemPath);
                    }
                } else {
                    File gemspecStub = new File(dependency.getFilePath());
                    File specDir = gemspecStub.getParentFile();
                    if (specDir != null && specDir.getName().equals(SPECIFICATIONS)) {
                        File gemsDir2 = new File(specDir.getParentFile(), GEMS);
                        File packageDir = new File(gemsDir2, gemName);
                        dependency.setPackagePath(packageDir.getAbsolutePath());
                    }
                }
            }
        }
    }
}

