/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import com.google.common.io.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.anarres.jdiagnostics.DefaultQuery;
import org.apache.commons.collections.map.ReferenceMap;
import org.owasp.dependencycheck.analyzer.exception.LambdaExceptionWrapper;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nvd.json.BaseMetricV2;
import org.owasp.dependencycheck.data.nvd.json.BaseMetricV3;
import org.owasp.dependencycheck.data.nvd.json.CpeMatchStreamCollector;
import org.owasp.dependencycheck.data.nvd.json.DefCpeMatch;
import org.owasp.dependencycheck.data.nvd.json.DefCveItem;
import org.owasp.dependencycheck.data.nvd.json.LangString;
import org.owasp.dependencycheck.data.nvd.json.NodeFlatteningCollector;
import org.owasp.dependencycheck.data.nvd.json.ProblemtypeDatum;
import org.owasp.dependencycheck.data.nvd.json.Reference;
import org.owasp.dependencycheck.data.nvdcve.CveItemOperator;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseManager;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.cpe.CpeEcosystemCache;
import org.owasp.dependencycheck.data.update.cpe.CpePlus;
import org.owasp.dependencycheck.dependency.CvssV2;
import org.owasp.dependencycheck.dependency.CvssV3;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Pair;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeBuilder;
import us.springett.parsers.cpe.CpeParser;
import us.springett.parsers.cpe.ICpe;
import us.springett.parsers.cpe.exceptions.CpeParsingException;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public final class CveDB
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CveDB.class);
    public static final String DB_ECOSYSTEM_CACHE = "data/dbEcosystemCacheUpdates.sql";
    private final DatabaseManager databaseManager;
    private ResourceBundle statementBundle;
    private DatabaseProperties databaseProperties;
    private final String cpeStartsWithFilter;
    private final Map<String, List<Vulnerability>> vulnerabilitiesForCpeCache = Collections.synchronizedMap(new ReferenceMap(0, 1));
    private final Settings settings;
    private final CveItemOperator cveItemConverter;
    private boolean isOracle = false;
    private boolean isH2 = false;

    public void updateEcosystemCache() {
        LOGGER.debug("Updating the ecosystem cache");
        try {
            URL url = Resources.getResource((String)DB_ECOSYSTEM_CACHE);
            String sql = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            try (Connection conn = this.databaseManager.getConnection();
                 Statement statement = conn.createStatement();){
                statement.execute(sql);
            }
            catch (SQLException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new DatabaseException("Unable to update the ecosystem cache", ex);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to update the ecosystem cache", ex);
        }
        catch (LinkageError ex) {
            LOGGER.debug(new DefaultQuery((Throwable)ex).call().toString());
        }
    }

    public CveDB(Settings settings) throws DatabaseException {
        this.settings = settings;
        this.cpeStartsWithFilter = settings.getString("cve.cpe.startswith.filter", "cpe:2.3:a:");
        this.cveItemConverter = new CveItemOperator(this.cpeStartsWithFilter);
        this.databaseManager = new DatabaseManager(settings);
        this.statementBundle = this.databaseManager.getSqlStatements();
        this.isOracle = this.databaseManager.isOracle();
        this.isH2 = this.databaseManager.isH2Connection();
    }

    public void open() {
        this.databaseManager.open();
        this.databaseProperties = new DatabaseProperties(this);
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            LOGGER.debug("Closing database");
            this.clearCache();
            LOGGER.debug("Cache cleared");
            try {
                this.databaseManager.close();
                LOGGER.debug("Connection closed");
            }
            catch (Throwable ex) {
                LOGGER.error("There was an exception attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", ex);
            }
            this.releaseResources();
            LOGGER.debug("Resources released");
            this.databaseManager.cleanup();
        }
    }

    private void releaseResources() {
        this.statementBundle = null;
        this.databaseProperties = null;
    }

    public boolean isOpen() {
        return this.databaseManager.isOpen();
    }

    private PreparedStatement getPreparedStatement(Connection connection, PreparedStatementCveDb key, String parameter) throws DatabaseException, SQLException {
        PreparedStatement preparedStatement = this.getPreparedStatement(connection, key);
        preparedStatement.setString(1, parameter);
        return preparedStatement;
    }

    private PreparedStatement getPreparedStatement(Connection connection, PreparedStatementCveDb key, int parameter) throws DatabaseException, SQLException {
        PreparedStatement preparedStatement = this.getPreparedStatement(connection, key);
        preparedStatement.setInt(1, parameter);
        return preparedStatement;
    }

    private PreparedStatement getPreparedStatement(Connection connection, PreparedStatementCveDb key) throws DatabaseException {
        PreparedStatement preparedStatement;
        block4: {
            preparedStatement = null;
            try {
                String statementString = this.statementBundle.getString(key.name());
                preparedStatement = this.isOracle && key == PreparedStatementCveDb.UPDATE_VULNERABILITY ? connection.prepareCall(statementString) : connection.prepareStatement(statementString);
                if (this.isOracle) {
                    preparedStatement.setFetchSize(10000);
                }
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex);
            }
            catch (MissingResourceException ex) {
                if (ex.getMessage().contains("key MERGE_PROPERTY")) break block4;
                throw new DatabaseException(ex);
            }
        }
        return preparedStatement;
    }

    protected void finalize() throws Throwable {
        LOGGER.debug("Entering finalize");
        this.close();
        super.finalize();
    }

    public DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    DatabaseProperties reloadProperties() {
        this.databaseProperties = new DatabaseProperties(this);
        return this.databaseProperties;
    }

    public Set<CpePlus> getCPEs(String vendor, String product) {
        HashSet<CpePlus> cpe = new HashSet<CpePlus>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_CPE_ENTRIES);){
            ps.setString(1, vendor);
            ps.setString(2, product);
            try (ResultSet rs = ps.executeQuery();){
                CpeBuilder builder = new CpeBuilder();
                while (rs.next()) {
                    Cpe entry = builder.part(rs.getString(1)).vendor(rs.getString(2)).product(rs.getString(3)).version(rs.getString(4)).update(rs.getString(5)).edition(rs.getString(6)).language(rs.getString(7)).swEdition(rs.getString(8)).targetSw(rs.getString(9)).targetHw(rs.getString(10)).other(rs.getString(11)).build();
                    CpePlus plus = new CpePlus(entry, rs.getString(12));
                    cpe.add(plus);
                }
            }
        }
        catch (SQLException | CpeParsingException | CpeValidationException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", ex);
        }
        return cpe;
    }

    public Set<Pair<String, String>> getVendorProductList() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
            throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
        }
        return data;
    }

    public Set<Pair<String, String>> getVendorProductListForNode() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST_FOR_NODE);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
            throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
        }
        return data;
    }

    public Properties getProperties() {
        Properties prop = new Properties();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_PROPERTIES);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                prop.setProperty(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", (Throwable)ex);
        }
        return prop;
    }

    public void saveProperty(String key, String value) {
        block51: {
            this.clearCache();
            try (Connection conn = this.databaseManager.getConnection();
                 PreparedStatement mergeProperty = this.getPreparedStatement(conn, PreparedStatementCveDb.MERGE_PROPERTY);){
                if (mergeProperty != null) {
                    mergeProperty.setString(1, key);
                    mergeProperty.setString(2, value);
                    mergeProperty.execute();
                    break block51;
                }
                try (PreparedStatement updateProperty = this.getPreparedStatement(conn, PreparedStatementCveDb.UPDATE_PROPERTY);){
                    updateProperty.setString(1, value);
                    updateProperty.setString(2, key);
                    if (updateProperty.executeUpdate() != 0) break block51;
                    try (PreparedStatement insertProperty = this.getPreparedStatement(conn, PreparedStatementCveDb.INSERT_PROPERTY);){
                        insertProperty.setString(1, key);
                        insertProperty.setString(2, value);
                        insertProperty.executeUpdate();
                    }
                }
            }
            catch (SQLException ex) {
                LOGGER.warn("Unable to save property '{}' with a value of '{}' to the database", (Object)key, (Object)value);
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    private void clearCache() {
        this.vulnerabilitiesForCpeCache.clear();
    }

    public List<Vulnerability> getVulnerabilities(Cpe cpe) throws DatabaseException {
        List<Vulnerability> cachedVulnerabilities = this.vulnerabilitiesForCpeCache.get(cpe.toCpe23FS());
        if (cachedVulnerabilities != null) {
            LOGGER.debug("Cache hit for {}", (Object)cpe.toCpe23FS());
            return cachedVulnerabilities;
        }
        LOGGER.debug("Cache miss for {}", (Object)cpe.toCpe23FS());
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_CVE_FROM_SOFTWARE);){
            ps.setString(1, cpe.getVendor());
            ps.setString(2, cpe.getProduct());
            try (ResultSet rs = ps.executeQuery();){
                Vulnerability v;
                String currentCVE = "";
                HashSet<VulnerableSoftware> vulnSoftware = new HashSet<VulnerableSoftware>();
                VulnerableSoftwareBuilder vulnerableSoftwareBuilder = new VulnerableSoftwareBuilder();
                while (rs.next()) {
                    VulnerableSoftware vs;
                    String cveId = rs.getString(1);
                    if (currentCVE.isEmpty()) {
                        currentCVE = cveId;
                    }
                    if (!vulnSoftware.isEmpty() && !currentCVE.equals(cveId)) {
                        Vulnerability v2;
                        VulnerableSoftware matchedCPE = this.getMatchingSoftware(cpe, vulnSoftware);
                        if (matchedCPE != null && (v2 = this.getVulnerability(currentCVE, conn)) != null) {
                            v2.setMatchedVulnerableSoftware(matchedCPE);
                            v2.setSource(Vulnerability.Source.NVD);
                            vulnerabilities.add(v2);
                        }
                        vulnSoftware.clear();
                        currentCVE = cveId;
                    }
                    try {
                        vs = vulnerableSoftwareBuilder.part(rs.getString(2)).vendor(rs.getString(3)).product(rs.getString(4)).version(rs.getString(5)).update(rs.getString(6)).edition(rs.getString(7)).language(rs.getString(8)).swEdition(rs.getString(9)).targetSw(rs.getString(10)).targetHw(rs.getString(11)).other(rs.getString(12)).versionEndExcluding(rs.getString(13)).versionEndIncluding(rs.getString(14)).versionStartExcluding(rs.getString(15)).versionStartIncluding(rs.getString(16)).vulnerable(rs.getBoolean(17)).build();
                    }
                    catch (CpeParsingException | CpeValidationException ex) {
                        throw new DatabaseException("Database contains an invalid Vulnerable Software Entry", ex);
                    }
                    vulnSoftware.add(vs);
                }
                VulnerableSoftware matchedCPE = this.getMatchingSoftware(cpe, vulnSoftware);
                if (matchedCPE != null && (v = this.getVulnerability(currentCVE, conn)) != null) {
                    v.setMatchedVulnerableSoftware(matchedCPE);
                    v.setSource(Vulnerability.Source.NVD);
                    vulnerabilities.add(v);
                }
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException("Exception retrieving vulnerability for " + cpe.toCpe23FS(), ex);
        }
        this.vulnerabilitiesForCpeCache.put(cpe.toCpe23FS(), vulnerabilities);
        return vulnerabilities;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vulnerability getVulnerability(String cve) throws DatabaseException {
        try (Connection conn = this.databaseManager.getConnection();){
            Vulnerability vulnerability = this.getVulnerability(cve, conn);
            return vulnerability;
        }
        catch (SQLException ex) {
            throw new DatabaseException("Error retrieving " + cve, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vulnerability getVulnerability(String cve, Connection conn) throws DatabaseException {
        VulnerableSoftwareBuilder vulnerableSoftwareBuilder = new VulnerableSoftwareBuilder();
        Vulnerability vuln = null;
        try {
            int cveId;
            Throwable throwable;
            Throwable throwable2;
            block110: {
                throwable2 = null;
                try (PreparedStatement psV = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_VULNERABILITY, cve);){
                    throwable = null;
                    try (ResultSet rsV = psV.executeQuery();){
                        if (rsV.next()) {
                            Serializable cvss;
                            cveId = rsV.getInt(1);
                            vuln = new Vulnerability();
                            vuln.setSource(Vulnerability.Source.NVD);
                            vuln.setName(cve);
                            vuln.setDescription(rsV.getString(2));
                            if (rsV.getObject(11) != null) {
                                cvss = new CvssV2(rsV.getFloat(11), rsV.getString(12), rsV.getString(13), rsV.getString(14), rsV.getString(15), rsV.getString(16), rsV.getString(17), rsV.getString(3), this.getFloatValue(rsV, 4), this.getFloatValue(rsV, 5), this.getBooleanValue(rsV, 6), this.getBooleanValue(rsV, 7), this.getBooleanValue(rsV, 8), this.getBooleanValue(rsV, 9), this.getBooleanValue(rsV, 10), rsV.getString(18));
                                vuln.setCvssV2((CvssV2)cvss);
                            }
                            if (rsV.getObject(21) != null) {
                                cvss = new CvssV3(rsV.getString(21), rsV.getString(22), rsV.getString(23), rsV.getString(24), rsV.getString(25), rsV.getString(26), rsV.getString(27), rsV.getString(28), rsV.getFloat(29), rsV.getString(30), this.getFloatValue(rsV, 19), this.getFloatValue(rsV, 20), rsV.getString(31));
                                vuln.setCvssV3((CvssV3)cvss);
                            }
                            break block110;
                        }
                        LOGGER.debug(cve + " does not exist in the database");
                        Vulnerability vulnerability = null;
                        return vulnerability;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable rsV) {
                    throwable2 = rsV;
                    throw rsV;
                }
            }
            throwable2 = null;
            try (PreparedStatement psCWE = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_VULNERABILITY_CWE, cveId);){
                throwable = null;
                try (ResultSet rsC = psCWE.executeQuery();){
                    while (rsC.next()) {
                        vuln.addCwe(rsC.getString(1));
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable rsC) {
                throwable2 = rsC;
                throw rsC;
            }
            throwable2 = null;
            try (PreparedStatement psR = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_REFERENCES, cveId);){
                throwable = null;
                try (ResultSet rsR = psR.executeQuery();){
                    while (rsR.next()) {
                        vuln.addReference(rsR.getString(1), rsR.getString(2), rsR.getString(3));
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            catch (Throwable rsR) {
                throwable2 = rsR;
                throw rsR;
            }
            throwable2 = null;
            try (PreparedStatement psS = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_SOFTWARE, cveId);){
                throwable = null;
                try (ResultSet rsS = psS.executeQuery();){
                    while (rsS.next()) {
                        vulnerableSoftwareBuilder.part(rsS.getString(1)).vendor(rsS.getString(2)).product(rsS.getString(3)).version(rsS.getString(4)).update(rsS.getString(5)).edition(rsS.getString(6)).language(rsS.getString(7)).swEdition(rsS.getString(8)).targetSw(rsS.getString(9)).targetHw(rsS.getString(10)).other(rsS.getString(11)).versionEndExcluding(rsS.getString(12)).versionEndIncluding(rsS.getString(13)).versionStartExcluding(rsS.getString(14)).versionStartIncluding(rsS.getString(15)).vulnerable(rsS.getBoolean(16));
                        vuln.addVulnerableSoftware(vulnerableSoftwareBuilder.build());
                    }
                    return vuln;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
        }
        catch (SQLException ex) {
            throw new DatabaseException("Error retrieving " + cve, ex);
        }
        catch (CpeParsingException | CpeValidationException ex) {
            throw new DatabaseException("The database contains an invalid Vulnerable Software Entry", ex);
        }
    }

    public void updateVulnerability(DefCveItem cve, String baseEcosystem) {
        this.clearCache();
        String cveId = cve.getCve().getCVEDataMeta().getId();
        try {
            String description = this.cveItemConverter.extractDescription(cve);
            if (this.cveItemConverter.isRejected(description)) {
                this.deleteVulnerability(cveId);
            } else if (this.cveItemConverter.testCveCpeStartWithFilter(cve)) {
                int vulnerabilityId = this.updateOrInsertVulnerability(cve, description);
                this.updateVulnerabilityInsertCwe(vulnerabilityId, cve);
                this.updateVulnerabilityInsertReferences(vulnerabilityId, cve);
                List<VulnerableSoftware> software = this.parseCpes(cve);
                this.updateVulnerabilityInsertSoftware(vulnerabilityId, cveId, software, baseEcosystem);
            }
        }
        catch (SQLException ex) {
            String msg = String.format("Error updating '%s'", cveId);
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg, ex);
        }
        catch (CpeValidationException ex) {
            String msg = String.format("Error parsing CPE entry from '%s'", cveId);
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg, ex);
        }
    }

    private void loadCpeEcosystemCache() {
        HashMap<Pair<String, String>, String> map = new HashMap<Pair<String, String>, String>();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.SELECT_CPE_ECOSYSTEM);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                Pair<String, String> key = new Pair<String, String>(rs.getString(1), rs.getString(2));
                String value = rs.getString(3);
                map.put(key, value);
            }
        }
        catch (SQLException ex) {
            String msg = String.format("Error loading the Cpe Ecosystem Cache: %s", ex.getMessage());
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg, ex);
        }
        CpeEcosystemCache.setCache(map);
    }

    private void saveCpeEcosystemCache() {
        Map<Pair<String, String>, String> map = CpeEcosystemCache.getChanged();
        if (map != null && !map.isEmpty()) {
            try (Connection conn = this.databaseManager.getConnection();
                 PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.MERGE_CPE_ECOSYSTEM);){
                for (Map.Entry<Pair<String, String>, String> entry : map.entrySet()) {
                    ps.setString(1, entry.getKey().getLeft());
                    ps.setString(2, entry.getKey().getRight());
                    ps.setString(3, entry.getValue());
                    if (this.isBatchInsertEnabled()) {
                        ps.addBatch();
                        continue;
                    }
                    ps.execute();
                }
                if (this.isBatchInsertEnabled()) {
                    ps.executeBatch();
                }
            }
            catch (SQLException ex) {
                String msg = String.format("Error saving the Cpe Ecosystem Cache: %s", ex.getMessage());
                LOGGER.debug(msg, (Throwable)ex);
                throw new DatabaseException(msg, ex);
            }
        }
    }

    private int updateOrInsertVulnerability(DefCveItem cve, String description) {
        int vulnerabilityId;
        block48: {
            if (CpeEcosystemCache.isEmpty()) {
                this.loadCpeEcosystemCache();
            }
            try (Connection conn = this.databaseManager.getConnection();
                 PreparedStatement callUpdate = this.getPreparedStatement(conn, PreparedStatementCveDb.UPDATE_VULNERABILITY);){
                Object msg;
                Map<String, Object> props;
                callUpdate.setString(1, cve.getCve().getCVEDataMeta().getId());
                callUpdate.setString(2, description);
                if (cve.getImpact().getBaseMetricV2() != null) {
                    BaseMetricV2 cvssv2 = cve.getImpact().getBaseMetricV2();
                    props = cvssv2.getAdditionalProperties();
                    callUpdate.setString(3, cvssv2.getSeverity());
                    this.setFloatValue(callUpdate, 4, props, "exploitabilityScore");
                    this.setFloatValue(callUpdate, 5, props, "impactScore");
                    this.setBooleanValue(callUpdate, 6, props, "acInsufInfo");
                    this.setBooleanValue(callUpdate, 7, props, "obtainAllPrivilege");
                    this.setBooleanValue(callUpdate, 8, props, "obtainUserPrivilege");
                    this.setBooleanValue(callUpdate, 9, props, "obtainOtherPrivilege");
                    this.setBooleanValue(callUpdate, 10, props, "userInteractionRequired");
                    callUpdate.setFloat(11, cvssv2.getCvssV2().getBaseScore().floatValue());
                    callUpdate.setString(12, cvssv2.getCvssV2().getAccessVector().value());
                    callUpdate.setString(13, cvssv2.getCvssV2().getAccessComplexity().value());
                    callUpdate.setString(14, cvssv2.getCvssV2().getAuthentication().value());
                    callUpdate.setString(15, cvssv2.getCvssV2().getConfidentialityImpact().value());
                    callUpdate.setString(16, cvssv2.getCvssV2().getIntegrityImpact().value());
                    callUpdate.setString(17, cvssv2.getCvssV2().getAvailabilityImpact().value());
                    props = cvssv2.getCvssV2().getAdditionalProperties();
                    this.setStringValue(callUpdate, 18, props, "version");
                } else {
                    callUpdate.setNull(3, 0);
                    callUpdate.setNull(4, 0);
                    callUpdate.setNull(5, 0);
                    callUpdate.setNull(6, 0);
                    callUpdate.setNull(7, 0);
                    callUpdate.setNull(8, 0);
                    callUpdate.setNull(9, 0);
                    callUpdate.setNull(10, 0);
                    callUpdate.setNull(11, 0);
                    callUpdate.setNull(12, 0);
                    callUpdate.setNull(13, 0);
                    callUpdate.setNull(14, 0);
                    callUpdate.setNull(15, 0);
                    callUpdate.setNull(16, 0);
                    callUpdate.setNull(17, 0);
                    callUpdate.setNull(18, 0);
                }
                if (cve.getImpact().getBaseMetricV3() != null) {
                    BaseMetricV3 cvssv3 = cve.getImpact().getBaseMetricV3();
                    props = cvssv3.getAdditionalProperties();
                    this.setFloatValue(callUpdate, 19, props, "exploitabilityScore");
                    this.setFloatValue(callUpdate, 20, props, "impactScore");
                    callUpdate.setString(21, cvssv3.getCvssV3().getAttackVector().value());
                    callUpdate.setString(22, cvssv3.getCvssV3().getAttackComplexity().value());
                    callUpdate.setString(23, cvssv3.getCvssV3().getPrivilegesRequired().value());
                    callUpdate.setString(24, cvssv3.getCvssV3().getUserInteraction().value());
                    callUpdate.setString(25, cvssv3.getCvssV3().getScope().value());
                    callUpdate.setString(26, cvssv3.getCvssV3().getConfidentialityImpact().value());
                    callUpdate.setString(27, cvssv3.getCvssV3().getIntegrityImpact().value());
                    callUpdate.setString(28, cvssv3.getCvssV3().getAvailabilityImpact().value());
                    callUpdate.setFloat(29, cvssv3.getCvssV3().getBaseScore().floatValue());
                    callUpdate.setString(30, cvssv3.getCvssV3().getBaseSeverity().value());
                    props = cvssv3.getCvssV3().getAdditionalProperties();
                    this.setStringValue(callUpdate, 31, props, "version");
                } else {
                    callUpdate.setNull(19, 0);
                    callUpdate.setNull(20, 0);
                    callUpdate.setNull(21, 0);
                    callUpdate.setNull(22, 0);
                    callUpdate.setNull(23, 0);
                    callUpdate.setNull(24, 0);
                    callUpdate.setNull(25, 0);
                    callUpdate.setNull(26, 0);
                    callUpdate.setNull(27, 0);
                    callUpdate.setNull(28, 0);
                    callUpdate.setNull(29, 0);
                    callUpdate.setNull(30, 0);
                    callUpdate.setNull(31, 0);
                }
                if (this.isOracle) {
                    try {
                        CallableStatement cs = (CallableStatement)callUpdate;
                        cs.registerOutParameter(32, (SQLType)JDBCType.INTEGER);
                        cs.executeUpdate();
                        vulnerabilityId = cs.getInt(32);
                        break block48;
                    }
                    catch (SQLException ex) {
                        msg = String.format("Unable to retrieve id for new vulnerability for '%s'", cve.getCve().getCVEDataMeta().getId());
                        throw new DatabaseException((String)msg, ex);
                    }
                }
                try {
                    ResultSet rs = callUpdate.executeQuery();
                    msg = null;
                    try {
                        rs.next();
                        vulnerabilityId = rs.getInt(1);
                    }
                    catch (Throwable throwable) {
                        msg = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (msg != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)msg).addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    msg = String.format("Unable to retrieve id for new vulnerability for '%s'", cve.getCve().getCVEDataMeta().getId());
                    throw new DatabaseException((String)msg, ex);
                }
            }
            catch (SQLException ex) {
                throw new UnexpectedAnalysisException(ex);
            }
        }
        return vulnerabilityId;
    }

    private void updateVulnerabilityInsertCwe(int vulnerabilityId, DefCveItem cve) throws SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement insertCWE = this.getPreparedStatement(conn, PreparedStatementCveDb.INSERT_CWE, vulnerabilityId);){
            for (ProblemtypeDatum datum : cve.getCve().getProblemtype().getProblemtypeData()) {
                for (LangString desc : datum.getDescription()) {
                    if (!"en".equals(desc.getLang())) continue;
                    insertCWE.setString(2, desc.getValue());
                    if (this.isBatchInsertEnabled()) {
                        insertCWE.addBatch();
                        continue;
                    }
                    insertCWE.execute();
                }
            }
            if (this.isBatchInsertEnabled()) {
                insertCWE.executeBatch();
            }
        }
    }

    private void deleteVulnerability(String cve) throws SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement deleteVulnerability = this.getPreparedStatement(conn, PreparedStatementCveDb.DELETE_VULNERABILITY, cve);){
            deleteVulnerability.executeUpdate();
        }
    }

    private void updateVulnerabilityInsertSoftware(int vulnerabilityId, String cveId, List<VulnerableSoftware> software, String baseEcosystem) throws DatabaseException, SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement insertSoftware = this.getPreparedStatement(conn, PreparedStatementCveDb.INSERT_SOFTWARE);){
            for (VulnerableSoftware parsedCpe : software) {
                insertSoftware.setInt(1, vulnerabilityId);
                insertSoftware.setString(2, parsedCpe.getPart().getAbbreviation());
                insertSoftware.setString(3, parsedCpe.getVendor());
                insertSoftware.setString(4, parsedCpe.getProduct());
                insertSoftware.setString(5, parsedCpe.getVersion());
                insertSoftware.setString(6, parsedCpe.getUpdate());
                insertSoftware.setString(7, parsedCpe.getEdition());
                insertSoftware.setString(8, parsedCpe.getLanguage());
                insertSoftware.setString(9, parsedCpe.getSwEdition());
                insertSoftware.setString(10, parsedCpe.getTargetSw());
                insertSoftware.setString(11, parsedCpe.getTargetHw());
                insertSoftware.setString(12, parsedCpe.getOther());
                String ecosystem = CpeEcosystemCache.getEcosystem(parsedCpe.getVendor(), parsedCpe.getProduct(), this.cveItemConverter.extractEcosystem(baseEcosystem, parsedCpe));
                this.addNullableStringParameter(insertSoftware, 13, ecosystem);
                this.addNullableStringParameter(insertSoftware, 14, parsedCpe.getVersionEndExcluding());
                this.addNullableStringParameter(insertSoftware, 15, parsedCpe.getVersionEndIncluding());
                this.addNullableStringParameter(insertSoftware, 16, parsedCpe.getVersionStartExcluding());
                this.addNullableStringParameter(insertSoftware, 17, parsedCpe.getVersionStartIncluding());
                insertSoftware.setBoolean(18, parsedCpe.isVulnerable());
                if (this.isBatchInsertEnabled()) {
                    insertSoftware.addBatch();
                    continue;
                }
                try {
                    insertSoftware.execute();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().contains("Duplicate entry")) {
                        String msg = String.format("Duplicate software key identified in '%s'", cveId);
                        LOGGER.info(msg, (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
            if (this.isBatchInsertEnabled()) {
                this.executeBatch(cveId, insertSoftware);
            }
        }
    }

    private void updateVulnerabilityInsertReferences(int vulnerabilityId, DefCveItem cve) throws SQLException {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement insertReference = this.getPreparedStatement(conn, PreparedStatementCveDb.INSERT_REFERENCE);){
            if (cve.getCve().getReferences() != null) {
                for (Reference r : cve.getCve().getReferences().getReferenceData()) {
                    insertReference.setInt(1, vulnerabilityId);
                    insertReference.setString(2, r.getName());
                    insertReference.setString(3, r.getUrl());
                    insertReference.setString(4, r.getRefsource());
                    if (this.isBatchInsertEnabled()) {
                        insertReference.addBatch();
                        continue;
                    }
                    insertReference.execute();
                }
            }
            if (this.isBatchInsertEnabled()) {
                insertReference.executeBatch();
            }
        }
    }

    private List<VulnerableSoftware> parseCpes(DefCveItem cve) throws CpeValidationException {
        ArrayList<VulnerableSoftware> software = new ArrayList<VulnerableSoftware>();
        List<DefCpeMatch> cpeEntries = cve.getConfigurations().getNodes().stream().collect(NodeFlatteningCollector.getInstance()).collect(CpeMatchStreamCollector.getInstance()).filter(predicate -> predicate.getCpe23Uri() != null).filter(predicate -> predicate.getCpe23Uri().startsWith(this.cpeStartsWithFilter)).filter(entry -> !"CVE-2009-0754".equals(cve.getCve().getCVEDataMeta().getId()) || !"cpe:2.3:a:apache:apache:*:*:*:*:*:*:*:*".equals(entry.getCpe23Uri())).collect(Collectors.toList());
        VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder();
        try {
            cpeEntries.forEach(entry -> {
                builder.cpe(this.parseCpe((DefCpeMatch)entry, cve.getCve().getCVEDataMeta().getId())).versionEndExcluding(entry.getVersionEndExcluding()).versionStartExcluding(entry.getVersionStartExcluding()).versionEndIncluding(entry.getVersionEndIncluding()).versionStartIncluding(entry.getVersionStartIncluding()).vulnerable(entry.getVulnerable());
                try {
                    software.add(builder.build());
                }
                catch (CpeValidationException ex) {
                    throw new LambdaExceptionWrapper((Exception)((Object)ex));
                }
            });
        }
        catch (LambdaExceptionWrapper ex) {
            throw (CpeValidationException)ex.getCause();
        }
        return software;
    }

    private Cpe parseCpe(DefCpeMatch cpe, String cveId) throws DatabaseException {
        Cpe parsedCpe;
        try {
            parsedCpe = CpeParser.parse((String)cpe.getCpe23Uri(), (boolean)true);
        }
        catch (CpeParsingException ex) {
            LOGGER.debug("NVD (" + cveId + ") contain an invalid 2.3 CPE: " + cpe.getCpe23Uri());
            if (cpe.getCpe22Uri() != null && !cpe.getCpe22Uri().isEmpty()) {
                try {
                    parsedCpe = CpeParser.parse((String)cpe.getCpe22Uri(), (boolean)true);
                }
                catch (CpeParsingException ex2) {
                    throw new DatabaseException("Unable to parse CPE: " + cpe.getCpe23Uri(), ex);
                }
            }
            throw new DatabaseException("Unable to parse CPE: " + cpe.getCpe23Uri(), ex);
        }
        return parsedCpe;
    }

    private int getBatchSize() {
        int max;
        try {
            max = this.settings.getInt("database.batchinsert.maxsize");
        }
        catch (InvalidSettingException pE) {
            max = 1000;
        }
        return max;
    }

    private boolean isBatchInsertEnabled() {
        boolean batch;
        try {
            batch = this.settings.getBoolean("database.batchinsert.enabled");
        }
        catch (InvalidSettingException pE) {
            batch = false;
        }
        return batch;
    }

    private void executeBatch(String vulnId, PreparedStatement statement) throws SQLException {
        try {
            statement.executeBatch();
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("Duplicate entry")) {
                String msg = String.format("Duplicate software key identified in '%s'", vulnId);
                LOGGER.info(msg, (Throwable)ex);
            }
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dataExists() {
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement cs = this.getPreparedStatement(conn, PreparedStatementCveDb.COUNT_CPE);
             ResultSet rs = cs.executeQuery();){
            if (!rs.next()) return false;
            if (rs.getInt(1) <= 0) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            String dd;
            try {
                dd = this.settings.getDataDirectory().getAbsolutePath();
            }
            catch (IOException ex1) {
                dd = this.settings.getString("data.directory");
            }
            LOGGER.error("Unable to access the local database.\n\nEnsure that '{}' is a writable directory. If the problem persist try deleting the files in '{}' and running {} again. If the problem continues, please create a log file (see documentation at https://jeremylong.github.io/DependencyCheck/) and open a ticket at https://github.com/jeremylong/DependencyCheck/issues and include the log file.\n\n", new Object[]{dd, dd, this.settings.getString("odc.application.name")});
            LOGGER.debug("", (Throwable)ex);
        }
        return false;
    }

    public void cleanupDatabase() {
        LOGGER.info("Begin database maintenance");
        long start = System.currentTimeMillis();
        this.saveCpeEcosystemCache();
        this.clearCache();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement psOrphans = this.getPreparedStatement(conn, PreparedStatementCveDb.CLEANUP_ORPHANS);
             PreparedStatement psEcosystem = this.getPreparedStatement(conn, PreparedStatementCveDb.UPDATE_ECOSYSTEM);
             PreparedStatement psEcosystem2 = this.getPreparedStatement(conn, PreparedStatementCveDb.UPDATE_ECOSYSTEM2);){
            int count;
            if (psEcosystem != null && (count = psEcosystem.executeUpdate()) > 0) {
                LOGGER.info("Updated the CPE ecosystem on {} NVD records", (Object)count);
            }
            if (psEcosystem2 != null && (count = psEcosystem2.executeUpdate()) > 0) {
                LOGGER.info("Removed the CPE ecosystem on {} NVD records", (Object)count);
            }
            if (psOrphans != null && (count = psOrphans.executeUpdate()) > 0) {
                LOGGER.info("Cleaned up {} orphaned NVD records", (Object)count);
            }
            long millis = System.currentTimeMillis() - start;
            LOGGER.info("End database maintenance ({} ms)", (Object)millis);
        }
        catch (SQLException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", (Throwable)ex);
            throw new DatabaseException("Unexpected SQL Exception", ex);
        }
    }

    public void defrag() {
        if (this.isH2) {
            long start = System.currentTimeMillis();
            try (Connection conn = this.databaseManager.getConnection();
                 CallableStatement psCompaxt = conn.prepareCall("SHUTDOWN DEFRAG");){
                LOGGER.info("Begin database defrag");
                psCompaxt.execute();
                long millis = System.currentTimeMillis() - start;
                LOGGER.info("End database defrag ({} ms)", (Object)millis);
            }
            catch (SQLException ex) {
                LOGGER.error("An unexpected SQL Exception occurred compacting the database; please see the verbose log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    VulnerableSoftware getMatchingSoftware(Cpe cpe, Set<VulnerableSoftware> vulnerableSoftware) {
        VulnerableSoftware matched = null;
        for (VulnerableSoftware vs : vulnerableSoftware) {
            if (!vs.matches((ICpe)cpe)) continue;
            if (matched == null) {
                matched = vs;
                continue;
            }
            if (!"*".equals(vs.getWellFormedUpdate()) || "*".equals(matched.getWellFormedUpdate())) continue;
            matched = vs;
        }
        return matched;
    }

    public void deleteUnusedCpe() {
        this.clearCache();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.DELETE_UNUSED_DICT_CPE);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            LOGGER.error("Unable to delete CPE dictionary entries", (Throwable)ex);
        }
    }

    public void addCpe(String cpe, String vendor, String product) {
        this.clearCache();
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement ps = this.getPreparedStatement(conn, PreparedStatementCveDb.ADD_DICT_CPE);){
            ps.setString(1, cpe);
            ps.setString(2, vendor);
            ps.setString(3, product);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            LOGGER.error("Unable to add CPE dictionary entry", (Throwable)ex);
        }
    }

    private void addNullableStringParameter(PreparedStatement ps, int pos, String value) throws SQLException {
        if (value == null || value.isEmpty()) {
            ps.setNull(pos, 12);
        } else {
            ps.setString(pos, value);
        }
    }

    private void setFloatValue(PreparedStatement ps, int i, Map<String, Object> props, String key) throws SQLException {
        if (props != null && props.containsKey(key)) {
            try {
                ps.setFloat(i, Float.parseFloat(props.get(key).toString()));
            }
            catch (NumberFormatException nfe) {
                ps.setNull(i, 0);
            }
        } else {
            ps.setNull(i, 0);
        }
    }

    private void setStringValue(PreparedStatement ps, int i, Map<String, Object> props, String key) throws SQLException {
        if (props != null && props.containsKey(key)) {
            ps.setString(i, props.get(key).toString());
        } else {
            ps.setNull(i, 0);
        }
    }

    private void setBooleanValue(PreparedStatement ps, int i, Map<String, Object> props, String key) throws SQLException {
        if (props != null && props.containsKey(key)) {
            ps.setBoolean(i, Boolean.parseBoolean(props.get(key).toString()));
        } else {
            ps.setNull(i, 0);
        }
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private Boolean getBooleanValue(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) == null) {
            return null;
        }
        return rs.getBoolean(index);
    }

    private Float getFloatValue(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) == null) {
            return null;
        }
        return Float.valueOf(rs.getFloat(index));
    }

    static enum PreparedStatementCveDb {
        CLEANUP_ORPHANS,
        UPDATE_ECOSYSTEM,
        UPDATE_ECOSYSTEM2,
        COUNT_CPE,
        DELETE_VULNERABILITY,
        INSERT_PROPERTY,
        INSERT_CWE,
        INSERT_REFERENCE,
        INSERT_SOFTWARE,
        MERGE_PROPERTY,
        SELECT_CPE_ENTRIES,
        SELECT_CVE_FROM_SOFTWARE,
        SELECT_PROPERTIES,
        SELECT_VULNERABILITY_CWE,
        SELECT_REFERENCES,
        SELECT_SOFTWARE,
        SELECT_VENDOR_PRODUCT_LIST,
        SELECT_VENDOR_PRODUCT_LIST_FOR_NODE,
        SELECT_VULNERABILITY,
        UPDATE_PROPERTY,
        UPDATE_VULNERABILITY,
        SELECT_CPE_ECOSYSTEM,
        MERGE_CPE_ECOSYSTEM,
        DELETE_UNUSED_DICT_CPE,
        ADD_DICT_CPE;

    }
}

