/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.xml.suppression.SuppressionParseException;
import org.owasp.dependencycheck.xml.suppression.SuppressionParser;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;
import org.owasp.dependencycheck.xml.suppression.SuppressionRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@ThreadSafe
public abstract class AbstractSuppressionAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSuppressionAnalyzer.class);
    private static final String BASE_SUPPRESSION_FILE = "dependencycheck-base-suppression.xml";
    private static final String SUPPRESSION_LOADED = "SUPPRESSION_LOADED";
    private final SuppressionRules rules = SuppressionRules.getInstance();

    protected SuppressionRules getSuppressionRules() {
        return this.rules;
    }

    protected int getRuleCount() {
        return this.rules.size();
    }

    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public synchronized void prepareAnalyzer(Engine engine) throws InitializationException {
        boolean loaded = this.getSettings().getBoolean(SUPPRESSION_LOADED, false);
        if (!loaded) {
            SuppressionRules.getInstance().list().clear();
        }
        if (this.rules.isEmpty()) {
            try {
                this.loadSuppressionBaseData();
            }
            catch (SuppressionParseException ex) {
                throw new InitializationException("Error initializing the suppression analyzer: " + ex.getLocalizedMessage(), ex, true);
            }
            try {
                this.loadSuppressionData();
            }
            catch (SuppressionParseException ex) {
                throw new InitializationException("Warn initializing the suppression analyzer: " + ex.getLocalizedMessage(), ex, false);
            }
            this.getSettings().setBoolean(SUPPRESSION_LOADED, true);
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.rules.isEmpty()) {
            return;
        }
        for (SuppressionRule rule : this.rules.list()) {
            if (!this.filter(rule)) continue;
            rule.process(dependency);
        }
    }

    abstract boolean filter(SuppressionRule var1);

    private void loadSuppressionData() throws SuppressionParseException {
        ArrayList<SuppressionRule> ruleList = new ArrayList<SuppressionRule>();
        SuppressionParser parser = new SuppressionParser();
        String[] suppressionFilePaths = this.getSettings().getArray("suppression.file");
        ArrayList<String> failedLoadingFiles = new ArrayList<String>();
        if (suppressionFilePaths != null && suppressionFilePaths.length > 0) {
            for (String suppressionFilePath : suppressionFilePaths) {
                try {
                    ruleList.addAll(this.loadSuppressionFile(parser, suppressionFilePath));
                }
                catch (SuppressionParseException ex) {
                    String msg = String.format("Failed to load %s, caused by %s. ", suppressionFilePath, ex.getMessage());
                    failedLoadingFiles.add(msg);
                }
            }
        }
        LOGGER.debug("{} suppression rules were loaded.", (Object)ruleList.size());
        this.rules.addAll(ruleList);
        if (!failedLoadingFiles.isEmpty()) {
            LOGGER.debug("{} suppression files failed to load.", (Object)failedLoadingFiles.size());
            StringBuilder sb = new StringBuilder();
            failedLoadingFiles.forEach(sb::append);
            throw new SuppressionParseException(sb.toString());
        }
    }

    private void loadSuppressionBaseData() throws SuppressionParseException {
        List<SuppressionRule> ruleList;
        SuppressionParser parser = new SuppressionParser();
        try (InputStream in = FileUtils.getResourceAsStream((String)BASE_SUPPRESSION_FILE);){
            if (in == null) {
                throw new SuppressionParseException("Suppression rules `dependencycheck-base-suppression.xml` could not be found");
            }
            ruleList = parser.parseSuppressionRules(in);
        }
        catch (IOException | SAXException ex) {
            throw new SuppressionParseException("Unable to parse the base suppression data file", ex);
        }
        this.rules.addAll(ruleList);
    }

    /*
     * Exception decompiling
     */
    private List<SuppressionRule> loadSuppressionFile(SuppressionParser parser, String suppressionFilePath) throws SuppressionParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[CATCHBLOCK]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void throwSuppressionParseException(String message, Exception exception, String suppressionFilePath) throws SuppressionParseException {
        LOGGER.warn(String.format(message + " '%s'", suppressionFilePath));
        LOGGER.debug("", (Throwable)exception);
        throw new SuppressionParseException(message, exception);
    }
}

