/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.Date;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.exception.WriteLockException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.WriteLockShutdownHook;
import org.owasp.dependencycheck.utils.WriteLockShutdownHookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class WriteLock
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteLock.class);
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public static final int SLEEP_DURATION = 15000;
    public static final int MAX_SLEEP_COUNT = 160;
    private FileLock lock = null;
    private RandomAccessFile file = null;
    private File lockFile = null;
    private final Settings settings;
    private final String magic;
    private final boolean isLockable;
    private final String lockFileName;
    private WriteLockShutdownHook hook = null;

    public WriteLock(Settings settings) throws WriteLockException {
        this(settings, true);
    }

    public WriteLock(Settings settings, boolean isLockable) throws WriteLockException {
        this(settings, isLockable, "odc.update.lock");
    }

    public WriteLock(Settings settings, boolean isLockable, String lockFileName) throws WriteLockException {
        this.settings = settings;
        byte[] random = new byte[16];
        SECURE_RANDOM.nextBytes(random);
        this.magic = Checksum.getHex((byte[])random);
        this.isLockable = isLockable;
        this.lockFileName = lockFileName;
        this.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lock() throws WriteLockException {
        if (!this.isLockable) {
            return;
        }
        try {
            File dir = this.settings.getDataDirectory();
            this.lockFile = new File(dir, this.lockFileName);
            this.checkState();
            int ctr = 0;
            do {
                try {
                    if (!this.lockFile.exists() && this.lockFile.createNewFile()) {
                        this.file = new RandomAccessFile(this.lockFile, "rw");
                        this.lock = this.file.getChannel().lock();
                        this.file.writeBytes(this.magic);
                        this.file.getChannel().force(true);
                        Thread.sleep(20L);
                        this.file.seek(0L);
                        String current = this.file.readLine();
                        if (current != null && !current.equals(this.magic)) {
                            this.lock.close();
                            this.lock = null;
                            LOGGER.debug("Another process obtained a lock first ({})", (Object)Thread.currentThread().getName());
                        } else {
                            this.addShutdownHook();
                            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                            LOGGER.debug("Lock file created ({}) {} @ {}", new Object[]{Thread.currentThread().getName(), this.magic, timestamp.toString()});
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    LOGGER.trace("Expected error as another thread has likely locked the file", (Throwable)ex);
                }
                catch (IOException ex) {
                    LOGGER.trace("Expected error as another thread has likely locked the file", (Throwable)ex);
                }
                finally {
                    if (this.lock == null && this.file != null) {
                        try {
                            this.file.close();
                            this.file = null;
                        }
                        catch (IOException ex) {
                            LOGGER.trace("Unable to close the lock file", (Throwable)ex);
                        }
                    }
                }
                if (this.lock != null && this.lock.isValid()) continue;
                try {
                    Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                    LOGGER.debug("Sleeping thread {} ({}) for {} seconds because an exclusive lock on the database could not be obtained ({})", new Object[]{Thread.currentThread().getName(), this.magic, 15, timestamp.toString()});
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.debug("sleep was interrupted.", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            } while (++ctr < 160 && (this.lock == null || !this.lock.isValid()));
            if (this.lock == null || !this.lock.isValid()) {
                throw new WriteLockException("Unable to obtain the update lock, skipping the database update. Skipping the database update.");
            }
        }
        catch (IOException ex) {
            throw new WriteLockException(ex.getMessage(), ex);
        }
    }

    @Override
    public void close() {
        String msg;
        if (!this.isLockable) {
            return;
        }
        if (this.lock != null) {
            try {
                this.lock.release();
                this.lock = null;
            }
            catch (IOException ex) {
                LOGGER.debug("Failed to release lock", (Throwable)ex);
            }
        }
        if (this.file != null) {
            try {
                this.file.close();
                this.file = null;
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to delete lock file", (Throwable)ex);
            }
        }
        if (this.lockFile != null && this.lockFile.isFile() && (msg = this.readLockFile()) != null && msg.equals(this.magic) && !this.lockFile.delete()) {
            LOGGER.error("Lock file '{}' was unable to be deleted. Please manually delete this file.", (Object)this.lockFile.toString());
            this.lockFile.deleteOnExit();
        }
        this.lockFile = null;
        this.removeShutdownHook();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        LOGGER.debug("Lock released ({}) {} @ {}", new Object[]{Thread.currentThread().getName(), this.magic, timestamp.toString()});
    }

    private void checkState() throws WriteLockException {
        if (!this.lockFile.getParentFile().isDirectory() && !this.lockFile.mkdir()) {
            throw new WriteLockException("Unable to create path to data directory.");
        }
        if (this.lockFile.isFile()) {
            if (this.getFileAge(this.lockFile) > 30.0) {
                LOGGER.debug("An old write lock file was found: {}", (Object)this.lockFile.getAbsolutePath());
                if (!this.lockFile.delete()) {
                    LOGGER.warn("An old write lock file was found but the system was unable to delete the file. Consider manually deleting {}", (Object)this.lockFile.getAbsolutePath());
                }
            } else {
                LOGGER.info("Lock file found `{}`", (Object)this.lockFile);
                LOGGER.info("Existing update in progress; waiting for update to complete");
            }
        }
    }

    private String readLockFile() {
        String msg = null;
        try (RandomAccessFile f = new RandomAccessFile(this.lockFile, "rw");){
            msg = f.readLine();
        }
        catch (IOException ex) {
            LOGGER.debug(String.format("Error reading lock file: %s", this.lockFile), (Throwable)ex);
        }
        return msg;
    }

    private double getFileAge(File file) {
        Date d = new Date();
        long modified = file.lastModified();
        double time = (double)(d.getTime() - modified) / 1000.0 / 60.0;
        LOGGER.debug("Lock file age is {} minutes", (Object)time);
        return time;
    }

    private void addShutdownHook() {
        if (this.hook == null) {
            this.hook = WriteLockShutdownHookFactory.getHook(this.settings);
            this.hook.add(this);
        }
    }

    private void removeShutdownHook() {
        if (this.hook != null) {
            this.hook.remove();
            this.hook = null;
        }
    }
}

