/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.util.Calendar;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.owasp.dependencycheck.exception.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);

    private DateUtil() {
    }

    public static Calendar parseXmlDate(String xsDate) throws ParseException {
        try {
            DatatypeFactory df = DatatypeFactory.newInstance();
            XMLGregorianCalendar dateTime = df.newXMLGregorianCalendar(xsDate);
            return dateTime.toGregorianCalendar();
        }
        catch (DatatypeConfigurationException ex) {
            throw new ParseException("Unable to parse " + xsDate, ex);
        }
    }

    public static boolean withinDateRange(long date, long compareTo, int dayRange) {
        long msRange = (long)dayRange * 24L * 60L * 60L;
        return compareTo - date < msRange;
    }

    public static long getEpochValueInSeconds(String epoch) {
        String seconds = epoch.length() >= 13 ? epoch.substring(0, 10) : epoch;
        long results = 0L;
        try {
            results = Long.parseLong(seconds);
        }
        catch (NumberFormatException ex) {
            LOGGER.debug(String.format("Error parsing '%s' property from the database - using zero", epoch), (Throwable)ex);
        }
        return results;
    }
}

