/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.data.nodeaudit.NpmAuditParser;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.processing.ProcessReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public class PnpmAuditAnalyzer
extends AbstractNpmAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PnpmAuditAnalyzer.class);
    public static final String PNPM_PACKAGE_LOCK = "pnpm-lock.yaml";
    private static final FileFilter LOCK_FILE_FILTER = FileFilterBuilder.newInstance().addFilenames("pnpm-lock.yaml").build();
    private String pnpmPath;

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File packageLock;
        if (dependency.getDisplayFileName().equals(dependency.getFileName())) {
            engine.removeDependency(dependency);
        }
        if (!(packageLock = dependency.getActualFile()).isFile() || packageLock.length() == 0L || !PnpmAuditAnalyzer.shouldProcess(packageLock)) {
            return;
        }
        HashMap<String, String> dependencyMap = new HashMap<String, String>();
        List<Advisory> advisories = this.analyzePackage(packageLock, dependency);
        try {
            this.processResults(advisories, engine, dependency, dependencyMap);
        }
        catch (CpeValidationException ex) {
            throw new UnexpectedAnalysisException(ex);
        }
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.pnpm.audit.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return LOCK_FILE_FILTER;
    }

    @Override
    public String getName() {
        return "Pnpm Audit Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        super.prepareFileTypeAnalyzer(engine);
        if (!this.isEnabled()) {
            LOGGER.debug("{} Analyzer is disabled skipping pnpm executable check", (Object)this.getName());
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getPnpm());
        args.add("--help");
        ProcessBuilder builder = new ProcessBuilder(args);
        LOGGER.debug("Launching: {}", args);
        try {
            Process process = builder.start();
            try (ProcessReader processReader = new ProcessReader(process);){
                processReader.readAll();
                int exitValue = process.waitFor();
                boolean expectedExitValue = false;
                int executableNotFoundExitValue = 127;
                switch (exitValue) {
                    case 0: {
                        LOGGER.debug("{} is enabled.", (Object)this.getName());
                        return;
                    }
                    case 127: {
                        this.setEnabled(false);
                        LOGGER.warn("The {} has been disabled. Pnpm executable was not found.", (Object)this.getName());
                    }
                    default: {
                        this.setEnabled(false);
                        LOGGER.warn("The {} has been disabled. Pnpm executable was not found.", (Object)this.getName());
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.setEnabled(false);
            LOGGER.debug("The {} has been disabled. Pnpm executable was not found.", (Throwable)ex);
            LOGGER.warn("The {} has been disabled. Pnpm executable was not found.", (Object)this.getName());
            throw new InitializationException("Unable to read pnpm audit output.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPnpm() {
        String value;
        PnpmAuditAnalyzer pnpmAuditAnalyzer = this;
        synchronized (pnpmAuditAnalyzer) {
            if (this.pnpmPath == null) {
                String path = this.getSettings().getString("analyzer.pnpm.path");
                if (path == null) {
                    this.pnpmPath = "pnpm";
                } else {
                    File pnpmFile = new File(path);
                    if (pnpmFile.isFile()) {
                        this.pnpmPath = pnpmFile.getAbsolutePath();
                    } else {
                        LOGGER.warn("Provided path to `pnpm` executable is invalid.");
                        this.pnpmPath = "pnpm";
                    }
                }
            }
            value = this.pnpmPath;
        }
        return value;
    }

    /*
     * Exception decompiling
     */
    private JSONObject fetchPnpmAuditJson(Dependency dependency, boolean skipDevDependencies) throws AnalysisException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Advisory> analyzePackage(File lockFile, Dependency dependency) throws AnalysisException {
        try {
            Boolean skipDevDependencies = this.getSettings().getBoolean("analyzer.node.audit.skipdev", false);
            JSONObject auditJson = this.fetchPnpmAuditJson(dependency, skipDevDependencies);
            return this.getAuditParser().parse(auditJson);
        }
        catch (JSONException e) {
            throw new AnalysisException(String.format("Failed to parse %s file from the NPM Audit API (PnpmAuditAnalyzer).", lockFile.getPath()), e);
        }
        catch (SearchException ex) {
            LOGGER.error("PnpmAuditAnalyzer failed on {}", (Object)dependency.getActualFilePath());
            throw ex;
        }
    }

    @NotNull
    private NpmAuditParser getAuditParser() {
        return new NpmAuditParser();
    }
}

