/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.lucene;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LuceneUtils {
    private LuceneUtils() {
    }

    public static boolean isKeyword(String term) {
        switch (term.toUpperCase()) {
            case "AND": 
            case "OR": 
            case "NOT": 
            case "TO": 
            case "-": 
            case "+": {
                return true;
            }
        }
        return false;
    }

    @SuppressFBWarnings(justification="As this is an encoding method the fallthrough is intentional", value={"SF_SWITCH_NO_DEFAULT"})
    public static void appendEscapedLuceneQuery(StringBuilder buf, CharSequence text) {
        if (text == null || buf == null) {
            return;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '!': 
                case '\"': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buf.append('\\');
                }
            }
            buf.append(c);
        }
    }

    public static String escapeLuceneQuery(CharSequence text) {
        if (text == null) {
            return null;
        }
        int size = text.length() << 1;
        StringBuilder buf = new StringBuilder(size);
        LuceneUtils.appendEscapedLuceneQuery(buf, text);
        return buf.toString();
    }
}

