/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;

@ThreadSafe
public abstract class AbstractDependencyComparingAnalyzer
extends AbstractAnalyzer {
    private boolean analyzed = false;

    protected synchronized boolean getAnalyzed() {
        return this.analyzed;
    }

    @Override
    public final boolean supportsParallelProcessing() {
        return false;
    }

    @Override
    protected synchronized void analyzeDependency(Dependency ignore, Engine engine) throws AnalysisException {
        if (!this.analyzed) {
            this.analyzed = true;
            HashSet<Dependency> dependenciesToRemove = new HashSet<Dependency>();
            Dependency[] dependencies = engine.getDependencies();
            if (dependencies.length < 2) {
                return;
            }
            Arrays.sort(dependencies, (l, r) -> l.getFileName().compareTo(r.getFileName()));
            for (int x = 0; x < dependencies.length - 1; ++x) {
                Dependency nextDependency;
                Dependency dependency = dependencies[x];
                if (dependenciesToRemove.contains(dependency)) continue;
                for (int y = x + 1; y < dependencies.length && !this.evaluateDependencies(dependency, nextDependency = dependencies[y], dependenciesToRemove); ++y) {
                }
            }
            dependenciesToRemove.forEach(d -> engine.removeDependency((Dependency)d));
        }
    }

    protected abstract boolean evaluateDependencies(Dependency var1, Dependency var2, Set<Dependency> var3);
}

