/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.analyzer.exception.LambdaExceptionWrapper;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nvd.json.BaseMetricV2;
import org.owasp.dependencycheck.data.nvd.json.BaseMetricV3;
import org.owasp.dependencycheck.data.nvd.json.CpeMatchStreamCollector;
import org.owasp.dependencycheck.data.nvd.json.DefCpeMatch;
import org.owasp.dependencycheck.data.nvd.json.DefCveItem;
import org.owasp.dependencycheck.data.nvd.json.LangString;
import org.owasp.dependencycheck.data.nvd.json.NodeFlatteningCollector;
import org.owasp.dependencycheck.data.nvd.json.ProblemtypeDatum;
import org.owasp.dependencycheck.data.nvd.json.Reference;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.data.nvdcve.CveItemOperator;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.cpe.CpeEcosystemCache;
import org.owasp.dependencycheck.data.update.cpe.CpePlus;
import org.owasp.dependencycheck.dependency.CvssV2;
import org.owasp.dependencycheck.dependency.CvssV3;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Pair;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeBuilder;
import us.springett.parsers.cpe.CpeParser;
import us.springett.parsers.cpe.ICpe;
import us.springett.parsers.cpe.exceptions.CpeParsingException;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public final class CveDB
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CveDB.class);
    private final ConnectionFactory connectionFactory;
    private Connection connection;
    private ResourceBundle statementBundle;
    private DatabaseProperties databaseProperties;
    private final EnumMap<PreparedStatementCveDb, PreparedStatement> preparedStatements = new EnumMap(PreparedStatementCveDb.class);
    private final VulnerableSoftwareBuilder vulnerableSoftwareBuilder = new VulnerableSoftwareBuilder();
    private final String cpeStartsWithFilter;
    private final Map<String, List<Vulnerability>> vulnerabilitiesForCpeCache = Collections.synchronizedMap(new ReferenceMap(0, 1));
    private final Settings settings;
    private final CveItemOperator cveItemConverter;
    private boolean isOracle = false;

    public CveDB(Settings settings) throws DatabaseException {
        this.settings = settings;
        this.cpeStartsWithFilter = settings.getString("cve.cpe.startswith.filter", "cpe:2.3:a:");
        this.cveItemConverter = new CveItemOperator(this.cpeStartsWithFilter);
        this.connectionFactory = new ConnectionFactory(settings);
        this.open();
    }

    private String determineDatabaseProductName(Connection conn) {
        try {
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            LOGGER.debug("Database product: {}", (Object)databaseProductName);
            return databaseProductName;
        }
        catch (SQLException se) {
            LOGGER.warn("Problem determining database product!", (Throwable)se);
            return null;
        }
    }

    private synchronized void open() throws DatabaseException {
        try {
            if (!this.isOpen()) {
                this.connection = this.connectionFactory.getConnection();
                String databaseProductName = this.determineDatabaseProductName(this.connection);
                this.isOracle = "oracle".equals(databaseProductName);
                this.statementBundle = databaseProductName != null ? ResourceBundle.getBundle("data/dbStatements", new Locale(databaseProductName)) : ResourceBundle.getBundle("data/dbStatements");
                this.prepareStatements();
                this.databaseProperties = new DatabaseProperties(this);
            }
        }
        catch (DatabaseException e) {
            this.releaseResources();
            throw e;
        }
    }

    @Override
    public synchronized void close() {
        if (this.isOpen()) {
            LOGGER.debug("Closing database");
            this.clearCache();
            LOGGER.debug("Cache cleared");
            this.closeStatements();
            LOGGER.debug("Statments closed");
            try {
                this.connection.close();
                LOGGER.debug("Connection closed");
            }
            catch (SQLException ex) {
                LOGGER.error("There was an error attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            catch (Throwable ex) {
                LOGGER.error("There was an exception attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", ex);
            }
            this.releaseResources();
            LOGGER.debug("Resources released");
            this.connectionFactory.cleanup();
        }
    }

    private synchronized void releaseResources() {
        this.statementBundle = null;
        this.preparedStatements.clear();
        this.databaseProperties = null;
        this.connection = null;
    }

    protected synchronized boolean isOpen() {
        return this.connection != null;
    }

    private void prepareStatements() throws DatabaseException {
        for (PreparedStatementCveDb key : PreparedStatementCveDb.values()) {
            PreparedStatement preparedStatement = this.prepareStatement(key);
            if (preparedStatement == null) continue;
            this.preparedStatements.put(key, preparedStatement);
        }
    }

    private PreparedStatement prepareStatement(PreparedStatementCveDb key) throws DatabaseException {
        PreparedStatement preparedStatement;
        block4: {
            preparedStatement = null;
            try {
                String statementString = this.statementBundle.getString(key.name());
                preparedStatement = this.isOracle && key == PreparedStatementCveDb.UPDATE_VULNERABILITY ? this.connection.prepareCall(statementString) : this.connection.prepareStatement(statementString);
                if (this.isOracle) {
                    preparedStatement.setFetchSize(10000);
                }
            }
            catch (SQLException ex) {
                throw new DatabaseException(ex);
            }
            catch (MissingResourceException ex) {
                if (ex.getMessage().contains("key MERGE_PROPERTY")) break block4;
                throw new DatabaseException(ex);
            }
        }
        return preparedStatement;
    }

    private synchronized void closeStatements() {
        this.preparedStatements.values().forEach(preparedStatement -> DBUtils.closeStatement(preparedStatement));
    }

    private synchronized PreparedStatement getPreparedStatement(PreparedStatementCveDb key) throws SQLException {
        if (!this.preparedStatements.containsKey((Object)key)) {
            return null;
        }
        PreparedStatement preparedStatement = this.preparedStatements.get((Object)key);
        preparedStatement.clearParameters();
        return preparedStatement;
    }

    public synchronized void commit() throws SQLException {
    }

    protected void finalize() throws Throwable {
        LOGGER.debug("Entering finalize");
        this.close();
        super.finalize();
    }

    public synchronized DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    protected synchronized DatabaseProperties reloadProperties() {
        this.databaseProperties = new DatabaseProperties(this);
        return this.databaseProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<CpePlus> getCPEs(String vendor, String product) {
        HashSet<CpePlus> cpe = new HashSet<CpePlus>();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_CPE_ENTRIES);
            if (ps == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_CPE_ENTRIES));
            }
            ps.setString(1, vendor);
            ps.setString(2, product);
            rs = ps.executeQuery();
            CpeBuilder builder = new CpeBuilder();
            while (rs.next()) {
                Cpe entry = builder.part(rs.getString(1)).vendor(rs.getString(2)).product(rs.getString(3)).version(rs.getString(4)).update(rs.getString(5)).edition(rs.getString(6)).language(rs.getString(7)).swEdition(rs.getString(8)).targetSw(rs.getString(9)).targetHw(rs.getString(10)).other(rs.getString(11)).build();
                CpePlus plus = new CpePlus(entry, rs.getString(12));
                cpe.add(plus);
            }
            DBUtils.closeResultSet(rs);
        }
        catch (SQLException | CpeParsingException | CpeValidationException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", ex);
        }
        finally {
            DBUtils.closeResultSet(rs);
        }
        return cpe;
    }

    public synchronized Set<Pair<String, String>> simpleCPESearch(String vendor, String product, String majorVersion) {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        ResultSet rs = null;
        try {
            String[] parts;
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_SIMPLE_CPE_SEARCH);
            if (ps == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST));
            }
            String vendorSearch = vendor.replace("-", "_");
            if (StringUtils.countMatches((CharSequence)vendorSearch, (char)'.') > 1 && ("org".equals((parts = vendorSearch.split("\\."))[0]) || "com".equals(parts[0]))) {
                vendorSearch = parts[1];
            }
            String productSearch = product.replace("-", "_");
            ps.setString(1, vendorSearch);
            ps.setString(2, productSearch);
            ps.setString(3, vendorSearch + "_project");
            ps.setString(4, productSearch);
            ps.setString(5, vendorSearch);
            ps.setString(6, productSearch + majorVersion);
            ps.setString(7, vendorSearch + "_project");
            ps.setString(8, productSearch + majorVersion);
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        return data;
    }

    public synchronized Set<Pair<String, String>> getVendorProductList() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST);
            if (ps == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        return data;
    }

    public synchronized Set<Pair<String, String>> getVendorProductListForNode() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST_FOR_NODE);
            if (ps == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST_FOR_NODE));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties getProperties() {
        Properties prop = new Properties();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_PROPERTIES);
            if (ps == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_PROPERTIES));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                prop.setProperty(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
        }
        DBUtils.closeResultSet(rs);
        return prop;
    }

    public synchronized void saveProperty(String key, String value) {
        this.clearCache();
        try {
            PreparedStatement mergeProperty = this.getPreparedStatement(PreparedStatementCveDb.MERGE_PROPERTY);
            if (mergeProperty != null) {
                mergeProperty.setString(1, key);
                mergeProperty.setString(2, value);
                mergeProperty.execute();
            } else {
                PreparedStatement updateProperty = this.getPreparedStatement(PreparedStatementCveDb.UPDATE_PROPERTY);
                if (updateProperty == null) {
                    throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.UPDATE_PROPERTY));
                }
                updateProperty.setString(1, value);
                updateProperty.setString(2, key);
                if (updateProperty.executeUpdate() == 0) {
                    PreparedStatement insertProperty = this.getPreparedStatement(PreparedStatementCveDb.INSERT_PROPERTY);
                    if (insertProperty == null) {
                        throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_PROPERTY));
                    }
                    insertProperty.setString(1, key);
                    insertProperty.setString(2, value);
                    insertProperty.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            LOGGER.warn("Unable to save property '{}' with a value of '{}' to the database", (Object)key, (Object)value);
            LOGGER.debug("", (Throwable)ex);
        }
    }

    private synchronized void clearCache() {
        this.vulnerabilitiesForCpeCache.clear();
    }

    public synchronized List<Vulnerability> getVulnerabilities(Cpe cpe) throws DatabaseException {
        List<Vulnerability> cachedVulnerabilities = this.vulnerabilitiesForCpeCache.get(cpe.toCpe23FS());
        if (cachedVulnerabilities != null) {
            LOGGER.debug("Cache hit for {}", (Object)cpe.toCpe23FS());
            return cachedVulnerabilities;
        }
        LOGGER.debug("Cache miss for {}", (Object)cpe.toCpe23FS());
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        ResultSet rs = null;
        try {
            Vulnerability v;
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_CVE_FROM_SOFTWARE);
            ps.setString(1, cpe.getVendor());
            ps.setString(2, cpe.getProduct());
            rs = ps.executeQuery();
            String currentCVE = "";
            HashSet<VulnerableSoftware> vulnSoftware = new HashSet<VulnerableSoftware>();
            while (rs.next()) {
                VulnerableSoftware vs;
                String cveId = rs.getString(1);
                if (currentCVE.isEmpty()) {
                    currentCVE = cveId;
                }
                if (!vulnSoftware.isEmpty() && !currentCVE.equals(cveId)) {
                    Vulnerability v2;
                    VulnerableSoftware matchedCPE = this.getMatchingSoftware(cpe, vulnSoftware);
                    if (matchedCPE != null && (v2 = this.getVulnerability(currentCVE)) != null) {
                        v2.setMatchedVulnerableSoftware(matchedCPE);
                        v2.setSource(Vulnerability.Source.NVD);
                        vulnerabilities.add(v2);
                    }
                    vulnSoftware.clear();
                    currentCVE = cveId;
                }
                try {
                    vs = this.vulnerableSoftwareBuilder.part(rs.getString(2)).vendor(rs.getString(3)).product(rs.getString(4)).version(rs.getString(5)).update(rs.getString(6)).edition(rs.getString(7)).language(rs.getString(8)).swEdition(rs.getString(9)).targetSw(rs.getString(10)).targetHw(rs.getString(11)).other(rs.getString(12)).versionEndExcluding(rs.getString(13)).versionEndIncluding(rs.getString(14)).versionStartExcluding(rs.getString(15)).versionStartIncluding(rs.getString(16)).vulnerable(rs.getBoolean(17)).build();
                }
                catch (CpeParsingException | CpeValidationException ex) {
                    throw new DatabaseException("Database contains an invalid Vulnerable Software Entry", ex);
                }
                vulnSoftware.add(vs);
            }
            VulnerableSoftware matchedCPE = this.getMatchingSoftware(cpe, vulnSoftware);
            if (matchedCPE != null && (v = this.getVulnerability(currentCVE)) != null) {
                v.setMatchedVulnerableSoftware(matchedCPE);
                v.setSource(Vulnerability.Source.NVD);
                vulnerabilities.add(v);
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Exception retrieving vulnerability for " + cpe.toCpe23FS(), ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        this.vulnerabilitiesForCpeCache.put(cpe.toCpe23FS(), vulnerabilities);
        return vulnerabilities;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Vulnerability getVulnerability(String cve) throws DatabaseException {
        ResultSet rsV = null;
        ResultSet rsC = null;
        ResultSet rsR = null;
        ResultSet rsS = null;
        Vulnerability vuln = null;
        try {
            PreparedStatement psV = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VULNERABILITY);
            if (psV == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VULNERABILITY));
            }
            psV.setString(1, cve);
            rsV = psV.executeQuery();
            if (rsV.next()) {
                PreparedStatement psCWE;
                Serializable cvss;
                int cveId = rsV.getInt(1);
                vuln = new Vulnerability();
                vuln.setSource(Vulnerability.Source.NVD);
                vuln.setName(cve);
                vuln.setDescription(rsV.getString(2));
                if (rsV.getObject(11) != null) {
                    cvss = new CvssV2(rsV.getFloat(11), rsV.getString(12), rsV.getString(13), rsV.getString(14), rsV.getString(15), rsV.getString(16), rsV.getString(17), rsV.getString(3), this.getFloatValue(rsV, 4), this.getFloatValue(rsV, 5), this.getBooleanValue(rsV, 6), this.getBooleanValue(rsV, 7), this.getBooleanValue(rsV, 8), this.getBooleanValue(rsV, 9), this.getBooleanValue(rsV, 10), rsV.getString(18));
                    vuln.setCvssV2((CvssV2)cvss);
                }
                if (rsV.getObject(21) != null) {
                    cvss = new CvssV3(rsV.getString(21), rsV.getString(22), rsV.getString(23), rsV.getString(24), rsV.getString(25), rsV.getString(26), rsV.getString(27), rsV.getString(28), rsV.getFloat(29), rsV.getString(30), this.getFloatValue(rsV, 19), this.getFloatValue(rsV, 20), rsV.getString(31));
                    vuln.setCvssV3((CvssV3)cvss);
                }
                if ((psCWE = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VULNERABILITY_CWE)) == null) {
                    throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_VULNERABILITY_CWE));
                }
                psCWE.setInt(1, cveId);
                rsC = psCWE.executeQuery();
                while (rsC.next()) {
                    vuln.addCwe(rsC.getString(1));
                }
                PreparedStatement psR = this.getPreparedStatement(PreparedStatementCveDb.SELECT_REFERENCES);
                if (psR == null) {
                    throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_REFERENCES));
                }
                psR.setInt(1, cveId);
                rsR = psR.executeQuery();
                while (rsR.next()) {
                    vuln.addReference(rsR.getString(1), rsR.getString(2), rsR.getString(3));
                }
                PreparedStatement psS = this.getPreparedStatement(PreparedStatementCveDb.SELECT_SOFTWARE);
                if (psS == null) {
                    throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.SELECT_SOFTWARE));
                }
                psS.setInt(1, cveId);
                rsS = psS.executeQuery();
                while (rsS.next()) {
                    this.vulnerableSoftwareBuilder.part(rsS.getString(1)).vendor(rsS.getString(2)).product(rsS.getString(3)).version(rsS.getString(4)).update(rsS.getString(5)).edition(rsS.getString(6)).language(rsS.getString(7)).swEdition(rsS.getString(8)).targetSw(rsS.getString(9)).targetHw(rsS.getString(10)).other(rsS.getString(11)).versionEndExcluding(rsS.getString(12)).versionEndIncluding(rsS.getString(13)).versionStartExcluding(rsS.getString(14)).versionStartIncluding(rsS.getString(15)).vulnerable(rsS.getBoolean(16));
                    vuln.addVulnerableSoftware(this.vulnerableSoftwareBuilder.build());
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Error retrieving " + cve, ex);
                catch (CpeParsingException | CpeValidationException ex2) {
                    throw new DatabaseException("The database contains an invalid Vulnerable Software Entry", ex2);
                }
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rsV);
                DBUtils.closeResultSet(rsC);
                DBUtils.closeResultSet(rsR);
                DBUtils.closeResultSet(rsS);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rsV);
        DBUtils.closeResultSet(rsC);
        DBUtils.closeResultSet(rsR);
        DBUtils.closeResultSet(rsS);
        return vuln;
    }

    public void updateVulnerability(DefCveItem cve, String baseEcosystem) {
        this.clearCache();
        String cveId = cve.getCve().getCVEDataMeta().getId();
        try {
            String description = this.cveItemConverter.extractDescription(cve);
            if (this.cveItemConverter.isRejected(description)) {
                this.deleteVulnerability(cveId);
            } else if (this.cveItemConverter.testCveCpeStartWithFilter(cve)) {
                int vulnerabilityId = this.updateOrInsertVulnerability(cve, description);
                this.updateVulnerabilityInsertCwe(vulnerabilityId, cve);
                this.updateVulnerabilityInsertReferences(vulnerabilityId, cve);
                List<VulnerableSoftware> software = this.parseCpes(cve);
                this.updateVulnerabilityInsertSoftware(vulnerabilityId, cveId, software, baseEcosystem);
            }
        }
        catch (SQLException ex) {
            String msg = String.format("Error updating '%s'", cveId);
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg, ex);
        }
        catch (CpeValidationException ex) {
            String msg = String.format("Error parsing CPE entry from '%s'", cveId);
            LOGGER.debug(msg, (Throwable)ex);
            throw new DatabaseException(msg, ex);
        }
    }

    private void loadCpeEcosystemCache() {
        HashMap<Pair<String, String>, String> map = new HashMap<Pair<String, String>, String>();
        ResultSet rs = null;
        try (PreparedStatement ps = this.prepareStatement(PreparedStatementCveDb.SELECT_CPE_ECOSYSTEM);){
            rs = ps.executeQuery();
            while (rs.next()) {
                Pair<String, String> key = new Pair<String, String>(rs.getString(1), rs.getString(2));
                String value = rs.getString(3);
                map.put(key, value);
            }
        }
        catch (SQLException ex) {
            try {
                String msg = String.format("Error loading the Cpe Ecosystem Cache: %s", ex.getMessage());
                LOGGER.debug(msg, (Throwable)ex);
                throw new DatabaseException(msg, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        CpeEcosystemCache.setCache(map);
    }

    private void saveCpeEcosystemCache() {
        Map<Pair<String, String>, String> map = CpeEcosystemCache.getChanged();
        if (map != null && !map.isEmpty()) {
            try (PreparedStatement ps = this.prepareStatement(PreparedStatementCveDb.MERGE_CPE_ECOSYSTEM);){
                for (Map.Entry<Pair<String, String>, String> entry : map.entrySet()) {
                    ps.setString(1, entry.getKey().getLeft());
                    ps.setString(2, entry.getKey().getRight());
                    ps.setString(3, entry.getValue());
                    if (this.isBatchInsertEnabled()) {
                        ps.addBatch();
                        continue;
                    }
                    ps.execute();
                }
                if (this.isBatchInsertEnabled()) {
                    ps.executeBatch();
                }
            }
            catch (SQLException ex) {
                String msg = String.format("Error saving the Cpe Ecosystem Cache: %s", ex.getMessage());
                LOGGER.debug(msg, (Throwable)ex);
                throw new DatabaseException(msg, ex);
            }
        }
    }

    private synchronized int updateOrInsertVulnerability(DefCveItem cve, String description) {
        int vulnerabilityId;
        block37: {
            if (CpeEcosystemCache.isEmpty()) {
                this.loadCpeEcosystemCache();
            }
            try (PreparedStatement callUpdate = this.prepareStatement(PreparedStatementCveDb.UPDATE_VULNERABILITY);){
                Object msg;
                Map<String, Object> props;
                if (callUpdate == null) {
                    throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.UPDATE_VULNERABILITY));
                }
                callUpdate.setString(1, cve.getCve().getCVEDataMeta().getId());
                callUpdate.setString(2, description);
                if (cve.getImpact().getBaseMetricV2() != null) {
                    BaseMetricV2 cvssv2 = cve.getImpact().getBaseMetricV2();
                    props = cvssv2.getAdditionalProperties();
                    callUpdate.setString(3, cvssv2.getSeverity());
                    this.setFloatValue(callUpdate, 4, props, "exploitabilityScore");
                    this.setFloatValue(callUpdate, 5, props, "impactScore");
                    this.setBooleanValue(callUpdate, 6, props, "acInsufInfo");
                    this.setBooleanValue(callUpdate, 7, props, "obtainAllPrivilege");
                    this.setBooleanValue(callUpdate, 8, props, "obtainUserPrivilege");
                    this.setBooleanValue(callUpdate, 9, props, "obtainOtherPrivilege");
                    this.setBooleanValue(callUpdate, 10, props, "userInteractionRequired");
                    callUpdate.setFloat(11, cvssv2.getCvssV2().getBaseScore().floatValue());
                    callUpdate.setString(12, cvssv2.getCvssV2().getAccessVector().value());
                    callUpdate.setString(13, cvssv2.getCvssV2().getAccessComplexity().value());
                    callUpdate.setString(14, cvssv2.getCvssV2().getAuthentication().value());
                    callUpdate.setString(15, cvssv2.getCvssV2().getConfidentialityImpact().value());
                    callUpdate.setString(16, cvssv2.getCvssV2().getIntegrityImpact().value());
                    callUpdate.setString(17, cvssv2.getCvssV2().getAvailabilityImpact().value());
                    props = cvssv2.getCvssV2().getAdditionalProperties();
                    this.setStringValue(callUpdate, 18, props, "version");
                } else {
                    callUpdate.setNull(3, 0);
                    callUpdate.setNull(4, 0);
                    callUpdate.setNull(5, 0);
                    callUpdate.setNull(6, 0);
                    callUpdate.setNull(7, 0);
                    callUpdate.setNull(8, 0);
                    callUpdate.setNull(9, 0);
                    callUpdate.setNull(10, 0);
                    callUpdate.setNull(11, 0);
                    callUpdate.setNull(12, 0);
                    callUpdate.setNull(13, 0);
                    callUpdate.setNull(14, 0);
                    callUpdate.setNull(15, 0);
                    callUpdate.setNull(16, 0);
                    callUpdate.setNull(17, 0);
                    callUpdate.setNull(18, 0);
                }
                if (cve.getImpact().getBaseMetricV3() != null) {
                    BaseMetricV3 cvssv3 = cve.getImpact().getBaseMetricV3();
                    props = cvssv3.getAdditionalProperties();
                    this.setFloatValue(callUpdate, 19, props, "exploitabilityScore");
                    this.setFloatValue(callUpdate, 20, props, "impactScore");
                    callUpdate.setString(21, cvssv3.getCvssV3().getAttackVector().value());
                    callUpdate.setString(22, cvssv3.getCvssV3().getAttackComplexity().value());
                    callUpdate.setString(23, cvssv3.getCvssV3().getPrivilegesRequired().value());
                    callUpdate.setString(24, cvssv3.getCvssV3().getUserInteraction().value());
                    callUpdate.setString(25, cvssv3.getCvssV3().getScope().value());
                    callUpdate.setString(26, cvssv3.getCvssV3().getConfidentialityImpact().value());
                    callUpdate.setString(27, cvssv3.getCvssV3().getIntegrityImpact().value());
                    callUpdate.setString(28, cvssv3.getCvssV3().getAvailabilityImpact().value());
                    callUpdate.setFloat(29, cvssv3.getCvssV3().getBaseScore().floatValue());
                    callUpdate.setString(30, cvssv3.getCvssV3().getBaseSeverity().value());
                    props = cvssv3.getCvssV3().getAdditionalProperties();
                    this.setStringValue(callUpdate, 31, props, "version");
                } else {
                    callUpdate.setNull(19, 0);
                    callUpdate.setNull(20, 0);
                    callUpdate.setNull(21, 0);
                    callUpdate.setNull(22, 0);
                    callUpdate.setNull(23, 0);
                    callUpdate.setNull(24, 0);
                    callUpdate.setNull(25, 0);
                    callUpdate.setNull(26, 0);
                    callUpdate.setNull(27, 0);
                    callUpdate.setNull(28, 0);
                    callUpdate.setNull(29, 0);
                    callUpdate.setNull(30, 0);
                    callUpdate.setNull(31, 0);
                }
                if (this.isOracle) {
                    try {
                        CallableStatement cs = (CallableStatement)callUpdate;
                        cs.registerOutParameter(32, (SQLType)JDBCType.INTEGER);
                        cs.executeUpdate();
                        vulnerabilityId = cs.getInt(32);
                        break block37;
                    }
                    catch (SQLException ex) {
                        msg = String.format("Unable to retrieve id for new vulnerability for '%s'", cve.getCve().getCVEDataMeta().getId());
                        throw new DatabaseException((String)msg, ex);
                    }
                }
                try {
                    ResultSet rs = callUpdate.executeQuery();
                    msg = null;
                    try {
                        rs.next();
                        vulnerabilityId = rs.getInt(1);
                    }
                    catch (Throwable throwable) {
                        msg = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rs != null) {
                            if (msg != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)msg).addSuppressed(throwable);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (SQLException ex) {
                    msg = String.format("Unable to retrieve id for new vulnerability for '%s'", cve.getCve().getCVEDataMeta().getId());
                    throw new DatabaseException((String)msg, ex);
                }
            }
            catch (SQLException ex) {
                throw new UnexpectedAnalysisException(ex);
            }
        }
        return vulnerabilityId;
    }

    private synchronized void updateVulnerabilityInsertCwe(int vulnerabilityId, DefCveItem cve) throws SQLException {
        try (PreparedStatement insertCWE = this.prepareStatement(PreparedStatementCveDb.INSERT_CWE);){
            if (insertCWE == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_CWE));
            }
            insertCWE.setInt(1, vulnerabilityId);
            for (ProblemtypeDatum datum : cve.getCve().getProblemtype().getProblemtypeData()) {
                for (LangString desc : datum.getDescription()) {
                    if (!"en".equals(desc.getLang())) continue;
                    insertCWE.setString(2, desc.getValue());
                    if (this.isBatchInsertEnabled()) {
                        insertCWE.addBatch();
                        continue;
                    }
                    insertCWE.execute();
                }
            }
            if (this.isBatchInsertEnabled()) {
                insertCWE.executeBatch();
            }
        }
    }

    private synchronized void deleteVulnerability(String cve) throws SQLException {
        try (PreparedStatement deleteVulnerability = this.prepareStatement(PreparedStatementCveDb.DELETE_VULNERABILITY);){
            deleteVulnerability.setString(1, cve);
            deleteVulnerability.executeUpdate();
        }
    }

    private synchronized void updateVulnerabilityInsertSoftware(int vulnerabilityId, String cveId, List<VulnerableSoftware> software, String baseEcosystem) throws DatabaseException, SQLException {
        try (PreparedStatement insertSoftware = this.prepareStatement(PreparedStatementCveDb.INSERT_SOFTWARE);){
            if (insertSoftware == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_SOFTWARE));
            }
            for (VulnerableSoftware parsedCpe : software) {
                insertSoftware.setInt(1, vulnerabilityId);
                insertSoftware.setString(2, parsedCpe.getPart().getAbbreviation());
                insertSoftware.setString(3, parsedCpe.getVendor());
                insertSoftware.setString(4, parsedCpe.getProduct());
                insertSoftware.setString(5, parsedCpe.getVersion());
                insertSoftware.setString(6, parsedCpe.getUpdate());
                insertSoftware.setString(7, parsedCpe.getEdition());
                insertSoftware.setString(8, parsedCpe.getLanguage());
                insertSoftware.setString(9, parsedCpe.getSwEdition());
                insertSoftware.setString(10, parsedCpe.getTargetSw());
                insertSoftware.setString(11, parsedCpe.getTargetHw());
                insertSoftware.setString(12, parsedCpe.getOther());
                String ecosystem = CpeEcosystemCache.getEcosystem(parsedCpe.getVendor(), parsedCpe.getProduct(), this.cveItemConverter.extractEcosystem(baseEcosystem, parsedCpe));
                this.addNullableStringParameter(insertSoftware, 13, ecosystem);
                this.addNullableStringParameter(insertSoftware, 14, parsedCpe.getVersionEndExcluding());
                this.addNullableStringParameter(insertSoftware, 15, parsedCpe.getVersionEndIncluding());
                this.addNullableStringParameter(insertSoftware, 16, parsedCpe.getVersionStartExcluding());
                this.addNullableStringParameter(insertSoftware, 17, parsedCpe.getVersionStartIncluding());
                insertSoftware.setBoolean(18, parsedCpe.isVulnerable());
                if (this.isBatchInsertEnabled()) {
                    insertSoftware.addBatch();
                    continue;
                }
                try {
                    insertSoftware.execute();
                }
                catch (SQLException ex) {
                    if (ex.getMessage().contains("Duplicate entry")) {
                        String msg = String.format("Duplicate software key identified in '%s'", cveId);
                        LOGGER.info(msg, (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
            if (this.isBatchInsertEnabled()) {
                this.executeBatch(cveId, insertSoftware);
            }
        }
    }

    private synchronized void updateVulnerabilityInsertReferences(int vulnerabilityId, DefCveItem cve) throws SQLException {
        try (PreparedStatement insertReference = this.prepareStatement(PreparedStatementCveDb.INSERT_REFERENCE);){
            if (insertReference == null) {
                throw new SQLException("Database query does not exist in the resource bundle: " + (Object)((Object)PreparedStatementCveDb.INSERT_REFERENCE));
            }
            for (Reference r : cve.getCve().getReferences().getReferenceData()) {
                insertReference.setInt(1, vulnerabilityId);
                insertReference.setString(2, r.getName());
                insertReference.setString(3, r.getUrl());
                insertReference.setString(4, r.getRefsource());
                if (this.isBatchInsertEnabled()) {
                    insertReference.addBatch();
                    continue;
                }
                insertReference.execute();
            }
            if (this.isBatchInsertEnabled()) {
                insertReference.executeBatch();
            }
        }
    }

    private List<VulnerableSoftware> parseCpes(DefCveItem cve) throws CpeValidationException {
        ArrayList<VulnerableSoftware> software = new ArrayList<VulnerableSoftware>();
        List<DefCpeMatch> cpeEntries = cve.getConfigurations().getNodes().stream().collect(NodeFlatteningCollector.getInstance()).collect(CpeMatchStreamCollector.getInstance()).filter(predicate -> predicate.getCpe23Uri().startsWith(this.cpeStartsWithFilter)).filter(entry -> !"CVE-2009-0754".equals(cve.getCve().getCVEDataMeta().getId()) || !"cpe:2.3:a:apache:apache:*:*:*:*:*:*:*:*".equals(entry.getCpe23Uri())).collect(Collectors.toList());
        VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder();
        try {
            cpeEntries.forEach(entry -> {
                builder.cpe(this.parseCpe((DefCpeMatch)entry, cve.getCve().getCVEDataMeta().getId())).versionEndExcluding(entry.getVersionEndExcluding()).versionStartExcluding(entry.getVersionStartExcluding()).versionEndIncluding(entry.getVersionEndIncluding()).versionStartIncluding(entry.getVersionStartIncluding()).vulnerable(entry.getVulnerable());
                try {
                    software.add(builder.build());
                }
                catch (CpeValidationException ex) {
                    throw new LambdaExceptionWrapper((Exception)((Object)ex));
                }
            });
        }
        catch (LambdaExceptionWrapper ex) {
            throw (CpeValidationException)ex.getCause();
        }
        return software;
    }

    private Cpe parseCpe(DefCpeMatch cpe, String cveId) throws DatabaseException {
        Cpe parsedCpe;
        try {
            parsedCpe = CpeParser.parse((String)cpe.getCpe23Uri(), (boolean)true);
        }
        catch (CpeParsingException ex) {
            LOGGER.debug("NVD (" + cveId + ") contain an invalid 2.3 CPE: " + cpe.getCpe23Uri());
            if (cpe.getCpe22Uri() != null && !cpe.getCpe22Uri().isEmpty()) {
                try {
                    parsedCpe = CpeParser.parse((String)cpe.getCpe22Uri(), (boolean)true);
                }
                catch (CpeParsingException ex2) {
                    throw new DatabaseException("Unable to parse CPE: " + cpe.getCpe23Uri(), ex);
                }
            }
            throw new DatabaseException("Unable to parse CPE: " + cpe.getCpe23Uri(), ex);
        }
        return parsedCpe;
    }

    private int getBatchSize() {
        int max;
        try {
            max = this.settings.getInt("database.batchinsert.maxsize");
        }
        catch (InvalidSettingException pE) {
            max = 1000;
        }
        return max;
    }

    private boolean isBatchInsertEnabled() {
        boolean batch;
        try {
            batch = this.settings.getBoolean("database.batchinsert.enabled");
        }
        catch (InvalidSettingException pE) {
            batch = false;
        }
        return batch;
    }

    private void executeBatch(String vulnId, PreparedStatement statement) throws SQLException {
        try {
            statement.executeBatch();
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("Duplicate entry")) {
                String msg = String.format("Duplicate software key identified in '%s'", vulnId);
                LOGGER.info(msg, (Throwable)ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean dataExists() {
        ResultSet rs;
        block8: {
            boolean bl;
            PreparedStatement cs;
            block7: {
                rs = null;
                cs = this.getPreparedStatement(PreparedStatementCveDb.COUNT_CPE);
                if (cs != null) break block7;
                LOGGER.error("Unable to validate if data exists in the database");
                boolean bl2 = false;
                DBUtils.closeResultSet(rs);
                return bl2;
            }
            try {
                rs = cs.executeQuery();
                if (!rs.next() || rs.getInt(1) <= 0) break block8;
                bl = true;
            }
            catch (Exception ex) {
                try {
                    String dd;
                    try {
                        dd = this.settings.getDataDirectory().getAbsolutePath();
                    }
                    catch (IOException ex1) {
                        dd = this.settings.getString("data.directory");
                    }
                    LOGGER.error("Unable to access the local database.\n\nEnsure that '{}' is a writable directory. If the problem persist try deleting the files in '{}' and running {} again. If the problem continues, please create a log file (see documentation at http://jeremylong.github.io/DependencyCheck/) and open a ticket at https://github.com/jeremylong/DependencyCheck/issues and include the log file.\n\n", new Object[]{dd, dd, this.settings.getString("odc.application.name")});
                    LOGGER.debug("", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    throw throwable;
                }
                DBUtils.closeResultSet(rs);
            }
            DBUtils.closeResultSet(rs);
            return bl;
        }
        DBUtils.closeResultSet(rs);
        return false;
    }

    public synchronized void cleanupDatabase() {
        LOGGER.info("Begin database maintenance");
        long start = System.currentTimeMillis();
        this.saveCpeEcosystemCache();
        this.clearCache();
        try (PreparedStatement psOrphans = this.getPreparedStatement(PreparedStatementCveDb.CLEANUP_ORPHANS);
             PreparedStatement psEcosystem = this.getPreparedStatement(PreparedStatementCveDb.UPDATE_ECOSYSTEM);
             PreparedStatement psEcosystem2 = this.getPreparedStatement(PreparedStatementCveDb.UPDATE_ECOSYSTEM2);){
            int count;
            if (psEcosystem != null && (count = psEcosystem.executeUpdate()) > 0) {
                LOGGER.info("Updated the CPE ecosystem on {} NVD records", (Object)count);
            }
            if (psEcosystem2 != null && (count = psEcosystem2.executeUpdate()) > 0) {
                LOGGER.info("Removed the CPE ecosystem on {} NVD records", (Object)count);
            }
            if (psOrphans != null && (count = psOrphans.executeUpdate()) > 0) {
                LOGGER.info("Cleaned up {} orphaned NVD records", (Object)count);
            }
            long millis = System.currentTimeMillis() - start;
            LOGGER.info("End database maintenance ({} ms)", (Object)millis);
        }
        catch (SQLException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", (Throwable)ex);
            throw new DatabaseException("Unexpected SQL Exception", ex);
        }
    }

    public synchronized void defrag() {
        if (ConnectionFactory.isH2Connection(this.settings)) {
            long start = System.currentTimeMillis();
            try (CallableStatement psCompaxt = this.connection.prepareCall("SHUTDOWN DEFRAG");){
                if (psCompaxt != null) {
                    LOGGER.info("Begin database defrag");
                    psCompaxt.execute();
                    long millis = System.currentTimeMillis() - start;
                    LOGGER.info("End database defrag ({} ms)", (Object)millis);
                }
            }
            catch (SQLException ex) {
                LOGGER.error("An unexpected SQL Exception occurred compacting the database; please see the verbose log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
        }
    }

    protected VulnerableSoftware getMatchingSoftware(Cpe cpe, Set<VulnerableSoftware> vulnerableSoftware) {
        VulnerableSoftware matched = null;
        for (VulnerableSoftware vs : vulnerableSoftware) {
            if (!vs.matches((ICpe)cpe)) continue;
            if (matched == null) {
                matched = vs;
                continue;
            }
            if (!"*".equals(vs.getWellFormedUpdate()) || "*".equals(matched.getWellFormedUpdate())) continue;
            matched = vs;
        }
        return matched;
    }

    public synchronized void deleteUnusedCpe() {
        this.clearCache();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(this.statementBundle.getString("DELETE_UNUSED_DICT_CPE"));
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("Unable to delete CPE dictionary entries", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(ps);
                throw throwable;
            }
            DBUtils.closeStatement(ps);
        }
        DBUtils.closeStatement(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addCpe(String cpe, String vendor, String product) {
        this.clearCache();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(this.statementBundle.getString("ADD_DICT_CPE"));
            ps.setString(1, cpe);
            ps.setString(2, vendor);
            ps.setString(3, product);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("Unable to add CPE dictionary entry", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(ps);
                throw throwable;
            }
            DBUtils.closeStatement(ps);
        }
        DBUtils.closeStatement(ps);
    }

    private void addNullableStringParameter(PreparedStatement ps, int pos, String value) throws SQLException {
        if (value == null || value.isEmpty()) {
            ps.setNull(pos, 12);
        } else {
            ps.setString(pos, value);
        }
    }

    private void setFloatValue(PreparedStatement ps, int i, Map<String, Object> props, String key) throws SQLException {
        if (props != null && props.containsKey(key)) {
            try {
                ps.setFloat(i, Float.parseFloat(props.get(key).toString()));
            }
            catch (NumberFormatException nfe) {
                ps.setNull(i, 0);
            }
        } else {
            ps.setNull(i, 0);
        }
    }

    private void setStringValue(PreparedStatement ps, int i, Map<String, Object> props, String key) throws SQLException {
        if (props != null && props.containsKey(key)) {
            ps.setString(i, props.get(key).toString());
        } else {
            ps.setNull(i, 0);
        }
    }

    private void setBooleanValue(PreparedStatement ps, int i, Map<String, Object> props, String key) throws SQLException {
        if (props != null && props.containsKey(key)) {
            ps.setBoolean(i, Boolean.valueOf(props.get(key).toString()));
        } else {
            ps.setNull(i, 0);
        }
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    private Boolean getBooleanValue(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) == null) {
            return null;
        }
        return rs.getBoolean(index);
    }

    private Float getFloatValue(ResultSet rs, int index) throws SQLException {
        if (rs.getObject(index) == null) {
            return null;
        }
        return Float.valueOf(rs.getFloat(index));
    }

    static enum PreparedStatementCveDb {
        CLEANUP_ORPHANS,
        UPDATE_ECOSYSTEM,
        UPDATE_ECOSYSTEM2,
        COUNT_CPE,
        DELETE_VULNERABILITY,
        INSERT_PROPERTY,
        INSERT_CWE,
        INSERT_REFERENCE,
        INSERT_SOFTWARE,
        MERGE_PROPERTY,
        SELECT_CPE_ENTRIES,
        SELECT_CVE_FROM_SOFTWARE,
        SELECT_PROPERTIES,
        SELECT_VULNERABILITY_CWE,
        SELECT_REFERENCES,
        SELECT_SOFTWARE,
        SELECT_VENDOR_PRODUCT_LIST,
        SELECT_SIMPLE_CPE_SEARCH,
        SELECT_VENDOR_PRODUCT_LIST_FOR_NODE,
        SELECT_VULNERABILITY,
        UPDATE_PROPERTY,
        UPDATE_VULNERABILITY,
        SELECT_CPE_ECOSYSTEM,
        MERGE_CPE_ECOSYSTEM;

    }
}

