/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.CpeBuilder;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

@ThreadSafe
public class FalsePositiveAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FalsePositiveAnalyzer.class);
    private static final FileFilter DLL_EXE_FILTER = FileFilterBuilder.newInstance().addExtensions("dll", "exe").build();
    public static final Pattern CORE_JAVA = Pattern.compile("^cpe:/a:(sun|oracle|ibm):(j2[ems]e|java(_platform_micro_edition|_runtime_environment|_se|virtual_machine|se_development_kit|fx)?|jdk|jre|jsse)($|:.*)");
    public static final Pattern CORE_JAVA_JSF = Pattern.compile("^cpe:/a:(sun|oracle|ibm):jsf($|:.*)");
    public static final Pattern CORE_FILES = Pattern.compile("(^|/)((alt[-])?rt|jsse|jfxrt|jfr|jce|javaws|deploy|charsets)\\.jar$");
    public static final Pattern CORE_JSF_FILES = Pattern.compile("(^|/)jsf[-][^/]*\\.jar$");
    private static final String ANALYZER_NAME = "False Positive Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_IDENTIFIER_ANALYSIS;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.falsepositive.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        this.removeJreEntries(dependency);
        this.removeBadMatches(dependency);
        this.removeBadSpringMatches(dependency);
        this.removeWrongVersionMatches(dependency);
        this.removeSpuriousCPE(dependency);
        this.removeDuplicativeEntriesFromJar(dependency, engine);
        this.addFalseNegativeCPEs(dependency);
    }

    private void removeBadSpringMatches(Dependency dependency) {
        String mustContain = null;
        for (Identifier i2 : dependency.getSoftwareIdentifiers()) {
            int endPoint;
            if (i2.getValue() == null || !i2.getValue().startsWith("org.springframework.") || (endPoint = i2.getValue().indexOf(58, 19)) < 0) continue;
            mustContain = i2.getValue().substring(19, endPoint).toLowerCase();
            break;
        }
        if (mustContain != null) {
            HashSet<Identifier> removalSet = new HashSet<Identifier>();
            for (Identifier i3 : dependency.getVulnerableSoftwareIdentifiers()) {
                if (i3.getValue() == null || !i3.getValue().startsWith("cpe:/a:springsource:") || i3.getValue().toLowerCase().contains(mustContain)) continue;
                removalSet.add(i3);
            }
            removalSet.forEach(i -> dependency.removeVulnerableSoftwareIdentifier((Identifier)i));
        }
    }

    @SuppressFBWarnings(justification="null checks are working correctly to prevent NPE", value={"NP_NULL_ON_SOME_PATH_MIGHT_BE_INFEASIBLE"})
    private void removeSpuriousCPE(Dependency dependency) {
        ArrayList<Identifier> ids = new ArrayList<Identifier>(dependency.getVulnerableSoftwareIdentifiers());
        Collections.sort(ids);
        ListIterator mainItr = ids.listIterator();
        while (mainItr.hasNext()) {
            Identifier temp = (Identifier)mainItr.next();
            if (!(temp instanceof CpeIdentifier)) continue;
            CpeIdentifier currentId = (CpeIdentifier)temp;
            Cpe currentCpe = currentId.getCpe();
            ListIterator subItr = ids.listIterator(mainItr.nextIndex());
            while (subItr.hasNext()) {
                Identifier nextId = (Identifier)subItr.next();
                if (!(nextId instanceof CpeIdentifier)) continue;
                CpeIdentifier nextCpeId = (CpeIdentifier)nextId;
                Cpe nextCpe = nextCpeId.getCpe();
                if (!currentCpe.getVendor().equals(nextCpe.getVendor()) || !currentCpe.getProduct().equals(nextCpe.getProduct())) continue;
                String currentVersion = currentCpe.getVersion();
                String nextVersion = nextCpe.getVersion();
                if (currentVersion == null && nextVersion == null) {
                    LOGGER.debug("currentVersion and nextVersion are both null?");
                    continue;
                }
                if (currentVersion == null && nextVersion != null) {
                    dependency.removeVulnerableSoftwareIdentifier(currentId);
                    continue;
                }
                if (nextVersion == null && currentVersion != null) {
                    dependency.removeVulnerableSoftwareIdentifier(nextId);
                    continue;
                }
                if (currentVersion.length() < nextVersion.length()) {
                    if (!nextVersion.startsWith(currentVersion) && !"-".equals(currentVersion)) continue;
                    dependency.removeVulnerableSoftwareIdentifier(currentId);
                    continue;
                }
                if (!currentVersion.startsWith(nextVersion) && !"-".equals(nextVersion)) continue;
                dependency.removeVulnerableSoftwareIdentifier(nextId);
            }
        }
    }

    private void removeJreEntries(Dependency dependency) {
        HashSet removalSet = new HashSet();
        dependency.getVulnerableSoftwareIdentifiers().forEach(i -> {
            Matcher coreCPE = CORE_JAVA.matcher(i.getValue());
            Matcher coreFiles = CORE_FILES.matcher(dependency.getFileName());
            Matcher coreJsfCPE = CORE_JAVA_JSF.matcher(i.getValue());
            Matcher coreJsfFiles = CORE_JSF_FILES.matcher(dependency.getFileName());
            if (coreCPE.matches() && !coreFiles.matches() || coreJsfCPE.matches() && !coreJsfFiles.matches()) {
                removalSet.add(i);
            }
        });
        removalSet.forEach(i -> dependency.removeVulnerableSoftwareIdentifier((Identifier)i));
    }

    protected void removeBadMatches(Dependency dependency) {
        for (Identifier i : dependency.getVulnerableSoftwareIdentifiers()) {
            boolean found;
            if (!(i instanceof CpeIdentifier)) continue;
            CpeIdentifier cpeId = (CpeIdentifier)i;
            Cpe cpe = cpeId.getCpe();
            if ((cpe.getProduct().matches(".*c\\+\\+.*") || "file".equals(cpe.getVendor()) && "file".equals(cpe.getProduct()) || "mozilla".equals(cpe.getVendor()) && "mozilla".equals(cpe.getProduct()) || "cvs".equals(cpe.getVendor()) && "cvs".equals(cpe.getProduct()) || "ftp".equals(cpe.getVendor()) && "ftp".equals(cpe.getProduct()) || "tcp".equals(cpe.getVendor()) && "tcp".equals(cpe.getProduct()) || "ssh".equals(cpe.getVendor()) && "ssh".equals(cpe.getProduct()) || "lookup".equals(cpe.getVendor()) && "lookup".equals(cpe.getProduct())) && (dependency.getFileName().toLowerCase().endsWith(".jar") || dependency.getFileName().toLowerCase().endsWith("pom.xml") || dependency.getFileName().toLowerCase().endsWith(".dll") || dependency.getFileName().toLowerCase().endsWith(".exe") || dependency.getFileName().toLowerCase().endsWith(".nuspec") || dependency.getFileName().toLowerCase().endsWith(".zip") || dependency.getFileName().toLowerCase().endsWith(".sar") || dependency.getFileName().toLowerCase().endsWith(".apk") || dependency.getFileName().toLowerCase().endsWith(".tar") || dependency.getFileName().toLowerCase().endsWith(".gz") || dependency.getFileName().toLowerCase().endsWith(".tgz") || dependency.getFileName().toLowerCase().endsWith(".ear") || dependency.getFileName().toLowerCase().endsWith(".war"))) {
                dependency.removeVulnerableSoftwareIdentifier(i);
                continue;
            }
            if (("jquery".equals(cpe.getVendor()) && "jquery".equals(cpe.getProduct()) || "prototypejs".equals(cpe.getVendor()) && "prototype".equals(cpe.getProduct()) || "yahoo".equals(cpe.getVendor()) && "yui".equals(cpe.getProduct())) && (dependency.getFileName().toLowerCase().endsWith(".jar") || dependency.getFileName().toLowerCase().endsWith("pom.xml") || dependency.getFileName().toLowerCase().endsWith(".dll") || dependency.getFileName().toLowerCase().endsWith(".exe"))) {
                dependency.removeVulnerableSoftwareIdentifier(i);
                continue;
            }
            if (("microsoft".equals(cpe.getVendor()) && "excel".equals(cpe.getProduct()) || "microsoft".equals(cpe.getVendor()) && "word".equals(cpe.getProduct()) || "microsoft".equals(cpe.getVendor()) && "visio".equals(cpe.getProduct()) || "microsoft".equals(cpe.getVendor()) && "powerpoint".equals(cpe.getProduct()) || "microsoft".equals(cpe.getVendor()) && "office".equals(cpe.getProduct()) || "core_ftp".equals(cpe.getVendor()) && "core_ftp".equals(cpe.getProduct())) && (dependency.getFileName().toLowerCase().endsWith(".jar") || dependency.getFileName().toLowerCase().endsWith(".ear") || dependency.getFileName().toLowerCase().endsWith(".war") || dependency.getFileName().toLowerCase().endsWith("pom.xml"))) {
                dependency.removeVulnerableSoftwareIdentifier(i);
                continue;
            }
            if ("apache".equals(cpe.getVendor()) && "maven".equals(cpe.getProduct()) && !dependency.getFileName().toLowerCase().matches("maven-core-[\\d.]+\\.jar")) {
                dependency.removeVulnerableSoftwareIdentifier(i);
                continue;
            }
            if ("m-core".equals(cpe.getVendor()) && "m-core".equals(cpe.getProduct())) {
                found = false;
                for (Evidence e : dependency.getEvidence(EvidenceType.PRODUCT)) {
                    if (!"m-core".equalsIgnoreCase(e.getValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (Evidence e : dependency.getEvidence(EvidenceType.VENDOR)) {
                        if (!"m-core".equalsIgnoreCase(e.getValue())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                dependency.removeVulnerableSoftwareIdentifier(i);
                continue;
            }
            if ("jboss".equals(cpe.getVendor()) && "jboss".equals(cpe.getProduct()) && !dependency.getFileName().toLowerCase().matches("jboss-?[\\d.-]+(GA)?\\.jar")) {
                dependency.removeVulnerableSoftwareIdentifier(i);
                continue;
            }
            if (!"java-websocket_project".equals(cpe.getVendor()) || !"java-websocket".equals(cpe.getProduct())) continue;
            found = false;
            for (Identifier si : dependency.getSoftwareIdentifiers()) {
                if (!si.getValue().toLowerCase().contains("org.java-websocket/java-websocket")) continue;
                found = true;
                break;
            }
            if (found) continue;
            dependency.removeVulnerableSoftwareIdentifier(i);
        }
    }

    private void removeWrongVersionMatches(Dependency dependency) {
        HashSet identifiersToRemove = new HashSet();
        String fileName = dependency.getFileName();
        if (fileName != null && fileName.contains("axis2")) {
            dependency.getVulnerableSoftwareIdentifiers().stream().filter(i -> i instanceof CpeIdentifier).map(i -> (CpeIdentifier)i).forEach(i -> {
                Cpe cpe = i.getCpe();
                if ("apache".equals(cpe.getVendor()) && "axis".equals(cpe.getProduct())) {
                    identifiersToRemove.add(i);
                }
            });
        } else if (fileName != null && fileName.contains("axis")) {
            dependency.getVulnerableSoftwareIdentifiers().stream().filter(i -> i instanceof CpeIdentifier).map(i -> (CpeIdentifier)i).forEach(i -> {
                Cpe cpe = i.getCpe();
                if ("apache".equals(cpe.getVendor()) && "axis2".equals(cpe.getProduct())) {
                    identifiersToRemove.add(i);
                }
            });
        }
        identifiersToRemove.forEach(i -> dependency.removeVulnerableSoftwareIdentifier((Identifier)i));
    }

    private void addFalseNegativeCPEs(Dependency dependency) {
        CpeBuilder builder = new CpeBuilder();
        dependency.getVulnerableSoftwareIdentifiers().stream().filter(i -> i instanceof CpeIdentifier).map(i -> (CpeIdentifier)i).forEach(i -> {
            Cpe newCpe1;
            Cpe cpe = i.getCpe();
            if ("oracle".equals(cpe.getVendor()) && ("opensso".equals(cpe.getProduct()) || "opensso_enterprise".equals(cpe.getProduct())) || "sun".equals(cpe.getVendor()) && ("opensso".equals(cpe.getProduct()) || "opensso_enterprise".equals(cpe.getProduct()))) {
                try {
                    newCpe1 = builder.part(Part.APPLICATION).vendor("sun").product("opensso_enterprise").version(cpe.getVersion()).build();
                    Cpe newCpe2 = builder.part(Part.APPLICATION).vendor("oracle").product("opensso_enterprise").version(cpe.getVersion()).build();
                    Cpe newCpe3 = builder.part(Part.APPLICATION).vendor("sun").product("opensso").version(cpe.getVersion()).build();
                    Cpe newCpe4 = builder.part(Part.APPLICATION).vendor("oracle").product("opensso").version(cpe.getVersion()).build();
                    CpeIdentifier newCpeId1 = new CpeIdentifier(newCpe1, i.getConfidence());
                    CpeIdentifier newCpeId2 = new CpeIdentifier(newCpe2, i.getConfidence());
                    CpeIdentifier newCpeId3 = new CpeIdentifier(newCpe3, i.getConfidence());
                    CpeIdentifier newCpeId4 = new CpeIdentifier(newCpe4, i.getConfidence());
                    dependency.addVulnerableSoftwareIdentifier(newCpeId1);
                    dependency.addVulnerableSoftwareIdentifier(newCpeId2);
                    dependency.addVulnerableSoftwareIdentifier(newCpeId3);
                    dependency.addVulnerableSoftwareIdentifier(newCpeId4);
                }
                catch (CpeValidationException ex) {
                    LOGGER.warn("Unable to add oracle and sun CPEs", (Throwable)ex);
                }
            }
            if ("apache".equals(cpe.getVendor()) && "santuario_xml_security_for_java".equals(cpe.getProduct())) {
                try {
                    newCpe1 = builder.part(Part.APPLICATION).vendor("apache").product("xml_security_for_java").version(cpe.getVersion()).build();
                    CpeIdentifier newCpeId1 = new CpeIdentifier(newCpe1, i.getConfidence());
                    dependency.addVulnerableSoftwareIdentifier(newCpeId1);
                }
                catch (CpeValidationException ex) {
                    LOGGER.warn("Unable to add apache xml_security_for_java CPE", (Throwable)ex);
                }
            }
        });
    }

    private synchronized void removeDuplicativeEntriesFromJar(Dependency dependency, Engine engine) {
    }

    private Dependency findDependency(String dependencyPath, Dependency[] dependencies) {
        for (Dependency d : dependencies) {
            if (!d.getFilePath().equalsIgnoreCase(dependencyPath)) continue;
            return d;
        }
        return null;
    }
}

