/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.RubyBundlerAnalyzer;
import org.owasp.dependencycheck.analyzer.RubyGemspecAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.processing.BundlerAuditProcessor;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.processing.ProcessReader;
import org.owasp.dependencycheck.utils.processing.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public class RubyBundleAuditAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RubyBundleAuditAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "ruby";
    private static final String ANALYZER_NAME = "Ruby Bundle Audit Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_INFORMATION_COLLECTION;
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFilenames("Gemfile.lock").build();
    public static final String NAME = "Name: ";
    public static final String VERSION = "Version: ";
    public static final String ADVISORY = "Advisory: ";
    public static final String CRITICALITY = "Criticality: ";
    private CveDB cvedb = null;
    private boolean needToDisableGemspecAnalyzer = true;

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.bundle.audit.enabled";
    }

    private Process launchBundleAudit(File folder, List<String> bundleAuditArgs) throws AnalysisException {
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        String bundleAuditPath = this.getSettings().getString("analyzer.bundle.audit.path");
        File bundleAudit = null;
        if (bundleAuditPath != null && !(bundleAudit = new File(bundleAuditPath)).isFile()) {
            LOGGER.warn("Supplied `bundleAudit` path is incorrect: {}", (Object)bundleAuditPath);
            bundleAudit = null;
        }
        args.add(bundleAudit != null ? bundleAudit.getAbsolutePath() : "bundle-audit");
        args.addAll(bundleAuditArgs);
        ProcessBuilder builder = new ProcessBuilder(args);
        String bundleAuditWorkingDirectoryPath = this.getSettings().getString("analyzer.bundle.audit.working.directory");
        File bundleAuditWorkingDirectory = null;
        if (bundleAuditWorkingDirectoryPath != null && !(bundleAuditWorkingDirectory = new File(bundleAuditWorkingDirectoryPath)).isDirectory()) {
            LOGGER.warn("Supplied `bundleAuditWorkingDirectory` path is incorrect: {}", (Object)bundleAuditWorkingDirectoryPath);
            bundleAuditWorkingDirectory = null;
        }
        File launchBundleAuditFromDirectory = bundleAuditWorkingDirectory != null ? bundleAuditWorkingDirectory : folder;
        builder.directory(launchBundleAuditFromDirectory);
        try {
            LOGGER.info("Launching: {} from {}", args, (Object)launchBundleAuditFromDirectory);
            return builder.start();
        }
        catch (IOException ioe) {
            throw new AnalysisException("bundle-audit initialization failure; this error can be ignored if you are not analyzing Ruby. Otherwise ensure that bundle-audit is installed and the path to bundle audit is correctly specified", ioe);
        }
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        if (engine != null) {
            this.cvedb = engine.getDatabase();
        }
        String bundleAuditVersionDetails = null;
        try {
            ImmutableList bundleAuditArgs = ImmutableList.of((Object)"version");
            Process process = this.launchBundleAudit(this.getSettings().getTempDirectory(), (List<String>)bundleAuditArgs);
            try (ProcessReader processReader = new ProcessReader(process);){
                processReader.readAll();
                String error = processReader.getError();
                if (error != null) {
                    LOGGER.warn("Warnings from bundle-audit {}", (Object)error);
                }
                bundleAuditVersionDetails = processReader.getOutput();
                int exitValue = process.exitValue();
                if (exitValue != 0) {
                    this.setEnabled(false);
                    String msg = String.format("bundle-audit execution failed - exit code: %d; error: %s ", exitValue, error);
                    throw new InitializationException(msg);
                }
            }
        }
        catch (AnalysisException ae) {
            this.setEnabled(false);
            String msg = String.format("Exception from bundle-audit process: %s. Disabling %s", ae.getCause(), ANALYZER_NAME);
            throw new InitializationException(msg, ae);
        }
        catch (UnsupportedEncodingException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unexpected bundle-audit encoding when reading input stream.", ex);
        }
        catch (IOException ex) {
            this.setEnabled(false);
            throw new InitializationException("Unable to read bundle-audit output.", ex);
        }
        catch (InterruptedException ex) {
            this.setEnabled(false);
            String msg = String.format("Bundle-audit process was interrupted. Disabling %s", ANALYZER_NAME);
            Thread.currentThread().interrupt();
            throw new InitializationException(msg);
        }
        LOGGER.info("{} is enabled and is using bundle-audit with version details: {}. Note: It is necessary to manually run \"bundle-audit update\" occasionally to keep its database up to date.", (Object)ANALYZER_NAME, (Object)bundleAuditVersionDetails);
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.needToDisableGemspecAnalyzer) {
            boolean failed = true;
            String className = RubyGemspecAnalyzer.class.getName();
            for (FileTypeAnalyzer analyzer : engine.getFileTypeAnalyzers()) {
                if (analyzer instanceof RubyBundlerAnalyzer) {
                    ((RubyBundlerAnalyzer)analyzer).setEnabled(false);
                    LOGGER.info("Disabled {} to avoid noisy duplicate results.", (Object)RubyBundlerAnalyzer.class.getName());
                    continue;
                }
                if (!(analyzer instanceof RubyGemspecAnalyzer)) continue;
                ((RubyGemspecAnalyzer)analyzer).setEnabled(false);
                LOGGER.info("Disabled {} to avoid noisy duplicate results.", (Object)className);
                failed = false;
            }
            if (failed) {
                LOGGER.warn("Did not find {}.", (Object)className);
            }
            this.needToDisableGemspecAnalyzer = false;
        }
        File parentFile = dependency.getActualFile().getParentFile();
        ImmutableList bundleAuditArgs = ImmutableList.of((Object)"check", (Object)"--verbose");
        Process process = this.launchBundleAudit(parentFile, (List<String>)bundleAuditArgs);
        try (BundlerAuditProcessor processor = new BundlerAuditProcessor(dependency, engine);
             ProcessReader processReader = new ProcessReader(process, (Processor)processor);){
            int exitValue;
            processReader.readAll();
            String error = processReader.getError();
            if (error != null) {
                LOGGER.warn("Warnings from bundle-audit {}", (Object)error);
            }
            if ((exitValue = process.exitValue()) < 0 || exitValue > 1) {
                String msg = String.format("Unexpected exit code from bundle-audit process; exit code: %s", exitValue);
                throw new AnalysisException(msg);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new AnalysisException("bundle-audit process interrupted", ie);
        }
        catch (IOException | CpeValidationException ioe) {
            LOGGER.warn("bundle-audit failure", ioe);
            throw new AnalysisException("bunder-audit error: " + ioe.getMessage(), ioe);
        }
    }
}

