/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.golang;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoModDependency {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoModDependency.class);
    private static final Set<String> LICENSE_FILES = new HashSet<String>(Arrays.asList("LICENSE", "LICENCE", "LICENSE.TXT", "LICENSE.MD", "LICENCE.MD", "LICENSE.CODE", "LICENCE.CODE", "COPYING"));
    private final String modulePath;
    private final String version;
    private final PackageURLBuilder packageURLBuilder;
    private final String dir;

    GoModDependency(String modulePath, String version, String dir) {
        this.modulePath = modulePath;
        this.version = version;
        this.dir = dir;
        this.packageURLBuilder = PackageURLBuilder.aPackageURL().withType("golang");
    }

    public Dependency toDependency(Dependency parentDependency) {
        return this.createDependency(parentDependency, this.modulePath, this.version);
    }

    private Dependency createDependency(Dependency parentDependency, String name, String version) {
        File file;
        Identifier id;
        Dependency dep = new Dependency(parentDependency.getActualFile(), true);
        String namespace = null;
        String vendor = null;
        String moduleName = null;
        String packageNamespace = null;
        int lastSlash = name.lastIndexOf("/");
        if (lastSlash > 0) {
            packageNamespace = name.substring(0, lastSlash);
            int pos = packageNamespace.indexOf("/");
            if (pos > 0) {
                namespace = packageNamespace.substring(0, pos);
                vendor = packageNamespace.substring(pos + 1);
            }
            moduleName = name.substring(lastSlash + 1);
        } else {
            moduleName = name;
        }
        String filePath = String.format("%s:%s/%s/%s", parentDependency.getFilePath(), packageNamespace, moduleName, version);
        this.packageURLBuilder.withName(moduleName);
        this.packageURLBuilder.withNamespace(packageNamespace);
        if (StringUtils.isNotBlank((CharSequence)version)) {
            this.packageURLBuilder.withVersion(version);
        }
        dep.setEcosystem("golang");
        dep.setDisplayFileName(name + ":" + version);
        dep.setName(moduleName);
        if (StringUtils.isNotBlank((CharSequence)version)) {
            dep.setVersion(version);
            dep.setPackagePath(String.format("%s:%s", name, version));
        }
        dep.setFilePath(filePath);
        if (vendor != null) {
            dep.addEvidence(EvidenceType.VENDOR, "go.mod", "vendor", vendor, Confidence.HIGHEST);
            dep.addEvidence(EvidenceType.PRODUCT, "go.mod", "vendor", vendor, Confidence.MEDIUM);
        }
        if (namespace != null && !"golang.org".equals(namespace)) {
            dep.addEvidence(EvidenceType.VENDOR, "go.mod", "namespace", namespace, Confidence.LOW);
        }
        dep.addEvidence(EvidenceType.PRODUCT, "go.mod", "name", moduleName, Confidence.HIGHEST);
        dep.addEvidence(EvidenceType.VENDOR, "go.mod", "name", moduleName, Confidence.HIGH);
        if (StringUtils.isNotBlank((CharSequence)version)) {
            dep.addEvidence(EvidenceType.VERSION, "go.mod", "version", version, Confidence.HIGHEST);
        }
        try {
            id = new PurlIdentifier(this.packageURLBuilder.build(), Confidence.HIGHEST);
        }
        catch (MalformedPackageURLException ex) {
            LOGGER.warn("Unable to create package-url identifier for `{}` in `{}` - reason: {}", new Object[]{name, parentDependency.getFilePath(), ex.getMessage()});
            StringBuilder value = new StringBuilder(name);
            if (StringUtils.isNotBlank((CharSequence)version)) {
                value.append("@").append(version);
            }
            id = new GenericIdentifier(value.toString(), Confidence.HIGH);
        }
        dep.addSoftwareIdentifier(id);
        if (StringUtils.isNotBlank((CharSequence)this.dir) && (file = new File(this.dir)).exists()) {
            dep.setFilePath(file.getAbsolutePath());
            dep.setActualFilePath(file.getAbsolutePath());
            dep.setFileName(file.getName());
            this.extractLicense(dep, file);
        }
        return dep;
    }

    private void extractLicense(Dependency dependency, File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!LICENSE_FILES.contains(f.getName().toUpperCase())) continue;
                try {
                    String license = FileUtils.readFileToString((File)f, (Charset)Charset.forName("UTF-8"));
                    dependency.setLicense(license);
                    break;
                }
                catch (IOException ex) {
                    LOGGER.debug("Error reading license file `" + file.getAbsolutePath() + "`: " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public String toString() {
        return this.modulePath + ": " + this.version;
    }
}

