/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cpe;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.owasp.dependencycheck.data.cpe.IndexException;
import org.owasp.dependencycheck.data.cpe.MemoryIndex;
import org.owasp.dependencycheck.data.lucene.SearchFieldAnalyzer;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.utils.Pair;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractMemoryIndex
implements MemoryIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMemoryIndex.class);
    private MMapDirectory index;
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private Analyzer searchingAnalyzer;
    private QueryParser queryParser;
    private SearchFieldAnalyzer productFieldAnalyzer;
    private SearchFieldAnalyzer vendorFieldAnalyzer;
    private final AtomicInteger usageCount = new AtomicInteger(0);

    protected abstract AbstractMemoryIndex instance();

    @Override
    public synchronized void open(Set<Pair<String, String>> data, Settings settings) throws IndexException {
        if (this.instance().usageCount.addAndGet(1) == 1) {
            try {
                File temp = settings.getTempDirectory();
                this.index = new MMapDirectory(temp.toPath());
                this.buildIndex(data);
                this.indexReader = DirectoryReader.open((Directory)this.index);
            }
            catch (IOException ex) {
                throw new IndexException(ex);
            }
            this.indexSearcher = new IndexSearcher(this.indexReader);
            this.searchingAnalyzer = this.createSearchingAnalyzer();
            this.queryParser = new QueryParser("id", this.searchingAnalyzer);
        }
    }

    public synchronized boolean isOpen() {
        return this.instance().usageCount.get() > 0;
    }

    private Analyzer createSearchingAnalyzer() {
        HashMap<String, Object> fieldAnalyzers = new HashMap<String, Object>();
        fieldAnalyzers.put("id", new KeywordAnalyzer());
        this.productFieldAnalyzer = new SearchFieldAnalyzer();
        this.vendorFieldAnalyzer = new SearchFieldAnalyzer();
        fieldAnalyzers.put("product", (Object)this.productFieldAnalyzer);
        fieldAnalyzers.put("vendor", (Object)this.vendorFieldAnalyzer);
        return new PerFieldAnalyzerWrapper((Analyzer)new KeywordAnalyzer(), fieldAnalyzers);
    }

    @Override
    public synchronized void close() {
        if (this.instance().usageCount.addAndGet(-1) == 0) {
            if (this.searchingAnalyzer != null) {
                this.searchingAnalyzer.close();
                this.searchingAnalyzer = null;
            }
            if (this.indexReader != null) {
                try {
                    this.indexReader.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("", (Throwable)ex);
                }
                this.indexReader = null;
            }
            this.queryParser = null;
            this.indexSearcher = null;
            if (this.index != null) {
                try {
                    this.index.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("", (Throwable)ex);
                }
                this.index = null;
            }
        }
    }

    private void buildIndex(Set<Pair<String, String>> data) throws IndexException {
        try (Analyzer analyzer = this.createSearchingAnalyzer();
             IndexWriter indexWriter = new IndexWriter((Directory)this.index, new IndexWriterConfig(analyzer));){
            FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
            ft.setIndexOptions(IndexOptions.DOCS);
            ft.setOmitNorms(true);
            Document doc = new Document();
            Field v = new Field("vendor", (CharSequence)"vendor", (IndexableFieldType)ft);
            Field p = new Field("product", (CharSequence)"product", (IndexableFieldType)ft);
            doc.add((IndexableField)v);
            doc.add((IndexableField)p);
            for (Pair<String, String> pair : data) {
                if (pair.getLeft() == null || pair.getRight() == null) continue;
                v.setStringValue(pair.getLeft());
                p.setStringValue(pair.getRight());
                indexWriter.addDocument((Iterable)doc);
                this.resetAnalyzers();
            }
            indexWriter.commit();
        }
        catch (DatabaseException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new IndexException("Error reading CPE data", ex);
        }
        catch (IOException ex) {
            throw new IndexException("Unable to close an in-memory index", ex);
        }
    }

    @Override
    public synchronized TopDocs search(String searchString, int maxQueryResults) throws ParseException, IndexException, IOException {
        Query query = this.parseQuery(searchString);
        return this.search(query, maxQueryResults);
    }

    @Override
    public synchronized Query parseQuery(String searchString) throws ParseException, IndexException {
        Query query;
        if (searchString == null || searchString.trim().isEmpty() || "product:() AND vendor:()".equals(searchString)) {
            throw new ParseException("Query is null or empty");
        }
        LOGGER.debug(searchString);
        try {
            query = this.queryParser.parse(searchString);
        }
        catch (BooleanQuery.TooManyClauses ex) {
            BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
            query = this.queryParser.parse(searchString);
        }
        catch (ParseException ex) {
            if (ex.getMessage() != null && ex.getMessage().contains("too many boolean clauses")) {
                BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
                query = this.queryParser.parse(searchString);
            }
            LOGGER.debug("Parse Excepction", (Throwable)ex);
            throw ex;
        }
        try {
            this.resetAnalyzers();
        }
        catch (IOException ex) {
            throw new IndexException("Unable to reset the analyzer after parsing", ex);
        }
        return query;
    }

    @Override
    public synchronized TopDocs search(Query query, int maxQueryResults) throws CorruptIndexException, IOException {
        return this.indexSearcher.search(query, maxQueryResults);
    }

    @Override
    public synchronized Document getDocument(int documentId) throws IOException {
        return this.indexSearcher.doc(documentId);
    }

    public synchronized int numDocs() {
        if (this.indexReader == null) {
            return -1;
        }
        return this.indexReader.numDocs();
    }

    public synchronized String explain(Query query, int doc) throws IOException {
        return this.indexSearcher.explain(query, doc).toString();
    }

    protected synchronized void resetAnalyzers() throws IOException {
        this.productFieldAnalyzer.reset();
        this.vendorFieldAnalyzer.reset();
    }
}

