/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.ArchiveExtractionException;
import org.owasp.dependencycheck.utils.ExtractionException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ExtractionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractionUtil.class);

    private ExtractionUtil() {
    }

    public static void extractFiles(File archive, File extractTo) throws ExtractionException {
        ExtractionUtil.extractFiles(archive, extractTo, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void extractFiles(File archive, File extractTo, Engine engine) throws ExtractionException {
        String destPath;
        if (archive == null || extractTo == null) {
            return;
        }
        try {
            destPath = extractTo.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new ExtractionException("Unable to extract files to destination path", (Throwable)ex);
        }
        try (FileInputStream fis = new FileInputStream(archive);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            ZipInputStream zis = new ZipInputStream(bis);
            block27: while (true) {
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    String msg;
                    if (entry.isDirectory()) {
                        File d = new File(extractTo, entry.getName());
                        if (!d.getCanonicalPath().startsWith(destPath)) {
                            msg = String.format("Archive (%s) contains a path that would be extracted outside of the target directory.", archive.getAbsolutePath());
                            throw new ExtractionException(msg);
                        }
                        if (d.exists() || d.mkdirs()) continue;
                        msg = String.format("Unable to create '%s'.", d.getAbsolutePath());
                        throw new ExtractionException(msg);
                    }
                    File file = new File(extractTo, entry.getName());
                    if (engine != null && !engine.accept(file)) continue;
                    if (!file.getCanonicalPath().startsWith(destPath)) {
                        msg = String.format("Archive (%s) contains a file that would be extracted outside of the target directory.", archive.getAbsolutePath());
                        throw new ExtractionException(msg);
                    }
                    try {
                        FileOutputStream fos = new FileOutputStream(file);
                        try {
                            ByteStreams.copy((InputStream)zis, (OutputStream)fos);
                            continue block27;
                        }
                        finally {
                            fos.close();
                            continue block27;
                        }
                    }
                    catch (FileNotFoundException ex) {
                        LOGGER.debug("", (Throwable)ex);
                        String msg2 = String.format("Unable to find file '%s'.", file.getName());
                        throw new ExtractionException(msg2, (Throwable)ex);
                    }
                    catch (IOException ex) {
                        LOGGER.debug("", (Throwable)ex);
                        String msg3 = String.format("IO Exception while parsing file '%s'.", file.getName());
                        throw new ExtractionException(msg3, (Throwable)ex);
                        return;
                    }
                }
            }
            finally {
                zis.close();
            }
        }
        catch (IOException ex) {
            String msg = String.format("Exception reading archive '%s'.", archive.getName());
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException(msg, (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void extractFiles(InputStream archive, File extractTo) throws ExtractionException {
        String destPath;
        if (archive == null || extractTo == null) {
            return;
        }
        try {
            destPath = extractTo.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new ExtractionException("Unable to extract files to destination path", (Throwable)ex);
        }
        try (BufferedInputStream bis = new BufferedInputStream(archive);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File d = new File(extractTo, entry.getName());
                    if (!d.getCanonicalPath().startsWith(destPath)) {
                        throw new ExtractionException("Archive contains a path that would be extracted outside of the target directory.");
                    }
                    if (d.exists() || d.mkdirs()) continue;
                    String msg = String.format("Unable to create '%s'.", d.getAbsolutePath());
                    throw new ExtractionException(msg);
                }
                File file = new File(extractTo, entry.getName());
                if (!file.getCanonicalPath().startsWith(destPath)) {
                    LOGGER.debug("ZipSlip detected\n-Destination: " + destPath + "\n-Path: " + file.toString());
                    throw new ExtractionException("Archive contains a file that would be extracted outside of the target directory.");
                }
                try (FileOutputStream fos = new FileOutputStream(file);){
                    ByteStreams.copy((InputStream)zis, (OutputStream)fos);
                }
                catch (FileNotFoundException ex) {
                    LOGGER.debug("", (Throwable)ex);
                    String msg = String.format("Unable to find file '%s'.", file.getName());
                    throw new ExtractionException(msg, (Throwable)ex);
                }
                catch (IOException ex) {
                    LOGGER.debug("", (Throwable)ex);
                    String msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                    throw new ExtractionException(msg, (Throwable)ex);
                    return;
                }
            }
        }
        catch (IOException ex) {
            throw new ExtractionException("Exception reading archive", (Throwable)ex);
        }
    }

    public static void extractFilesUsingFilter(File archive, File destination, FilenameFilter filter) throws ExtractionException {
        if (archive == null || destination == null) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(archive);){
            ExtractionUtil.extractArchive((ArchiveInputStream)new ZipArchiveInputStream((InputStream)new BufferedInputStream(fis)), destination, filter);
        }
        catch (FileNotFoundException ex) {
            String msg = String.format("Error extracting file `%s` with filter: %s", archive.getAbsolutePath(), ex.getMessage());
            LOGGER.debug(msg, (Throwable)ex);
            throw new ExtractionException(msg);
        }
        catch (IOException | ArchiveExtractionException ex) {
            LOGGER.warn("Exception extracting archive '{}'.", (Object)archive.getAbsolutePath());
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException("Unable to extract from archive", (Throwable)ex);
        }
    }

    private static void extractArchive(ArchiveInputStream input, File destination, FilenameFilter filter) throws ArchiveExtractionException {
        try {
            ArchiveEntry entry;
            String destPath = destination.getCanonicalPath();
            while ((entry = input.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File dir = new File(destination, entry.getName());
                    if (!dir.getCanonicalPath().startsWith(destPath)) {
                        String msg = String.format("Archive contains a path (%s) that would be extracted outside of the target directory.", dir.getAbsolutePath());
                        throw new AnalysisException(msg);
                    }
                    if (dir.exists() || dir.mkdirs()) continue;
                    String msg = String.format("Unable to create directory '%s'.", dir.getAbsolutePath());
                    throw new AnalysisException(msg);
                }
                ExtractionUtil.extractFile(input, destination, filter, entry);
            }
        }
        catch (IOException | AnalysisException ex) {
            throw new ArchiveExtractionException(ex);
        }
        finally {
            FileUtils.close((Closeable)input);
        }
    }

    private static void extractFile(ArchiveInputStream input, File destination, FilenameFilter filter, ArchiveEntry entry) throws ExtractionException {
        block10: {
            File file = new File(destination, entry.getName());
            try {
                if (!filter.accept(file.getParentFile(), file.getName())) break block10;
                String destPath = destination.getCanonicalPath();
                if (!file.getCanonicalPath().startsWith(destPath)) {
                    LOGGER.debug("ZipSlip detected\n-Destination: " + destPath + "\n-Path: " + file.toString());
                    String msg = String.format("Archive contains a file (%s) that would be extracted outside of the target directory.", file.getAbsolutePath());
                    throw new ExtractionException(msg);
                }
                LOGGER.debug("Extracting '{}'", (Object)file.getPath());
                ExtractionUtil.createParentFile(file);
                try (FileOutputStream fos = new FileOutputStream(file);){
                    ByteStreams.copy((InputStream)input, (OutputStream)fos);
                }
                catch (FileNotFoundException ex) {
                    LOGGER.debug("", (Throwable)ex);
                    String msg = String.format("Unable to find file '%s'.", file.getName());
                    throw new ExtractionException(msg, (Throwable)ex);
                }
            }
            catch (IOException ex) {
                LOGGER.debug("", (Throwable)ex);
                String msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                throw new ExtractionException(msg, (Throwable)ex);
            }
        }
    }

    private static void createParentFile(File file) throws ExtractionException {
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            String msg = String.format("Unable to build directory '%s'.", parent.getAbsolutePath());
            throw new ExtractionException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractGzip(File file) throws FileNotFoundException, IOException {
        String originalPath = file.getPath();
        File gzip = new File(originalPath + ".gz");
        if (gzip.isFile() && !gzip.delete()) {
            LOGGER.debug("Failed to delete initial temporary file when extracting 'gz' {}", (Object)gzip.toString());
            gzip.deleteOnExit();
        }
        if (!file.renameTo(gzip)) {
            throw new IOException("Unable to rename '" + file.getPath() + "'");
        }
        File newFile = new File(originalPath);
        try (FileInputStream fis = new FileInputStream(gzip);
             GZIPInputStream cin = new GZIPInputStream(fis);
             FileOutputStream out = new FileOutputStream(newFile);){
            ByteStreams.copy((InputStream)cin, (OutputStream)out);
        }
        finally {
            if (gzip.isFile() && !org.apache.commons.io.FileUtils.deleteQuietly((File)gzip)) {
                LOGGER.debug("Failed to delete temporary file when extracting 'gz' {}", (Object)gzip.toString());
                gzip.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(File file) throws FileNotFoundException, IOException {
        String originalPath = file.getPath();
        File zip = new File(originalPath + ".zip");
        if (zip.isFile() && !zip.delete()) {
            LOGGER.debug("Failed to delete initial temporary file when extracting 'zip' {}", (Object)zip.toString());
            zip.deleteOnExit();
        }
        if (!file.renameTo(zip)) {
            throw new IOException("Unable to rename '" + file.getPath() + "'");
        }
        File newFile = new File(originalPath);
        try (FileInputStream fis = new FileInputStream(zip);
             ZipInputStream cin = new ZipInputStream(fis);
             FileOutputStream out = new FileOutputStream(newFile);){
            cin.getNextEntry();
            ByteStreams.copy((InputStream)cin, (OutputStream)out);
        }
        finally {
            if (zip.isFile() && !org.apache.commons.io.FileUtils.deleteQuietly((File)zip)) {
                LOGGER.debug("Failed to delete temporary file when extracting 'zip' {}", (Object)zip.toString());
                zip.deleteOnExit();
            }
        }
    }
}

