/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nodeaudit;

import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.owasp.dependencycheck.analyzer.NodePackageAnalyzer;

@ThreadSafe
public final class NpmPayloadBuilder {
    private NpmPayloadBuilder() {
    }

    public static JsonObject build(JsonObject lockJson, JsonObject packageJson, Map<String, String> dependencyMap, boolean skipDevDependencies) {
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder();
        NpmPayloadBuilder.addProjectInfo(packageJson, payloadBuilder);
        JsonObjectBuilder requiresBuilder = Json.createObjectBuilder();
        if (packageJson.containsKey((Object)"dependencies")) {
            packageJson.getJsonObject("dependencies").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue, TreeMap::new)).entrySet().forEach(entry -> {
                if (NodePackageAnalyzer.shouldSkipDependency((String)entry.getKey(), ((JsonString)entry.getValue()).getString())) {
                    return;
                }
                requiresBuilder.add((String)entry.getKey(), (JsonValue)entry.getValue());
                dependencyMap.put((String)entry.getKey(), ((JsonValue)entry.getValue()).toString());
            });
        }
        if (!skipDevDependencies && packageJson.containsKey((Object)"devDependencies")) {
            packageJson.getJsonObject("devDependencies").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue, TreeMap::new)).entrySet().forEach(entry -> {
                if (NodePackageAnalyzer.shouldSkipDependency((String)entry.getKey(), ((JsonString)entry.getValue()).getString())) {
                    return;
                }
                requiresBuilder.add((String)entry.getKey(), (JsonValue)entry.getValue());
                dependencyMap.put((String)entry.getKey(), ((JsonValue)entry.getValue()).toString());
            });
        }
        payloadBuilder.add("requires", (JsonValue)requiresBuilder.build());
        JsonObjectBuilder dependenciesBuilder = Json.createObjectBuilder();
        JsonObject dependencies = lockJson.getJsonObject("dependencies");
        if (dependencies != null) {
            dependencies.entrySet().forEach(entry -> {
                JsonObject dep = (JsonObject)entry.getValue();
                String version = dep.getString("version");
                if (NodePackageAnalyzer.shouldSkipDependency((String)entry.getKey(), version)) {
                    return;
                }
                dependencyMap.put((String)entry.getKey(), version);
                dependenciesBuilder.add((String)entry.getKey(), (JsonValue)NpmPayloadBuilder.buildDependencies(dep, dependencyMap));
            });
        }
        payloadBuilder.add("dependencies", (JsonValue)dependenciesBuilder.build());
        NpmPayloadBuilder.addConstantElements(payloadBuilder);
        return payloadBuilder.build();
    }

    public static JsonObject build(JsonObject packageJson, Map<String, String> dependencyMap) {
        JsonObjectBuilder payloadBuilder = Json.createObjectBuilder();
        NpmPayloadBuilder.addProjectInfo(packageJson, payloadBuilder);
        JsonObjectBuilder requiresBuilder = Json.createObjectBuilder();
        JsonObjectBuilder dependenciesBuilder = Json.createObjectBuilder();
        JsonObject dependencies = packageJson.getJsonObject("dependencies");
        if (dependencies != null) {
            dependencies.entrySet().forEach(entry -> {
                String version;
                if (((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.OBJECT) {
                    JsonObject dep = (JsonObject)entry.getValue();
                    String name = (String)entry.getKey();
                    if (NodePackageAnalyzer.shouldSkipDependency(name, version = dep.getString("version"))) {
                        return;
                    }
                    dependencyMap.put(name, version);
                    dependenciesBuilder.add(name, (JsonValue)NpmPayloadBuilder.buildDependencies(dep, dependencyMap));
                } else {
                    String tmp = ((JsonValue)entry.getValue()).toString();
                    version = tmp.startsWith("\"") ? tmp.substring(1, tmp.length() - 1) : tmp;
                }
                requiresBuilder.add((String)entry.getKey(), "^" + version);
            });
        }
        payloadBuilder.add("requires", (JsonValue)requiresBuilder.build());
        payloadBuilder.add("dependencies", (JsonValue)dependenciesBuilder.build());
        NpmPayloadBuilder.addConstantElements(payloadBuilder);
        return payloadBuilder.build();
    }

    private static void addProjectInfo(JsonObject packageJson, JsonObjectBuilder payloadBuilder) {
        String projectName = packageJson.getString("name", "");
        String projectVersion = packageJson.getString("version", "");
        if (!projectName.isEmpty()) {
            payloadBuilder.add("name", projectName);
        }
        if (!projectVersion.isEmpty()) {
            payloadBuilder.add("version", projectVersion);
        }
    }

    private static void addConstantElements(JsonObjectBuilder payloadBuilder) {
        payloadBuilder.add("install", (JsonValue)Json.createArrayBuilder().build());
        payloadBuilder.add("remove", (JsonValue)Json.createArrayBuilder().build());
        payloadBuilder.add("metadata", Json.createObjectBuilder().add("npm_version", "6.9.0").add("node_version", "v10.5.0").add("platform", "linux"));
    }

    private static JsonObject buildDependencies(JsonObject dep, Map<String, String> dependencyMap) {
        JsonObjectBuilder depBuilder = Json.createObjectBuilder();
        depBuilder.add("version", dep.getString("version"));
        if (dep.containsKey((Object)"integrity")) {
            depBuilder.add("integrity", dep.getString("integrity"));
        }
        if (dep.containsKey((Object)"requires")) {
            depBuilder.add("requires", (JsonValue)dep.getJsonObject("requires"));
        }
        if (dep.containsKey((Object)"dependencies")) {
            JsonObjectBuilder dependeciesBuilder = Json.createObjectBuilder();
            dep.getJsonObject("dependencies").entrySet().forEach(entry -> {
                String v = ((JsonObject)entry.getValue()).getString("version");
                dependencyMap.put((String)entry.getKey(), v);
                dependeciesBuilder.add((String)entry.getKey(), (JsonValue)NpmPayloadBuilder.buildDependencies((JsonObject)entry.getValue(), dependencyMap));
            });
            depBuilder.add("dependencies", (JsonValue)dependeciesBuilder.build());
        }
        return depBuilder.build();
    }
}

