/*
 * This file is part of dependency-check-core.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2020 The OWASP Foundation. All Rights Reserved.
 */
package org.owasp.dependencycheck.data.nvd.ecosystem;

public enum FileExtensionHint implements EcosystemHint {

    // note: all must be lowercase
    PHP(".php", Ecosystem.PHP),
    PERL_PM(".pm", Ecosystem.PERL),
    PERL_PL(".pl", Ecosystem.PERL),
    JAR_JAVA(".java", Ecosystem.JAVA),
    JAR_JSP(".jsp", Ecosystem.JAVA),
    JAR_RUBY(".rb", Ecosystem.RUBY),
    PYTON(".py", Ecosystem.PYTHON),
    CMAKE_CPP(".cpp", Ecosystem.NATIVE),
    CMAKE_C(".c", Ecosystem.NATIVE),
    CMAKE_H(".h", Ecosystem.NATIVE);

    private final String extension;

    private final String ecosystem;

    private FileExtensionHint(String extension, String ecosystem) {
        this.extension = extension;
        this.ecosystem = ecosystem;
    }

    @Override
    public String getEcosystem() {
        return ecosystem;
    }

    public String getExtension() {
        return extension;
    }

    @Override
    public EcosystemHintNature getNature() {
        return EcosystemHintNature.FILE_EXTENSION;
    }

    @Override
    public String getValue() {
        return getExtension();
    }
}
