/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.ecosystem;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.data.nvd.ecosystem.DescriptionKeywordHint;
import org.owasp.dependencycheck.data.nvd.ecosystem.EcosystemHint;
import org.owasp.dependencycheck.data.nvd.ecosystem.EcosystemHintNature;
import org.owasp.dependencycheck.data.nvd.ecosystem.FileExtensionHint;
import org.owasp.dependencycheck.data.nvd.ecosystem.StringAhoCorasickDoubleArrayTrie;
import org.owasp.dependencycheck.data.nvd.json.DefCveItem;
import org.owasp.dependencycheck.data.nvd.json.LangString;

@NotThreadSafe
public class DescriptionEcosystemMapper {
    protected static final String[] ECOSYSTEMS;
    protected static final int[] HINT_TO_ECOSYSTEM_LOOKUP;
    protected static final TreeMap<String, EcosystemHint> ECOSYSTEM_MAP;
    protected final boolean[] keywordPrefixes = DescriptionEcosystemMapper.getPrefixesFor(" -(\"'");
    protected final boolean[] keywordPostfixes = DescriptionEcosystemMapper.getPrefixesFor(" -)\"',.:;");
    protected final int[] values = new int[ECOSYSTEMS.length];
    protected final StringAhoCorasickDoubleArrayTrie<EcosystemHint> ahoCorasickDoubleArrayTrie = DescriptionEcosystemMapper.toAhoCorasickDoubleArrayTrie();

    protected static boolean[] getPrefixesFor(String str) {
        char c;
        int n = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (c >= str.charAt(i)) continue;
            c = str.charAt(i);
        }
        boolean[] delimiters = new boolean[c + true];
        for (int i = 0; i < str.length(); ++i) {
            delimiters[str.charAt((int)i)] = true;
        }
        return delimiters;
    }

    protected void increment(int i) {
        int n = HINT_TO_ECOSYSTEM_LOOKUP[i];
        this.values[n] = this.values[n] + 1;
    }

    protected void reset() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = 0;
        }
    }

    protected static StringAhoCorasickDoubleArrayTrie<EcosystemHint> toAhoCorasickDoubleArrayTrie() {
        StringAhoCorasickDoubleArrayTrie<EcosystemHint> exact = new StringAhoCorasickDoubleArrayTrie<EcosystemHint>();
        exact.build(ECOSYSTEM_MAP);
        return exact;
    }

    public String getEcosystem(DefCveItem cve) {
        for (LangString langString : cve.getCve().getDescription().getDescriptionData()) {
            if (!langString.getLang().equals("en")) continue;
            this.search(langString.getValue());
        }
        return this.getResult();
    }

    public String getEcosystem(String multicase) {
        this.search(multicase);
        return this.getResult();
    }

    private void search(String multicase) {
        String c = multicase.toLowerCase();
        this.ahoCorasickDoubleArrayTrie.parseText(c, (AhoCorasickDoubleArrayTrie.IHitFull<EcosystemHint>)((AhoCorasickDoubleArrayTrie.IHitFull)(begin, end, value, index) -> {
            if (value.getNature() == EcosystemHintNature.FILE_EXTENSION) {
                if (!DescriptionEcosystemMapper.isExtension(multicase, begin, end)) {
                    return;
                }
                String ecosystem = value.getEcosystem();
                if ("php".equals(ecosystem) && c.regionMatches(begin, ".php", 0, 4) ? DescriptionEcosystemMapper.isURL(c, begin) : "java".equals(ecosystem) && c.regionMatches(begin, ".jsp", 0, 4) && DescriptionEcosystemMapper.isURL(c, begin)) {
                    return;
                }
            } else {
                char endChar;
                char startChar;
                if (!(begin == 0 || (startChar = c.charAt(begin - 1)) < this.keywordPrefixes.length && this.keywordPrefixes[startChar])) {
                    return;
                }
                if (!(end == c.length() || (endChar = c.charAt(end)) < this.keywordPostfixes.length && this.keywordPostfixes[endChar])) {
                    return;
                }
                String ecosystem = value.getEcosystem();
                if ("native".equals(ecosystem) && StringUtils.contains((CharSequence)c, (CharSequence)"android")) {
                    return;
                }
            }
            this.increment(index);
        }));
    }

    private String getResult() {
        int best = this.getBestScoreAndReset();
        if (best != -1) {
            return ECOSYSTEMS[best];
        }
        return null;
    }

    private int getBestScoreAndReset() {
        int best = -1;
        int bestScore = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] <= 0) continue;
            if (this.values[i] > bestScore) {
                best = i;
                bestScore = this.values[i];
            }
            this.values[i] = 0;
        }
        return best;
    }

    protected static boolean isExtension(String str, int begin, int end) {
        if (str.length() != end && Character.isLetterOrDigit(str.charAt(end))) {
            return false;
        }
        return DescriptionEcosystemMapper.isLowercaseAscii(str, begin + 1, end);
    }

    protected static boolean isLowercaseAscii(String multicase, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = multicase.charAt(i);
            if (c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static boolean isURL(String c, int begin) {
        begin -= 2;
        while (begin > 2) {
            if (c.charAt(--begin) == ' ') {
                return false;
            }
            if (c.charAt(begin) != ':') continue;
            return c.charAt(begin + 1) == '/' && c.charAt(begin + 2) == '/';
        }
        return false;
    }

    static {
        ECOSYSTEM_MAP = new TreeMap();
        for (FileExtensionHint fileExtensionHint : FileExtensionHint.values()) {
            ECOSYSTEM_MAP.put(fileExtensionHint.getValue(), fileExtensionHint);
        }
        for (Enum enum_ : DescriptionKeywordHint.values()) {
            ECOSYSTEM_MAP.put(((DescriptionKeywordHint)enum_).getValue(), (EcosystemHint)((Object)enum_));
        }
        HashMap<String, Integer> ecosystemIndexes = new HashMap<String, Integer>();
        HINT_TO_ECOSYSTEM_LOOKUP = new int[ECOSYSTEM_MAP.size()];
        int index = 0;
        for (Map.Entry<String, EcosystemHint> entry : ECOSYSTEM_MAP.entrySet()) {
            EcosystemHint ecosystemHint = entry.getValue();
            Integer ecosystemIndex = (Integer)ecosystemIndexes.get(ecosystemHint.getEcosystem());
            if (ecosystemIndex == null) {
                ecosystemIndex = ecosystemIndexes.size();
                ecosystemIndexes.put(ecosystemHint.getEcosystem(), ecosystemIndex);
            }
            DescriptionEcosystemMapper.HINT_TO_ECOSYSTEM_LOOKUP[index] = ecosystemIndex;
            ++index;
        }
        ECOSYSTEMS = new String[ecosystemIndexes.size()];
        for (Map.Entry<String, EcosystemHint> entry : ecosystemIndexes.entrySet()) {
            DescriptionEcosystemMapper.ECOSYSTEMS[((Integer)((Object)entry.getValue())).intValue()] = entry.getKey();
        }
    }
}

