/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.data.nvd.json.DefCveItem;
import org.owasp.dependencycheck.data.nvd.json.Reference;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;

public class CveItemOperator {
    public String extractDescription(DefCveItem cve) {
        return cve.getCve().getDescription().getDescriptionData().stream().filter(desc -> "en".equals(desc.getLang())).map(d -> d.getValue()).collect(Collectors.joining(" "));
    }

    public String extractBaseEcosystem(DefCveItem cve, String description) {
        if (description == null) {
            return this.extractBaseEcosystemFromReferences(cve);
        }
        int idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".php");
        if (idx > 0 && (idx + 4 == description.length() || !Character.isLetterOrDigit(description.charAt(idx + 4))) || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"wordpress") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"drupal") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"joomla") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"moodle") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"typo3")) {
            return "Composer";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)" npm ") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"node module") && StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)".js") || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)" node.js")) {
            return "npm";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".pm");
        if (!(idx <= 0 || idx + 3 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 3)))) {
            return "perl";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".pl");
        if (!(idx <= 0 || idx + 3 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 3)))) {
            return "perl";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".java");
        if (!(idx <= 0 || idx + 5 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 5)))) {
            return "Java";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".jsp");
        if (!(idx <= 0 || idx + 4 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 4)))) {
            return "Java";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)" grails ")) {
            return "Java";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".rb");
        if (!(idx <= 0 || idx + 3 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 3)))) {
            return "ruby";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"ruby gem")) {
            return "ruby";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".py");
        if (idx > 0 && (idx + 3 == description.length() || !Character.isLetterOrDigit(description.charAt(idx + 3))) || StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"django")) {
            return "python";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"buffer overflow") && !StringUtils.containsIgnoreCase((CharSequence)description, (CharSequence)"android")) {
            return "CMAKE";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".c");
        if (!(idx <= 0 || idx + 2 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 2)))) {
            return "CMAKE";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".cpp");
        if (!(idx <= 0 || idx + 4 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 4)))) {
            return "CMAKE";
        }
        idx = StringUtils.indexOfIgnoreCase((CharSequence)description, (CharSequence)".h");
        if (!(idx <= 0 || idx + 2 != description.length() && Character.isLetterOrDigit(description.charAt(idx + 2)))) {
            return "CMAKE";
        }
        return this.extractBaseEcosystemFromReferences(cve);
    }

    protected String extractBaseEcosystemFromReferences(DefCveItem cve) {
        for (Reference r : cve.getCve().getReferences().getReferenceData()) {
            if (r.getUrl().contains("elixir-security-advisories")) {
                return "elixir";
            }
            if (r.getUrl().contains("ruby-lang.org")) {
                return "ruby";
            }
            if (r.getUrl().contains("python.org")) {
                return "python";
            }
            if (r.getUrl().contains("drupal.org")) {
                return "python";
            }
            if (r.getUrl().contains("npm")) {
                return "npm";
            }
            if (r.getUrl().contains("nodejs.org")) {
                return "npm";
            }
            if (r.getUrl().contains("nodesecurity.io")) {
                return "npm";
            }
            if (!r.getUrl().contains("rustsec.org")) continue;
            return "rust";
        }
        return null;
    }

    private String extractEcosystem(String baseEcosystem, String vendor, String product, String targetSw) {
        if ("ibm".equals(vendor) && "java".equals(product)) {
            return "c/c++";
        }
        if ("oracle".equals(vendor) && "vm".equals(product)) {
            return "c/c++";
        }
        if ("*".equals(targetSw) || baseEcosystem != null) {
            return baseEcosystem;
        }
        return targetSw;
    }

    public String extractEcosystem(String baseEcosystem, VulnerableSoftware parsedCpe) {
        return this.extractEcosystem(baseEcosystem, parsedCpe.getVendor(), parsedCpe.getProduct(), parsedCpe.getTargetSw());
    }

    public boolean isRejected(String description) {
        return description.startsWith("** REJECT **");
    }
}

