
package org.owasp.dependencycheck.data.nvd.json;

import java.util.HashMap;
import java.util.Map;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;


/**
 * JSON Schema for Common Vulnerability Scoring System version 3.x
 * <p>
 * 
 * 
 */
public class CvssV3X {

    /**
     * CVSS Version
     * (Required)
     * 
     */
    @SerializedName("version")
    @Expose
    private CvssV3X.Version version;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("vectorString")
    @Expose
    private String vectorString;
    @SerializedName("attackVector")
    @Expose
    private CvssV3X.AttackVectorType attackVector;
    @SerializedName("attackComplexity")
    @Expose
    private CvssV3X.AttackComplexityType attackComplexity;
    @SerializedName("privilegesRequired")
    @Expose
    private CvssV3X.PrivilegesRequiredType privilegesRequired;
    @SerializedName("userInteraction")
    @Expose
    private CvssV3X.UserInteractionType userInteraction;
    @SerializedName("scope")
    @Expose
    private CvssV3X.ScopeType scope;
    @SerializedName("confidentialityImpact")
    @Expose
    private CvssV3X.CiaType confidentialityImpact;
    @SerializedName("integrityImpact")
    @Expose
    private CvssV3X.CiaType integrityImpact;
    @SerializedName("availabilityImpact")
    @Expose
    private CvssV3X.CiaType availabilityImpact;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("baseScore")
    @Expose
    private Double baseScore;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("baseSeverity")
    @Expose
    private CvssV3X.SeverityType baseSeverity;
    @SerializedName("exploitCodeMaturity")
    @Expose
    private CvssV3X.ExploitCodeMaturityType exploitCodeMaturity;
    @SerializedName("remediationLevel")
    @Expose
    private CvssV3X.RemediationLevelType remediationLevel;
    @SerializedName("reportConfidence")
    @Expose
    private CvssV3X.ConfidenceType reportConfidence;
    @SerializedName("temporalScore")
    @Expose
    private Double temporalScore;
    @SerializedName("temporalSeverity")
    @Expose
    private CvssV3X.SeverityType temporalSeverity;
    @SerializedName("confidentialityRequirement")
    @Expose
    private CvssV3X.CiaRequirementType confidentialityRequirement;
    @SerializedName("integrityRequirement")
    @Expose
    private CvssV3X.CiaRequirementType integrityRequirement;
    @SerializedName("availabilityRequirement")
    @Expose
    private CvssV3X.CiaRequirementType availabilityRequirement;
    @SerializedName("modifiedAttackVector")
    @Expose
    private CvssV3X.ModifiedAttackVectorType modifiedAttackVector;
    @SerializedName("modifiedAttackComplexity")
    @Expose
    private CvssV3X.ModifiedAttackComplexityType modifiedAttackComplexity;
    @SerializedName("modifiedPrivilegesRequired")
    @Expose
    private CvssV3X.ModifiedPrivilegesRequiredType modifiedPrivilegesRequired;
    @SerializedName("modifiedUserInteraction")
    @Expose
    private CvssV3X.ModifiedUserInteractionType modifiedUserInteraction;
    @SerializedName("modifiedScope")
    @Expose
    private CvssV3X.ModifiedScopeType modifiedScope;
    @SerializedName("modifiedConfidentialityImpact")
    @Expose
    private CvssV3X.ModifiedCiaType modifiedConfidentialityImpact;
    @SerializedName("modifiedIntegrityImpact")
    @Expose
    private CvssV3X.ModifiedCiaType modifiedIntegrityImpact;
    @SerializedName("modifiedAvailabilityImpact")
    @Expose
    private CvssV3X.ModifiedCiaType modifiedAvailabilityImpact;
    @SerializedName("environmentalScore")
    @Expose
    private Double environmentalScore;
    @SerializedName("environmentalSeverity")
    @Expose
    private CvssV3X.SeverityType environmentalSeverity;

    /**
     * CVSS Version
     * (Required)
     * 
     */
    public CvssV3X.Version getVersion() {
        return version;
    }

    /**
     * CVSS Version
     * (Required)
     * 
     */
    public void setVersion(CvssV3X.Version version) {
        this.version = version;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getVectorString() {
        return vectorString;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setVectorString(String vectorString) {
        this.vectorString = vectorString;
    }

    public CvssV3X.AttackVectorType getAttackVector() {
        return attackVector;
    }

    public void setAttackVector(CvssV3X.AttackVectorType attackVector) {
        this.attackVector = attackVector;
    }

    public CvssV3X.AttackComplexityType getAttackComplexity() {
        return attackComplexity;
    }

    public void setAttackComplexity(CvssV3X.AttackComplexityType attackComplexity) {
        this.attackComplexity = attackComplexity;
    }

    public CvssV3X.PrivilegesRequiredType getPrivilegesRequired() {
        return privilegesRequired;
    }

    public void setPrivilegesRequired(CvssV3X.PrivilegesRequiredType privilegesRequired) {
        this.privilegesRequired = privilegesRequired;
    }

    public CvssV3X.UserInteractionType getUserInteraction() {
        return userInteraction;
    }

    public void setUserInteraction(CvssV3X.UserInteractionType userInteraction) {
        this.userInteraction = userInteraction;
    }

    public CvssV3X.ScopeType getScope() {
        return scope;
    }

    public void setScope(CvssV3X.ScopeType scope) {
        this.scope = scope;
    }

    public CvssV3X.CiaType getConfidentialityImpact() {
        return confidentialityImpact;
    }

    public void setConfidentialityImpact(CvssV3X.CiaType confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    public CvssV3X.CiaType getIntegrityImpact() {
        return integrityImpact;
    }

    public void setIntegrityImpact(CvssV3X.CiaType integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    public CvssV3X.CiaType getAvailabilityImpact() {
        return availabilityImpact;
    }

    public void setAvailabilityImpact(CvssV3X.CiaType availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Double getBaseScore() {
        return baseScore;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setBaseScore(Double baseScore) {
        this.baseScore = baseScore;
    }

    /**
     * 
     * (Required)
     * 
     */
    public CvssV3X.SeverityType getBaseSeverity() {
        return baseSeverity;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setBaseSeverity(CvssV3X.SeverityType baseSeverity) {
        this.baseSeverity = baseSeverity;
    }

    public CvssV3X.ExploitCodeMaturityType getExploitCodeMaturity() {
        return exploitCodeMaturity;
    }

    public void setExploitCodeMaturity(CvssV3X.ExploitCodeMaturityType exploitCodeMaturity) {
        this.exploitCodeMaturity = exploitCodeMaturity;
    }

    public CvssV3X.RemediationLevelType getRemediationLevel() {
        return remediationLevel;
    }

    public void setRemediationLevel(CvssV3X.RemediationLevelType remediationLevel) {
        this.remediationLevel = remediationLevel;
    }

    public CvssV3X.ConfidenceType getReportConfidence() {
        return reportConfidence;
    }

    public void setReportConfidence(CvssV3X.ConfidenceType reportConfidence) {
        this.reportConfidence = reportConfidence;
    }

    public Double getTemporalScore() {
        return temporalScore;
    }

    public void setTemporalScore(Double temporalScore) {
        this.temporalScore = temporalScore;
    }

    public CvssV3X.SeverityType getTemporalSeverity() {
        return temporalSeverity;
    }

    public void setTemporalSeverity(CvssV3X.SeverityType temporalSeverity) {
        this.temporalSeverity = temporalSeverity;
    }

    public CvssV3X.CiaRequirementType getConfidentialityRequirement() {
        return confidentialityRequirement;
    }

    public void setConfidentialityRequirement(CvssV3X.CiaRequirementType confidentialityRequirement) {
        this.confidentialityRequirement = confidentialityRequirement;
    }

    public CvssV3X.CiaRequirementType getIntegrityRequirement() {
        return integrityRequirement;
    }

    public void setIntegrityRequirement(CvssV3X.CiaRequirementType integrityRequirement) {
        this.integrityRequirement = integrityRequirement;
    }

    public CvssV3X.CiaRequirementType getAvailabilityRequirement() {
        return availabilityRequirement;
    }

    public void setAvailabilityRequirement(CvssV3X.CiaRequirementType availabilityRequirement) {
        this.availabilityRequirement = availabilityRequirement;
    }

    public CvssV3X.ModifiedAttackVectorType getModifiedAttackVector() {
        return modifiedAttackVector;
    }

    public void setModifiedAttackVector(CvssV3X.ModifiedAttackVectorType modifiedAttackVector) {
        this.modifiedAttackVector = modifiedAttackVector;
    }

    public CvssV3X.ModifiedAttackComplexityType getModifiedAttackComplexity() {
        return modifiedAttackComplexity;
    }

    public void setModifiedAttackComplexity(CvssV3X.ModifiedAttackComplexityType modifiedAttackComplexity) {
        this.modifiedAttackComplexity = modifiedAttackComplexity;
    }

    public CvssV3X.ModifiedPrivilegesRequiredType getModifiedPrivilegesRequired() {
        return modifiedPrivilegesRequired;
    }

    public void setModifiedPrivilegesRequired(CvssV3X.ModifiedPrivilegesRequiredType modifiedPrivilegesRequired) {
        this.modifiedPrivilegesRequired = modifiedPrivilegesRequired;
    }

    public CvssV3X.ModifiedUserInteractionType getModifiedUserInteraction() {
        return modifiedUserInteraction;
    }

    public void setModifiedUserInteraction(CvssV3X.ModifiedUserInteractionType modifiedUserInteraction) {
        this.modifiedUserInteraction = modifiedUserInteraction;
    }

    public CvssV3X.ModifiedScopeType getModifiedScope() {
        return modifiedScope;
    }

    public void setModifiedScope(CvssV3X.ModifiedScopeType modifiedScope) {
        this.modifiedScope = modifiedScope;
    }

    public CvssV3X.ModifiedCiaType getModifiedConfidentialityImpact() {
        return modifiedConfidentialityImpact;
    }

    public void setModifiedConfidentialityImpact(CvssV3X.ModifiedCiaType modifiedConfidentialityImpact) {
        this.modifiedConfidentialityImpact = modifiedConfidentialityImpact;
    }

    public CvssV3X.ModifiedCiaType getModifiedIntegrityImpact() {
        return modifiedIntegrityImpact;
    }

    public void setModifiedIntegrityImpact(CvssV3X.ModifiedCiaType modifiedIntegrityImpact) {
        this.modifiedIntegrityImpact = modifiedIntegrityImpact;
    }

    public CvssV3X.ModifiedCiaType getModifiedAvailabilityImpact() {
        return modifiedAvailabilityImpact;
    }

    public void setModifiedAvailabilityImpact(CvssV3X.ModifiedCiaType modifiedAvailabilityImpact) {
        this.modifiedAvailabilityImpact = modifiedAvailabilityImpact;
    }

    public Double getEnvironmentalScore() {
        return environmentalScore;
    }

    public void setEnvironmentalScore(Double environmentalScore) {
        this.environmentalScore = environmentalScore;
    }

    public CvssV3X.SeverityType getEnvironmentalSeverity() {
        return environmentalSeverity;
    }

    public void setEnvironmentalSeverity(CvssV3X.SeverityType environmentalSeverity) {
        this.environmentalSeverity = environmentalSeverity;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CvssV3X.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("version");
        sb.append('=');
        sb.append(((this.version == null)?"<null>":this.version));
        sb.append(',');
        sb.append("vectorString");
        sb.append('=');
        sb.append(((this.vectorString == null)?"<null>":this.vectorString));
        sb.append(',');
        sb.append("attackVector");
        sb.append('=');
        sb.append(((this.attackVector == null)?"<null>":this.attackVector));
        sb.append(',');
        sb.append("attackComplexity");
        sb.append('=');
        sb.append(((this.attackComplexity == null)?"<null>":this.attackComplexity));
        sb.append(',');
        sb.append("privilegesRequired");
        sb.append('=');
        sb.append(((this.privilegesRequired == null)?"<null>":this.privilegesRequired));
        sb.append(',');
        sb.append("userInteraction");
        sb.append('=');
        sb.append(((this.userInteraction == null)?"<null>":this.userInteraction));
        sb.append(',');
        sb.append("scope");
        sb.append('=');
        sb.append(((this.scope == null)?"<null>":this.scope));
        sb.append(',');
        sb.append("confidentialityImpact");
        sb.append('=');
        sb.append(((this.confidentialityImpact == null)?"<null>":this.confidentialityImpact));
        sb.append(',');
        sb.append("integrityImpact");
        sb.append('=');
        sb.append(((this.integrityImpact == null)?"<null>":this.integrityImpact));
        sb.append(',');
        sb.append("availabilityImpact");
        sb.append('=');
        sb.append(((this.availabilityImpact == null)?"<null>":this.availabilityImpact));
        sb.append(',');
        sb.append("baseScore");
        sb.append('=');
        sb.append(((this.baseScore == null)?"<null>":this.baseScore));
        sb.append(',');
        sb.append("baseSeverity");
        sb.append('=');
        sb.append(((this.baseSeverity == null)?"<null>":this.baseSeverity));
        sb.append(',');
        sb.append("exploitCodeMaturity");
        sb.append('=');
        sb.append(((this.exploitCodeMaturity == null)?"<null>":this.exploitCodeMaturity));
        sb.append(',');
        sb.append("remediationLevel");
        sb.append('=');
        sb.append(((this.remediationLevel == null)?"<null>":this.remediationLevel));
        sb.append(',');
        sb.append("reportConfidence");
        sb.append('=');
        sb.append(((this.reportConfidence == null)?"<null>":this.reportConfidence));
        sb.append(',');
        sb.append("temporalScore");
        sb.append('=');
        sb.append(((this.temporalScore == null)?"<null>":this.temporalScore));
        sb.append(',');
        sb.append("temporalSeverity");
        sb.append('=');
        sb.append(((this.temporalSeverity == null)?"<null>":this.temporalSeverity));
        sb.append(',');
        sb.append("confidentialityRequirement");
        sb.append('=');
        sb.append(((this.confidentialityRequirement == null)?"<null>":this.confidentialityRequirement));
        sb.append(',');
        sb.append("integrityRequirement");
        sb.append('=');
        sb.append(((this.integrityRequirement == null)?"<null>":this.integrityRequirement));
        sb.append(',');
        sb.append("availabilityRequirement");
        sb.append('=');
        sb.append(((this.availabilityRequirement == null)?"<null>":this.availabilityRequirement));
        sb.append(',');
        sb.append("modifiedAttackVector");
        sb.append('=');
        sb.append(((this.modifiedAttackVector == null)?"<null>":this.modifiedAttackVector));
        sb.append(',');
        sb.append("modifiedAttackComplexity");
        sb.append('=');
        sb.append(((this.modifiedAttackComplexity == null)?"<null>":this.modifiedAttackComplexity));
        sb.append(',');
        sb.append("modifiedPrivilegesRequired");
        sb.append('=');
        sb.append(((this.modifiedPrivilegesRequired == null)?"<null>":this.modifiedPrivilegesRequired));
        sb.append(',');
        sb.append("modifiedUserInteraction");
        sb.append('=');
        sb.append(((this.modifiedUserInteraction == null)?"<null>":this.modifiedUserInteraction));
        sb.append(',');
        sb.append("modifiedScope");
        sb.append('=');
        sb.append(((this.modifiedScope == null)?"<null>":this.modifiedScope));
        sb.append(',');
        sb.append("modifiedConfidentialityImpact");
        sb.append('=');
        sb.append(((this.modifiedConfidentialityImpact == null)?"<null>":this.modifiedConfidentialityImpact));
        sb.append(',');
        sb.append("modifiedIntegrityImpact");
        sb.append('=');
        sb.append(((this.modifiedIntegrityImpact == null)?"<null>":this.modifiedIntegrityImpact));
        sb.append(',');
        sb.append("modifiedAvailabilityImpact");
        sb.append('=');
        sb.append(((this.modifiedAvailabilityImpact == null)?"<null>":this.modifiedAvailabilityImpact));
        sb.append(',');
        sb.append("environmentalScore");
        sb.append('=');
        sb.append(((this.environmentalScore == null)?"<null>":this.environmentalScore));
        sb.append(',');
        sb.append("environmentalSeverity");
        sb.append('=');
        sb.append(((this.environmentalSeverity == null)?"<null>":this.environmentalSeverity));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.modifiedPrivilegesRequired == null)? 0 :this.modifiedPrivilegesRequired.hashCode()));
        result = ((result* 31)+((this.reportConfidence == null)? 0 :this.reportConfidence.hashCode()));
        result = ((result* 31)+((this.modifiedConfidentialityImpact == null)? 0 :this.modifiedConfidentialityImpact.hashCode()));
        result = ((result* 31)+((this.availabilityImpact == null)? 0 :this.availabilityImpact.hashCode()));
        result = ((result* 31)+((this.privilegesRequired == null)? 0 :this.privilegesRequired.hashCode()));
        result = ((result* 31)+((this.baseScore == null)? 0 :this.baseScore.hashCode()));
        result = ((result* 31)+((this.temporalSeverity == null)? 0 :this.temporalSeverity.hashCode()));
        result = ((result* 31)+((this.userInteraction == null)? 0 :this.userInteraction.hashCode()));
        result = ((result* 31)+((this.integrityRequirement == null)? 0 :this.integrityRequirement.hashCode()));
        result = ((result* 31)+((this.modifiedAvailabilityImpact == null)? 0 :this.modifiedAvailabilityImpact.hashCode()));
        result = ((result* 31)+((this.availabilityRequirement == null)? 0 :this.availabilityRequirement.hashCode()));
        result = ((result* 31)+((this.modifiedScope == null)? 0 :this.modifiedScope.hashCode()));
        result = ((result* 31)+((this.attackComplexity == null)? 0 :this.attackComplexity.hashCode()));
        result = ((result* 31)+((this.scope == null)? 0 :this.scope.hashCode()));
        result = ((result* 31)+((this.attackVector == null)? 0 :this.attackVector.hashCode()));
        result = ((result* 31)+((this.integrityImpact == null)? 0 :this.integrityImpact.hashCode()));
        result = ((result* 31)+((this.modifiedIntegrityImpact == null)? 0 :this.modifiedIntegrityImpact.hashCode()));
        result = ((result* 31)+((this.vectorString == null)? 0 :this.vectorString.hashCode()));
        result = ((result* 31)+((this.exploitCodeMaturity == null)? 0 :this.exploitCodeMaturity.hashCode()));
        result = ((result* 31)+((this.temporalScore == null)? 0 :this.temporalScore.hashCode()));
        result = ((result* 31)+((this.modifiedAttackVector == null)? 0 :this.modifiedAttackVector.hashCode()));
        result = ((result* 31)+((this.version == null)? 0 :this.version.hashCode()));
        result = ((result* 31)+((this.confidentialityRequirement == null)? 0 :this.confidentialityRequirement.hashCode()));
        result = ((result* 31)+((this.remediationLevel == null)? 0 :this.remediationLevel.hashCode()));
        result = ((result* 31)+((this.modifiedUserInteraction == null)? 0 :this.modifiedUserInteraction.hashCode()));
        result = ((result* 31)+((this.modifiedAttackComplexity == null)? 0 :this.modifiedAttackComplexity.hashCode()));
        result = ((result* 31)+((this.baseSeverity == null)? 0 :this.baseSeverity.hashCode()));
        result = ((result* 31)+((this.confidentialityImpact == null)? 0 :this.confidentialityImpact.hashCode()));
        result = ((result* 31)+((this.environmentalScore == null)? 0 :this.environmentalScore.hashCode()));
        result = ((result* 31)+((this.environmentalSeverity == null)? 0 :this.environmentalSeverity.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CvssV3X) == false) {
            return false;
        }
        CvssV3X rhs = ((CvssV3X) other);
        return (((((((((((((((((((((((((((((((this.modifiedPrivilegesRequired == rhs.modifiedPrivilegesRequired)||((this.modifiedPrivilegesRequired!= null)&&this.modifiedPrivilegesRequired.equals(rhs.modifiedPrivilegesRequired)))&&((this.reportConfidence == rhs.reportConfidence)||((this.reportConfidence!= null)&&this.reportConfidence.equals(rhs.reportConfidence))))&&((this.modifiedConfidentialityImpact == rhs.modifiedConfidentialityImpact)||((this.modifiedConfidentialityImpact!= null)&&this.modifiedConfidentialityImpact.equals(rhs.modifiedConfidentialityImpact))))&&((this.availabilityImpact == rhs.availabilityImpact)||((this.availabilityImpact!= null)&&this.availabilityImpact.equals(rhs.availabilityImpact))))&&((this.privilegesRequired == rhs.privilegesRequired)||((this.privilegesRequired!= null)&&this.privilegesRequired.equals(rhs.privilegesRequired))))&&((this.baseScore == rhs.baseScore)||((this.baseScore!= null)&&this.baseScore.equals(rhs.baseScore))))&&((this.temporalSeverity == rhs.temporalSeverity)||((this.temporalSeverity!= null)&&this.temporalSeverity.equals(rhs.temporalSeverity))))&&((this.userInteraction == rhs.userInteraction)||((this.userInteraction!= null)&&this.userInteraction.equals(rhs.userInteraction))))&&((this.integrityRequirement == rhs.integrityRequirement)||((this.integrityRequirement!= null)&&this.integrityRequirement.equals(rhs.integrityRequirement))))&&((this.modifiedAvailabilityImpact == rhs.modifiedAvailabilityImpact)||((this.modifiedAvailabilityImpact!= null)&&this.modifiedAvailabilityImpact.equals(rhs.modifiedAvailabilityImpact))))&&((this.availabilityRequirement == rhs.availabilityRequirement)||((this.availabilityRequirement!= null)&&this.availabilityRequirement.equals(rhs.availabilityRequirement))))&&((this.modifiedScope == rhs.modifiedScope)||((this.modifiedScope!= null)&&this.modifiedScope.equals(rhs.modifiedScope))))&&((this.attackComplexity == rhs.attackComplexity)||((this.attackComplexity!= null)&&this.attackComplexity.equals(rhs.attackComplexity))))&&((this.scope == rhs.scope)||((this.scope!= null)&&this.scope.equals(rhs.scope))))&&((this.attackVector == rhs.attackVector)||((this.attackVector!= null)&&this.attackVector.equals(rhs.attackVector))))&&((this.integrityImpact == rhs.integrityImpact)||((this.integrityImpact!= null)&&this.integrityImpact.equals(rhs.integrityImpact))))&&((this.modifiedIntegrityImpact == rhs.modifiedIntegrityImpact)||((this.modifiedIntegrityImpact!= null)&&this.modifiedIntegrityImpact.equals(rhs.modifiedIntegrityImpact))))&&((this.vectorString == rhs.vectorString)||((this.vectorString!= null)&&this.vectorString.equals(rhs.vectorString))))&&((this.exploitCodeMaturity == rhs.exploitCodeMaturity)||((this.exploitCodeMaturity!= null)&&this.exploitCodeMaturity.equals(rhs.exploitCodeMaturity))))&&((this.temporalScore == rhs.temporalScore)||((this.temporalScore!= null)&&this.temporalScore.equals(rhs.temporalScore))))&&((this.modifiedAttackVector == rhs.modifiedAttackVector)||((this.modifiedAttackVector!= null)&&this.modifiedAttackVector.equals(rhs.modifiedAttackVector))))&&((this.version == rhs.version)||((this.version!= null)&&this.version.equals(rhs.version))))&&((this.confidentialityRequirement == rhs.confidentialityRequirement)||((this.confidentialityRequirement!= null)&&this.confidentialityRequirement.equals(rhs.confidentialityRequirement))))&&((this.remediationLevel == rhs.remediationLevel)||((this.remediationLevel!= null)&&this.remediationLevel.equals(rhs.remediationLevel))))&&((this.modifiedUserInteraction == rhs.modifiedUserInteraction)||((this.modifiedUserInteraction!= null)&&this.modifiedUserInteraction.equals(rhs.modifiedUserInteraction))))&&((this.modifiedAttackComplexity == rhs.modifiedAttackComplexity)||((this.modifiedAttackComplexity!= null)&&this.modifiedAttackComplexity.equals(rhs.modifiedAttackComplexity))))&&((this.baseSeverity == rhs.baseSeverity)||((this.baseSeverity!= null)&&this.baseSeverity.equals(rhs.baseSeverity))))&&((this.confidentialityImpact == rhs.confidentialityImpact)||((this.confidentialityImpact!= null)&&this.confidentialityImpact.equals(rhs.confidentialityImpact))))&&((this.environmentalScore == rhs.environmentalScore)||((this.environmentalScore!= null)&&this.environmentalScore.equals(rhs.environmentalScore))))&&((this.environmentalSeverity == rhs.environmentalSeverity)||((this.environmentalSeverity!= null)&&this.environmentalSeverity.equals(rhs.environmentalSeverity))));
    }

    public enum AttackComplexityType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW");
        private final String value;
        private final static Map<String, CvssV3X.AttackComplexityType> CONSTANTS = new HashMap<String, CvssV3X.AttackComplexityType>();

        static {
            for (CvssV3X.AttackComplexityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private AttackComplexityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.AttackComplexityType fromValue(String value) {
            CvssV3X.AttackComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum AttackVectorType {

        @SerializedName("NETWORK")
        NETWORK("NETWORK"),
        @SerializedName("ADJACENT_NETWORK")
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        @SerializedName("LOCAL")
        LOCAL("LOCAL"),
        @SerializedName("PHYSICAL")
        PHYSICAL("PHYSICAL");
        private final String value;
        private final static Map<String, CvssV3X.AttackVectorType> CONSTANTS = new HashMap<String, CvssV3X.AttackVectorType>();

        static {
            for (CvssV3X.AttackVectorType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private AttackVectorType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.AttackVectorType fromValue(String value) {
            CvssV3X.AttackVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum CiaRequirementType {

        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("MEDIUM")
        MEDIUM("MEDIUM"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.CiaRequirementType> CONSTANTS = new HashMap<String, CvssV3X.CiaRequirementType>();

        static {
            for (CvssV3X.CiaRequirementType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private CiaRequirementType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.CiaRequirementType fromValue(String value) {
            CvssV3X.CiaRequirementType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum CiaType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("HIGH")
        HIGH("HIGH");
        private final String value;
        private final static Map<String, CvssV3X.CiaType> CONSTANTS = new HashMap<String, CvssV3X.CiaType>();

        static {
            for (CvssV3X.CiaType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private CiaType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.CiaType fromValue(String value) {
            CvssV3X.CiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ConfidenceType {

        @SerializedName("UNKNOWN")
        UNKNOWN("UNKNOWN"),
        @SerializedName("REASONABLE")
        REASONABLE("REASONABLE"),
        @SerializedName("CONFIRMED")
        CONFIRMED("CONFIRMED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.ConfidenceType> CONSTANTS = new HashMap<String, CvssV3X.ConfidenceType>();

        static {
            for (CvssV3X.ConfidenceType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ConfidenceType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.ConfidenceType fromValue(String value) {
            CvssV3X.ConfidenceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ExploitCodeMaturityType {

        @SerializedName("UNPROVEN")
        UNPROVEN("UNPROVEN"),
        @SerializedName("PROOF_OF_CONCEPT")
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        @SerializedName("FUNCTIONAL")
        FUNCTIONAL("FUNCTIONAL"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.ExploitCodeMaturityType> CONSTANTS = new HashMap<String, CvssV3X.ExploitCodeMaturityType>();

        static {
            for (CvssV3X.ExploitCodeMaturityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ExploitCodeMaturityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.ExploitCodeMaturityType fromValue(String value) {
            CvssV3X.ExploitCodeMaturityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ModifiedAttackComplexityType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.ModifiedAttackComplexityType> CONSTANTS = new HashMap<String, CvssV3X.ModifiedAttackComplexityType>();

        static {
            for (CvssV3X.ModifiedAttackComplexityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ModifiedAttackComplexityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.ModifiedAttackComplexityType fromValue(String value) {
            CvssV3X.ModifiedAttackComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ModifiedAttackVectorType {

        @SerializedName("NETWORK")
        NETWORK("NETWORK"),
        @SerializedName("ADJACENT_NETWORK")
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        @SerializedName("LOCAL")
        LOCAL("LOCAL"),
        @SerializedName("PHYSICAL")
        PHYSICAL("PHYSICAL"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.ModifiedAttackVectorType> CONSTANTS = new HashMap<String, CvssV3X.ModifiedAttackVectorType>();

        static {
            for (CvssV3X.ModifiedAttackVectorType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ModifiedAttackVectorType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.ModifiedAttackVectorType fromValue(String value) {
            CvssV3X.ModifiedAttackVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ModifiedCiaType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.ModifiedCiaType> CONSTANTS = new HashMap<String, CvssV3X.ModifiedCiaType>();

        static {
            for (CvssV3X.ModifiedCiaType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ModifiedCiaType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.ModifiedCiaType fromValue(String value) {
            CvssV3X.ModifiedCiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ModifiedPrivilegesRequiredType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.ModifiedPrivilegesRequiredType> CONSTANTS = new HashMap<String, CvssV3X.ModifiedPrivilegesRequiredType>();

        static {
            for (CvssV3X.ModifiedPrivilegesRequiredType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ModifiedPrivilegesRequiredType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.ModifiedPrivilegesRequiredType fromValue(String value) {
            CvssV3X.ModifiedPrivilegesRequiredType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ModifiedScopeType {

        @SerializedName("UNCHANGED")
        UNCHANGED("UNCHANGED"),
        @SerializedName("CHANGED")
        CHANGED("CHANGED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.ModifiedScopeType> CONSTANTS = new HashMap<String, CvssV3X.ModifiedScopeType>();

        static {
            for (CvssV3X.ModifiedScopeType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ModifiedScopeType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.ModifiedScopeType fromValue(String value) {
            CvssV3X.ModifiedScopeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ModifiedUserInteractionType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("REQUIRED")
        REQUIRED("REQUIRED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.ModifiedUserInteractionType> CONSTANTS = new HashMap<String, CvssV3X.ModifiedUserInteractionType>();

        static {
            for (CvssV3X.ModifiedUserInteractionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ModifiedUserInteractionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.ModifiedUserInteractionType fromValue(String value) {
            CvssV3X.ModifiedUserInteractionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum PrivilegesRequiredType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("NONE")
        NONE("NONE");
        private final String value;
        private final static Map<String, CvssV3X.PrivilegesRequiredType> CONSTANTS = new HashMap<String, CvssV3X.PrivilegesRequiredType>();

        static {
            for (CvssV3X.PrivilegesRequiredType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private PrivilegesRequiredType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.PrivilegesRequiredType fromValue(String value) {
            CvssV3X.PrivilegesRequiredType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum RemediationLevelType {

        @SerializedName("OFFICIAL_FIX")
        OFFICIAL_FIX("OFFICIAL_FIX"),
        @SerializedName("TEMPORARY_FIX")
        TEMPORARY_FIX("TEMPORARY_FIX"),
        @SerializedName("WORKAROUND")
        WORKAROUND("WORKAROUND"),
        @SerializedName("UNAVAILABLE")
        UNAVAILABLE("UNAVAILABLE"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV3X.RemediationLevelType> CONSTANTS = new HashMap<String, CvssV3X.RemediationLevelType>();

        static {
            for (CvssV3X.RemediationLevelType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private RemediationLevelType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.RemediationLevelType fromValue(String value) {
            CvssV3X.RemediationLevelType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum ScopeType {

        @SerializedName("UNCHANGED")
        UNCHANGED("UNCHANGED"),
        @SerializedName("CHANGED")
        CHANGED("CHANGED");
        private final String value;
        private final static Map<String, CvssV3X.ScopeType> CONSTANTS = new HashMap<String, CvssV3X.ScopeType>();

        static {
            for (CvssV3X.ScopeType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ScopeType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.ScopeType fromValue(String value) {
            CvssV3X.ScopeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum SeverityType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("MEDIUM")
        MEDIUM("MEDIUM"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("CRITICAL")
        CRITICAL("CRITICAL");
        private final String value;
        private final static Map<String, CvssV3X.SeverityType> CONSTANTS = new HashMap<String, CvssV3X.SeverityType>();

        static {
            for (CvssV3X.SeverityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private SeverityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.SeverityType fromValue(String value) {
            CvssV3X.SeverityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    public enum UserInteractionType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("REQUIRED")
        REQUIRED("REQUIRED");
        private final String value;
        private final static Map<String, CvssV3X.UserInteractionType> CONSTANTS = new HashMap<String, CvssV3X.UserInteractionType>();

        static {
            for (CvssV3X.UserInteractionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private UserInteractionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.UserInteractionType fromValue(String value) {
            CvssV3X.UserInteractionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * CVSS Version
     * 
     */
    public enum Version {

        @SerializedName("3.0")
        _3_0("3.0"),
        @SerializedName("3.1")
        _3_1("3.1");
        private final String value;
        private final static Map<String, CvssV3X.Version> CONSTANTS = new HashMap<String, CvssV3X.Version>();

        static {
            for (CvssV3X.Version c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Version(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV3X.Version fromValue(String value) {
            CvssV3X.Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
