/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.pom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.owasp.dependencycheck.xml.XmlInputStream;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomHandler;
import org.owasp.dependencycheck.xml.pom.PomParseException;
import org.owasp.dependencycheck.xml.pom.PomProjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@ThreadSafe
public class PomParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomParser.class);

    public Model parse(File file) throws PomParseException {
        Model model;
        FileInputStream fis = new FileInputStream(file);
        Throwable throwable = null;
        try {
            model = this.parse(fis);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    PomParser.$closeResource(throwable, fis);
                    throw throwable3;
                }
            }
            catch (IOException ex) {
                if (ex instanceof PomParseException) {
                    throw (PomParseException)ex;
                }
                LOGGER.debug("", (Throwable)ex);
                throw new PomParseException(String.format("Unable to parse pom '%s'", file.toString()), ex);
            }
        }
        PomParser.$closeResource(throwable, fis);
        return model;
    }

    public Model parseWithoutDocTypeCleanup(File file) throws PomParseException {
        Model model;
        FileInputStream fis = new FileInputStream(file);
        Throwable throwable = null;
        try {
            model = this.parseWithoutDocTypeCleanup(fis);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    PomParser.$closeResource(throwable, fis);
                    throw throwable3;
                }
            }
            catch (IOException ex) {
                if (ex instanceof PomParseException) {
                    throw (PomParseException)ex;
                }
                LOGGER.debug("", (Throwable)ex);
                throw new PomParseException(String.format("Unable to parse pom '%s'", file.toString()), ex);
            }
        }
        PomParser.$closeResource(throwable, fis);
        return model;
    }

    public Model parse(InputStream inputStream) throws PomParseException {
        try {
            PomHandler handler = new PomHandler();
            SAXParser saxParser = XmlUtils.buildSecureSaxParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            BOMInputStream bomStream = new BOMInputStream((InputStream)new XmlInputStream(new PomProjectInputStream(inputStream)));
            ByteOrderMark bom = bomStream.getBOM();
            String defaultEncoding = StandardCharsets.UTF_8.name();
            String charsetName = bom == null ? defaultEncoding : bom.getCharsetName();
            InputStreamReader reader = new InputStreamReader((InputStream)bomStream, charsetName);
            InputSource in = new InputSource(reader);
            xmlReader.parse(in);
            return handler.getModel();
        }
        catch (FileNotFoundException | ParserConfigurationException | SAXException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
    }

    public Model parseWithoutDocTypeCleanup(InputStream inputStream) throws PomParseException {
        try {
            PomHandler handler = new PomHandler();
            SAXParser saxParser = XmlUtils.buildSecureSaxParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            BOMInputStream bomStream = new BOMInputStream((InputStream)new XmlInputStream(inputStream));
            ByteOrderMark bom = bomStream.getBOM();
            String defaultEncoding = StandardCharsets.UTF_8.name();
            String charsetName = bom == null ? defaultEncoding : bom.getCharsetName();
            InputStreamReader reader = new InputStreamReader((InputStream)bomStream, charsetName);
            InputSource in = new InputSource(reader);
            xmlReader.parse(in);
            return handler.getModel();
        }
        catch (FileNotFoundException | ParserConfigurationException | SAXException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new PomParseException(ex);
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

