/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import com.moandjiezana.toml.Toml;
import java.io.FileFilter;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class GolangDepAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GolangDepAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "Golang";
    private static final String GOPKG_LOCK = "Gopkg.lock";
    private static final FileFilter GOPKG_LOCK_FILTER = FileFilterBuilder.newInstance().addFilenames("Gopkg.lock").build();

    @Override
    public String getName() {
        return "Golang Dep Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.golang.dep.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return GOPKG_LOCK_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        engine.removeDependency(dependency);
        Toml result = new Toml().read(dependency.getActualFile());
        List projectsLocks = result.getTables("projects");
        if (projectsLocks == null) {
            return;
        }
        projectsLocks.forEach(project -> {
            String name = project.getString("name");
            String version = project.getString("version");
            String revision = project.getString("revision");
            Dependency dep = this.createDependency(dependency, name, version, revision, null);
            engine.addDependency(dep);
            List packages = project.getList("packages");
            for (String pkg : packages) {
                if (!StringUtils.isNotBlank((CharSequence)pkg) || ".".equals(pkg)) continue;
                dep = this.createDependency(dependency, name, version, revision, pkg);
                engine.addDependency(dep);
            }
        });
    }

    private Dependency createDependency(Dependency parentDependency, String name, String version, String revision, String subPath) {
        Identifier id;
        Dependency dep = new Dependency(parentDependency.getActualFile(), true);
        dep.setEcosystem(DEPENDENCY_ECOSYSTEM);
        if (StringUtils.isNotBlank((CharSequence)subPath)) {
            dep.setDisplayFileName(name + "/" + subPath);
            dep.setName(name + "/" + subPath);
        } else {
            dep.setDisplayFileName(name);
            dep.setName(name);
        }
        PackageURLBuilder packageBuilder = PackageURLBuilder.aPackageURL().withType("golang");
        String baseNamespace = null;
        String depNamespace = null;
        String depName = null;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            int slashPos = name.indexOf("/");
            if (slashPos > 0) {
                baseNamespace = name.substring(0, slashPos);
                int lastSlash = name.lastIndexOf("/");
                depName = name.substring(lastSlash + 1);
                if (lastSlash != slashPos) {
                    depNamespace = name.substring(slashPos + 1, lastSlash);
                    dep.addEvidence(EvidenceType.PRODUCT, GOPKG_LOCK, "namespace", depNamespace, Confidence.HIGH);
                    dep.addEvidence(EvidenceType.VENDOR, GOPKG_LOCK, "namespace", depNamespace, Confidence.HIGH);
                    packageBuilder.withNamespace(baseNamespace + "/" + depNamespace);
                } else {
                    packageBuilder.withNamespace(baseNamespace);
                }
                packageBuilder.withName(depName);
                if (!"golang.org".equals(baseNamespace)) {
                    dep.addEvidence(EvidenceType.PRODUCT, GOPKG_LOCK, "namespace", baseNamespace, Confidence.LOW);
                    dep.addEvidence(EvidenceType.VENDOR, GOPKG_LOCK, "namespace", baseNamespace, Confidence.LOW);
                }
                dep.addEvidence(EvidenceType.PRODUCT, GOPKG_LOCK, "name", depName, Confidence.HIGHEST);
                dep.addEvidence(EvidenceType.VENDOR, GOPKG_LOCK, "name", depName, Confidence.HIGHEST);
            } else {
                packageBuilder.withName(name);
                dep.addEvidence(EvidenceType.PRODUCT, GOPKG_LOCK, "namespace", name, Confidence.HIGHEST);
                dep.addEvidence(EvidenceType.VENDOR, GOPKG_LOCK, "namespace", name, Confidence.HIGHEST);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)version)) {
            packageBuilder.withVersion(version);
            dep.setVersion(version);
            dep.addEvidence(EvidenceType.VERSION, GOPKG_LOCK, "version", version, Confidence.HIGHEST);
        }
        if (StringUtils.isNotBlank((CharSequence)revision) && version == null) {
            packageBuilder.withVersion(revision);
        }
        if (StringUtils.isNotBlank((CharSequence)subPath)) {
            packageBuilder.withSubpath(subPath);
            dep.addEvidence(EvidenceType.PRODUCT, GOPKG_LOCK, "package", subPath, Confidence.HIGH);
            dep.addEvidence(EvidenceType.VENDOR, GOPKG_LOCK, "package", subPath, Confidence.MEDIUM);
        }
        try {
            PackageURL purl = packageBuilder.build();
            id = new PurlIdentifier(purl, Confidence.HIGHEST);
        }
        catch (MalformedPackageURLException ex) {
            LOGGER.warn("Unable to create package-url identifier for `{}` in `{}` - reason: {}", new Object[]{name, parentDependency.getFilePath(), ex.getMessage()});
            StringBuilder value = new StringBuilder(name);
            if (StringUtils.isNotBlank((CharSequence)subPath)) {
                value.append("/").append(subPath);
            }
            if (StringUtils.isNotBlank((CharSequence)version)) {
                value.append("@").append(version);
            }
            id = new GenericIdentifier(value.toString(), Confidence.HIGH);
        }
        dep.addSoftwareIdentifier(id);
        dep.setSha1sum(Checksum.getSHA1Checksum((String)((Object)id).toString()));
        dep.setMd5sum(Checksum.getMD5Checksum((String)((Object)id).toString()));
        dep.setSha256sum(Checksum.getSHA256Checksum((String)((Object)id).toString()));
        return dep;
    }
}

