/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.golang;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonParsingException;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.golang.GoModDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class GoModJsonParser {
    private final JsonReader jsonReader;
    private final List<GoModDependency> goModDependencies;
    private static final Logger LOGGER = LoggerFactory.getLogger(GoModJsonParser.class);

    public GoModJsonParser(InputStream inputStream) {
        LOGGER.debug("Creating a ComposerLockParser");
        this.jsonReader = Json.createReader((InputStream)inputStream);
        this.goModDependencies = new ArrayList<GoModDependency>();
    }

    public void process() throws AnalysisException {
        LOGGER.debug("Beginning go.mod processing");
        try {
            JsonObject composer = this.jsonReader.readObject();
            if (composer.containsKey((Object)"Require")) {
                LOGGER.debug("Found modules");
                JsonArray modules = composer.getJsonArray("Require");
                for (JsonObject module : modules.getValuesAs(JsonObject.class)) {
                    String path = module.getString("Path");
                    String version = module.getString("Version");
                    if (version.startsWith("v")) {
                        version = version.substring(1);
                    }
                    this.goModDependencies.add(new GoModDependency(path, version));
                }
            }
        }
        catch (JsonParsingException jsonpe) {
            throw new AnalysisException("Error parsing stream", jsonpe);
        }
        catch (JsonException jsone) {
            throw new AnalysisException("Error reading stream", jsone);
        }
        catch (IllegalStateException ise) {
            throw new AnalysisException("Illegal state in go mod stream", ise);
        }
        catch (ClassCastException cce) {
            throw new AnalysisException("JSON not exactly matching output of `go mod edit -json`", cce);
        }
    }

    public List<GoModDependency> getDependencies() {
        return this.goModDependencies;
    }
}

