/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.data.nvdcve.DriverLoadException;
import org.owasp.dependencycheck.data.nvdcve.DriverShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class DriverLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverLoader.class);

    public static void cleanup(Driver driver) {
        try {
            DriverManager.deregisterDriver(driver);
        }
        catch (SQLException ex) {
            LOGGER.debug("An error occurred unloading the database driver", (Throwable)ex);
        }
        catch (Throwable unexpected) {
            LOGGER.debug("An unexpected throwable occurred unloading the database driver", unexpected);
        }
    }

    private DriverLoader() {
    }

    public static Driver load(String className) throws DriverLoadException {
        ClassLoader loader = DriverLoader.class.getClassLoader();
        return DriverLoader.load(className, loader);
    }

    public static Driver load(String className, String pathToDriver) throws DriverLoadException {
        String[] paths;
        final ClassLoader parent = ClassLoader.getSystemClassLoader();
        final ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths = pathToDriver.split(File.pathSeparator)) {
            File file = new File(path);
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    try {
                        urls.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        LOGGER.debug("Unable to load database driver '{}'; invalid path provided '{}'", new Object[]{className, f.getAbsoluteFile(), ex});
                        throw new DriverLoadException("Unable to load database driver. Invalid path provided", ex);
                    }
                }
                continue;
            }
            if (!file.exists()) continue;
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                LOGGER.debug("Unable to load database driver '{}'; invalid path provided '{}'", new Object[]{className, file.getAbsoluteFile(), ex});
                throw new DriverLoadException("Unable to load database driver. Invalid path provided", ex);
            }
        }
        URLClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[0]), parent);
            }
        });
        return DriverLoader.load(className, loader);
    }

    private static Driver load(String className, ClassLoader loader) throws DriverLoadException {
        try {
            Class<?> c = Class.forName(className, true, loader);
            Driver driver = (Driver)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DriverShim shim = new DriverShim(driver);
            DriverManager.registerDriver(shim);
            return shim;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | SQLException ex) {
            String msg = String.format("Unable to load database driver '%s'", className);
            LOGGER.debug(msg, (Throwable)ex);
            throw new DriverLoadException(msg, ex);
        }
    }
}

