/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.ossindex.OssindexClientFactory;
import org.owasp.dependencycheck.dependency.CvssV2;
import org.owasp.dependencycheck.dependency.CvssV3;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.VulnerableSoftwareBuilder;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.ossindex.service.api.componentreport.ComponentReport;
import org.sonatype.ossindex.service.api.componentreport.ComponentReportVulnerability;
import org.sonatype.ossindex.service.api.cvss.Cvss2Severity;
import org.sonatype.ossindex.service.api.cvss.Cvss2Vector;
import org.sonatype.ossindex.service.api.cvss.Cvss3Severity;
import org.sonatype.ossindex.service.api.cvss.Cvss3Vector;
import org.sonatype.ossindex.service.api.cvss.CvssVector;
import org.sonatype.ossindex.service.api.cvss.CvssVectorFactory;
import org.sonatype.ossindex.service.client.OssindexClient;
import org.sonatype.ossindex.service.client.transport.Transport;
import us.springett.parsers.cpe.exceptions.CpeValidationException;
import us.springett.parsers.cpe.values.Part;

public class OssIndexAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(OssIndexAnalyzer.class);
    private static final Pattern CVE_PATTERN = Pattern.compile("\\bCVE-\\d{4}-\\d{4,10}\\b");
    public static final String REFERENCE_TYPE = "OSSINDEX";
    private OssindexClient client;
    private Map<PackageUrl, ComponentReport> reports;
    private boolean failed = false;
    private final Object fetchMutex = new Object();

    @Override
    public String getName() {
        return "Sonatype OSS Index Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS_PHASE2;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.ossindex.enabled";
    }

    @Override
    public boolean supportsParallelProcessing() {
        return true;
    }

    @Override
    protected void prepareAnalyzer(Engine engine) throws InitializationException {
        this.client = OssindexClientFactory.create(this.getSettings());
    }

    @Override
    protected void closeAnalyzer() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        this.client = null;
        this.reports = null;
        this.failed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (this.client == null) {
            throw new IllegalStateException();
        }
        Object object = this.fetchMutex;
        synchronized (object) {
            if (!this.failed && this.reports == null) {
                try {
                    this.reports = this.requestReports(engine.getDependencies());
                }
                catch (Transport.TransportException ex) {
                    this.failed = true;
                    if (ex.getMessage() != null && ex.getMessage().endsWith("401")) {
                        throw new AnalysisException("Invalid credentails provided for OSS Index", ex);
                    }
                    LOG.debug("Error requesting component reports", (Throwable)ex);
                    throw new AnalysisException("Failed to request component-reports", ex);
                }
                catch (Exception e) {
                    LOG.debug("Error requesting component reports", (Throwable)e);
                    this.failed = true;
                    throw new AnalysisException("Failed to request component-reports", e);
                }
            }
        }
        if (!this.failed) {
            this.enrich(dependency);
        }
    }

    @Nullable
    private PackageUrl parsePackageUrl(String value) {
        try {
            return PackageUrl.parse((String)value);
        }
        catch (PackageUrl.InvalidException e) {
            LOG.warn("Invalid Package-URL: {}", (Object)value, (Object)e);
            return null;
        }
    }

    private Map<PackageUrl, ComponentReport> requestReports(Dependency[] dependencies) throws Exception {
        LOG.debug("Requesting component-reports for {} dependencies", (Object)dependencies.length);
        ArrayList<PackageUrl> packages = new ArrayList<PackageUrl>();
        for (Dependency dependency : dependencies) {
            for (Identifier id : dependency.getSoftwareIdentifiers()) {
                PackageUrl purl;
                if (!(id instanceof PurlIdentifier) || (purl = this.parsePackageUrl(id.getValue())) == null || !StringUtils.isNotBlank((CharSequence)purl.getVersion())) continue;
                LOG.debug("oss index adding package: {}", (Object)purl);
                packages.add(purl);
            }
        }
        if (!packages.isEmpty()) {
            return this.client.requestComponentReports(packages);
        }
        LOG.warn("Unable to determine Package-URL identifiers for {} dependencies", (Object)dependencies.length);
        return Collections.emptyMap();
    }

    private void enrich(Dependency dependency) {
        LOG.debug("Enrich dependency: {}", (Object)dependency);
        for (Identifier id : dependency.getSoftwareIdentifiers()) {
            if (!(id instanceof PurlIdentifier)) continue;
            LOG.debug("  Package: {} -> {}", (Object)id, (Object)id.getConfidence());
            PackageUrl purl = this.parsePackageUrl(id.getValue());
            if (purl == null || !StringUtils.isNotBlank((CharSequence)purl.getVersion())) continue;
            try {
                ComponentReport report = this.reports.get(purl);
                if (report == null) {
                    LOG.debug("Missing component-report for: " + purl);
                    continue;
                }
                id.setUrl(report.getReference().toString());
                for (ComponentReportVulnerability vuln : report.getVulnerabilities()) {
                    Vulnerability v = this.transform(report, vuln);
                    Vulnerability existing = dependency.getVulnerabilities().stream().filter(e -> e.getName().equals(v.getName())).findFirst().orElse(null);
                    if (existing != null) {
                        existing.getReferences().addAll(v.getReferences());
                        continue;
                    }
                    dependency.addVulnerability(v);
                }
            }
            catch (Exception e2) {
                LOG.warn("Failed to fetch component-report for: {}", (Object)purl, (Object)e2);
            }
        }
    }

    private Vulnerability transform(ComponentReport report, ComponentReportVulnerability source) {
        float cvssScore;
        Vulnerability result = new Vulnerability();
        result.setSource(Vulnerability.Source.OSSINDEX);
        if (source.getCve() != null) {
            result.setName(source.getCve());
        } else {
            Matcher matcher;
            String cve = null;
            if (source.getTitle() != null) {
                matcher = CVE_PATTERN.matcher(source.getTitle());
                cve = matcher.find() ? matcher.group() : source.getTitle();
            }
            if (cve == null && source.getReference() != null && (matcher = CVE_PATTERN.matcher(source.getReference().toString())).find()) {
                cve = matcher.group();
            }
            result.setName(cve != null ? cve : source.getId());
        }
        result.setDescription(source.getDescription());
        result.addCwe(source.getCwe());
        float f = cvssScore = source.getCvssScore() != null ? source.getCvssScore().floatValue() : -1.0f;
        if (source.getCvssVector() != null) {
            CvssVector cvssVector = CvssVectorFactory.create((String)source.getCvssVector());
            Map metrics = cvssVector.getMetrics();
            if (cvssVector instanceof Cvss2Vector) {
                result.setCvssV2(new CvssV2(cvssScore, (String)metrics.get("AV"), (String)metrics.get("AC"), (String)metrics.get("Au"), (String)metrics.get("C"), (String)metrics.get("I"), (String)metrics.get("A"), Cvss2Severity.of((Float)Float.valueOf(cvssScore)).name()));
            } else if (cvssVector instanceof Cvss3Vector) {
                result.setCvssV3(new CvssV3((String)metrics.get("AV"), (String)metrics.get("AC"), (String)metrics.get("PR"), (String)metrics.get("UI"), (String)metrics.get("S"), (String)metrics.get("C"), (String)metrics.get("I"), (String)metrics.get("A"), cvssScore, Cvss3Severity.of((Float)Float.valueOf(cvssScore)).name()));
            } else {
                LOG.warn("Unsupported CVSS vector: {}", (Object)cvssVector);
                result.setUnscoredSeverity(Float.toString(cvssScore));
            }
        } else {
            LOG.debug("OSS has no vector for {}", (Object)result.getName());
            result.setUnscoredSeverity(Float.toString(cvssScore));
        }
        result.addReference(REFERENCE_TYPE, source.getTitle(), source.getReference().toString());
        PackageUrl purl = report.getCoordinates();
        try {
            VulnerableSoftwareBuilder builder = new VulnerableSoftwareBuilder().part(Part.APPLICATION).vendor(purl.getNamespaceAsString()).product(purl.getName()).version(purl.getVersion());
            VulnerableSoftware software = builder.build();
            result.addVulnerableSoftware(software);
            result.setMatchedVulnerableSoftware(software);
        }
        catch (CpeValidationException e) {
            LOG.warn("Unable to construct vulnerable-software for: {}", (Object)purl, (Object)e);
        }
        return result;
    }
}

