
package org.owasp.dependencycheck.data.nvd.json;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class Affects {

    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("vendor")
    @Expose
    private Vendor vendor;

    /**
     * 
     * (Required)
     * 
     */
    public Vendor getVendor() {
        return vendor;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Affects.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("vendor");
        sb.append('=');
        sb.append(((this.vendor == null)?"<null>":this.vendor));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.vendor == null)? 0 :this.vendor.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Affects) == false) {
            return false;
        }
        Affects rhs = ((Affects) other);
        return ((this.vendor == rhs.vendor)||((this.vendor!= null)&&this.vendor.equals(rhs.vendor)));
    }

}
