/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nodeaudit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmAuditParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(NpmAuditParser.class);

    public List<Advisory> parse(JSONObject jsonResponse) {
        LOGGER.debug("Parsing JSON node");
        ArrayList<Advisory> advisories = new ArrayList<Advisory>();
        JSONObject jsonAdvisories = jsonResponse.getJSONObject("advisories");
        Iterator keys = jsonAdvisories.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Advisory advisory = this.parseAdvisory(jsonAdvisories.getJSONObject(key));
            advisories.add(advisory);
        }
        return advisories;
    }

    private Advisory parseAdvisory(JSONObject object) {
        Advisory advisory = new Advisory();
        advisory.setId(object.getInt("id"));
        advisory.setOverview(object.optString("overview", null));
        advisory.setReferences(object.optString("references", null));
        advisory.setCreated(object.optString("created", null));
        advisory.setUpdated(object.optString("updated", null));
        advisory.setRecommendation(object.optString("recommendation", null));
        advisory.setTitle(object.optString("title", null));
        advisory.setModuleName(object.optString("module_name", null));
        advisory.setVulnerableVersions(object.optString("vulnerable_versions", null));
        advisory.setPatchedVersions(object.optString("patched_versions", null));
        advisory.setAccess(object.optString("access", null));
        advisory.setSeverity(object.optString("severity", null));
        advisory.setCwe(object.optString("cwe", null));
        JSONArray findings = object.optJSONArray("findings");
        for (int i = 0; i < findings.length(); ++i) {
            JSONObject finding = findings.getJSONObject(i);
            String version = finding.optString("version", null);
            JSONArray paths = finding.optJSONArray("paths");
            for (int j = 0; j < paths.length(); ++j) {
                String path = paths.getString(j);
                if (path == null || !path.equals(advisory.getModuleName())) continue;
                advisory.setVersion(version);
            }
        }
        JSONArray jsonCves = object.optJSONArray("cves");
        ArrayList<String> stringCves = new ArrayList<String>();
        if (jsonCves != null) {
            for (int j = 0; j < jsonCves.length(); ++j) {
                stringCves.add(jsonCves.getString(j));
            }
            advisory.setCves(stringCves);
        }
        return advisory;
    }
}

