/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.util.Calendar;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.owasp.dependencycheck.exception.ParseException;

@ThreadSafe
public final class DateUtil {
    private DateUtil() {
    }

    public static Calendar parseXmlDate(String xsDate) throws ParseException {
        try {
            DatatypeFactory df = DatatypeFactory.newInstance();
            XMLGregorianCalendar dateTime = df.newXMLGregorianCalendar(xsDate);
            return dateTime.toGregorianCalendar();
        }
        catch (DatatypeConfigurationException ex) {
            throw new ParseException("Unable to parse " + xsDate, ex);
        }
    }

    public static boolean withinDateRange(long date, long compareTo, int dayRange) {
        long msRange = (long)dayRange * 24L * 60L * 60L * 1000L;
        return compareTo - date < msRange;
    }
}

