/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.ossindex;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.ossindex.service.client.OssindexClient;
import org.sonatype.ossindex.service.client.OssindexClientConfiguration;
import org.sonatype.ossindex.service.client.internal.OssindexClientImpl;
import org.sonatype.ossindex.service.client.marshal.GsonMarshaller;
import org.sonatype.ossindex.service.client.marshal.Marshaller;
import org.sonatype.ossindex.service.client.transport.HttpUrlConnectionTransport;
import org.sonatype.ossindex.service.client.transport.Transport;
import org.sonatype.ossindex.service.client.transport.UserAgentSupplier;

public class OssindexClientFactory {
    public static OssindexClient create(final Settings settings) {
        OssindexClientConfiguration config = new OssindexClientConfiguration();
        String baseUrl = settings.getString("analyzer.ossindex.url", null);
        if (baseUrl != null) {
            config.setBaseUrl(baseUrl);
        }
        final UserAgentSupplier userAgent = new UserAgentSupplier("dependency-check", settings.getString("application.version", "unknown"));
        HttpUrlConnectionTransport transport = new HttpUrlConnectionTransport(userAgent){
            private final URLConnectionFactory connectionFactory;
            {
                super(arg0);
                this.connectionFactory = new URLConnectionFactory(settings);
            }

            protected HttpURLConnection connect(URL url) throws IOException {
                HttpURLConnection connection = this.connectionFactory.createHttpURLConnection(url);
                connection.setRequestProperty("User-Agent", userAgent.get());
                return connection;
            }
        };
        GsonMarshaller marshaller = new GsonMarshaller();
        return new OssindexClientImpl(config, (Transport)transport, (Marshaller)marshaller);
    }

    static {
        PackageUrl.RenderFlavor.setDefault((PackageUrl.RenderFlavor)PackageUrl.RenderFlavor.SCHEME);
    }
}

