/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.agent;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.exception.ScanAgentException;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DependencyCheckScanAgent {
    private static final String NEW_LINE = System.getProperty("line.separator", "\n").intern();
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyCheckScanAgent.class);
    private String applicationName = "Dependency-Check";
    private List<Dependency> dependencies;
    private String dataDirectory = null;
    private String reportOutputDirectory;
    private float failBuildOnCVSS = 11.0f;
    private boolean autoUpdate = true;
    private boolean updateOnly = false;
    private boolean generateReport = true;
    private ReportGenerator.Format reportFormat = ReportGenerator.Format.HTML;
    private String proxyServer;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String connectionTimeout;
    private String logFile = null;
    private boolean showSummary = true;
    private String suppressionFile;
    private String databasePassword;
    private String cpeStartsWithFilter;
    private boolean centralAnalyzerEnabled = true;
    private String centralUrl;
    private boolean nexusAnalyzerEnabled = true;
    private String nexusUrl;
    private boolean nexusUsesProxy = true;
    private String databaseDriverName;
    private String databaseDriverPath;
    private String connectionString;
    private String databaseUser;
    private String zipExtensions;
    private String cveUrlModified;
    private String cveUrlBase;
    private String pathToCore;
    private Settings settings;
    private String propertiesFilePath;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(String reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public float getFailBuildOnCVSS() {
        return this.failBuildOnCVSS;
    }

    public void setFailBuildOnCVSS(float failBuildOnCVSS) {
        this.failBuildOnCVSS = failBuildOnCVSS;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public boolean isUpdateOnly() {
        return this.updateOnly;
    }

    public void setUpdateOnly(boolean updateOnly) {
        this.updateOnly = updateOnly;
    }

    public boolean isGenerateReport() {
        return this.generateReport;
    }

    public void setGenerateReport(boolean generateReport) {
        this.generateReport = generateReport;
    }

    public ReportGenerator.Format getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(ReportGenerator.Format reportFormat) {
        this.reportFormat = reportFormat;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    @Deprecated
    public String getProxyUrl() {
        return this.proxyServer;
    }

    @Deprecated
    public void setProxyUrl(String proxyUrl) {
        this.proxyServer = proxyUrl;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getSuppressionFile() {
        return this.suppressionFile;
    }

    public void setSuppressionFile(String suppressionFile) {
        this.suppressionFile = suppressionFile;
    }

    public boolean isShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(boolean showSummary) {
        this.showSummary = showSummary;
    }

    public void setCpeStartsWithFilter(String cpeStartsWithFilter) {
        this.cpeStartsWithFilter = cpeStartsWithFilter;
    }

    public String getCpeStartsWithFilter() {
        return this.cpeStartsWithFilter;
    }

    public boolean isCentralAnalyzerEnabled() {
        return this.centralAnalyzerEnabled;
    }

    public void setCentralAnalyzerEnabled(boolean centralAnalyzerEnabled) {
        this.centralAnalyzerEnabled = centralAnalyzerEnabled;
    }

    public String getCentralUrl() {
        return this.centralUrl;
    }

    public void setCentralUrl(String centralUrl) {
        this.centralUrl = centralUrl;
    }

    public boolean isNexusAnalyzerEnabled() {
        return this.nexusAnalyzerEnabled;
    }

    public void setNexusAnalyzerEnabled(boolean nexusAnalyzerEnabled) {
        this.nexusAnalyzerEnabled = nexusAnalyzerEnabled;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public void setNexusUrl(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    public boolean isNexusUsesProxy() {
        return this.nexusUsesProxy;
    }

    public void setNexusUsesProxy(boolean nexusUsesProxy) {
        this.nexusUsesProxy = nexusUsesProxy;
    }

    public String getDatabaseDriverName() {
        return this.databaseDriverName;
    }

    public void setDatabaseDriverName(String databaseDriverName) {
        this.databaseDriverName = databaseDriverName;
    }

    public String getDatabaseDriverPath() {
        return this.databaseDriverPath;
    }

    public void setDatabaseDriverPath(String databaseDriverPath) {
        this.databaseDriverPath = databaseDriverPath;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getZipExtensions() {
        return this.zipExtensions;
    }

    public void setZipExtensions(String zipExtensions) {
        this.zipExtensions = zipExtensions;
    }

    public String getCveUrlModified() {
        return this.cveUrlModified;
    }

    public void setCveUrlModified(String cveUrlModified) {
        this.cveUrlModified = cveUrlModified;
    }

    public String getCveUrlBase() {
        return this.cveUrlBase;
    }

    public void setCveUrlBase(String cveUrlBase) {
        this.cveUrlBase = cveUrlBase;
    }

    public String getPathToDotnetCore() {
        return this.pathToCore;
    }

    public void setPathToDotnetCore(String pathToCore) {
        this.pathToCore = pathToCore;
    }

    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    public void setPropertiesFilePath(String propertiesFilePath) {
        this.propertiesFilePath = propertiesFilePath;
    }

    private Engine executeDependencyCheck() throws ExceptionCollection {
        Engine engine;
        this.populateSettings();
        try {
            engine = new Engine(this.settings);
        }
        catch (DatabaseException ex) {
            throw new ExceptionCollection(ex, true);
        }
        if (this.updateOnly) {
            try {
                engine.doUpdates();
            }
            catch (UpdateException ex) {
                throw new ExceptionCollection(ex);
            }
            finally {
                engine.close();
            }
        } else {
            engine.setDependencies(this.dependencies);
            engine.analyzeDependencies();
        }
        return engine;
    }

    private void generateExternalReports(Engine engine, File outDirectory) throws ScanAgentException {
        try {
            engine.writeReports(this.applicationName, outDirectory, this.reportFormat.name());
        }
        catch (ReportException ex) {
            LOGGER.debug("Unexpected exception occurred during analysis; please see the verbose error log for more details.", (Throwable)ex);
            throw new ScanAgentException("Error generating the report", ex);
        }
    }

    private void populateSettings() {
        this.settings = new Settings();
        if (this.dataDirectory != null) {
            this.settings.setString("data.directory", this.dataDirectory);
        } else {
            File jarPath = new File(DependencyCheckScanAgent.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            File base = jarPath.getParentFile();
            String sub = this.settings.getString("data.directory");
            File dataDir = new File(base, sub);
            this.settings.setString("data.directory", dataDir.getAbsolutePath());
        }
        if (this.propertiesFilePath != null) {
            try {
                this.settings.mergeProperties(this.propertiesFilePath);
                LOGGER.info("Successfully loaded user-defined properties");
            }
            catch (IOException e) {
                LOGGER.error("Unable to merge user-defined properties", (Throwable)e);
                LOGGER.error("Continuing execution");
            }
        }
        this.settings.setBoolean("autoupdate", this.autoUpdate);
        this.settings.setStringIfNotEmpty("proxy.server", this.proxyServer);
        this.settings.setStringIfNotEmpty("proxy.port", this.proxyPort);
        this.settings.setStringIfNotEmpty("proxy.username", this.proxyUsername);
        this.settings.setStringIfNotEmpty("proxy.password", this.proxyPassword);
        this.settings.setStringIfNotEmpty("connection.timeout", this.connectionTimeout);
        this.settings.setStringIfNotEmpty("suppression.file", this.suppressionFile);
        this.settings.setStringIfNotEmpty("cve.cpe.startswith.filter", this.cpeStartsWithFilter);
        this.settings.setBoolean("analyzer.central.enabled", this.centralAnalyzerEnabled);
        this.settings.setStringIfNotEmpty("analyzer.central.url", this.centralUrl);
        this.settings.setBoolean("analyzer.nexus.enabled", this.nexusAnalyzerEnabled);
        this.settings.setStringIfNotEmpty("analyzer.nexus.url", this.nexusUrl);
        this.settings.setBoolean("analyzer.nexus.proxy", this.nexusUsesProxy);
        this.settings.setStringIfNotEmpty("data.driver_name", this.databaseDriverName);
        this.settings.setStringIfNotEmpty("data.driver_path", this.databaseDriverPath);
        this.settings.setStringIfNotEmpty("data.connection_string", this.connectionString);
        this.settings.setStringIfNotEmpty("data.user", this.databaseUser);
        this.settings.setStringIfNotEmpty("data.password", this.databasePassword);
        this.settings.setStringIfNotEmpty("extensions.zip", this.zipExtensions);
        this.settings.setStringIfNotEmpty("cve.url.modified", this.cveUrlModified);
        this.settings.setStringIfNotEmpty("cve.url.base", this.cveUrlBase);
        this.settings.setStringIfNotEmpty("analyzer.assembly.dotnet.path", this.pathToCore);
    }

    public Engine execute() throws ScanAgentException {
        Engine engine = null;
        try {
            engine = this.executeDependencyCheck();
            if (!this.updateOnly) {
                if (this.generateReport) {
                    this.generateExternalReports(engine, new File(this.reportOutputDirectory));
                }
                if (this.showSummary) {
                    DependencyCheckScanAgent.showSummary(engine.getDependencies());
                }
                if (this.failBuildOnCVSS <= 10.0f) {
                    this.checkForFailure(engine.getDependencies());
                }
            }
        }
        catch (ExceptionCollection ex) {
            if (ex.isFatal()) {
                LOGGER.error("A fatal exception occurred during analysis; analysis has stopped. Please see the debug log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            throw new ScanAgentException("One or more exceptions occurred during analysis; please see the debug log for more details.", ex);
        }
        finally {
            this.settings.cleanup(true);
            if (engine != null) {
                engine.close();
            }
        }
        return engine;
    }

    private void checkForFailure(Dependency[] dependencies) throws ScanAgentException {
        StringBuilder ids = new StringBuilder();
        for (Dependency d : dependencies) {
            boolean addName = true;
            for (Vulnerability v : d.getVulnerabilities()) {
                if (!(v.getCvssV2().getScore() >= this.failBuildOnCVSS)) continue;
                if (addName) {
                    addName = false;
                    ids.append(NEW_LINE).append(d.getFileName()).append(": ");
                    ids.append(v.getName());
                    continue;
                }
                ids.append(", ").append(v.getName());
            }
        }
        if (ids.length() > 0) {
            String msg = this.showSummary ? String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities that have a CVSS score greater than or equal to '%.1f': %s%nSee the dependency-check report for more details.%n%n", Float.valueOf(this.failBuildOnCVSS), ids.toString()) : String.format("%n%nDependency-Check Failure:%nOne or more dependencies were identified with vulnerabilities.%n%nSee the dependency-check report for more details.%n%n", new Object[0]);
            throw new ScanAgentException(msg);
        }
    }

    public static void showSummary(Dependency[] dependencies) {
        DependencyCheckScanAgent.showSummary(null, dependencies);
    }

    public static void showSummary(String projectName, Dependency[] dependencies) {
        StringBuilder summary = new StringBuilder();
        for (Dependency d : dependencies) {
            String ids = d.getVulnerabilities(true).stream().map(v -> v.getName()).collect(Collectors.joining(", "));
            if (ids.length() <= 0) continue;
            summary.append(d.getFileName()).append(" (");
            summary.append(Stream.concat(d.getSoftwareIdentifiers().stream(), d.getVulnerableSoftwareIdentifiers().stream()).map(i -> i.getValue()).collect(Collectors.joining(", ")));
            summary.append(") : ").append(ids).append(NEW_LINE);
        }
        if (summary.length() > 0) {
            if (projectName == null || projectName.isEmpty()) {
                LOGGER.warn("\n\nOne or more dependencies were identified with known vulnerabilities:\n\n{}\n\nSee the dependency-check report for more details.\n\n", (Object)summary.toString());
            } else {
                LOGGER.warn("\n\nOne or more dependencies were identified with known vulnerabilities in {}:\n\n{}\n\nSee the dependency-check report for more details.\n\n", (Object)projectName, (Object)summary.toString());
            }
        }
    }
}

