/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;
import us.springett.parsers.cpe.util.Convert;
import us.springett.parsers.cpe.values.Part;

public class ReportTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportTool.class);

    public String identifierToSuppressionId(Identifier id) {
        if (id instanceof PurlIdentifier) {
            PurlIdentifier purl = (PurlIdentifier)id;
            return purl.toGav();
        }
        if (id instanceof CpeIdentifier) {
            try {
                CpeIdentifier cpeId = (CpeIdentifier)id;
                Cpe cpe = cpeId.getCpe();
                return String.format("cpe:/%s:%s:%s", Convert.wellFormedToCpeUri((Part)cpe.getPart()), Convert.wellFormedToCpeUri((String)cpe.getWellFormedVendor()), Convert.wellFormedToCpeUri((String)cpe.getWellFormedProduct()));
            }
            catch (CpeEncodingException ex) {
                LOGGER.debug("Unable to convert to cpe URI", (Throwable)ex);
            }
        }
        return null;
    }
}

