/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.WordUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.reporting.EscapeTool;
import org.owasp.dependencycheck.reporting.ReportTool;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ReportGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportGenerator.class);
    private final VelocityEngine velocityEngine;
    private final Context context;
    private final Settings settings;

    public ReportGenerator(String applicationName, List<Dependency> dependencies, List<Analyzer> analyzers, DatabaseProperties properties, Settings settings) {
        this.settings = settings;
        this.velocityEngine = this.createVelocityEngine();
        this.velocityEngine.init();
        this.context = this.createContext(applicationName, dependencies, analyzers, properties);
    }

    public ReportGenerator(String applicationName, String groupID, String artifactID, String version, List<Dependency> dependencies, List<Analyzer> analyzers, DatabaseProperties properties, Settings settings) {
        this(applicationName, dependencies, analyzers, properties, settings);
        if (version != null) {
            this.context.put("applicationVersion", (Object)version);
        }
        if (artifactID != null) {
            this.context.put("artifactID", (Object)artifactID);
        }
        if (groupID != null) {
            this.context.put("groupID", (Object)groupID);
        }
    }

    private VelocityEngine createVelocityEngine() {
        VelocityEngine velocity = new VelocityEngine();
        return velocity;
    }

    private VelocityContext createContext(String applicationName, List<Dependency> dependencies, List<Analyzer> analyzers, DatabaseProperties properties) {
        DateTime dt = new DateTime();
        DateTimeFormatter dateFormat = DateTimeFormat.forPattern((String)"MMM d, yyyy 'at' HH:mm:ss z");
        DateTimeFormatter dateFormatXML = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String scanDate = dateFormat.print((ReadableInstant)dt);
        String scanDateXML = dateFormatXML.print((ReadableInstant)dt);
        VelocityContext ctxt = new VelocityContext();
        ctxt.put("applicationName", (Object)applicationName);
        ctxt.put("dependencies", dependencies);
        ctxt.put("analyzers", analyzers);
        ctxt.put("properties", (Object)properties);
        ctxt.put("scanDate", (Object)scanDate);
        ctxt.put("scanDateXML", (Object)scanDateXML);
        ctxt.put("enc", (Object)new EscapeTool());
        ctxt.put("rpt", (Object)new ReportTool());
        ctxt.put("WordUtils", (Object)new WordUtils());
        ctxt.put("VENDOR", (Object)EvidenceType.VENDOR);
        ctxt.put("PRODUCT", (Object)EvidenceType.PRODUCT);
        ctxt.put("VERSION", (Object)EvidenceType.VERSION);
        ctxt.put("version", (Object)this.settings.getString("application.version", "Unknown"));
        return ctxt;
    }

    public void write(String outputLocation, String format) throws ReportException {
        Format reportFormat = null;
        try {
            reportFormat = Format.valueOf(format.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.trace("ignore this exception", (Throwable)ex);
        }
        if (reportFormat != null) {
            this.write(outputLocation, reportFormat);
        } else {
            File out = this.getReportFile(outputLocation, null);
            if (out.isDirectory()) {
                throw new ReportException("Unable to write non-standard VSL output to a directory, please specify a file name");
            }
            this.processTemplate(format, out);
        }
    }

    public void write(String outputLocation, Format format) throws ReportException {
        if (format == Format.ALL) {
            for (Format f : Format.values()) {
                if (f == Format.ALL) continue;
                this.write(outputLocation, f);
            }
        } else {
            File out = this.getReportFile(outputLocation, format);
            String templateName = format.toString().toLowerCase() + "Report";
            this.processTemplate(templateName, out);
            if (format == Format.JSON) {
                this.pretifyJson(out.getPath());
            }
        }
    }

    protected File getReportFile(String outputLocation, Format format) {
        File outFile = new File(outputLocation);
        if (outFile.getParentFile() == null) {
            outFile = new File(".", outputLocation);
        }
        String pathToCheck = outputLocation.toLowerCase();
        if (format == Format.XML && !pathToCheck.endsWith(".xml")) {
            return new File(outFile, "dependency-check-report.xml");
        }
        if (format == Format.HTML && !pathToCheck.endsWith(".html") && !pathToCheck.endsWith(".htm")) {
            return new File(outFile, "dependency-check-report.html");
        }
        if (format == Format.JSON && !pathToCheck.endsWith(".json")) {
            return new File(outFile, "dependency-check-report.json");
        }
        if (format == Format.CSV && !pathToCheck.endsWith(".csv")) {
            return new File(outFile, "dependency-check-report.csv");
        }
        return outFile;
    }

    protected void processTemplate(String template, File file) throws ReportException {
        this.ensureParentDirectoryExists(file);
        try (FileOutputStream output = new FileOutputStream(file);){
            this.processTemplate(template, output);
        }
        catch (IOException ex) {
            throw new ReportException(String.format("Unable to write to file: %s", file), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTemplate(String templateName, OutputStream outputStream) throws ReportException {
        InputStream input = null;
        String logTag = null;
        File f = new File(templateName);
        try {
            if (f.isFile()) {
                try {
                    logTag = templateName;
                    input = new FileInputStream(f);
                }
                catch (FileNotFoundException ex) {
                    throw new ReportException("Unable to locate template file: " + templateName, ex);
                }
            } else {
                logTag = "templates/" + templateName + ".vsl";
                input = org.owasp.dependencycheck.utils.FileUtils.getResourceAsStream((String)logTag);
            }
            if (input == null) {
                logTag = templateName;
                input = org.owasp.dependencycheck.utils.FileUtils.getResourceAsStream((String)templateName);
            }
            if (input == null) {
                throw new ReportException("Template file doesn't exist: " + logTag);
            }
            try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
                 OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                if (!this.velocityEngine.evaluate(this.context, (Writer)writer, logTag, (Reader)reader)) {
                    throw new ReportException("Failed to convert the template into html.");
                }
                writer.flush();
            }
            catch (UnsupportedEncodingException ex) {
                throw new ReportException("Unable to generate the report using UTF-8", ex);
            }
            catch (IOException ex) {
                throw new ReportException("Unable to write the report", ex);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("Error closing input", (Throwable)ex);
                }
            }
        }
    }

    private void ensureParentDirectoryExists(File file) throws ReportException {
        boolean created;
        if (!file.getParentFile().exists() && !(created = file.getParentFile().mkdirs())) {
            String msg = String.format("Unable to create directory '%s'.", file.getParentFile().getAbsolutePath());
            throw new ReportException(msg);
        }
    }

    private void pretifyJson(String pathToJson) throws ReportException {
        String outputPath = pathToJson + ".pretty";
        File in = new File(pathToJson);
        File out = new File(outputPath);
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(in), StandardCharsets.UTF_8));
             JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8));){
            ReportGenerator.prettyPrint(reader, writer);
        }
        catch (IOException ex) {
            LOGGER.debug("Malformed JSON?", (Throwable)ex);
            throw new ReportException("Unable to generate json report", ex);
        }
        if (out.isFile() && in.isFile() && in.delete()) {
            try {
                FileUtils.moveFile((File)out, (File)in);
            }
            catch (IOException ex) {
                LOGGER.error("Unable to generate pretty report, caused by: ", (Object)ex.getMessage());
            }
        }
    }

    private static void prettyPrint(JsonReader reader, JsonWriter writer) throws IOException {
        writer.setIndent("  ");
        block12: while (true) {
            JsonToken token = reader.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    reader.beginArray();
                    writer.beginArray();
                    continue block12;
                }
                case END_ARRAY: {
                    reader.endArray();
                    writer.endArray();
                    continue block12;
                }
                case BEGIN_OBJECT: {
                    reader.beginObject();
                    writer.beginObject();
                    continue block12;
                }
                case END_OBJECT: {
                    reader.endObject();
                    writer.endObject();
                    continue block12;
                }
                case NAME: {
                    String name = reader.nextName();
                    writer.name(name);
                    continue block12;
                }
                case STRING: {
                    String s = reader.nextString();
                    writer.value(s);
                    continue block12;
                }
                case NUMBER: {
                    String n = reader.nextString();
                    writer.value((Number)new BigDecimal(n));
                    continue block12;
                }
                case BOOLEAN: {
                    boolean b = reader.nextBoolean();
                    writer.value(b);
                    continue block12;
                }
                case NULL: {
                    reader.nextNull();
                    writer.nullValue();
                    continue block12;
                }
                case END_DOCUMENT: {
                    return;
                }
            }
            LOGGER.debug("Unexpected JSON toekn {}", (Object)token.toString());
        }
    }

    public static enum Format {
        ALL,
        XML,
        HTML,
        JSON,
        CSV;

    }
}

