/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.owasp.dependencycheck.dependency.Confidence;

@ThreadSafe
public class Evidence
implements Serializable,
Comparable<Evidence> {
    private static final long serialVersionUID = 2402386455919067874L;
    private static final int MAGIC_HASH_INIT_VALUE = 3;
    private static final int MAGIC_HASH_MULTIPLIER = 67;
    private String name;
    private String source;
    private String value;
    private Confidence confidence;

    public Evidence() {
    }

    public Evidence(String source, String name, String value, Confidence confidence) {
        this.source = source;
        this.name = name;
        this.value = value;
        this.confidence = confidence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 67).append((Object)StringUtils.lowerCase((String)this.name)).append((Object)StringUtils.lowerCase((String)this.source)).append((Object)StringUtils.lowerCase((String)this.value)).append((Object)this.confidence).toHashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Evidence)) {
            return false;
        }
        Evidence e = (Evidence)that;
        return StringUtils.equalsIgnoreCase((CharSequence)this.name, (CharSequence)e.name) && StringUtils.equalsIgnoreCase((CharSequence)this.source, (CharSequence)e.source) && StringUtils.equalsIgnoreCase((CharSequence)this.value, (CharSequence)e.value) && ObjectUtils.equals((Object)((Object)this.confidence), (Object)((Object)e.confidence));
    }

    @Override
    public int compareTo(Evidence o) {
        if (o == null) {
            throw new IllegalArgumentException("Unable to compare null evidence");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.source, (CharSequence)o.source)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)this.name, (CharSequence)o.name)) {
                if (StringUtils.equalsIgnoreCase((CharSequence)this.value, (CharSequence)o.value)) {
                    if (ObjectUtils.equals((Object)((Object)this.confidence), (Object)((Object)o.confidence))) {
                        return 0;
                    }
                    return ObjectUtils.compare((Comparable)((Object)this.confidence), (Comparable)((Object)o.confidence));
                }
                return this.compareToIgnoreCaseWithNullCheck(this.value, o.value);
            }
            return this.compareToIgnoreCaseWithNullCheck(this.name, o.name);
        }
        return this.compareToIgnoreCaseWithNullCheck(this.source, o.source);
    }

    private int compareToIgnoreCaseWithNullCheck(String me, String other) {
        if (me == null && other == null) {
            return 0;
        }
        if (me == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        return me.compareToIgnoreCase(other);
    }

    public String toString() {
        return "Evidence{name=" + this.name + ", source=" + this.source + ", value=" + this.value + ", confidence=" + (Object)((Object)this.confidence) + '}';
    }
}

