/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetireJSDataSource
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetireJSDataSource.class);
    public static final String RETIREJS_UPDATED_ON = "RetireJSUpdatedOn";
    private Settings settings;
    private static final String DEFAULT_JS_URL = "https://raw.githubusercontent.com/Retirejs/retire.js/master/repository/jsrepository.json";

    protected RetireJSDataSource(Settings settings) {
        this.settings = settings;
    }

    public RetireJSDataSource() {
    }

    @Override
    public void update(Engine engine) throws UpdateException {
        this.settings = engine.getSettings();
        String url = null;
        try {
            boolean proceed;
            boolean autoupdate = this.settings.getBoolean("autoupdate", true);
            boolean enabled = this.settings.getBoolean("analyzer.retirejs.enabled", true);
            File repoFile = new File(this.settings.getDataDirectory(), "jsrepository.json");
            boolean bl = proceed = enabled && autoupdate && this.shouldUpdagte(repoFile);
            if (proceed) {
                LOGGER.debug("Begin RetireJS Update");
                url = this.settings.getString("analyzer.retirejs.repo.js.url", DEFAULT_JS_URL);
                this.initializeRetireJsRepo(this.settings, new URL(url));
            }
        }
        catch (InvalidSettingException ex) {
            throw new UpdateException("Unable to determine if autoupdate is enabled", ex);
        }
        catch (MalformedURLException ex) {
            throw new UpdateException(String.format("Inavlid URL for RetireJS repository (%s)", url), ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to get the data directory", ex);
        }
    }

    protected boolean shouldUpdagte(File repo) throws NumberFormatException {
        boolean proceed = true;
        if (repo != null && repo.isFile()) {
            int validForHours = this.settings.getInt("analyzer.retirejs.repo.validforhours", 0);
            long lastUpdatedOn = repo.lastModified();
            long now = System.currentTimeMillis();
            LOGGER.debug("Last updated: {}", (Object)lastUpdatedOn);
            LOGGER.debug("Now: {}", (Object)now);
            long msValid = (long)validForHours * 60L * 60L * 1000L;
            boolean bl = proceed = now - lastUpdatedOn > msValid;
            if (!proceed) {
                LOGGER.info("Skipping RetireJS update since last update was within {} hours.", (Object)validForHours);
            }
        }
        return proceed;
    }

    private void initializeRetireJsRepo(Settings settings, URL repoUrl) throws UpdateException {
        block15: {
            try {
                File dataDir = settings.getDataDirectory();
                File tmpDir = settings.getTempDirectory();
                boolean useProxy = false;
                if (null != settings.getString("proxy.server")) {
                    useProxy = true;
                    LOGGER.debug("Using proxy");
                }
                LOGGER.debug("RetireJS Repo URL: {}", (Object)repoUrl.toExternalForm());
                URLConnectionFactory factory = new URLConnectionFactory(settings);
                HttpURLConnection conn = factory.createHttpURLConnection(repoUrl, useProxy);
                String filename = repoUrl.getFile().substring(repoUrl.getFile().lastIndexOf("/") + 1, repoUrl.getFile().length());
                if (conn.getResponseCode() != 200) break block15;
                File tmpFile = new File(tmpDir, filename);
                File repoFile = new File(dataDir, filename);
                try (InputStream inputStream = conn.getInputStream();
                     FileOutputStream outputStream = new FileOutputStream(tmpFile);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                Files.copy(tmpFile.toPath(), repoFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
            }
            catch (IOException e) {
                throw new UpdateException("Failed to initialize the RetireJS repo", e);
            }
        }
    }
}

