/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.json;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.owasp.dependencycheck.data.nvd.json.Node;

public class NodeFlatteningCollector
implements Collector<Node, ArrayList<Node>, Stream<Node>> {
    private List<Node> flatten(Node node) {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(node);
        return this.flatten(result, node.getChildren());
    }

    private List<Node> flatten(List<Node> result, List<Node> nodes) {
        nodes.stream().forEach(n -> {
            this.flatten(result, n.getChildren());
            result.add((Node)n);
        });
        return result;
    }

    @Override
    public Supplier<ArrayList<Node>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<ArrayList<Node>, Node> accumulator() {
        return (nodes, n) -> nodes.addAll(this.flatten((Node)n));
    }

    @Override
    public BinaryOperator<ArrayList<Node>> combiner() {
        return (map, other) -> {
            map.addAll(other);
            return map;
        };
    }

    @Override
    public Function<ArrayList<Node>, Stream<Node>> finisher() {
        return m -> m.stream();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED);
    }
}

