/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.NuspecAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nuget.MSBuildProjectParseException;
import org.owasp.dependencycheck.data.nuget.NugetPackageReference;
import org.owasp.dependencycheck.data.nuget.XPathMSBuildProjectParser;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class MSBuildProjectAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NuspecAnalyzer.class);
    private static final String ANALYZER_NAME = "MSBuild Project Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String[] SUPPORTED_EXTENSIONS = new String[]{"csproj", "vbproj"};
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(SUPPORTED_EXTENSIONS).build();

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.msbuildproject.enabled";
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        LOGGER.debug("Checking MSBuild project file {}", (Object)dependency);
        try {
            List<NugetPackageReference> packages;
            XPathMSBuildProjectParser parser = new XPathMSBuildProjectParser();
            try (FileInputStream fis = new FileInputStream(dependency.getActualFilePath());){
                packages = parser.parse(fis);
            }
            catch (FileNotFoundException | MSBuildProjectParseException ex) {
                throw new AnalysisException(ex);
            }
            if (packages == null || packages.isEmpty()) {
                return;
            }
            for (NugetPackageReference npr : packages) {
                Dependency child = new Dependency(dependency.getActualFile(), true);
                String id = npr.getId();
                String version = npr.getVersion();
                child.setEcosystem("NuGet");
                child.setName(id);
                child.setVersion(version);
                try {
                    PackageURL purl = PackageURLBuilder.aPackageURL().withType("nuget").withName(id).withVersion(version).build();
                    child.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
                }
                catch (MalformedPackageURLException ex) {
                    LOGGER.debug("Unable to build package url for msbuild", (Throwable)ex);
                    GenericIdentifier gid = new GenericIdentifier("msbuild:" + id + "@" + version, Confidence.HIGHEST);
                    child.addSoftwareIdentifier(gid);
                }
                child.setPackagePath(String.format("%s:%s", id, version));
                child.setSha1sum(Checksum.getSHA1Checksum((String)String.format("%s:%s", id, version)));
                child.setSha256sum(Checksum.getSHA256Checksum((String)String.format("%s:%s", id, version)));
                child.setMd5sum(Checksum.getMD5Checksum((String)String.format("%s:%s", id, version)));
                child.addEvidence(EvidenceType.PRODUCT, "msbuild", "id", id, Confidence.HIGHEST);
                child.addEvidence(EvidenceType.VERSION, "msbuild", "version", version, Confidence.HIGHEST);
                if (id.indexOf(".") > 0) {
                    String[] parts = id.split("\\.");
                    child.addEvidence(EvidenceType.VENDOR, "msbuild", "id", parts[0], Confidence.MEDIUM);
                    child.addEvidence(EvidenceType.PRODUCT, "msbuild", "id", parts[1], Confidence.MEDIUM);
                    if (parts.length > 2) {
                        String rest = id.substring(id.indexOf(".") + 1);
                        child.addEvidence(EvidenceType.PRODUCT, "msbuild", "id", rest, Confidence.MEDIUM);
                    }
                } else {
                    child.addEvidence(EvidenceType.VENDOR, "msbuild", "id", id, Confidence.LOW);
                }
                engine.addDependency(child);
            }
        }
        catch (Throwable e) {
            throw new AnalysisException(e);
        }
    }
}

