/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.cwe;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.owasp.dependencycheck.data.cwe.CweHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class App {
    private App() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Incorrect arguments - please provide one or more files as input");
            System.err.println("Download the research concepts, developer concepts, and architectural concepts view of the CWE from https://cwe.mitre.org/data/downloads.html");
            return;
        }
        File in = new File(args[0]);
        if (!in.isFile()) {
            System.err.println(String.format("%s does not exist", in.getAbsolutePath()));
            return;
        }
        File out = new File("cwe.hashmap.serialized");
        Map<String, String> cwe = App.readCweData(args);
        App.serializeCweData(cwe, out);
    }

    private static Map<String, String> readCweData(String[] files) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            CweHandler handler = new CweHandler();
            for (String f : files) {
                File in = new File(f);
                if (!in.isFile()) {
                    System.err.println(String.format("File not found %s", in));
                }
                System.out.println(String.format("Parsing %s", in));
                saxParser.parse(in, (DefaultHandler)handler);
            }
            return handler.getCwe();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            System.err.println(String.format("Error generating serialized data: %s", ex.getMessage()));
            return null;
        }
    }

    private static void serializeCweData(Map<String, String> cwe, File out) {
        try (FileOutputStream fout = new FileOutputStream(out);
             ObjectOutputStream objOut = new ObjectOutputStream(fout);){
            System.out.println("Writing " + cwe.size() + " cwe entries.");
            objOut.writeObject(cwe);
            System.out.println(String.format("Serialized CWE data written to %s", out.getCanonicalPath()));
            System.out.println("To update the ODC CWE data copy the serialized file to 'src/main/resources/data/cwe.hashmap.serialized'");
        }
        catch (IOException ex) {
            System.err.println(String.format("Error generating serialized data: %s", ex.getMessage()));
        }
    }
}

