/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import org.owasp.dependencycheck.utils.H2DBLock;
import org.owasp.dependencycheck.utils.H2DBShutdownHook;
import org.owasp.dependencycheck.utils.H2DBShutdownHookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DBCleanupHook
extends H2DBShutdownHook {
    private H2DBLock lock;
    private static final Logger LOGGER = LoggerFactory.getLogger(H2DBShutdownHookFactory.class);

    @Override
    public void add(H2DBLock lock) {
        this.lock = lock;
        Runtime.getRuntime().addShutdownHook(this);
    }

    @Override
    public void remove() {
        try {
            Runtime.getRuntime().removeShutdownHook(this);
        }
        catch (IllegalStateException ex) {
            LOGGER.trace("ignore as we are likely shutting down", (Throwable)ex);
        }
    }

    @Override
    public void run() {
        if (this.lock != null) {
            this.lock.release();
            this.lock = null;
        }
    }
}

