/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.utils.FileFilterBuilder;

@Experimental
@ThreadSafe
public class CocoaPodsAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "CocoaPod";
    private static final String ANALYZER_NAME = "CocoaPods Package Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String PODSPEC = "podspec";
    private static final FileFilter PODSPEC_FILTER = FileFilterBuilder.newInstance().addExtensions("podspec").build();
    private static final Pattern PODSPEC_BLOCK_PATTERN = Pattern.compile("Pod::Spec\\.new\\s+?do\\s+?\\|(.+?)\\|");

    @Override
    protected FileFilter getFileFilter() {
        return PODSPEC_FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.cocoapods.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        try {
            contents = FileUtils.readFileToString((File)dependency.getActualFile(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        Matcher matcher = PODSPEC_BLOCK_PATTERN.matcher(contents);
        if (matcher.find()) {
            String version;
            String license;
            String homepage;
            String author;
            String summary;
            String blockVariable;
            String name = this.determineEvidence(contents = contents.substring(matcher.end()), blockVariable = matcher.group(1), "name");
            if (!name.isEmpty()) {
                dependency.addEvidence(EvidenceType.PRODUCT, PODSPEC, "name_project", name, Confidence.HIGHEST);
                dependency.addEvidence(EvidenceType.VENDOR, PODSPEC, "name_project", name, Confidence.HIGHEST);
                dependency.setName(name);
            }
            if (!(summary = this.determineEvidence(contents, blockVariable, "summary")).isEmpty()) {
                dependency.addEvidence(EvidenceType.PRODUCT, PODSPEC, "summary", summary, Confidence.HIGHEST);
            }
            if (!(author = this.determineEvidence(contents, blockVariable, "authors?")).isEmpty()) {
                dependency.addEvidence(EvidenceType.VENDOR, PODSPEC, "author", author, Confidence.HIGHEST);
            }
            if (!(homepage = this.determineEvidence(contents, blockVariable, "homepage")).isEmpty()) {
                dependency.addEvidence(EvidenceType.VENDOR, PODSPEC, "homepage", homepage, Confidence.HIGHEST);
            }
            if (!(license = this.determineEvidence(contents, blockVariable, "licen[cs]es?")).isEmpty()) {
                dependency.setLicense(license);
            }
            if (!(version = this.determineEvidence(contents, blockVariable, "version")).isEmpty()) {
                dependency.addEvidence(EvidenceType.VERSION, PODSPEC, "version", version, Confidence.HIGHEST);
                dependency.setVersion(version);
            }
        }
        this.setPackagePath(dependency);
    }

    private String determineEvidence(String contents, String blockVariable, String fieldPattern) {
        String value = "";
        Matcher arrayMatcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?\\{\\s*?(.*?)\\s*?\\}", blockVariable, fieldPattern), 2).matcher(contents);
        if (arrayMatcher.find()) {
            value = arrayMatcher.group(1);
        } else {
            Matcher matcher = Pattern.compile(String.format("\\s*?%s\\.%s\\s*?=\\s*?(['\"])(.*?)\\1", blockVariable, fieldPattern), 2).matcher(contents);
            if (matcher.find()) {
                value = matcher.group(2);
            }
        }
        return value;
    }

    private void setPackagePath(Dependency dep) {
        File file = new File(dep.getFilePath());
        String parent = file.getParent();
        if (parent != null) {
            dep.setPackagePath(parent);
        }
    }
}

