/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.owasp.dependencycheck.xml.suppression.SuppressionRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
public class SuppressionHandler
extends DefaultHandler {
    public static final String SUPPRESS = "suppress";
    public static final String FILE_PATH = "filePath";
    public static final String SHA1 = "sha1";
    public static final String CVE = "cve";
    public static final String NOTES = "notes";
    public static final String CPE = "cpe";
    public static final String CWE = "cwe";
    public static final String GAV = "gav";
    public static final String CVSS_BELOW = "cvssBelow";
    private final List<SuppressionRule> suppressionRules = new ArrayList<SuppressionRule>();
    private SuppressionRule rule;
    private Attributes currentAttributes;
    private StringBuilder currentText;

    public List<SuppressionRule> getSuppressionRules() {
        return this.suppressionRules;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentAttributes = attributes;
        this.currentText = new StringBuilder();
        if (SUPPRESS.equals(qName)) {
            this.rule = new SuppressionRule();
            String base = this.currentAttributes.getValue("base");
            if (base != null) {
                this.rule.setBase(Boolean.parseBoolean(base));
            } else {
                this.rule.setBase(false);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (null != qName) {
            switch (qName) {
                case "suppress": {
                    this.suppressionRules.add(this.rule);
                    this.rule = null;
                    break;
                }
                case "filePath": {
                    this.rule.setFilePath(this.processPropertyType());
                    break;
                }
                case "sha1": {
                    this.rule.setSha1(this.currentText.toString());
                    break;
                }
                case "gav": {
                    this.rule.setGav(this.processPropertyType());
                    break;
                }
                case "cpe": {
                    this.rule.addCpe(this.processPropertyType());
                    break;
                }
                case "cwe": {
                    this.rule.addCwe(this.currentText.toString());
                    break;
                }
                case "cve": {
                    this.rule.addCve(this.currentText.toString());
                    break;
                }
                case "notes": {
                    this.rule.addNotes(this.currentText.toString());
                    break;
                }
                case "cvssBelow": {
                    float cvss = Float.parseFloat(this.currentText.toString());
                    this.rule.addCvssBelow(Float.valueOf(cvss));
                    break;
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText.append(ch, start, length);
    }

    private PropertyType processPropertyType() {
        PropertyType pt = new PropertyType();
        pt.setValue(this.currentText.toString());
        if (this.currentAttributes != null && this.currentAttributes.getLength() > 0) {
            String caseSensitive;
            String regex = this.currentAttributes.getValue("regex");
            if (regex != null) {
                pt.setRegex(Boolean.parseBoolean(regex));
            }
            if ((caseSensitive = this.currentAttributes.getValue("caseSensitive")) != null) {
                pt.setCaseSensitive(Boolean.parseBoolean(caseSensitive));
            }
        }
        return pt;
    }
}

