/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections.map.ReferenceMap;
import org.owasp.dependencycheck.data.cwe.CweDB;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.Pair;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CveDB
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CveDB.class);
    private final ConnectionFactory connectionFactory;
    private Connection connection;
    private ResourceBundle statementBundle;
    private DatabaseProperties databaseProperties;
    private final EnumMap<PreparedStatementCveDb, PreparedStatement> preparedStatements = new EnumMap(PreparedStatementCveDb.class);
    private final Map<String, List<Vulnerability>> vulnerabilitiesForCpeCache = Collections.synchronizedMap(new ReferenceMap(0, 1));
    private final Settings settings;

    public CveDB(Settings settings) throws DatabaseException {
        this.settings = settings;
        this.connectionFactory = new ConnectionFactory(settings);
        this.open();
    }

    private String determineDatabaseProductName(Connection conn) {
        try {
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            LOGGER.debug("Database product: {}", (Object)databaseProductName);
            return databaseProductName;
        }
        catch (SQLException se) {
            LOGGER.warn("Problem determining database product!", (Throwable)se);
            return null;
        }
    }

    private synchronized void open() throws DatabaseException {
        try {
            if (!this.isOpen()) {
                this.connection = this.connectionFactory.getConnection();
                String databaseProductName = this.determineDatabaseProductName(this.connection);
                this.statementBundle = databaseProductName != null ? ResourceBundle.getBundle("data/dbStatements", new Locale(databaseProductName)) : ResourceBundle.getBundle("data/dbStatements");
                this.prepareStatements();
                this.databaseProperties = new DatabaseProperties(this);
            }
        }
        catch (DatabaseException e) {
            this.releaseResources();
            throw e;
        }
    }

    @Override
    public synchronized void close() {
        if (this.isOpen()) {
            this.clearCache();
            this.closeStatements();
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                LOGGER.error("There was an error attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            catch (Throwable ex) {
                LOGGER.error("There was an exception attempting to close the CveDB, see the log for more details.");
                LOGGER.debug("", ex);
            }
            this.releaseResources();
            this.connectionFactory.cleanup();
        }
    }

    private synchronized void releaseResources() {
        this.statementBundle = null;
        this.preparedStatements.clear();
        this.databaseProperties = null;
        this.connection = null;
    }

    protected synchronized boolean isOpen() {
        return this.connection != null;
    }

    private void prepareStatements() throws DatabaseException {
        for (PreparedStatementCveDb key : PreparedStatementCveDb.values()) {
            PreparedStatement preparedStatement;
            block4: {
                preparedStatement = null;
                try {
                    String statementString = this.statementBundle.getString(key.name());
                    preparedStatement = key == PreparedStatementCveDb.INSERT_VULNERABILITY || key == PreparedStatementCveDb.INSERT_CPE ? this.connection.prepareStatement(statementString, new String[]{"id"}) : this.connection.prepareStatement(statementString);
                }
                catch (SQLException ex) {
                    throw new DatabaseException(ex);
                }
                catch (MissingResourceException ex) {
                    if (ex.getMessage().contains("key MERGE_PROPERTY")) break block4;
                    throw new DatabaseException(ex);
                }
            }
            if (preparedStatement == null) continue;
            this.preparedStatements.put(key, preparedStatement);
        }
    }

    private synchronized void closeStatements() {
        for (PreparedStatement preparedStatement : this.preparedStatements.values()) {
            DBUtils.closeStatement(preparedStatement);
        }
    }

    private synchronized PreparedStatement getPreparedStatement(PreparedStatementCveDb key) throws SQLException {
        if (!this.preparedStatements.containsKey((Object)key)) {
            return null;
        }
        PreparedStatement preparedStatement = this.preparedStatements.get((Object)key);
        preparedStatement.clearParameters();
        return preparedStatement;
    }

    public synchronized void commit() throws SQLException {
    }

    protected void finalize() throws Throwable {
        LOGGER.debug("Entering finalize");
        this.close();
        super.finalize();
    }

    public synchronized DatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    protected synchronized DatabaseProperties reloadProperties() {
        this.databaseProperties = new DatabaseProperties(this);
        return this.databaseProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<VulnerableSoftware> getCPEs(String vendor, String product) {
        HashSet<VulnerableSoftware> cpe = new HashSet<VulnerableSoftware>();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_CPE_ENTRIES);
            ps.setString(1, vendor);
            ps.setString(2, product);
            rs = ps.executeQuery();
            while (rs.next()) {
                VulnerableSoftware vs = new VulnerableSoftware();
                vs.setCpe(rs.getString(1));
                cpe.add(vs);
            }
            DBUtils.closeResultSet(rs);
        }
        catch (SQLException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", (Throwable)ex);
        }
        finally {
            DBUtils.closeResultSet(rs);
        }
        return cpe;
    }

    public synchronized Set<Pair<String, String>> getVendorProductList() throws DatabaseException {
        HashSet<Pair<String, String>> data = new HashSet<Pair<String, String>>();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VENDOR_PRODUCT_LIST);
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new Pair<String, String>(rs.getString(1), rs.getString(2)));
            }
        }
        catch (SQLException ex) {
            try {
                String msg = "An unexpected SQL Exception occurred; please see the verbose log for more details.";
                throw new DatabaseException("An unexpected SQL Exception occurred; please see the verbose log for more details.", ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties getProperties() {
        Properties prop = new Properties();
        ResultSet rs = null;
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_PROPERTIES);
            rs = ps.executeQuery();
            while (rs.next()) {
                prop.setProperty(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
                LOGGER.debug("", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
        }
        DBUtils.closeResultSet(rs);
        return prop;
    }

    public synchronized void saveProperty(String key, String value) {
        this.clearCache();
        try {
            PreparedStatement mergeProperty = this.getPreparedStatement(PreparedStatementCveDb.MERGE_PROPERTY);
            if (mergeProperty != null) {
                mergeProperty.setString(1, key);
                mergeProperty.setString(2, value);
                mergeProperty.execute();
            } else {
                PreparedStatement updateProperty = this.getPreparedStatement(PreparedStatementCveDb.UPDATE_PROPERTY);
                updateProperty.setString(1, value);
                updateProperty.setString(2, key);
                if (updateProperty.executeUpdate() == 0) {
                    PreparedStatement insertProperty = this.getPreparedStatement(PreparedStatementCveDb.INSERT_PROPERTY);
                    insertProperty.setString(1, key);
                    insertProperty.setString(2, value);
                    insertProperty.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            LOGGER.warn("Unable to save property '{}' with a value of '{}' to the database", (Object)key, (Object)value);
            LOGGER.debug("", (Throwable)ex);
        }
    }

    private synchronized void clearCache() {
        this.vulnerabilitiesForCpeCache.clear();
    }

    public synchronized List<Vulnerability> getVulnerabilities(String cpeStr) throws DatabaseException {
        List<Vulnerability> cachedVulnerabilities = this.vulnerabilitiesForCpeCache.get(cpeStr);
        if (cachedVulnerabilities != null) {
            LOGGER.debug("Cache hit for {}", (Object)cpeStr);
            return cachedVulnerabilities;
        }
        LOGGER.debug("Cache miss for {}", (Object)cpeStr);
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(cpeStr);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.trace("", (Throwable)ex);
        }
        DependencyVersion detectedVersion = this.parseDependencyVersion(cpe);
        ArrayList<Vulnerability> vulnerabilities = new ArrayList<Vulnerability>();
        ResultSet rs = null;
        try {
            Vulnerability v;
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.SELECT_CVE_FROM_SOFTWARE);
            ps.setString(1, cpe.getVendor());
            ps.setString(2, cpe.getProduct());
            rs = ps.executeQuery();
            String currentCVE = "";
            HashMap<String, Boolean> vulnSoftware = new HashMap<String, Boolean>();
            while (rs.next()) {
                String cveId = rs.getString(1);
                if (!currentCVE.equals(cveId)) {
                    Vulnerability v2;
                    Map.Entry<String, Boolean> matchedCPE = this.getMatchingSoftware(vulnSoftware, cpe.getVendor(), cpe.getProduct(), detectedVersion);
                    if (matchedCPE != null && (v2 = this.getVulnerability(currentCVE)) != null) {
                        v2.setMatchedCPE(matchedCPE.getKey(), matchedCPE.getValue() != false ? "Y" : null);
                        vulnerabilities.add(v2);
                    }
                    vulnSoftware.clear();
                    currentCVE = cveId;
                }
                String cpeId = rs.getString(2);
                String previous = rs.getString(3);
                Boolean p = previous != null && !previous.isEmpty();
                vulnSoftware.put(cpeId, p);
            }
            Map.Entry<String, Boolean> matchedCPE = this.getMatchingSoftware(vulnSoftware, cpe.getVendor(), cpe.getProduct(), detectedVersion);
            if (matchedCPE != null && (v = this.getVulnerability(currentCVE)) != null) {
                v.setMatchedCPE(matchedCPE.getKey(), matchedCPE.getValue() != false ? "Y" : null);
                vulnerabilities.add(v);
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Exception retrieving vulnerability for " + cpeStr, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rs);
        this.vulnerabilitiesForCpeCache.put(cpeStr, vulnerabilities);
        return vulnerabilities;
    }

    public synchronized Vulnerability getVulnerability(String cve) throws DatabaseException {
        ResultSet rsV = null;
        ResultSet rsR = null;
        ResultSet rsS = null;
        Vulnerability vuln = null;
        try {
            PreparedStatement psV = this.getPreparedStatement(PreparedStatementCveDb.SELECT_VULNERABILITY);
            psV.setString(1, cve);
            rsV = psV.executeQuery();
            if (rsV.next()) {
                String name;
                vuln = new Vulnerability();
                vuln.setName(cve);
                vuln.setDescription(rsV.getString(2));
                String cwe = rsV.getString(3);
                if (cwe != null && (name = CweDB.getCweName(cwe)) != null) {
                    cwe = cwe + ' ' + name;
                }
                int cveId = rsV.getInt(1);
                vuln.setCwe(cwe);
                vuln.setCvssScore(rsV.getFloat(4));
                vuln.setCvssAccessVector(rsV.getString(5));
                vuln.setCvssAccessComplexity(rsV.getString(6));
                vuln.setCvssAuthentication(rsV.getString(7));
                vuln.setCvssConfidentialityImpact(rsV.getString(8));
                vuln.setCvssIntegrityImpact(rsV.getString(9));
                vuln.setCvssAvailabilityImpact(rsV.getString(10));
                PreparedStatement psR = this.getPreparedStatement(PreparedStatementCveDb.SELECT_REFERENCES);
                psR.setInt(1, cveId);
                rsR = psR.executeQuery();
                while (rsR.next()) {
                    vuln.addReference(rsR.getString(1), rsR.getString(2), rsR.getString(3));
                }
                PreparedStatement psS = this.getPreparedStatement(PreparedStatementCveDb.SELECT_SOFTWARE);
                psS.setInt(1, cveId);
                rsS = psS.executeQuery();
                while (rsS.next()) {
                    String cpe = rsS.getString(1);
                    String prevVersion = rsS.getString(2);
                    if (prevVersion == null) {
                        vuln.addVulnerableSoftware(cpe);
                        continue;
                    }
                    vuln.addVulnerableSoftware(cpe, prevVersion);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new DatabaseException("Error retrieving " + cve, ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rsV);
                DBUtils.closeResultSet(rsR);
                DBUtils.closeResultSet(rsS);
                throw throwable;
            }
        }
        DBUtils.closeResultSet(rsV);
        DBUtils.closeResultSet(rsR);
        DBUtils.closeResultSet(rsS);
        return vuln;
    }

    /*
     * Exception decompiling
     */
    public synchronized void updateVulnerability(Vulnerability vuln) throws DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean dataExists() {
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            try {
                PreparedStatement cs = this.getPreparedStatement(PreparedStatementCveDb.COUNT_CPE);
                rs = cs.executeQuery();
                if (!rs.next() || rs.getInt(1) <= 0) break block6;
                bl = true;
            }
            catch (Exception ex) {
                try {
                    String dd;
                    try {
                        dd = this.settings.getDataDirectory().getAbsolutePath();
                    }
                    catch (IOException ex1) {
                        dd = this.settings.getString("data.directory");
                    }
                    LOGGER.error("Unable to access the local database.\n\nEnsure that '{}' is a writable directory. If the problem persist try deleting the files in '{}' and running {} again. If the problem continues, please create a log file (see documentation at http://jeremylong.github.io/DependencyCheck/) and open a ticket at https://github.com/jeremylong/DependencyCheck/issues and include the log file.\n\n", new Object[]{dd, dd, this.settings.getString("application.name")});
                    LOGGER.debug("", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    throw throwable;
                }
                DBUtils.closeResultSet(rs);
            }
            DBUtils.closeResultSet(rs);
            return bl;
        }
        DBUtils.closeResultSet(rs);
        return false;
    }

    public synchronized void cleanupDatabase() {
        this.clearCache();
        try {
            PreparedStatement ps = this.getPreparedStatement(PreparedStatementCveDb.CLEANUP_ORPHANS);
            if (ps != null) {
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            LOGGER.error("An unexpected SQL Exception occurred; please see the verbose log for more details.");
            LOGGER.debug("", (Throwable)ex);
        }
    }

    protected Map.Entry<String, Boolean> getMatchingSoftware(Map<String, Boolean> vulnerableSoftware, String vendor, String product, DependencyVersion identifiedVersion) {
        DependencyVersion v;
        boolean isVersionTwoADifferentProduct = "apache".equals(vendor) && "struts".equals(product);
        HashSet<String> majorVersionsAffectingAllPrevious = new HashSet<String>();
        boolean matchesAnyPrevious = identifiedVersion == null || "-".equals(identifiedVersion.toString());
        String majorVersionMatch = null;
        for (Map.Entry<String, Boolean> entry : vulnerableSoftware.entrySet()) {
            DependencyVersion v2 = this.parseDependencyVersion(entry.getKey());
            if (v2 == null || "-".equals(v2.toString())) {
                return entry;
            }
            if (!entry.getValue().booleanValue()) continue;
            if (matchesAnyPrevious) {
                return entry;
            }
            if (identifiedVersion != null && identifiedVersion.getVersionParts().get(0).equals(v2.getVersionParts().get(0))) {
                majorVersionMatch = v2.getVersionParts().get(0);
            }
            majorVersionsAffectingAllPrevious.add(v2.getVersionParts().get(0));
        }
        if (matchesAnyPrevious) {
            return null;
        }
        boolean canSkipVersions = majorVersionMatch != null && majorVersionsAffectingAllPrevious.size() > 1;
        for (Map.Entry<String, Boolean> entry : vulnerableSoftware.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            v = this.parseDependencyVersion(entry.getKey());
            if (canSkipVersions && majorVersionMatch != null && !majorVersionMatch.equals(v.getVersionParts().get(0)) || identifiedVersion == null || !identifiedVersion.equals(v)) continue;
            return entry;
        }
        for (Map.Entry<String, Boolean> entry : vulnerableSoftware.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            v = this.parseDependencyVersion(entry.getKey());
            if (canSkipVersions && majorVersionMatch != null && !majorVersionMatch.equals(v.getVersionParts().get(0)) || !entry.getValue().booleanValue() || identifiedVersion == null || identifiedVersion.compareTo(v) > 0 || isVersionTwoADifferentProduct && !identifiedVersion.getVersionParts().get(0).equals(v.getVersionParts().get(0))) continue;
            return entry;
        }
        return null;
    }

    private DependencyVersion parseDependencyVersion(String cpeStr) {
        VulnerableSoftware cpe = new VulnerableSoftware();
        try {
            cpe.parseName(cpeStr);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.trace("", (Throwable)ex);
        }
        return this.parseDependencyVersion(cpe);
    }

    private DependencyVersion parseDependencyVersion(VulnerableSoftware cpe) {
        DependencyVersion cpeVersion;
        if (cpe.getVersion() != null && !cpe.getVersion().isEmpty()) {
            String versionText = cpe.getUpdate() != null && !cpe.getUpdate().isEmpty() ? String.format("%s.%s", cpe.getVersion(), cpe.getUpdate()) : cpe.getVersion();
            cpeVersion = DependencyVersionUtil.parseVersion(versionText);
        } else {
            cpeVersion = new DependencyVersion("-");
        }
        return cpeVersion;
    }

    public synchronized void deleteUnusedCpe() {
        this.clearCache();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(this.statementBundle.getString("DELETE_UNUSED_DICT_CPE"));
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("Unable to delete CPE dictionary entries", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(ps);
                throw throwable;
            }
            DBUtils.closeStatement(ps);
        }
        DBUtils.closeStatement(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addCpe(String cpe, String vendor, String product) {
        this.clearCache();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(this.statementBundle.getString("ADD_DICT_CPE"));
            ps.setString(1, cpe);
            ps.setString(2, vendor);
            ps.setString(3, product);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                LOGGER.error("Unable to add CPE dictionary entry", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(ps);
                throw throwable;
            }
            DBUtils.closeStatement(ps);
        }
        DBUtils.closeStatement(ps);
    }

    static enum PreparedStatementCveDb {
        CLEANUP_ORPHANS,
        COUNT_CPE,
        DELETE_REFERENCE,
        DELETE_SOFTWARE,
        DELETE_VULNERABILITY,
        INSERT_CPE,
        INSERT_PROPERTY,
        INSERT_REFERENCE,
        INSERT_SOFTWARE,
        INSERT_VULNERABILITY,
        MERGE_PROPERTY,
        SELECT_CPE_ENTRIES,
        SELECT_CPE_ID,
        SELECT_CVE_FROM_SOFTWARE,
        SELECT_PROPERTIES,
        SELECT_REFERENCES,
        SELECT_SOFTWARE,
        SELECT_VENDOR_PRODUCT_LIST,
        SELECT_VULNERABILITY,
        SELECT_VULNERABILITY_ID,
        UPDATE_PROPERTY,
        UPDATE_VULNERABILITY;

    }
}

